"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QSyntaxHighlighter(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsyntaxhighlighter.html

    **Detailed Description**

    The QSyntaxHighlighter class is a base class for implementing
    **QTextDocument**  syntax highlighters. A syntax highligher automatically
    highlights parts of the text in a **QTextDocument** . Syntax highlighters
    are often used when the user is entering text in a specific format (for
    example source code) and help the user to read the text and identify syntax
    errors.

    To provide your own syntax highlighting, you must subclass
    QSyntaxHighlighter and reimplement **highlightBlock** ().

    When you create an instance of your QSyntaxHighlighter subclass, pass it the
    **QTextDocument**  that you want the syntax highlighting to be applied to.
    For example:

    **QTextEdit**  *editor = new **QTextEdit** ;
        MyHighlighter *highlighter
    = new MyHighlighter(editor->document());

    After this your **highlightBlock** () function will be called automatically
    whenever necessary. Use your **highlightBlock** () function to apply
    formatting (e.g. setting the font and color) to the text that is passed to
    it. QSyntaxHighlighter provides the **setFormat** () function which applies
    a given **QTextCharFormat**  on the current text block. For example:

    void MyHighlighter::highlightBlock(const **QString**  &text)
        {
    **QTextCharFormat**  myClassFormat;
    myClassFormat.setFontWeight(**QFont** ::Bold);
    myClassFormat.setForeground(Qt::darkMagenta);
    **QRegularExpression**  expression("\\\\bMy[A-Za-z]+\\\\b");
    **QRegularExpressionMatchIterator**  i = expression.globalMatch(text);
    while (i.hasNext())
            {
              **QRegularExpressionMatch**  match =
    i.next();
              setFormat(match.capturedStart(), match.capturedLength(),
    myClassFormat);
            }
        }

    Some syntaxes can have constructs that span several text blocks. For
    example, a C++ syntax highlighter should be able to cope with `/``*...*``/`
    multiline comments. To deal with these cases it is necessary to know the end
    state of the previous text block (e.g. "in comment").

    Inside your **highlightBlock** () implementation you can query the end state
    of the previous text block using the **previousBlockState** () function.
    After parsing the block you can save the last state using
    **setCurrentBlockState** ().

    The **currentBlockState** () and **previousBlockState** () functions return
    an int value. If no state is set, the returned value is -1. You can
    designate any other value to identify any given state using the
    **setCurrentBlockState** () function. Once the state is set the
    **QTextBlock**  keeps that value until it is set set again or until the
    corresponding paragraph of text is deleted.

    For example, if you're writing a simple C++ syntax highlighter, you might
    designate 1 to signify "in comment":

    **QTextCharFormat**  multiLineCommentFormat;
    multiLineCommentFormat.setForeground(Qt::red);
    **QRegularExpression**  startExpression("/\\\\*");
        **QRegularExpression**
    endExpression("\\\\*/");

        setCurrentBlockState(0);

        int
    startIndex = 0;
        if (previousBlockState() != 1)
            startIndex =
    text.indexOf(startExpression);

        while (startIndex >= 0) {
    **QRegularExpressionMatch**  endMatch;
           int endIndex =
    text.indexOf(endExpression, startIndex, &endMatch);
           int
    commentLength;
           if (endIndex == -1) {
    setCurrentBlockState(1);
               commentLength = text.length() -
    startIndex;
           } else {
               commentLength = endIndex - startIndex
    + endMatch.capturedLength();
           }
           setFormat(startIndex,
    commentLength, multiLineCommentFormat);
           startIndex =
    text.indexOf(startExpression,
                                     startIndex +
    commentLength);
        }

    In the example above, we first set the current block state to 0. Then, if
    the previous block ended within a comment, we highlight from the beginning
    of the current block (`startIndex = 0`). Otherwise, we search for the given
    start expression. If the specified end expression cannot be found in the
    text block, we change the current block state by calling
    **setCurrentBlockState** (), and make sure that the rest of the block is
    highlighted.

    In addition you can query the current formatting and user data using the
    **format** () and **currentBlockUserData** () functions respectively. You
    can also attach user data to the current text block using the
    **setCurrentBlockUserData** () function. **QTextBlockUserData**  can be used
    to store custom settings. In the case of syntax highlighting, it is in
    particular interesting as cache storage for information that you may figure
    out while parsing the paragraph's text. For an example, see the
    **setCurrentBlockUserData** () documentation.

    **See also** **QTextDocument**  and **Syntax Highlighter Example** .
    """

    @typing.overload
    def __init__(self, parent: "QTextDocument") -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#QSyntaxHighlighter

        **QSyntaxHighlighter::QSyntaxHighlighter(QObject * parent )**

        Constructs a QSyntaxHighlighter with the given **parent**.

        If the parent is a **QTextEdit** , it installs the syntax highlighter on
        the parents document. The specified **QTextEdit**  also becomes the
        owner of the QSyntaxHighlighter.
        """
        ...

    @typing.overload
    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#QSyntaxHighlighter-1

        **QSyntaxHighlighter::QSyntaxHighlighter(QTextDocument * parent )**

        Constructs a QSyntaxHighlighter and installs it on **parent**. The
        specified **QTextDocument**  also becomes the owner of the
        QSyntaxHighlighter.
        """
        ...

    def currentBlock(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#currentBlock

        **[protected] QTextBlock QSyntaxHighlighter::currentBlock() const**

        Returns the current text block.

        This function was introduced in Qt 4.4.
        """
        ...

    def currentBlockUserData(self) -> "QTextBlockUserData":
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#currentBlockUserData

        **[protected] QTextBlockUserData
        *QSyntaxHighlighter::currentBlockUserData() const**

        Returns the **QTextBlockUserData**  object previously attached to the
        current text block.

        **See also** **QTextBlock::userData** () and **setCurrentBlockUserData**
        ().
        """
        ...

    def setCurrentBlockUserData(self, data: "QTextBlockUserData") -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setCurrentBlockUserData

        **[protected] void
        QSyntaxHighlighter::setCurrentBlockUserData(QTextBlockUserData * data
        )**

        Attaches the given **data** to the current text block. The ownership is
        passed to the underlying text document, i.e. the provided
        **QTextBlockUserData**  object will be deleted if the corresponding text
        block gets deleted.

        **QTextBlockUserData**  can be used to store custom settings. In the
        case of syntax highlighting, it is in particular interesting as cache
        storage for information that you may figure out while parsing the
        paragraph's text.

        For example while parsing the text, you can keep track of parenthesis
        characters that you encounter ('{[(' and the like), and store their
        relative position and the actual **QChar**  in a simple class derived
        from **QTextBlockUserData** :

        struct ParenthesisInfo
            {
                **QChar**  char;
                int
        position;
            };

            struct BlockData : public
        **QTextBlockUserData**
            {
                **QVector** <ParenthesisInfo>
        parentheses;
            };

        During cursor navigation in the associated editor, you can ask the
        current **QTextBlock**  (retrieved using the **QTextCursor::block** ()
        function) if it has a user data object set and cast it to your
        `BlockData` object. Then you can check if the current cursor position
        matches with a previously recorded parenthesis position, and, depending
        on the type of parenthesis (opening or closing), find the next opening
        or closing parenthesis on the same level.

        In this way you can do a visual parenthesis matching and highlight from
        the current cursor position to the matching parenthesis. That makes it
        easier to spot a missing parenthesis in your code and to find where a
        corresponding opening/closing parenthesis is when editing parenthesis
        intensive code.

        **See also** **currentBlockUserData** () and **QTextBlock::setUserData**
        ().
        """
        ...

    def setCurrentBlockState(self, newState: int) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setCurrentBlockState

        **[protected] void QSyntaxHighlighter::setCurrentBlockState(int newState
        )**

        Sets the state of the current text block to **newState**.

        **See also** **currentBlockState** () and **highlightBlock** ().
        """
        ...

    def currentBlockState(self) -> int:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#currentBlockState

        **[protected] int QSyntaxHighlighter::currentBlockState() const**

        Returns the state of the current text block. If no value is set, the
        returned value is -1.

        **See also** **setCurrentBlockState** ().
        """
        ...

    def previousBlockState(self) -> int:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#previousBlockState

        **[protected] int QSyntaxHighlighter::previousBlockState() const**

        Returns the end state of the text block previous to the syntax
        highlighter's current block. If no value was previously set, the
        returned value is -1.

        **See also** **highlightBlock** () and **setCurrentBlockState** ().
        """
        ...

    def format(self, pos: int) -> "QTextCharFormat":
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#format

        **[protected] QTextCharFormat QSyntaxHighlighter::format(int position )
        const**

        Returns the format at **position** inside the syntax highlighter's
        current text block.

        **See also** **setFormat** ().
        """
        ...

    @typing.overload
    def setFormat(self, start: int, count: int, format: "QTextCharFormat") -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setFormat

        **[protected] void QSyntaxHighlighter::setFormat(int start , int count ,
        const QTextCharFormat & format )**

        This function is applied to the syntax highlighter's current text block
        (i.e. the text that is passed to the **highlightBlock** () function).

        The specified **format** is applied to the text from the **start**
        position for a length of **count** characters (if **count** is 0,
        nothing is done). The formatting properties set in **format** are merged
        at display time with the formatting information stored directly in the
        document, for example as previously set with **QTextCursor** 's
        functions. Note that the document itself remains unmodified by the
        format set through this function.

        **See also** **format** () and **highlightBlock** ().
        """
        ...

    @typing.overload
    def setFormat(
        self,
        start: int,
        count: int,
        color: typing.Union[QColor, QtCore.Qt.GlobalColor, QGradient],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setFormat-1

        **[protected] void QSyntaxHighlighter::setFormat(int start , int count ,
        const QColor & color )**

        This is an overloaded function.

        The specified **color** is applied to the current text block from the
        **start** position for a length of **count** characters.

        The other attributes of the current text block, e.g. the font and
        background color, are reset to default values.

        **See also** **format** () and **highlightBlock** ().
        """
        ...

    @typing.overload
    def setFormat(self, start: int, count: int, font: QFont) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setFormat-2

        **[protected] void QSyntaxHighlighter::setFormat(int start , int count ,
        const QFont & font )**

        This is an overloaded function.

        The specified **font** is applied to the current text block from the
        **start** position for a length of **count** characters.

        The other attributes of the current text block, e.g. the font and
        background color, are reset to default values.

        **See also** **format** () and **highlightBlock** ().
        """
        ...

    def highlightBlock(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#highlightBlock

        **[pure virtual protected] void QSyntaxHighlighter::highlightBlock(const
        QString & text )**

        Highlights the given text block. This function is called when necessary
        by the rich text engine, i.e. on text blocks which have changed.

        To provide your own syntax highlighting, you must subclass
        **QSyntaxHighlighter**  and reimplement highlightBlock(). In your
        reimplementation you should parse the block's **text** and call
        **setFormat** () as often as necessary to apply any font and color
        changes that you require. For example:

        void MyHighlighter::highlightBlock(const **QString**  &text)
            {
        **QTextCharFormat**  myClassFormat;
        myClassFormat.setFontWeight(**QFont** ::Bold);
        myClassFormat.setForeground(Qt::darkMagenta);
        **QRegularExpression**  expression("\\\\bMy[A-Za-z]+\\\\b");
        **QRegularExpressionMatchIterator**  i = expression.globalMatch(text);
        while (i.hasNext())
                {
                  **QRegularExpressionMatch**
        match = i.next();
                  setFormat(match.capturedStart(),
        match.capturedLength(), myClassFormat);
                }
            }

        See the **Detailed Description**  for examples of using
        **setCurrentBlockState** (), **currentBlockState** () and
        **previousBlockState** () to handle syntaxes with constructs that span
        several text blocks

        **See also** **previousBlockState** (), **setFormat** (), and
        **setCurrentBlockState** ().
        """
        ...

    def rehighlightBlock(self, block: "QTextBlock") -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#rehighlightBlock

        **[slot] void QSyntaxHighlighter::rehighlightBlock(const QTextBlock &
        block )**

        Reapplies the highlighting to the given **QTextBlock**  **block**.

        This function was introduced in Qt 4.6.

        **See also** **rehighlight** ().
        """
        ...

    def rehighlight(self) -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#rehighlight

        **[slot] void QSyntaxHighlighter::rehighlight()**

        Reapplies the highlighting to the whole document.

        This function was introduced in Qt 4.2.

        **See also** **rehighlightBlock** ().
        """
        ...

    def document(self) -> "QTextDocument":
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#document

        **QTextDocument *QSyntaxHighlighter::document() const**

        Returns the **QTextDocument**  on which this syntax highlighter is
        installed.

        **See also** **setDocument** ().
        """
        ...

    def setDocument(self, doc: "QTextDocument") -> None:
        """
        https://doc.qt.io/qt-5/qsyntaxhighlighter.html#setDocument

        **void QSyntaxHighlighter::setDocument(QTextDocument * doc )**

        Installs the syntax highlighter on the given **QTextDocument**  **doc**.
        A **QSyntaxHighlighter**  can only be used with one document at a time.

        **See also** **document** ().
        """
        ...
