"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QStandardItem(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qstandarditem.html

    **Detailed Description**

    Items usually contain text, icons, or checkboxes.

    Each item can have its own background brush which is set with the
    **setBackground** () function. The current background brush can be found
    with **background** (). The text label for each item can be rendered with
    its own font and brush. These are specified with the **setFont** () and
    **setForeground** () functions, and read with **font** () and **foreground**
    ().

    By default, items are enabled, editable, selectable, checkable, and can be
    used both as the source of a drag and drop operation and as a drop target.
    Each item's flags can be changed by calling **setFlags** (). Checkable items
    can be checked and unchecked with the **setCheckState** () function. The
    corresponding **checkState** () function indicates whether the item is
    currently checked.

    You can store application-specific data in an item by calling **setData**
    ().

    Each item can have a two-dimensional table of child items. This makes it
    possible to build hierarchies of items. The typical hierarchy is the tree,
    in which case the child table is a table with a single column (a list).

    The dimensions of the child table can be set with **setRowCount** () and
    **setColumnCount** (). Items can be positioned in the child table with
    **setChild** (). Get a pointer to a child item with **child** (). New rows
    and columns of children can also be inserted with **insertRow** () and
    **insertColumn** (), or appended with **appendRow** () and **appendColumn**
    (). When using the append and insert functions, the dimensions of the child
    table will grow as needed.

    An existing row of children can be removed with **removeRow** () or
    **takeRow** (); correspondingly, a column can be removed with
    **removeColumn** () or **takeColumn** ().

    An item's children can be sorted by calling **sortChildren** ().

    **Subclassing**

    When subclassing QStandardItem to provide custom items, it is possible to
    define new types for them so that they can be distinguished from the base
    class. The **type** () function should be reimplemented to return a new type
    value equal to or greater than **UserType** .

    Reimplement **data** () and **setData** () if you want to perform custom
    handling of data queries and/or control how an item's data is represented.

    Reimplement **clone** () if you want **QStandardItemModel**  to be able to
    create instances of your custom item class on demand (see
    **QStandardItemModel::setItemPrototype** ()).

    Reimplement **read** () and **write** () if you want to control how items
    are represented in their serialized form.

    Reimplement **operator<** () if you want to control the semantics of item
    comparison. **operator<** () determines the sorted order when sorting items
    with **sortChildren** () or with **QStandardItemModel::sort** ().

    **See also** **QStandardItemModel** , **Item View Convenience Classes** ,
    and **Model/View Programming** .
    """

    class ItemType(int):
        Type: QStandardItem = ...
        UserType: QStandardItem = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#QStandardItem

        **QStandardItem::QStandardItem()**

        Constructs an item.
        """
        ...

    @typing.overload
    def __init__(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#QStandardItem-1

        **QStandardItem::QStandardItem(const QString & text )**

        Constructs an item with the given **text**.
        """
        ...

    @typing.overload
    def __init__(self, icon: QIcon, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#QStandardItem-2

        **QStandardItem::QStandardItem(const QIcon & icon , const QString & text
        )**

        Constructs an item with the given **icon** and **text**.
        """
        ...

    @typing.overload
    def __init__(self, rows: int, columns: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#QStandardItem-3

        **QStandardItem::QStandardItem(int rows , int columns = 1)**

        Constructs an item with **rows** rows and **columns** columns of child
        items.
        """
        ...

    @typing.overload
    def __init__(self, other: "QStandardItem") -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#QStandardItem-4

        **[protected] QStandardItem::QStandardItem(const QStandardItem & other
        )**

        Constructs a copy of **other**. Note that **model** () is not copied.

        This function is useful when reimplementing **clone** ().
        """
        ...

    def clearData(self) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#clearData

        **void QStandardItem::clearData()**

        Removes all the data from all roles previously set.

        This function was introduced in Qt 5.12.

        **See also** **data** () and **setData** ().
        """
        ...

    def setUserTristate(self, tristate: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setUserTristate

        **void QStandardItem::setUserTristate(bool tristate )**

        Sets whether the item is tristate and controlled by the user. If
        **tristate** is true, the user can cycle through three separate states;
        otherwise, the item is checkable with two states. (Note that this also
        requires that the item is checkable; see **isCheckable** ().)

        This function was introduced in Qt 5.6.

        **See also** **isUserTristate** (), **setCheckable** (), and
        **setCheckState** ().
        """
        ...

    def isUserTristate(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isUserTristate

        **bool QStandardItem::isUserTristate() const**

        Returns whether the item is tristate; that is, if it's checkable with
        three separate states and the user can cycle through all three states.

        The default value is false.

        This function was introduced in Qt 5.6.

        **See also** **setUserTristate** (), **isCheckable** (), and
        **checkState** ().
        """
        ...

    def setAutoTristate(self, tristate: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setAutoTristate

        **void QStandardItem::setAutoTristate(bool tristate )**

        Determines that the item is tristate and controlled by **QTreeWidget**
        if **tristate** is `true`. This enables automatic management of the
        state of parent items in **QTreeWidget**  (checked if all children are
        checked, unchecked if all children are unchecked, or partially checked
        if only some children are checked).

        This function was introduced in Qt 5.6.

        **See also** **isAutoTristate** (), **setCheckable** (), and
        **setCheckState** ().
        """
        ...

    def isAutoTristate(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isAutoTristate

        **bool QStandardItem::isAutoTristate() const**

        Returns whether the item is tristate and is controlled by
        **QTreeWidget** .

        The default value is false.

        This function was introduced in Qt 5.6.

        **See also** **setAutoTristate** (), **isCheckable** (), and
        **checkState** ().
        """
        ...

    def emitDataChanged(self) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#emitDataChanged

        **[protected] void QStandardItem::emitDataChanged()**

        Causes the model associated with this item to emit a **dataChanged** ()
        signal for this item.

        You normally only need to call this function if you have subclassed
        **QStandardItem**  and reimplemented **data** () and/or **setData** ().

        This function was introduced in Qt 4.4.

        **See also** **setData** ().
        """
        ...

    def appendRows(self, items: typing.Iterable["QStandardItem"]) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#appendRows

        **void QStandardItem::appendRows(const QList<QStandardItem *> & items
        )**

        Appends rows containing **items**. The column count will not change.

        **See also** **insertRow** ().
        """
        ...

    def appendColumn(self, items: typing.Iterable["QStandardItem"]) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#appendColumn

        **void QStandardItem::appendColumn(const QList<QStandardItem *> & items
        )**

        Appends a column containing **items**. If necessary, the row count is
        increased to the size of **items**.

        **See also** **insertColumn** ().
        """
        ...

    @typing.overload
    def appendRow(self, items: typing.Iterable["QStandardItem"]) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#appendRow

        **void QStandardItem::appendRow(const QList<QStandardItem *> & items )**

        Appends a row containing **items**. If necessary, the column count is
        increased to the size of **items**.

        **See also** **insertRow** ().
        """
        ...

    @typing.overload
    def appendRow(self, aitem: "QStandardItem") -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#appendRow-1

        **void QStandardItem::appendRow(QStandardItem * item )**

        This is an overloaded function.

        Appends a row containing **item**.

        When building a list or a tree that has only one column, this function
        provides a convenient way to append a single new item.
        """
        ...

    def setAccessibleDescription(self, aaccessibleDescription: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setAccessibleDescription

        **void QStandardItem::setAccessibleDescription(const QString &
        accessibleDescription )**

        Sets the item's accessible description to the string specified by
        **accessibleDescription**.

        The accessible description is used by assistive technologies (i.e. for
        users who cannot use conventional means of interaction).

        **See also** **accessibleDescription** () and **setAccessibleText** ().
        """
        ...

    def setAccessibleText(self, aaccessibleText: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setAccessibleText

        **void QStandardItem::setAccessibleText(const QString & accessibleText
        )**

        Sets the item's accessible text to the string specified by
        **accessibleText**.

        The accessible text is used by assistive technologies (i.e. for users
        who cannot use conventional means of interaction).

        **See also** **accessibleText** () and **setAccessibleDescription** ().
        """
        ...

    def setCheckState(self, acheckState: QtCore.Qt.CheckState) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setCheckState

        **void QStandardItem::setCheckState(Qt::CheckState state )**

        Sets the check state of the item to be **state**.

        **See also** **checkState** () and **setCheckable** ().
        """
        ...

    def setForeground(
        self, abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setForeground

        **void QStandardItem::setForeground(const QBrush & brush )**

        Sets the brush used to display the item's foreground (e.g. text) to the
        given **brush**.

        **See also** **foreground** (), **setBackground** (), and **setFont**
        ().
        """
        ...

    def setBackground(
        self, abrush: typing.Union[QBrush, QColor, QtCore.Qt.GlobalColor, QGradient]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setBackground

        **void QStandardItem::setBackground(const QBrush & brush )**

        Sets the item's background brush to the specified **brush**.

        **See also** **background** () and **setForeground** ().
        """
        ...

    def setTextAlignment(
        self, atextAlignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setTextAlignment

        **void QStandardItem::setTextAlignment(Qt::Alignment alignment )**

        Sets the text alignment for the item's text to the **alignment**
        specified.

        **See also** **textAlignment** ().
        """
        ...

    def setFont(self, afont: QFont) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setFont

        **void QStandardItem::setFont(const QFont & font )**

        Sets the font used to display the item's text to the given **font**.

        **See also** **font** (), **setText** (), and **setForeground** ().
        """
        ...

    def setSizeHint(self, asizeHint: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setSizeHint

        **void QStandardItem::setSizeHint(const QSize & size )**

        Sets the size hint for the item to be **size**. If no size hint is set,
        the item delegate will compute the size hint based on the item data.

        **See also** **sizeHint** ().
        """
        ...

    def setWhatsThis(self, awhatsThis: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setWhatsThis

        **void QStandardItem::setWhatsThis(const QString & whatsThis )**

        Sets the item's "What's This?" help to the string specified by
        **whatsThis**.

        **See also** **whatsThis** (), **setStatusTip** (), and **setToolTip**
        ().
        """
        ...

    def setStatusTip(self, astatusTip: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setStatusTip

        **void QStandardItem::setStatusTip(const QString & statusTip )**

        Sets the item's status tip to the string specified by **statusTip**.

        **See also** **statusTip** (), **setToolTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setToolTip(self, atoolTip: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setToolTip

        **void QStandardItem::setToolTip(const QString & toolTip )**

        Sets the item's tooltip to the string specified by **toolTip**.

        **See also** **toolTip** (), **setStatusTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setIcon(self, aicon: QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setIcon

        **void QStandardItem::setIcon(const QIcon & icon )**

        Sets the item's icon to the **icon** specified.

        **See also** **icon** ().
        """
        ...

    def setText(self, atext: str) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setText

        **void QStandardItem::setText(const QString & text )**

        Sets the item's text to the **text** specified.

        **See also** **text** (), **setFont** (), and **setForeground** ().
        """
        ...

    def write(self, out: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#write

        **[virtual] void QStandardItem::write(QDataStream & out ) const**

        Writes the item to stream **out**. Only the data and flags of the item
        are written, not the child items.

        **See also** **read** ().
        """
        ...

    def read(self, in_: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#read

        **[virtual] void QStandardItem::read(QDataStream & in )**

        Reads the item from stream **in**. Only the data and flags of the item
        are read, not the child items.

        **See also** **write** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#type

        **[virtual] int QStandardItem::type() const**

        Returns the type of this item. The type is used to distinguish custom
        items from the base class. When subclassing **QStandardItem** , you
        should reimplement this function and return a new value greater than or
        equal to **UserType** .

        **See also** **QStandardItem::Type** .
        """
        ...

    def clone(self) -> "QStandardItem":
        """
        https://doc.qt.io/qt-5/qstandarditem.html#clone

        **[virtual] QStandardItem *QStandardItem::clone() const**

        Returns a copy of this item. The item's children are not copied.

        When subclassing **QStandardItem** , you can reimplement this function
        to provide **QStandardItemModel**  with a factory that it can use to
        create new items on demand.

        **See also** **QStandardItemModel::setItemPrototype** () and
        **operator=** ().
        """
        ...

    def sortChildren(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#sortChildren

        **void QStandardItem::sortChildren(int column , Qt::SortOrder order =
        Qt::AscendingOrder)**

        Sorts the children of the item using the given **order** , by the values
        in the given **column**.

        **Note:** This function is recursive, therefore it sorts the children of
        the item, its grandchildren, etc.

        **See also** **operator<** ().
        """
        ...

    def takeColumn(self, column: int) -> typing.List["QStandardItem"]:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#takeColumn

        **QList<QStandardItem *> QStandardItem::takeColumn(int column )**

        Removes **column** without deleting the column items, and returns a list
        of pointers to the removed items. For items in the column that have not
        been set, the corresponding pointers in the list will be `nullptr`.

        **See also** **removeColumn** (), **insertColumn** (), and **takeRow**
        ().
        """
        ...

    def takeRow(self, row: int) -> typing.List["QStandardItem"]:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#takeRow

        **QList<QStandardItem *> QStandardItem::takeRow(int row )**

        Removes **row** without deleting the row items, and returns a list of
        pointers to the removed items. For items in the row that have not been
        set, the corresponding pointers in the list will be `nullptr`.

        **See also** **removeRow** (), **insertRow** (), and **takeColumn** ().
        """
        ...

    def takeChild(self, row: int, column: int = ...) -> "QStandardItem":
        """
        https://doc.qt.io/qt-5/qstandarditem.html#takeChild

        **QStandardItem *QStandardItem::takeChild(int row , int column = 0)**

        Removes the child item at ( **row** , **column** ) without deleting it,
        and returns a pointer to the item. If there was no child at the given
        location, then this function returns `nullptr`.

        Note that this function, unlike **takeRow** () and **takeColumn** (),
        does not affect the dimensions of the child table.

        **See also** **child** (), **takeRow** (), and **takeColumn** ().
        """
        ...

    def removeColumns(self, column: int, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#removeColumns

        **void QStandardItem::removeColumns(int column , int count )**

        Removes **count** columns at column **column**. The items that were in
        those columns are deleted.

        **See also** **removeColumn** () and **removeRows** ().
        """
        ...

    def removeRows(self, row: int, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#removeRows

        **void QStandardItem::removeRows(int row , int count )**

        Removes **count** rows at row **row**. The items that were in those rows
        are deleted.

        **See also** **removeRow** () and **removeColumn** ().
        """
        ...

    def removeColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#removeColumn

        **void QStandardItem::removeColumn(int column )**

        Removes the given **column**. The items that were in the column are
        deleted.

        **See also** **takeColumn** (), **removeColumns** (), and **removeRow**
        ().
        """
        ...

    def removeRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#removeRow

        **void QStandardItem::removeRow(int row )**

        Removes the given **row**. The items that were in the row are deleted.

        **See also** **takeRow** (), **removeRows** (), and **removeColumn** ().
        """
        ...

    def insertColumns(self, column: int, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertColumns

        **void QStandardItem::insertColumns(int column , int count )**

        Inserts **count** columns of child items at column **column**.

        **See also** **insertColumn** () and **insertRows** ().
        """
        ...

    def insertColumn(
        self, column: int, items: typing.Iterable["QStandardItem"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertColumn

        **void QStandardItem::insertColumn(int column , const
        QList<QStandardItem *> & items )**

        Inserts a column at **column** containing **items**. If necessary, the
        row count is increased to the size of **items**.

        **See also** **insertColumns** () and **insertRow** ().
        """
        ...

    @typing.overload
    def insertRows(self, row: int, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertRows

        **void QStandardItem::insertRows(int row , const QList<QStandardItem *>
        & items )**

        Inserts **items** at **row**. The column count won't be changed.

        **See also** **insertRow** () and **insertColumn** ().
        """
        ...

    @typing.overload
    def insertRows(self, row: int, items: typing.Iterable["QStandardItem"]) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertRows-1

        **void QStandardItem::insertRows(int row , int count )**

        Inserts **count** rows of child items at row **row**.

        **See also** **insertRow** () and **insertColumns** ().
        """
        ...

    @typing.overload
    def insertRow(self, row: int, items: typing.Iterable["QStandardItem"]) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertRow

        **void QStandardItem::insertRow(int row , const QList<QStandardItem *> &
        items )**

        Inserts a row at **row** containing **items**. If necessary, the column
        count is increased to the size of **items**.

        **See also** **insertRows** () and **insertColumn** ().
        """
        ...

    @typing.overload
    def insertRow(self, arow: int, aitem: "QStandardItem") -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#insertRow-1

        **void QStandardItem::insertRow(int row , QStandardItem * item )**

        This is an overloaded function.

        Inserts a row at **row** containing **item**.

        When building a list or a tree that has only one column, this function
        provides a convenient way to insert a single new item.
        """
        ...

    @typing.overload
    def setChild(self, row: int, column: int, item: "QStandardItem") -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setChild

        **void QStandardItem::setChild(int row , int column , QStandardItem *
        item )**

        Sets the child item at ( **row** , **column** ) to **item**. This item
        (the parent item) takes ownership of **item**. If necessary, the row
        count and column count are increased to fit the item.

        **Note:** Passing `nullptr` as **item** removes the item.

        **See also** **child** ().
        """
        ...

    @typing.overload
    def setChild(self, arow: int, aitem: "QStandardItem") -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setChild-1

        **void QStandardItem::setChild(int row , QStandardItem * item )**

        This is an overloaded function.

        Sets the child at **row** to **item**.
        """
        ...

    def child(self, row: int, column: int = ...) -> "QStandardItem":
        """
        https://doc.qt.io/qt-5/qstandarditem.html#child

        **QStandardItem *QStandardItem::child(int row , int column = 0) const**

        Returns the child item at ( **row** , **column** ) if one has been set;
        otherwise returns `nullptr`.

        **See also** **setChild** (), **takeChild** (), and **parent** ().
        """
        ...

    def hasChildren(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#hasChildren

        **bool QStandardItem::hasChildren() const**

        Returns `true` if this item has any children; otherwise returns `false`.

        **See also** **rowCount** (), **columnCount** (), and **child** ().
        """
        ...

    def setColumnCount(self, columns: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setColumnCount

        **void QStandardItem::setColumnCount(int columns )**

        Sets the number of child item columns to **columns**. If this is less
        than **columnCount** (), the data in the unwanted columns is discarded.

        **See also** **columnCount** () and **setRowCount** ().
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#columnCount

        **int QStandardItem::columnCount() const**

        Returns the number of child item columns that the item has.

        **See also** **setColumnCount** () and **rowCount** ().
        """
        ...

    def setRowCount(self, rows: int) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setRowCount

        **void QStandardItem::setRowCount(int rows )**

        Sets the number of child item rows to **rows**. If this is less than
        **rowCount** (), the data in the unwanted rows is discarded.

        **See also** **rowCount** () and **setColumnCount** ().
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#rowCount

        **int QStandardItem::rowCount() const**

        Returns the number of child item rows that the item has.

        **See also** **setRowCount** () and **columnCount** ().
        """
        ...

    def model(self) -> QStandardItemModel:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#model

        **QStandardItemModel *QStandardItem::model() const**

        Returns the **QStandardItemModel**  that this item belongs to.

        If the item is not a child of another item that belongs to the model,
        this function returns `nullptr`.

        **See also** **index** ().
        """
        ...

    def index(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#index

        **QModelIndex QStandardItem::index() const**

        Returns the **QModelIndex**  associated with this item.

        When you need to invoke item functionality in a **QModelIndex** -based
        API (e.g. **QAbstractItemView** ), you can call this function to obtain
        an index that corresponds to the item's location in the model.

        If the item is not associated with a model, an invalid **QModelIndex**
        is returned.

        **See also** **model** () and **QStandardItemModel::itemFromIndex** ().
        """
        ...

    def column(self) -> int:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#column

        **int QStandardItem::column() const**

        Returns the column where the item is located in its parent's child
        table, or -1 if the item has no parent.

        **See also** **row** () and **parent** ().
        """
        ...

    def row(self) -> int:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#row

        **int QStandardItem::row() const**

        Returns the row where the item is located in its parent's child table,
        or -1 if the item has no parent.

        **See also** **column** () and **parent** ().
        """
        ...

    def parent(self) -> "QStandardItem":
        """
        https://doc.qt.io/qt-5/qstandarditem.html#parent

        **QStandardItem *QStandardItem::parent() const**

        Returns the item's parent item, or `nullptr` if the item has no parent.

        **Note:** For toplevel items parent() returns `nullptr`. To receive
        toplevel item's parent use **QStandardItemModel::invisibleRootItem** ()
        instead.

        **See also** **child** () and **QStandardItemModel::invisibleRootItem**
        ().
        """
        ...

    def setDropEnabled(self, dropEnabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setDropEnabled

        **void QStandardItem::setDropEnabled(bool dropEnabled )**

        Sets whether the item is drop enabled. If **dropEnabled** is true, the
        item can be used as a drop target; otherwise, it cannot.

        Note that you also need to ensure that drops are enabled in the view;
        see **QWidget::acceptDrops** (); and that the model supports the desired
        drop actions; see **QAbstractItemModel::supportedDropActions** ().

        **See also** **isDropEnabled** (), **setDragEnabled** (), and
        **setFlags** ().
        """
        ...

    def isDropEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isDropEnabled

        **bool QStandardItem::isDropEnabled() const**

        Returns whether the item is drop enabled. When an item is drop enabled,
        it can be used as a drop target.

        The default value is true.

        **See also** **setDropEnabled** (), **isDragEnabled** (), and **flags**
        ().
        """
        ...

    def setDragEnabled(self, dragEnabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setDragEnabled

        **void QStandardItem::setDragEnabled(bool dragEnabled )**

        Sets whether the item is drag enabled. If **dragEnabled** is true, the
        item can be dragged by the user; otherwise, the user cannot drag the
        item.

        Note that you also need to ensure that item dragging is enabled in the
        view; see **QAbstractItemView::dragEnabled** .

        **See also** **isDragEnabled** (), **setDropEnabled** (), and
        **setFlags** ().
        """
        ...

    def isDragEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isDragEnabled

        **bool QStandardItem::isDragEnabled() const**

        Returns whether the item is drag enabled. An item that is drag enabled
        can be dragged by the user.

        The default value is true.

        Note that item dragging must be enabled in the view for dragging to
        work; see **QAbstractItemView::dragEnabled** .

        **See also** **setDragEnabled** (), **isDropEnabled** (), and **flags**
        ().
        """
        ...

    def setTristate(self, tristate: bool) -> None:
        ...

    def isTristate(self) -> bool:
        ...

    def setCheckable(self, checkable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setCheckable

        **void QStandardItem::setCheckable(bool checkable )**

        Sets whether the item is user-checkable. If **checkable** is true, the
        item can be checked by the user; otherwise, the user cannot check the
        item.

        The item delegate will render a checkable item with a check box next to
        the item's text.

        **See also** **isCheckable** (), **setCheckState** (),
        **setUserTristate** (), and **setAutoTristate** ().
        """
        ...

    def isCheckable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isCheckable

        **bool QStandardItem::isCheckable() const**

        Returns whether the item is user-checkable.

        The default value is false.

        **See also** **setCheckable** (), **checkState** (), **isUserTristate**
        (), and **isAutoTristate** ().
        """
        ...

    def setSelectable(self, selectable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setSelectable

        **void QStandardItem::setSelectable(bool selectable )**

        Sets whether the item is selectable. If **selectable** is true, the item
        can be selected by the user; otherwise, the user cannot select the item.

        You can control the selection behavior and mode by manipulating their
        view properties; see **QAbstractItemView::selectionMode**  and
        **QAbstractItemView::selectionBehavior** .

        **See also** **isSelectable** () and **setFlags** ().
        """
        ...

    def isSelectable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isSelectable

        **bool QStandardItem::isSelectable() const**

        Returns whether the item is selectable by the user.

        The default value is true.

        **See also** **setSelectable** () and **flags** ().
        """
        ...

    def setEditable(self, editable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setEditable

        **void QStandardItem::setEditable(bool editable )**

        Sets whether the item is editable. If **editable** is true, the item can
        be edited by the user; otherwise, the user cannot edit the item.

        How the user can edit items in a view is determined by the view's edit
        triggers; see **QAbstractItemView::editTriggers** .

        **See also** **isEditable** () and **setFlags** ().
        """
        ...

    def isEditable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isEditable

        **bool QStandardItem::isEditable() const**

        Returns whether the item can be edited by the user.

        When an item is editable (and enabled), the user can edit the item by
        invoking one of the view's edit triggers; see
        **QAbstractItemView::editTriggers** .

        The default value is true.

        **See also** **setEditable** () and **flags** ().
        """
        ...

    def setEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setEnabled

        **void QStandardItem::setEnabled(bool enabled )**

        Sets whether the item is enabled. If **enabled** is true, the item is
        enabled, meaning that the user can interact with the item; if
        **enabled** is false, the user cannot interact with the item.

        This flag takes precedence over the other item flags; e.g. if an item is
        not enabled, it cannot be selected by the user, even if the
        **Qt::ItemIsSelectable**  flag has been set.

        **See also** **isEnabled** (), **Qt::ItemIsEnabled** , and **setFlags**
        ().
        """
        ...

    def isEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#isEnabled

        **bool QStandardItem::isEnabled() const**

        Returns whether the item is enabled.

        When an item is enabled, the user can interact with it. The possible
        types of interaction are specified by the other item flags, such as
        **isEditable** () and **isSelectable** ().

        The default value is true.

        **See also** **setEnabled** () and **flags** ().
        """
        ...

    def setFlags(
        self, flags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setFlags

        **void QStandardItem::setFlags(Qt::ItemFlags flags )**

        Sets the item flags for the item to **flags**.

        The item flags determine how the user can interact with the item. This
        is often used to disable an item.

        **See also** **flags** () and **setData** ().
        """
        ...

    def flags(self) -> QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#flags

        **Qt::ItemFlags QStandardItem::flags() const**

        Returns the item flags for the item.

        The item flags determine how the user can interact with the item.

        By default, items are enabled, editable, selectable, checkable, and can
        be used both as the source of a drag and drop operation and as a drop
        target.

        **See also** **setFlags** ().
        """
        ...

    def accessibleDescription(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#accessibleDescription

        **QString QStandardItem::accessibleDescription() const**

        Returns the item's accessible description.

        The accessible description is used by assistive technologies (i.e. for
        users who cannot use conventional means of interaction).

        **See also** **setAccessibleDescription** () and **accessibleText** ().
        """
        ...

    def accessibleText(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#accessibleText

        **QString QStandardItem::accessibleText() const**

        Returns the item's accessible text.

        The accessible text is used by assistive technologies (i.e. for users
        who cannot use conventional means of interaction).

        **See also** **setAccessibleText** () and **accessibleDescription** ().
        """
        ...

    def checkState(self) -> QtCore.Qt.CheckState:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#checkState

        **Qt::CheckState QStandardItem::checkState() const**

        Returns the checked state of the item.

        **See also** **setCheckState** () and **isCheckable** ().
        """
        ...

    def foreground(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#foreground

        **QBrush QStandardItem::foreground() const**

        Returns the brush used to render the item's foreground (e.g. text).

        **See also** **setForeground** () and **background** ().
        """
        ...

    def background(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#background

        **QBrush QStandardItem::background() const**

        Returns the brush used to render the item's background.

        **See also** **foreground** () and **setBackground** ().
        """
        ...

    def textAlignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#textAlignment

        **Qt::Alignment QStandardItem::textAlignment() const**

        Returns the text alignment for the item's text.

        **See also** **setTextAlignment** ().
        """
        ...

    def font(self) -> QFont:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#font

        **QFont QStandardItem::font() const**

        Returns the font used to render the item's text.

        **See also** **setFont** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#sizeHint

        **QSize QStandardItem::sizeHint() const**

        Returns the size hint set for the item, or an invalid **QSize**  if no
        size hint has been set.

        If no size hint has been set, the item delegate will compute the size
        hint based on the item data.

        **See also** **setSizeHint** ().
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#whatsThis

        **QString QStandardItem::whatsThis() const**

        Returns the item's "What's This?" help.

        **See also** **setWhatsThis** (), **toolTip** (), and **statusTip** ().
        """
        ...

    def statusTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#statusTip

        **QString QStandardItem::statusTip() const**

        Returns the item's status tip.

        **See also** **setStatusTip** (), **toolTip** (), and **whatsThis** ().
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#toolTip

        **QString QStandardItem::toolTip() const**

        Returns the item's tooltip.

        **See also** **setToolTip** (), **statusTip** (), and **whatsThis** ().
        """
        ...

    def icon(self) -> QIcon:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#icon

        **QIcon QStandardItem::icon() const**

        Returns the item's icon.

        **See also** **setIcon** () and **iconSize** .
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#text

        **QString QStandardItem::text() const**

        Returns the item's text. This is the text that's presented to the user
        in a view.

        **See also** **setText** ().
        """
        ...

    def setData(self, value: typing.Any, role: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#setData

        **[virtual] void QStandardItem::setData(const QVariant & value , int
        role = Qt::UserRole + 1)**

        Sets the item's data for the given **role** to the specified **value**.

        If you subclass **QStandardItem**  and reimplement this function, your
        reimplementation should call **emitDataChanged** () if you do not call
        the base implementation of setData(). This will ensure that e.g. views
        using the model are notified of the changes.

        **Note:** The default implementation treats **Qt::EditRole**  and
        **Qt::DisplayRole**  as referring to the same data.

        **See also** **Qt::ItemDataRole** , **data** (), and **setFlags** ().
        """
        ...

    def data(self, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qstandarditem.html#data

        **[virtual] QVariant QStandardItem::data(int role = Qt::UserRole + 1)
        const**

        Returns the item's data for the given **role** , or an invalid
        **QVariant**  if there is no data for the role.

        **Note:** The default implementation treats **Qt::EditRole**  and
        **Qt::DisplayRole**  as referring to the same data.

        **See also** **setData** ().
        """
        ...
