"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QRegExpValidator(QValidator):
    """
    https://doc.qt.io/qt-5/qregexpvalidator.html

    **Detailed Description**

    QRegExpValidator uses a regular expression (regexp) to determine whether an
    input string is **Acceptable** , **Intermediate** , or **Invalid** . The
    regexp can either be supplied when the QRegExpValidator is constructed, or
    at a later time.

    When QRegExpValidator determines whether a string is **Acceptable**  or not,
    the regexp is treated as if it begins with the start of string assertion (
    **^** ) and ends with the end of string assertion ( **$** ); the match is
    against the entire input string, or from the given position if a start
    position greater than zero is given.

    If a string is a prefix of an **Acceptable**  string, it is considered
    **Intermediate** . For example, "" and "A" are **Intermediate**  for the
    regexp **[A-Z][0-9]** (whereas "**_** " would be **Invalid** ).

    For a brief introduction to Qt's regexp engine, see **QRegExp** .

    Example of use:

    // regexp: optional '-' followed by between 1 and 3 digits
        **QRegExp**
    rx("-?\\\\d{1,3}");
        **QValidator**  *validator = new **QRegExpValidator**
    (rx, this);

        **QLineEdit**  *edit = new **QLineEdit** (this);
    edit->setValidator(validator);

    Below we present some examples of validators. In practice they would
    normally be associated with a widget as in the example above.

    // integers 1 to 9999
        **QRegExp**  rx("[1-9]\\\\d{0,3}");
        // the
    validator treats the regexp as "^[1-9]\\\\d{0,3}$"
        **QRegExpValidator**
    v(rx, 0);
        **QString**  s;
        int pos = 0;

        s = "0";
    v.validate(s, pos);    // returns Invalid
        s = "12345"; v.validate(s,
    pos);    // returns Invalid
        s = "1";     v.validate(s, pos);    //
    returns Acceptable

        rx.setPattern("\\\\S+");            // one or more
    non-whitespace characters
        v.setRegExp(rx);
        s = "myfile.txt";
    v.validate(s, pos); // Returns Acceptable
        s = "my file.txt";
    v.validate(s, pos); // Returns Invalid

        // A, B or C followed by
    exactly five digits followed by W, X, Y or Z
    rx.setPattern("[A-C]\\\\d{5}[W-Z]");
        v.setRegExp(rx);
        s = "a12345Z";
    v.validate(s, pos);        // Returns Invalid
        s = "A12345Z";
    v.validate(s, pos);        // Returns Acceptable
        s = "B12";
    v.validate(s, pos);        // Returns Intermediate

        // match most
    'readme' files
        rx.setPattern("read\\\\S?me(\\.(txt|asc|1st))?");
    rx.setCaseSensitive(false);
        v.setRegExp(rx);
        s = "readme";
    v.validate(s, pos); // Returns Acceptable
        s = "README.1ST";
    v.validate(s, pos); // Returns Acceptable
        s = "read me.txt";
    v.validate(s, pos); // Returns Invalid
        s = "readm";       v.validate(s,
    pos); // Returns Intermediate

    **See also** **QRegExp** , **QIntValidator** , **QDoubleValidator** , and
    **Settings Editor Example** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qregexpvalidator.html#QRegExpValidator

        **QRegExpValidator::QRegExpValidator(QObject * parent = nullptr)**

        Constructs a validator with a **parent** object that accepts any string
        (including an empty one) as valid.
        """
        ...

    @typing.overload
    def __init__(
        self, rx: QtCore.QRegExp, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qregexpvalidator.html#QRegExpValidator-1

        **QRegExpValidator::QRegExpValidator(const QRegExp & rx , QObject *
        parent = nullptr)**

        Constructs a validator with a **parent** object that accepts all strings
        that match the regular expression **rx**.

        The match is made against the entire string; e.g. if the regexp is
        **[A-Fa-f0-9]+** it will be treated as **^[A-Fa-f0-9]+$**.
        """
        ...

    def regExp(self) -> QtCore.QRegExp:
        """
        https://doc.qt.io/qt-5/qregexpvalidator.html#regExp-prop

        **regExp : QRegExp**

        This property holds the regular expression used for validation

        By default, this property contains a regular expression with the pattern
        `.*` that matches any string.

        **Access functions:**

        const QRegExp & **regExp** () const
        void **setRegExp** (const QRegExp
        & **rx** )

        **Notifier signal:**

        void **regExpChanged** (const QRegExp & **regExp** )

        **Member Function Documentation**
        """
        ...

    def setRegExp(self, rx: QtCore.QRegExp) -> None:
        """
        https://doc.qt.io/qt-5/qregexpvalidator.html#regExp-prop

        **regExp : QRegExp**

        This property holds the regular expression used for validation

        By default, this property contains a regular expression with the pattern
        `.*` that matches any string.

        **Access functions:**

        const QRegExp & **regExp** () const
        void **setRegExp** (const QRegExp
        & **rx** )

        **Notifier signal:**

        void **regExpChanged** (const QRegExp & **regExp** )

        **Member Function Documentation**
        """
        ...

    def validate(
        self, input: str, pos: int
    ) -> typing.Tuple[QValidator.State, str, int]:
        """
        https://doc.qt.io/qt-5/qregexpvalidator.html#validate

        **[override virtual] QValidator::State
        QRegExpValidator::validate(QString & input , int & pos ) const**

        Reimplements: **QValidator::validate** (QString &input, int &pos) const.

        Returns **Acceptable**  if **input** is matched by the regular
        expression for this validator, **Intermediate**  if it has matched
        partially (i.e. could be a valid match if additional valid characters
        are added), and **Invalid**  if **input** is not matched.

        Additionally, if **input** is not matched, the **pos** parameter is set
        to the length of the **input** parameter.

        For example, if the regular expression is **\\w\\d\\d** (word-character,
        digit, digit) then "A57" is **Acceptable** , "E5" is **Intermediate** ,
        and "+9" is **Invalid** .

        **See also** **QRegExp::exactMatch** ().
        """
        ...

    @property
    def regExpChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
