"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPolygonF(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpolygonf.html

    **Detailed Description**

    A QPolygonF is a **QVector** <**QPointF** >. The easiest way to add points
    to a QPolygonF is to use its streaming operator, as illustrated below:

    **QPolygonF**  polygon;
                polygon << **QPointF** (10.4, 20.5) <<
    **QPointF** (20.2, 30.2);

    In addition to the functions provided by **QVector** , QPolygonF provides
    the **boundingRect** () and **translate** () functions for geometry
    operations. Use the **QTransform::map** () function for more general
    transformations of QPolygonFs.

    QPolygonF also provides the **isClosed** () function to determine whether a
    polygon's start and end points are the same, and the **toPolygon** ()
    function returning an integer precision copy of this polygon.

    The QPolygonF class is **implicitly shared** .

    **See also** **QVector** , **QPolygon** , and **QLineF** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF

        **QPolygonF::QPolygonF()**

        Constructs a polygon with no points.

        **See also** **QVector::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(self, a: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF-1

        **QPolygonF::QPolygonF(int size )**

        Constructs a polygon of the given **size**. Creates an empty polygon if
        **size** == 0.

        **See also** **QVector::isEmpty** ().
        """
        ...

    @typing.overload
    def __init__(
        self, v: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF-2

        **QPolygonF::QPolygonF(const QVector<QPointF> & points )**

        Constructs a polygon containing the specified **points**.
        """
        ...

    @typing.overload
    def __init__(self, r: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF-4

        **QPolygonF::QPolygonF(const QRectF & rectangle )**

        Constructs a closed polygon from the specified **rectangle**.

        The polygon contains the four vertices of the rectangle in clockwise
        order starting and ending with the top-left vertex.

        **See also** **isClosed** ().
        """
        ...

    @typing.overload
    def __init__(self, a: QPolygon) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF-5

        **QPolygonF::QPolygonF(const QPolygon & polygon )**

        Constructs a float based polygon from the specified integer based
        **polygon**.

        **See also** **toPolygon** ().
        """
        ...

    @typing.overload
    def __init__(self, asize: int) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#QPolygonF-6

        **QPolygonF::QPolygonF(const QPolygonF & polygon )**

        Constructs a copy of the given **polygon**.
        """
        ...

    def intersects(self, r: "QPolygonF") -> bool:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#intersects

        **bool QPolygonF::intersects(const QPolygonF & p ) const**

        Returns `true` if the current polygon intersects at any point the given
        polygon **p**. Also returns `true` if the current polygon contains or is
        contained by any part of **p**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 5.10.

        **See also** **intersected** ().
        """
        ...

    def swap(self, other: "QPolygonF") -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#swap

        **void QPolygonF::swap(QPolygonF & other )**

        Swaps polygon **other** with this polygon. This operation is very fast
        and never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def __contains__(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int:
        ...

    @typing.overload
    def __delitem__(self, i: int) -> None:
        ...

    @typing.overload
    def __delitem__(self, slice: slice) -> None:
        ...

    @typing.overload
    def __setitem__(
        self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        ...

    @typing.overload
    def __setitem__(self, slice: slice, list: "QPolygonF") -> None:
        ...

    @typing.overload
    def __getitem__(self, i: int) -> QtCore.QPointF:
        ...

    @typing.overload
    def __getitem__(self, slice: slice) -> "QPolygonF":
        ...

    @typing.overload
    def value(self, i: int) -> QtCore.QPointF:
        ...

    @typing.overload
    def value(
        self, i: int, defaultValue: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> QtCore.QPointF:
        ...

    def size(self) -> int:
        ...

    def replace(
        self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        ...

    @typing.overload
    def remove(self, i: int) -> None:
        ...

    @typing.overload
    def remove(self, i: int, count: int) -> None:
        ...

    def prepend(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        ...

    def mid(self, pos: int, length: int = ...) -> "QPolygonF":
        ...

    def lastIndexOf(
        self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...
    ) -> int:
        ...

    def last(self) -> QtCore.QPointF:
        ...

    def isEmpty(self) -> bool:
        ...

    def insert(
        self, i: int, value: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        ...

    def indexOf(
        self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], from_: int = ...
    ) -> int:
        ...

    def first(self) -> QtCore.QPointF:
        ...

    def fill(
        self, value: typing.Union[QtCore.QPointF, QtCore.QPoint], size: int = ...
    ) -> None:
        ...

    def data(self) -> PyQt5.sip.voidptr:
        ...

    def __len__(self) -> int:
        ...

    @typing.overload
    def count(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int:
        ...

    @typing.overload
    def count(self) -> int:
        ...

    def contains(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        ...

    def clear(self) -> None:
        ...

    def at(self, i: int) -> QtCore.QPointF:
        ...

    def append(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        ...

    @typing.overload
    def translated(
        self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> "QPolygonF":
        """
        https://doc.qt.io/qt-5/qpolygonf.html#translated

        **QPolygonF QPolygonF::translated(const QPointF & offset ) const**

        Returns a copy of the polygon that is translated by the given
        **offset**.

        This function was introduced in Qt 4.6.

        **See also** **translate** ().
        """
        ...

    @typing.overload
    def translated(self, dx: float, dy: float) -> "QPolygonF":
        """
        https://doc.qt.io/qt-5/qpolygonf.html#translated-1

        **QPolygonF QPolygonF::translated(qreal dx , qreal dy ) const**

        This is an overloaded function.

        Returns a copy of the polygon that is translated by ( **dx** , **dy** ).

        This function was introduced in Qt 4.6.

        **See also** **translate** ().
        """
        ...

    def subtracted(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-5/qpolygonf.html#subtracted

        **QPolygonF QPolygonF::subtracted(const QPolygonF & r ) const**

        Returns a polygon which is **r** subtracted from this polygon.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 4.3.
        """
        ...

    def intersected(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-5/qpolygonf.html#intersected

        **QPolygonF QPolygonF::intersected(const QPolygonF & r ) const**

        Returns a polygon which is the intersection of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 4.3.

        **See also** **intersects** ().
        """
        ...

    def united(self, r: "QPolygonF") -> "QPolygonF":
        """
        https://doc.qt.io/qt-5/qpolygonf.html#united

        **QPolygonF QPolygonF::united(const QPolygonF & r ) const**

        Returns a polygon which is the union of this polygon and **r**.

        Set operations on polygons will treat the polygons as areas. Non-closed
        polygons will be treated as implicitly closed.

        This function was introduced in Qt 4.3.

        **See also** **intersected** () and **subtracted** ().
        """
        ...

    def containsPoint(
        self,
        pt: typing.Union[QtCore.QPointF, QtCore.QPoint],
        fillRule: QtCore.Qt.FillRule,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#containsPoint

        **bool QPolygonF::containsPoint(const QPointF & point , Qt::FillRule
        fillRule ) const**

        Returns `true` if the given **point** is inside the polygon according to
        the specified **fillRule** ; otherwise returns `false`.

        This function was introduced in Qt 4.3.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#boundingRect

        **QRectF QPolygonF::boundingRect() const**

        Returns the bounding rectangle of the polygon, or **QRectF** (0,0,0,0)
        if the polygon is empty.

        **See also** **QVector::isEmpty** ().
        """
        ...

    def isClosed(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#isClosed

        **bool QPolygonF::isClosed() const**

        Returns `true` if the polygon is closed; otherwise returns `false`.

        A polygon is said to be closed if its start point and end point are
        equal.

        **See also** **QVector::first** () and **QVector::last** ().
        """
        ...

    def toPolygon(self) -> QPolygon:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#toPolygon

        **QPolygon QPolygonF::toPolygon() const**

        Creates and returns a **QPolygon**  by converting each **QPointF**  to a
        **QPoint** .

        **See also** **QPointF::toPoint** ().
        """
        ...

    @typing.overload
    def translate(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#translate

        **void QPolygonF::translate(const QPointF & offset )**

        Translate all points in the polygon by the given **offset**.

        **See also** **translated** ().
        """
        ...

    @typing.overload
    def translate(self, dx: float, dy: float) -> None:
        """
        https://doc.qt.io/qt-5/qpolygonf.html#translate-1

        **void QPolygonF::translate(qreal dx , qreal dy )**

        This is an overloaded function.

        Translates all points in the polygon by ( **dx** , **dy** ).

        **See also** **translated** ().
        """
        ...
