"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QOpenGLDebugMessage(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qopengldebugmessage.html

    **Detailed Description**

    Debug messages are usually created by the OpenGL server and then read by
    OpenGL clients (either from the OpenGL internal debug log, or logged in
    real-time). A debug message has a textual representation, a vendor-specific
    numeric id, a source, a type and a severity.

    It's also possible for applications or third-party libraries and toolkits to
    create and insert messages in the debug log. In order to do so, you can use
    the **createApplicationMessage** () or the **createThirdPartyMessage** ()
    static functions.

    **See also** **QOpenGLDebugLogger** .
    """

    class Severity(int):
        InvalidSeverity: QOpenGLDebugMessage = ...
        HighSeverity: QOpenGLDebugMessage = ...
        MediumSeverity: QOpenGLDebugMessage = ...
        LowSeverity: QOpenGLDebugMessage = ...
        NotificationSeverity: QOpenGLDebugMessage = ...
        AnySeverity: QOpenGLDebugMessage = ...

    class Type(int):
        InvalidType: QOpenGLDebugMessage = ...
        ErrorType: QOpenGLDebugMessage = ...
        DeprecatedBehaviorType: QOpenGLDebugMessage = ...
        UndefinedBehaviorType: QOpenGLDebugMessage = ...
        PortabilityType: QOpenGLDebugMessage = ...
        PerformanceType: QOpenGLDebugMessage = ...
        OtherType: QOpenGLDebugMessage = ...
        MarkerType: QOpenGLDebugMessage = ...
        GroupPushType: QOpenGLDebugMessage = ...
        GroupPopType: QOpenGLDebugMessage = ...
        AnyType: QOpenGLDebugMessage = ...

    class Source(int):
        InvalidSource: QOpenGLDebugMessage = ...
        APISource: QOpenGLDebugMessage = ...
        WindowSystemSource: QOpenGLDebugMessage = ...
        ShaderCompilerSource: QOpenGLDebugMessage = ...
        ThirdPartySource: QOpenGLDebugMessage = ...
        ApplicationSource: QOpenGLDebugMessage = ...
        OtherSource: QOpenGLDebugMessage = ...
        AnySource: QOpenGLDebugMessage = ...

    class Sources(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QOpenGLDebugMessage.Sources", "QOpenGLDebugMessage.Source"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QOpenGLDebugMessage.Sources") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QOpenGLDebugMessage.Sources":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class Types(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QOpenGLDebugMessage.Types", "QOpenGLDebugMessage.Type"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QOpenGLDebugMessage.Types") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QOpenGLDebugMessage.Types":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class Severities(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QOpenGLDebugMessage.Severities", "QOpenGLDebugMessage.Severity"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QOpenGLDebugMessage.Severities") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QOpenGLDebugMessage.Severities":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#QOpenGLDebugMessage

        **QOpenGLDebugMessage::QOpenGLDebugMessage()**

        Constructs a debug message with an empty message string, id set to 0,
        source set to **InvalidSource** , type set to **InvalidType** , and
        severity set to **InvalidSeverity** .

        **Note:** This constructor should not be used to create a debug message;
        instead, use the **createApplicationMessage** () or the
        **createThirdPartyMessage** () static functions.

        **See also** **createApplicationMessage** () and
        **createThirdPartyMessage** ().
        """
        ...

    @typing.overload
    def __init__(self, debugMessage: "QOpenGLDebugMessage") -> None:
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#QOpenGLDebugMessage-1

        **QOpenGLDebugMessage::QOpenGLDebugMessage(const QOpenGLDebugMessage &
        debugMessage )**

        Constructs a debug message as a copy of **debugMessage**.

        **See also** **operator=** ().
        """
        ...

    @staticmethod
    def createThirdPartyMessage(
        text: str,
        id: int = ...,
        severity: "QOpenGLDebugMessage.Severity" = ...,
        type: "QOpenGLDebugMessage.Type" = ...,
    ) -> "QOpenGLDebugMessage":
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#createThirdPartyMessage

        **[static] QOpenGLDebugMessage
        QOpenGLDebugMessage::createThirdPartyMessage(const QString & text ,
        GLuint id = 0, QOpenGLDebugMessage::Severity severity =
        NotificationSeverity, QOpenGLDebugMessage::Type type = OtherType)**

        Constructs and returns a debug message with **text** as its text, **id**
        as id, **severity** as severity, and **type** as type. The message
        source will be set to **ThirdPartySource** .

        **See also** **QOpenGLDebugLogger::logMessage** () and
        **createApplicationMessage** ().
        """
        ...

    @staticmethod
    def createApplicationMessage(
        text: str,
        id: int = ...,
        severity: "QOpenGLDebugMessage.Severity" = ...,
        type: "QOpenGLDebugMessage.Type" = ...,
    ) -> "QOpenGLDebugMessage":
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#createApplicationMessage

        **[static] QOpenGLDebugMessage
        QOpenGLDebugMessage::createApplicationMessage(const QString & text ,
        GLuint id = 0, QOpenGLDebugMessage::Severity severity =
        NotificationSeverity, QOpenGLDebugMessage::Type type = OtherType)**

        Constructs and returns a debug message with **text** as its text, **id**
        as id, **severity** as severity, and **type** as type. The message
        source will be set to **ApplicationSource** .

        **See also** **QOpenGLDebugLogger::logMessage** () and
        **createThirdPartyMessage** ().
        """
        ...

    def message(self) -> str:
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#message

        **QString QOpenGLDebugMessage::message() const**

        Returns the textual message contained by this debug message.
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#id

        **GLuint QOpenGLDebugMessage::id() const**

        Returns the id of the debug message. Ids are generally vendor-specific.
        """
        ...

    def severity(self) -> "QOpenGLDebugMessage.Severity":
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#severity

        **QOpenGLDebugMessage::Severity QOpenGLDebugMessage::severity() const**

        Returns the severity of the debug message.
        """
        ...

    def type(self) -> "QOpenGLDebugMessage.Type":
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#type

        **QOpenGLDebugMessage::Type QOpenGLDebugMessage::type() const**

        Returns the type of the debug message.
        """
        ...

    def source(self) -> "QOpenGLDebugMessage.Source":
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#source

        **QOpenGLDebugMessage::Source QOpenGLDebugMessage::source() const**

        Returns the source of the debug message.
        """
        ...

    def swap(self, debugMessage: "QOpenGLDebugMessage") -> None:
        """
        https://doc.qt.io/qt-5/qopengldebugmessage.html#swap

        **void QOpenGLDebugMessage::swap(QOpenGLDebugMessage & debugMessage )**

        Swaps the message **debugMessage** with this message. This operation is
        very fast and never fails.
        """
        ...
