"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QFontDatabase(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qfontdatabase.html

    **Detailed Description**

    The most common uses of this class are to query the database for the list of
    font **families** () and for the **pointSizes** () and **styles** () that
    are available for each family. An alternative to **pointSizes** () is
    **smoothSizes** () which returns the sizes at which a given family and style
    will look attractive.

    If the font family is available from two or more foundries the foundry name
    is included in the family name; for example: "Helvetica [Adobe]" and
    "Helvetica [Cronyx]". When you specify a family, you can either use the old
    hyphenated "foundry-family" format or the bracketed "family [foundry]"
    format; for example: "Cronyx-Helvetica" or "Helvetica [Cronyx]". If the
    family has a foundry it is always returned using the bracketed format, as is
    the case with the value returned by **families** ().

    The **font** () function returns a **QFont**  given a family, style and
    point size.

    A family and style combination can be checked to see if it is **italic** ()
    or **bold** (), and to retrieve its **weight** (). Similarly we can call
    **isBitmapScalable** (), **isSmoothlyScalable** (), **isScalable** () and
    **isFixedPitch** ().

    Use the **styleString** () to obtain a text version of a style.

    The QFontDatabase class also supports some static functions, for example,
    **standardSizes** (). You can retrieve the description of a writing system
    using **writingSystemName** (), and a sample of characters in a writing
    system with **writingSystemSample** ().

    Example:

    **QFontDatabase**  database;
            **QTreeWidget**  fontTree;
    fontTree.setColumnCount(2);
            fontTree.setHeaderLabels(**QStringList**
    () << "Font" << "Smooth Sizes");

            const **QStringList**
    fontFamilies = database.families();
            for (const **QString**  &family
    : fontFamilies) {
                **QTreeWidgetItem**  *familyItem = new
    **QTreeWidgetItem** (&fontTree);
                familyItem->setText(0, family);
    const **QStringList**  fontStyles = database.styles(family);
                for
    (const **QString**  &style : fontStyles) {
    **QTreeWidgetItem**  *styleItem = new **QTreeWidgetItem** (familyItem);
    styleItem->setText(0, style);

                    **QString**  sizes;
    const QList<int> smoothSizes = database.smoothSizes(family, style)
    for (int points : smoothSizes)
                        sizes += **QString**
    ::number(points) + ' ';

                    styleItem->setText(1,
    sizes.trimmed());
                }
            }

    This example gets the list of font families, the list of styles for each
    family, and the point sizes that are available for each combination of
    family and style, displaying this information in a tree view.

    **See also** **QFont** , **QFontInfo** , **QFontMetrics** , and **Character
    Map Example** .
    """

    class SystemFont(int):
        GeneralFont: QFontDatabase = ...
        FixedFont: QFontDatabase = ...
        TitleFont: QFontDatabase = ...
        SmallestReadableFont: QFontDatabase = ...

    class WritingSystem(int):
        Any: QFontDatabase = ...
        Latin: QFontDatabase = ...
        Greek: QFontDatabase = ...
        Cyrillic: QFontDatabase = ...
        Armenian: QFontDatabase = ...
        Hebrew: QFontDatabase = ...
        Arabic: QFontDatabase = ...
        Syriac: QFontDatabase = ...
        Thaana: QFontDatabase = ...
        Devanagari: QFontDatabase = ...
        Bengali: QFontDatabase = ...
        Gurmukhi: QFontDatabase = ...
        Gujarati: QFontDatabase = ...
        Oriya: QFontDatabase = ...
        Tamil: QFontDatabase = ...
        Telugu: QFontDatabase = ...
        Kannada: QFontDatabase = ...
        Malayalam: QFontDatabase = ...
        Sinhala: QFontDatabase = ...
        Thai: QFontDatabase = ...
        Lao: QFontDatabase = ...
        Tibetan: QFontDatabase = ...
        Myanmar: QFontDatabase = ...
        Georgian: QFontDatabase = ...
        Khmer: QFontDatabase = ...
        SimplifiedChinese: QFontDatabase = ...
        TraditionalChinese: QFontDatabase = ...
        Japanese: QFontDatabase = ...
        Korean: QFontDatabase = ...
        Vietnamese: QFontDatabase = ...
        Other: QFontDatabase = ...
        Symbol: QFontDatabase = ...
        Ogham: QFontDatabase = ...
        Runic: QFontDatabase = ...
        Nko: QFontDatabase = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#QFontDatabase

        **QFontDatabase::QFontDatabase()**

        Creates a font database object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QFontDatabase") -> None:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#QFontDatabase

        **QFontDatabase::QFontDatabase()**

        Creates a font database object.
        """
        ...

    def isPrivateFamily(self, family: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#isPrivateFamily

        **bool QFontDatabase::isPrivateFamily(const QString & family ) const**

        Returns `true` if and only if the **family** font family is private.

        This happens, for instance, on macOS and iOS, where the system UI fonts
        are not accessible to the user. For completeness,
        **QFontDatabase::families** () returns all font families, including the
        private ones. You should use this function if you are developing a font
        selection control in order to keep private fonts hidden.

        This function was introduced in Qt 5.5.

        **See also** **families** ().
        """
        ...

    @staticmethod
    def systemFont(type: "QFontDatabase.SystemFont") -> QFont:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#systemFont

        **[static] QFont QFontDatabase::systemFont(QFontDatabase::SystemFont
        type )**

        Returns the most adequate font for a given **type** case for proper
        integration with the system's look and feel.

        This function was introduced in Qt 5.2.

        **See also** **QGuiApplication::font** ().
        """
        ...

    @staticmethod
    def supportsThreadedFontRendering() -> bool:
        ...

    @staticmethod
    def removeAllApplicationFonts() -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#removeAllApplicationFonts

        **[static] bool QFontDatabase::removeAllApplicationFonts()**

        Removes all application-local fonts previously added using
        **addApplicationFont** () and **addApplicationFontFromData** ().

        Returns `true` if unloading of the fonts succeeded; otherwise returns
        `false`.

        This function was introduced in Qt 4.2.

        **See also** **removeApplicationFont** (), **addApplicationFont** (),
        and **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def removeApplicationFont(id: int) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#removeApplicationFont

        **[static] bool QFontDatabase::removeApplicationFont(int id )**

        Removes the previously loaded application font identified by **id**.
        Returns `true` if unloading of the font succeeded; otherwise returns
        `false`.

        This function was introduced in Qt 4.2.

        **See also** **removeAllApplicationFonts** (), **addApplicationFont**
        (), and **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def applicationFontFamilies(id: int) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#applicationFontFamilies

        **[static] QStringList QFontDatabase::applicationFontFamilies(int id )**

        Returns a list of font families for the given application font
        identified by **id**.

        This function was introduced in Qt 4.2.

        **See also** **addApplicationFont** () and
        **addApplicationFontFromData** ().
        """
        ...

    @staticmethod
    def addApplicationFontFromData(
        fontData: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> int:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#addApplicationFontFromData

        **[static] int QFontDatabase::addApplicationFontFromData(const
        QByteArray & fontData )**

        Loads the font from binary data specified by **fontData** and makes it
        available to the application. An ID is returned that can be used to
        remove the font again with **removeApplicationFont** () or to retrieve
        the list of family names contained in the font.

        The function returns -1 if the font could not be loaded.

        Currently only TrueType fonts and TrueType font collections are
        supported.

        **Note:** Adding application fonts on Unix/X11 platforms without
        fontconfig is currently not supported.

        This function was introduced in Qt 4.2.

        **See also** **addApplicationFont** (), **applicationFontFamilies** (),
        and **removeApplicationFont** ().
        """
        ...

    @staticmethod
    def addApplicationFont(fileName: str) -> int:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#addApplicationFont

        **[static] int QFontDatabase::addApplicationFont(const QString &
        fileName )**

        Loads the font from the file specified by **fileName** and makes it
        available to the application. An ID is returned that can be used to
        remove the font again with **removeApplicationFont** () or to retrieve
        the list of family names contained in the font.

        The function returns -1 if the font could not be loaded.

        Currently only TrueType fonts, TrueType font collections, and OpenType
        fonts are supported.

        **Note:** Adding application fonts on Unix/X11 platforms without
        fontconfig is currently not supported.

        This function was introduced in Qt 4.2.

        **See also** **addApplicationFontFromData** (),
        **applicationFontFamilies** (), and **removeApplicationFont** ().
        """
        ...

    @staticmethod
    def writingSystemSample(writingSystem: "QFontDatabase.WritingSystem") -> str:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#writingSystemSample

        **[static] QString
        QFontDatabase::writingSystemSample(QFontDatabase::WritingSystem
        writingSystem )**

        Returns a string with sample characters from **writingSystem**.
        """
        ...

    @staticmethod
    def writingSystemName(writingSystem: "QFontDatabase.WritingSystem") -> str:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#writingSystemName

        **[static] QString
        QFontDatabase::writingSystemName(QFontDatabase::WritingSystem
        writingSystem )**

        Returns the names the **writingSystem** (e.g. for displaying to the user
        in a dialog).
        """
        ...

    def weight(self, family: str, style: str) -> int:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#weight

        **int QFontDatabase::weight(const QString & family , const QString &
        style ) const**

        Returns the weight of the font that has family **family** and style
        **style**. If there is no such family and style combination, returns -1.

        **See also** **italic** () and **bold** ().
        """
        ...

    def bold(self, family: str, style: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#bold

        **bool QFontDatabase::bold(const QString & family , const QString &
        style ) const**

        Returns `true` if the font that has family **family** and style
        **style** is bold; otherwise returns `false`.

        **See also** **italic** () and **weight** ().
        """
        ...

    def italic(self, family: str, style: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#italic

        **bool QFontDatabase::italic(const QString & family , const QString &
        style ) const**

        Returns `true` if the font that has family **family** and style
        **style** is italic; otherwise returns `false`.

        **See also** **weight** () and **bold** ().
        """
        ...

    def isFixedPitch(self, family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#isFixedPitch

        **bool QFontDatabase::isFixedPitch(const QString & family , const
        QString & style = QString()) const**

        Returns `true` if the font that has family **family** and style
        **style** is fixed pitch; otherwise returns `false`.
        """
        ...

    def isScalable(self, family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#isScalable

        **bool QFontDatabase::isScalable(const QString & family , const QString
        & style = QString()) const**

        Returns `true` if the font that has family **family** and style
        **style** is scalable; otherwise returns `false`.

        **See also** **isBitmapScalable** () and **isSmoothlyScalable** ().
        """
        ...

    def isSmoothlyScalable(self, family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#isSmoothlyScalable

        **bool QFontDatabase::isSmoothlyScalable(const QString & family , const
        QString & style = QString()) const**

        Returns `true` if the font that has family **family** and style
        **style** is smoothly scalable; otherwise returns `false`. If this
        function returns `true`, it's safe to scale this font to any size, and
        the result will always look attractive.

        **See also** **isScalable** () and **isBitmapScalable** ().
        """
        ...

    def isBitmapScalable(self, family: str, style: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#isBitmapScalable

        **bool QFontDatabase::isBitmapScalable(const QString & family , const
        QString & style = QString()) const**

        Returns `true` if the font that has family **family** and style
        **style** is a scalable bitmap font; otherwise returns `false`. Scaling
        a bitmap font usually produces an unattractive hardly readable result,
        because the pixels of the font are scaled. If you need to scale a bitmap
        font it is better to scale it to one of the fixed sizes returned by
        **smoothSizes** ().

        **See also** **isScalable** () and **isSmoothlyScalable** ().
        """
        ...

    def font(self, family: str, style: str, pointSize: int) -> QFont:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#font

        **QFont QFontDatabase::font(const QString & family , const QString &
        style , int pointSize ) const**

        Returns a **QFont**  object that has family **family** , style **style**
        and point size **pointSize**. If no matching font could be created, a
        **QFont**  object that uses the application's default font is returned.
        """
        ...

    @typing.overload
    def styleString(self, font: QFont) -> str:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#styleString

        **QString QFontDatabase::styleString(const QFont & font )**

        Returns a string that describes the style of the **font**. For example,
        "Bold Italic", "Bold", "Italic" or "Normal". An empty string may be
        returned.
        """
        ...

    @typing.overload
    def styleString(self, fontInfo: "QFontInfo") -> str:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#styleString-1

        **QString QFontDatabase::styleString(const QFontInfo & fontInfo )**

        Returns a string that describes the style of the **fontInfo**. For
        example, "Bold Italic", "Bold", "Italic" or "Normal". An empty string
        may be returned.
        """
        ...

    def smoothSizes(self, family: str, style: str) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#smoothSizes

        **QList<int> QFontDatabase::smoothSizes(const QString & family , const
        QString & styleName )**

        Returns the point sizes of a font that has family **family** and style
        **styleName** that will look attractive. The list may be empty. For non-
        scalable fonts and bitmap scalable fonts, this function is equivalent to
        **pointSizes** ().

        **See also** **pointSizes** () and **standardSizes** ().
        """
        ...

    def pointSizes(self, family: str, style: str = ...) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#pointSizes

        **QList<int> QFontDatabase::pointSizes(const QString & family , const
        QString & styleName = QString())**

        Returns a list of the point sizes available for the font that has family
        **family** and style **styleName**. The list may be empty.

        **See also** **smoothSizes** () and **standardSizes** ().
        """
        ...

    def styles(self, family: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#styles

        **QStringList QFontDatabase::styles(const QString & family ) const**

        Returns a list of the styles available for the font family **family**.
        Some example styles: "Light", "Light Italic", "Bold", "Oblique", "Demi".
        The list may be empty.

        **See also** **families** ().
        """
        ...

    def families(
        self, writingSystem: "QFontDatabase.WritingSystem" = ...
    ) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#families

        **QStringList QFontDatabase::families(QFontDatabase::WritingSystem
        writingSystem = Any) const**

        Returns a sorted list of the available font families which support the
        **writingSystem**.

        If a family exists in several foundries, the returned name for that font
        is in the form "family [foundry]". Examples: "Times [Adobe]", "Times
        [Cronyx]", "Palatino".

        **See also** **writingSystems** ().
        """
        ...

    @typing.overload
    def writingSystems(self) -> typing.List["QFontDatabase.WritingSystem"]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#writingSystems

        **QList<QFontDatabase::WritingSystem> QFontDatabase::writingSystems()
        const**

        Returns a sorted list of the available writing systems. This is list
        generated from information about all installed fonts on the system.

        **See also** **families** ().
        """
        ...

    @typing.overload
    def writingSystems(self, family: str) -> typing.List["QFontDatabase.WritingSystem"]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#writingSystems-1

        **QList<QFontDatabase::WritingSystem>
        QFontDatabase::writingSystems(const QString & family ) const**

        Returns a sorted list of the writing systems supported by a given font
        **family**.

        **See also** **families** ().
        """
        ...

    @staticmethod
    def standardSizes() -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qfontdatabase.html#standardSizes

        **[static] QList<int> QFontDatabase::standardSizes()**

        Returns a list of standard font sizes.

        **See also** **smoothSizes** () and **pointSizes** ().
        """
        ...
