"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QContextMenuEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qcontextmenuevent.html

    **Detailed Description**

    Context menu events are sent to widgets when a user performs an action
    associated with opening a context menu. The actions required to open context
    menus vary between platforms; for example, on Windows, pressing the menu
    button or clicking the right mouse button will cause this event to be sent.

    When this event occurs it is customary to show a **QMenu**  with a context
    menu, if this is relevant to the context.

    Context menu events contain a special accept flag that indicates whether the
    receiver accepted the event. If the event handler does not accept the event
    then, if possible, whatever triggered the event will be handled as a regular
    input event.
    """

    class Reason(int):
        Mouse: QContextMenuEvent = ...
        Keyboard: QContextMenuEvent = ...
        Other: QContextMenuEvent = ...

    @typing.overload
    def __init__(
        self,
        reason: "QContextMenuEvent.Reason",
        pos: QtCore.QPoint,
        globalPos: QtCore.QPoint,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#QContextMenuEvent

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos , const QPoint & globalPos , Qt::KeyboardModifiers
        modifiers )**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget. **globalPos** is the mouse position in absolute
        coordinates. The **modifiers** holds the keyboard modifiers.
        """
        ...

    @typing.overload
    def __init__(
        self,
        reason: "QContextMenuEvent.Reason",
        pos: QtCore.QPoint,
        globalPos: QtCore.QPoint,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#QContextMenuEvent-1

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos , const QPoint & globalPos )**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget. **globalPos** is the mouse position in absolute
        coordinates.
        """
        ...

    @typing.overload
    def __init__(self, reason: "QContextMenuEvent.Reason", pos: QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#QContextMenuEvent-2

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos )**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget.

        The **globalPos** () is initialized to **QCursor::pos** (), which may
        not be appropriate. Use the other constructor to specify the global
        position explicitly.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QContextMenuEvent") -> None:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#QContextMenuEvent

        **QContextMenuEvent::QContextMenuEvent(QContextMenuEvent::Reason reason
        , const QPoint & pos , const QPoint & globalPos , Qt::KeyboardModifiers
        modifiers )**

        Constructs a context menu event object with the accept parameter flag
        set to false.

        The **reason** parameter must be **QContextMenuEvent::Mouse**  or
        **QContextMenuEvent::Keyboard** .

        The **pos** parameter specifies the mouse position relative to the
        receiving widget. **globalPos** is the mouse position in absolute
        coordinates. The **modifiers** holds the keyboard modifiers.
        """
        ...

    def reason(self) -> "QContextMenuEvent.Reason":
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#reason

        **QContextMenuEvent::Reason QContextMenuEvent::reason() const**

        Returns the reason for this context event.
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#globalPos

        **const QPoint &QContextMenuEvent::globalPos() const**

        Returns the global position of the mouse pointer at the time of the
        event.

        **See also** **x** (), **y** (), and **pos** ().
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#pos

        **const QPoint &QContextMenuEvent::pos() const**

        Returns the position of the mouse pointer relative to the widget that
        received the event.

        **See also** **x** (), **y** (), and **globalPos** ().
        """
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#globalY

        **int QContextMenuEvent::globalY() const**

        Returns the global y position of the mouse pointer at the time of the
        event.

        **See also** **globalX** () and **globalPos** ().
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#globalX

        **int QContextMenuEvent::globalX() const**

        Returns the global x position of the mouse pointer at the time of the
        event.

        **See also** **globalY** () and **globalPos** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#y

        **int QContextMenuEvent::y() const**

        Returns the y position of the mouse pointer, relative to the widget that
        received the event.

        **See also** **x** () and **pos** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-5/qcontextmenuevent.html#x

        **int QContextMenuEvent::x() const**

        Returns the x position of the mouse pointer, relative to the widget that
        received the event.

        **See also** **y** () and **pos** ().
        """
        ...
