"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *


class QTranslator(QObject):
    """
    https://doc.qt.io/qt-5/qtranslator.html

    **Detailed Description**

    An object of this class contains a set of translations from a source
    language to a target language. QTranslator provides functions to look up
    translations in a translation file. Translation files are created using **Qt
    Linguist** .

    The most common use of QTranslator is to: load a translation file, and
    install it using **QCoreApplication::installTranslator** ().

    Here's an example `main()` function using the QTranslator:

    int main(int argc, char *argv[])
        {
            **QApplication**  app(argc,
    argv);

            **QTranslator**  translator;
            // look up e.g.
    :/i18n/myapp_de.qm
            if (translator.load(**QLocale** (),
    QLatin1String("myapp"), QLatin1String("_"), QLatin1String(":/i18n")))
    **QCoreApplication** ::installTranslator(&translator);
    **QPushButton**  hello(**QCoreApplication** ::translate("main", "Hello
    world!"));
            hello.resize(100, 30);

            hello.show();
    return app.exec();
        }

    Note that the translator must be created **before** the application's
    widgets.

    Most applications will never need to do anything else with this class. The
    other functions provided by this class are useful for applications that work
    on translator files.

    **Looking up Translations**

    It is possible to look up a translation using **translate** () (as **tr** ()
    and **QCoreApplication::translate** () do). The **translate** () function
    takes up to three parameters:

    * The **context** \\- usually the class name for the **tr** () caller.
      *
    The **source text** \\- usually the argument to **tr** ().
      * The
    **disambiguation** \\- an optional string that helps disambiguate different
    uses of the same text in the same context.

    For example, the "Cancel" in a dialog might have "Anuluj" when the program
    runs in Polish (in this case the source text would be "Cancel"). The context
    would (normally) be the dialog's class name; there would normally be no
    comment, and the translated text would be "Anuluj".

    But it's not always so simple. The Spanish version of a printer dialog with
    settings for two-sided printing and binding would probably require both
    "Activado" and "Activada" as translations for "Enabled". In this case the
    source text would be "Enabled" in both cases, and the context would be the
    dialog's class name, but the two items would have disambiguations such as
    "two-sided printing" for one and "binding" for the other. The disambiguation
    enables the translator to choose the appropriate gender for the Spanish
    version, and enables Qt to distinguish between translations.

    **Using Multiple Translations**

    Multiple translation files can be installed in an application. Translations
    are searched for in the reverse order in which they were installed, so the
    most recently installed translation file is searched for translations first
    and the earliest translation file is searched last. The search stops as soon
    as a translation containing a matching string is found.

    This mechanism makes it possible for a specific translation to be "selected"
    or given priority over the others; simply uninstall the translator from the
    application by passing it to the **QCoreApplication::removeTranslator** ()
    function and reinstall it with **QCoreApplication::installTranslator** ().
    It will then be the first translation to be searched for matching strings.

    **See also** **QCoreApplication::installTranslator** (),
    **QCoreApplication::removeTranslator** (), **QObject::tr** (),
    **QCoreApplication::translate** (), **I18N Example** , **Hello tr** ()
    Example, **Arrow Pad Example** , and **Troll Print Example** .
    """

    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtranslator.html#QTranslator

        **QTranslator::QTranslator(QObject * parent = nullptr)**

        Constructs an empty message file object with parent **parent** that is
        not connected to any file.
        """
        ...

    def filePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qtranslator.html#filePath

        **QString QTranslator::filePath() const**

        Returns the path of the loaded translation file.

        The file path is empty if no translation was loaded yet, the loading
        failed, or if the translation was not loaded from a file.

        This function was introduced in Qt 5.15.
        """
        ...

    def language(self) -> str:
        """
        https://doc.qt.io/qt-5/qtranslator.html#language

        **QString QTranslator::language() const**

        Returns the target language as stored in the translation file.

        This function was introduced in Qt 5.15.
        """
        ...

    def loadFromData(self, data: bytes, directory: str = ...) -> bool:
        ...

    @typing.overload
    def load(
        self,
        fileName: str,
        directory: str = ...,
        searchDelimiters: str = ...,
        suffix: str = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtranslator.html#load

        **bool QTranslator::load(const QString & filename , const QString &
        directory = QString(), const QString & search_delimiters = QString(),
        const QString & suffix = QString())**

        Loads **filename** \\+ **suffix** (".qm" if the **suffix** is not
        specified), which may be an absolute file name or relative to
        **directory**. Returns `true` if the translation is successfully loaded;
        otherwise returns `false`.

        If **directory** is not specified, the current directory is used (i.e.,
        as **currentPath()** ).

        The previous contents of this translator object are discarded.

        If the file name does not exist, other file names are tried in the
        following order:

        1. File name without **suffix** appended.
          2. File name with text after
        a character in **search_delimiters** stripped ("_." is the default for
        **search_delimiters** if it is an empty string) and **suffix**.
          3.
        File name stripped without **suffix** appended.
          4. File name stripped
        further, etc.

        For example, an application running in the fr_CA locale (French-speaking
        Canada) might call load("foo.fr_ca", "/opt/foolib"). load() would then
        try to open the first existing readable file from this list:

        1. `/opt/foolib/foo.fr_ca.qm`
          2. `/opt/foolib/foo.fr_ca`
          3.
        `/opt/foolib/foo.fr.qm`
          4. `/opt/foolib/foo.fr`
          5.
        `/opt/foolib/foo.qm`
          6. `/opt/foolib/foo`

        Usually, it is better to use the QTranslator::load(const **QLocale**  &,
        const **QString**  &, const **QString**  &, const **QString**  &, const
        **QString**  &) function instead, because it uses
        **QLocale::uiLanguages** () and not simply the locale name, which refers
        to the formatting of dates and numbers and not necessarily the UI
        language.
        """
        ...

    @typing.overload
    def load(
        self,
        locale: QLocale,
        fileName: str,
        prefix: str = ...,
        directory: str = ...,
        suffix: str = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtranslator.html#load-1

        **bool QTranslator::load(const QLocale & locale , const QString &
        filename , const QString & prefix = QString(), const QString & directory
        = QString(), const QString & suffix = QString())**

        Loads **filename** \\+ **prefix** \\+ **ui language name**  \\+ **suffix**
        (".qm" if the **suffix** is not specified), which may be an absolute
        file name or relative to **directory**. Returns `true` if the
        translation is successfully loaded; otherwise returns `false`.

        The previous contents of this translator object are discarded.

        If the file name does not exist, other file names are tried in the
        following order:

        1. File name without **suffix** appended.
          2. File name with ui
        language part after a "_" character stripped and **suffix**.
          3. File
        name with ui language part stripped without **suffix** appended.
          4.
        File name with ui language part stripped further, etc.

        For example, an application running in the **locale** with the following
        **ui languages**  \\- "es", "fr-CA", "de" might call load(QLocale(),
        "foo", ".", "/opt/foolib", ".qm"). load() would replace '-' (dash) with
        '_' (underscore) in the ui language and then try to open the first
        existing readable file from this list:

        1. `/opt/foolib/foo.es.qm`
          2. `/opt/foolib/foo.es`
          3.
        `/opt/foolib/foo.fr_CA.qm`
          4. `/opt/foolib/foo.fr_CA`
          5.
        `/opt/foolib/foo.de.qm`
          6. `/opt/foolib/foo.de`
          7.
        `/opt/foolib/foo.fr.qm`
          8. `/opt/foolib/foo.fr`
          9.
        `/opt/foolib/foo.qm`
          10. `/opt/foolib/foo`.
          11. `/opt/foolib/foo`

        On operating systems where file system is case sensitive,
        **QTranslator**  also tries to load a lower-cased version of the locale
        name.

        This function was introduced in Qt 4.8.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtranslator.html#isEmpty

        **[virtual] bool QTranslator::isEmpty() const**

        Returns `true` if this translator is empty, otherwise returns `false`.
        This function works with stripped and unstripped translation files.
        """
        ...

    def translate(
        self,
        context: str,
        sourceText: str,
        disambiguation: typing.Optional[str] = ...,
        n: int = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtranslator.html#translate

        **[virtual] QString QTranslator::translate(const char * context , const
        char * sourceText , const char * disambiguation = nullptr, int n = -1)
        const**

        Returns the translation for the key ( **context** , **sourceText** ,
        **disambiguation** ). If none is found, also tries ( **context** ,
        **sourceText** , ""). If that still fails, returns a null string.

        **Note:** Incomplete translations may result in unexpected behavior: If
        no translation for ( **context** , **sourceText** , "") is provided, the
        method might in this case actually return a translation for a different
        **disambiguation**.

        If **n** is not -1, it is used to choose an appropriate form for the
        translation (e.g. "%n file found" vs. "%n files found").

        If you need to programatically insert translations into a
        **QTranslator** , this function can be reimplemented.

        **See also** **load** ().
        """
        ...
