"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QSemaphore(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsemaphore.html

    **Detailed Description**

    A semaphore is a generalization of a mutex. While a mutex can only be locked
    once, it's possible to acquire a semaphore multiple times. Semaphores are
    typically used to protect a certain number of identical resources.

    Semaphores support two fundamental operations, **acquire** () and
    **release** ():

    * acquire( **n** ) tries to acquire **n** resources. If there aren't that
    many resources available, the call will block until this is the case.
      *
    release( **n** ) releases **n** resources.

    There's also a **tryAcquire** () function that returns immediately if it
    cannot acquire the resources, and an **available** () function that returns
    the number of available resources at any time.

    Example:

    **QSemaphore**  sem(5);      // sem.available() == 5
    sem.acquire(3);         // sem.available() == 2
        sem.acquire(2);
    // sem.available() == 0
        sem.release(5);         // sem.available() == 5
    sem.release(5);         // sem.available() == 10

        sem.tryAcquire(1);
    // sem.available() == 9, returns true
        sem.tryAcquire(250);    //
    sem.available() == 9, returns false

    A typical application of semaphores is for controlling access to a circular
    buffer shared by a producer thread and a consumer thread. The **Semaphores
    Example**  shows how to use QSemaphore to solve that problem.

    A non-computing example of a semaphore would be dining at a restaurant. A
    semaphore is initialized with the number of chairs in the restaurant. As
    people arrive, they want a seat. As seats are filled, **available** () is
    decremented. As people leave, the **available** () is incremented, allowing
    more people to enter. If a party of 10 people want to be seated, but there
    are only 9 seats, those 10 people will wait, but a party of 4 people would
    be seated (taking the available seats to 5, making the party of 10 people
    wait longer).

    **See also** **QSemaphoreReleaser** , **QMutex** , **QWaitCondition** ,
    **QThread** , and **Semaphores Example** .
    """

    def __init__(self, n: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#QSemaphore

        **QSemaphore::QSemaphore(int n = 0)**

        Creates a new semaphore and initializes the number of resources it
        guards to **n** (by default, 0).

        **See also** **release** () and **available** ().
        """
        ...

    def available(self) -> int:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#available

        **int QSemaphore::available() const**

        Returns the number of resources currently available to the semaphore.
        This number can never be negative.

        **See also** **acquire** () and **release** ().
        """
        ...

    def release(self, n: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#release

        **void QSemaphore::release(int n = 1)**

        Releases **n** resources guarded by the semaphore.

        This function can be used to "create" resources as well. For example:

        **QSemaphore**  sem(5);      // a semaphore that guards 5 resources
        sem.acquire(5);         // acquire all 5 resources
            sem.release(5);
        // release the 5 resources
            sem.release(10);        // "create" 10
        new resources

        **QSemaphoreReleaser**  is a **RAII**  wrapper around this function.

        **See also** **acquire** (), **available** (), and
        **QSemaphoreReleaser** .
        """
        ...

    @typing.overload
    def tryAcquire(self, n: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#tryAcquire

        **bool QSemaphore::tryAcquire(int n = 1)**

        Tries to acquire `n` resources guarded by the semaphore and returns
        `true` on success. If **available** () < **n** , this call immediately
        returns `false` without acquiring any resources.

        Example:

        **QSemaphore**  sem(5);      // sem.available() == 5
        sem.tryAcquire(250);    // sem.available() == 5, returns false
        sem.tryAcquire(3);      // sem.available() == 2, returns true

        **See also** **acquire** ().
        """
        ...

    @typing.overload
    def tryAcquire(self, n: int, timeout: int) -> bool:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#tryAcquire-1

        **bool QSemaphore::tryAcquire(int n , int timeout )**

        Tries to acquire `n` resources guarded by the semaphore and returns
        `true` on success. If **available** () < **n** , this call will wait for
        at most **timeout** milliseconds for resources to become available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **acquire** (), i.e. this function will wait forever for
        resources to become available if **timeout** is negative.

        Example:

        **QSemaphore**  sem(5);            // sem.available() == 5
        sem.tryAcquire(250, 1000);    // sem.available() == 5, waits 1000
        milliseconds and returns false
            sem.tryAcquire(3, 30000);     //
        sem.available() == 2, returns true without waiting

        **See also** **acquire** ().
        """
        ...

    def acquire(self, n: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsemaphore.html#acquire

        **void QSemaphore::acquire(int n = 1)**

        Tries to acquire `n` resources guarded by the semaphore. If **n** >
        **available** (), this call will block until enough resources are
        available.

        **See also** **release** (), **available** (), and **tryAcquire** ().
        """
        ...
