"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QOperatingSystemVersion(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qoperatingsystemversion.html

    **Detailed Description**

    Unlike other version functions in **QSysInfo** , QOperatingSystemVersion
    provides access to the full version number that **developers** typically use
    to vary behavior or determine whether to enable APIs or features based on
    the operating system version (as opposed to the kernel version number or
    marketing version).

    This class is also a complete replacement for QSysInfo::macVersion and
    QSysInfo::windowsVersion, additionally providing access to the third (micro)
    version number component.

    Presently, Android, Apple Platforms (iOS, macOS, tvOS, and watchOS), and
    Windows are supported.

    The **majorVersion()** , **minorVersion()** , and **microVersion()**
    functions return the parts of the operating system version number based on:

    PlatformsValue
    Androidresult of parsing
    **android.os.Build.VERSION.RELEASE**  using **QVersionNumber** , with a
    fallback to **android.os.Build.VERSION.SDK_INT**  to determine the major and
    minor version component if the former fails
    Apple
    Platforms**majorVersion** , **minorVersion** , and patchVersion from
    **NSProcessInfo.operatingSystemVersion**
    WindowsdwMajorVersion,
    dwMinorVersion, and dwBuildNumber from **RtlGetVersion**  \\- note that this
    function ALWAYS return the version number of the underlying operating
    system, as opposed to the shim underneath GetVersionEx that hides the real
    version number if the application is not manifested for that version of the
    OS

    Because QOperatingSystemVersion stores both a version number and an OS type,
    the OS type can be taken into account when performing comparisons. For
    example, on a macOS system running macOS Sierra (v10.12), the following
    expression will return `false` even though the major version number
    component of the object on the left hand side of the expression (10) is
    greater than that of the object on the right (9):

    **QOperatingSystemVersion** ::current() >= **QOperatingSystemVersion**
    (**QOperatingSystemVersion** ::IOS, 9)

    This allows expressions for multiple operating systems to be joined with a
    logical OR operator and still work as expected. For example:

    auto current = **QOperatingSystemVersion** ::current();
            if (current
    >= **QOperatingSystemVersion** ::OSXYosemite ||
                current >=
    **QOperatingSystemVersion** (**QOperatingSystemVersion** ::IOS, 8)) {
    // returns true on macOS >= 10.10 and iOS >= 8.0, but false on macOS < 10.10
    and iOS < 8.0
            }

    A more naive comparison algorithm might incorrectly return true on all
    versions of macOS, including Mac OS 9. This behavior is achieved by
    overloading the comparison operators to return `false` whenever the OS types
    of the QOperatingSystemVersion instances being compared do not match. Be
    aware that due to this it can be the case `x` >= y and `x` < y are BOTH
    `false` for the same instances of `x` and `y`.
    """

    class OSType(int):
        Unknown: QOperatingSystemVersion = ...
        Windows: QOperatingSystemVersion = ...
        MacOS: QOperatingSystemVersion = ...
        IOS: QOperatingSystemVersion = ...
        TvOS: QOperatingSystemVersion = ...
        WatchOS: QOperatingSystemVersion = ...
        Android: QOperatingSystemVersion = ...

    AndroidJellyBean = ...
    AndroidJellyBean_MR1 = ...
    AndroidJellyBean_MR2 = ...
    AndroidKitKat = ...
    AndroidLollipop = ...
    AndroidLollipop_MR1 = ...
    AndroidMarshmallow = ...
    AndroidNougat = ...
    AndroidNougat_MR1 = ...
    AndroidOreo = ...
    MacOSCatalina = ...
    MacOSHighSierra = ...
    MacOSMojave = ...
    MacOSSierra = ...
    OSXElCapitan = ...
    OSXMavericks = ...
    OSXYosemite = ...
    Windows10 = ...
    Windows7 = ...
    Windows8 = ...
    Windows8_1 = ...

    @typing.overload
    def __init__(
        self,
        osType: "QOperatingSystemVersion.OSType",
        vmajor: int,
        vminor: int = ...,
        vmicro: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#QOperatingSystemVers
        ion

        **QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersi
        on::OSType osType , int vmajor , int vminor = -1, int vmicro = -1)**

        Constructs a QOperatingSystemVersion consisting of the OS type
        **osType** , and major, minor, and micro version numbers **vmajor** ,
        **vminor** and **vmicro** , respectively.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QOperatingSystemVersion") -> None:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#QOperatingSystemVers
        ion

        **QOperatingSystemVersion::QOperatingSystemVersion(QOperatingSystemVersi
        on::OSType osType , int vmajor , int vminor = -1, int vmicro = -1)**

        Constructs a QOperatingSystemVersion consisting of the OS type
        **osType** , and major, minor, and micro version numbers **vmajor** ,
        **vminor** and **vmicro** , respectively.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#name

        **QString QOperatingSystemVersion::name() const**

        Returns a string representation of the OS type identified by the
        **QOperatingSystemVersion** .

        **See also** **type** ().
        """
        ...

    def type(self) -> "QOperatingSystemVersion.OSType":
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#type

        **QOperatingSystemVersion::OSType QOperatingSystemVersion::type()
        const**

        Returns the OS type identified by the **QOperatingSystemVersion** .

        **See also** **name** ().
        """
        ...

    def segmentCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#segmentCount

        **int QOperatingSystemVersion::segmentCount() const**

        Returns the number of integers stored in the version number.
        """
        ...

    def microVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#microVersion

        **int QOperatingSystemVersion::microVersion() const**

        Returns the micro version number, that is, the third segment of the
        operating system's version number.

        See the main class documentation for what the micro version number is on
        a given operating system.

        -1 indicates an unknown or absent version number component.

        **See also** **majorVersion** () and **minorVersion** ().
        """
        ...

    def minorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#minorVersion

        **int QOperatingSystemVersion::minorVersion() const**

        Returns the minor version number, that is, the second segment of the
        operating system's version number.

        See the main class documentation for what the minor version number is on
        a given operating system.

        -1 indicates an unknown or absent version number component.

        **See also** **majorVersion** () and **microVersion** ().
        """
        ...

    def majorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#majorVersion

        **int QOperatingSystemVersion::majorVersion() const**

        Returns the major version number, that is, the first segment of the
        operating system's version number.

        See the main class documentation for what the major version number is on
        a given operating system.

        -1 indicates an unknown or absent version number component.

        **See also** **minorVersion** () and **microVersion** ().
        """
        ...

    @staticmethod
    def currentType() -> "QOperatingSystemVersion.OSType":
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#currentType

        **[static] QOperatingSystemVersion::OSType
        QOperatingSystemVersion::currentType()**

        Returns the current OS type without constructing a
        **QOperatingSystemVersion**  instance.

        This function was introduced in Qt 5.10.

        **See also** **current** ().
        """
        ...

    @staticmethod
    def current() -> "QOperatingSystemVersion":
        """
        https://doc.qt.io/qt-5/qoperatingsystemversion.html#current

        **[static] QOperatingSystemVersion QOperatingSystemVersion::current()**

        Returns a **QOperatingSystemVersion**  indicating the current OS and its
        version number.

        **See also** **currentType** ().
        """
        ...
