"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5.QtCore import *
from PyQt5 import sip


class QMutex(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmutex.html

    **Detailed Description**

    The purpose of a QMutex is to protect an object, data structure or section
    of code so that only one thread can access it at a time (this is similar to
    the Java `synchronized` keyword). It is usually best to use a mutex with a
    **QMutexLocker**  since this makes it easy to ensure that locking and
    unlocking are performed consistently.

    For example, say there is a method that prints a message to the user on two
    lines:

    int number = 6;

        void method1()
        {
            number *= 5;
    number /= 4;
        }

        void method2()
        {
            number *= 3;
    number /= 2;
        }

    If these two methods are called in succession, the following happens:

    // method1()
        number *= 5;        // number is now 30
        number /= 4;
    // number is now 7

        // method2()
        number *= 3;        // number
    is now 21
        number /= 2;        // number is now 10

    If these two methods are called simultaneously from two threads then the
    following sequence could result:

    // Thread 1 calls method1()
        number *= 5;        // number is now 30
    // Thread 2 calls method2().
        //
        // Most likely Thread 1 has been put
    to sleep by the operating
        // system to allow Thread 2 to run.
        number
    *= 3;        // number is now 90
        number /= 2;        // number is now 45
    // Thread 1 finishes executing.
        number /= 4;        // number is now 11,
    instead of 10

    If we add a mutex, we should get the result we want:

    **QMutex**  mutex;
        int number = 6;

        void method1()
        {
    mutex.lock();
            number *= 5;
            number /= 4;
    mutex.unlock();
        }

        void method2()
        {
            mutex.lock();
    number *= 3;
            number /= 2;
            mutex.unlock();
        }

    Then only one thread can modify `number` at any given time and the result is
    correct. This is a trivial example, of course, but applies to any other case
    where things need to happen in a particular sequence.

    When you call **lock** () in a thread, other threads that try to call
    **lock** () in the same place will block until the thread that got the lock
    calls **unlock** (). A non-blocking alternative to **lock** () is
    **tryLock** ().

    QMutex is optimized to be fast in the non-contended case. A non-recursive
    QMutex will not allocate memory if there is no contention on that mutex. It
    is constructed and destroyed with almost no overhead, which means it is fine
    to have many mutexes as part of other classes.

    **See also** **QRecursiveMutex** , **QMutexLocker** , **QReadWriteLock** ,
    **QSemaphore** , and **QWaitCondition** .
    """

    class RecursionMode(int):
        NonRecursive: QMutex = ...
        Recursive: QMutex = ...

    def __init__(self, mode: "QMutex.RecursionMode" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmutex.html#QMutex

        **QMutex::QMutex()**

        Constructs a new mutex. The mutex is created in an unlocked state.
        """
        ...

    def isRecursive(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmutex.html#isRecursive

        **bool QMutex::isRecursive() const**

        Returns `true` if the mutex is recursive.

        This function was introduced in Qt 5.7.
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-5/qmutex.html#unlock

        **void QMutex::unlock()**

        Unlocks the mutex. Attempting to unlock a mutex in a different thread to
        the one that locked it results in an error. Unlocking a mutex that is
        not locked results in undefined behavior.

        **See also** **lock** ().
        """
        ...

    def tryLock(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qmutex.html#tryLock

        **bool QMutex::tryLock(int timeout = 0)**

        Attempts to lock the mutex. This function returns `true` if the lock was
        obtained; otherwise it returns `false`. If another thread has locked the
        mutex, this function will wait for at most **timeout** milliseconds for
        the mutex to become available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **lock** (), i.e. this function will wait forever until mutex
        can be locked if **timeout** is negative.

        If the lock was obtained, the mutex must be unlocked with **unlock** ()
        before another thread can successfully lock it.

        Calling this function multiple times on the same mutex from the same
        thread is allowed if this mutex is a **recursive mutex** . If this mutex
        is a **non-recursive mutex** , this function will **always** return
        false when attempting to lock the mutex recursively.

        **See also** **lock** () and **unlock** ().
        """
        ...

    def lock(self) -> None:
        """
        https://doc.qt.io/qt-5/qmutex.html#lock

        **void QMutex::lock()**

        Locks the mutex. If another thread has locked the mutex then this call
        will block until that thread has unlocked it.

        Calling this function multiple times on the same mutex from the same
        thread is allowed if this mutex is a **recursive mutex** . If this mutex
        is a **non-recursive mutex** , this function will **dead-lock** when the
        mutex is locked recursively.

        **See also** **unlock** ().
        """
        ...
