"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtCore import *


class QEventTransition(QAbstractTransition):
    """
    https://doc.qt.io/qt-5/qeventtransition.html

    **Detailed Description**

    A QEventTransition object binds an event to a particular **QObject** .
    QEventTransition is part of **The State Machine Framework** .

    Example:

    **QPushButton**  *button = ...;
        **QState**  *s1 = ...;
        **QState**
    *s2 = ...;
        // If in s1 and the button receives an Enter event,
    transition to s2
        **QEventTransition**  *enterTransition = new
    **QEventTransition** (button, **QEvent** ::Enter);
    enterTransition->setTargetState(s2);
        s1->addTransition(enterTransition);
    // If in s2 and the button receives an Exit event, transition back to s1
    **QEventTransition**  *leaveTransition = new **QEventTransition** (button,
    **QEvent** ::Leave);
        leaveTransition->setTargetState(s1);
    s2->addTransition(leaveTransition);

    **Subclassing**

    When reimplementing the **eventTest** () function, you should first call the
    base implementation to verify that the event is a
    **QStateMachine::WrappedEvent**  for the proper object and event type. You
    may then cast the event to a **QStateMachine::WrappedEvent**  and get the
    original event by calling **QStateMachine::WrappedEvent::event** (), and
    perform additional checks on that object.

    **See also** **QState::addTransition** ().
    """

    @typing.overload
    def __init__(self, sourceState: typing.Optional["QState"] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#QEventTransition

        **QEventTransition::QEventTransition(QState * sourceState = nullptr)**

        Constructs a new QEventTransition object with the given **sourceState**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        object: QObject,
        type: QEvent.Type,
        sourceState: typing.Optional["QState"] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#QEventTransition-1

        **QEventTransition::QEventTransition(QObject * object , QEvent::Type
        type , QState * sourceState = nullptr)**

        Constructs a new QEventTransition object associated with events of the
        given **type** for the given **object** , and with the given
        **sourceState**.
        """
        ...

    def event(self, e: QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#event

        **[override virtual protected] bool QEventTransition::event(QEvent * e
        )**

        Reimplements: **QAbstractTransition::event** (QEvent *e).
        """
        ...

    def onTransition(self, event: QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#onTransition

        **[override virtual protected] void
        QEventTransition::onTransition(QEvent * event )**

        Reimplements: **QAbstractTransition::onTransition** (QEvent *event).
        """
        ...

    def eventTest(self, event: QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#eventTest

        **[override virtual protected] bool QEventTransition::eventTest(QEvent *
        event )**

        Reimplements: **QAbstractTransition::eventTest** (QEvent *event).
        """
        ...

    def setEventType(self, type: QEvent.Type) -> None:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#setEventType

        **void QEventTransition::setEventType(QEvent::Type type )**

        Sets the event **type** that this event transition is associated with.

        **Note:** Setter function for property **eventType** .

        **See also** **eventType** ().
        """
        ...

    def eventType(self) -> QEvent.Type:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#eventType

        **QEvent::Type QEventTransition::eventType() const**

        Returns the event type that this event transition is associated with.

        **Note:** Getter function for property eventType.

        **See also** **setEventType** ().
        """
        ...

    def setEventSource(self, object: QObject) -> None:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#setEventSource

        **void QEventTransition::setEventSource(QObject * object )**

        Sets the event source associated with this event transition to be the
        given **object**.

        **Note:** Setter function for property **eventSource** .

        **See also** **eventSource** ().
        """
        ...

    def eventSource(self) -> QObject:
        """
        https://doc.qt.io/qt-5/qeventtransition.html#eventSource

        **QObject *QEventTransition::eventSource() const**

        Returns the event source associated with this event transition.

        **Note:** Getter function for property eventSource.

        **See also** **setEventSource** ().
        """
        ...
