"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QAbstractAnimation(QObject):
    """
    https://doc.qt.io/qt-5/qabstractanimation.html

    **Detailed Description**

    The class defines the functions for the functionality shared by all
    animations. By inheriting this class, you can create custom animations that
    plug into the rest of the animation framework.

    The progress of an animation is given by its current time
    (**currentLoopTime** ()), which is measured in milliseconds from the start
    of the animation (0) to its end (**duration** ()). The value is updated
    automatically while the animation is running. It can also be set directly
    with **setCurrentTime** ().

    At any point an animation is in one of three states: **Running** ,
    **Stopped** , or **Paused** \\--as defined by the **State**  enum. The
    current state can be changed by calling **start** (), **stop** (), **pause**
    (), or **resume** (). An animation will always reset its **current time**
    when it is started. If paused, it will continue with the same current time
    when resumed. When an animation is stopped, it cannot be resumed, but will
    keep its current time (until started again). QAbstractAnimation will emit
    **stateChanged** () whenever its state changes.

    An animation can loop any number of times by setting the **loopCount**
    property. When an animation's current time reaches its **duration** (), it
    will reset the current time and keep running. A loop count of 1 (the default
    value) means that the animation will run one time. Note that a duration of
    -1 means that the animation will run until stopped; the current time will
    increase indefinitely. When the current time equals **duration** () and the
    animation is in its final loop, the **Stopped**  state is entered, and the
    **finished** () signal is emitted.

    QAbstractAnimation provides pure virtual functions used by subclasses to
    track the progress of the animation: **duration** () and
    **updateCurrentTime** (). The **duration** () function lets you report a
    duration for the animation (as discussed above). The animation framework
    calls **updateCurrentTime** () when current time has changed. By
    reimplementing this function, you can track the animation progress. Note
    that neither the interval between calls nor the number of calls to this
    function are defined; though, it will normally be 60 updates per second.

    By reimplementing **updateState** (), you can track the animation's state
    changes, which is particularly useful for animations that are not driven by
    time.

    **See also** **QVariantAnimation** , **QPropertyAnimation** ,
    **QAnimationGroup** , and **The Animation Framework** .
    """

    class DeletionPolicy(int):
        KeepWhenStopped: QAbstractAnimation = ...
        DeleteWhenStopped: QAbstractAnimation = ...

    class State(int):
        Stopped: QAbstractAnimation = ...
        Paused: QAbstractAnimation = ...
        Running: QAbstractAnimation = ...

    class Direction(int):
        Forward: QAbstractAnimation = ...
        Backward: QAbstractAnimation = ...

    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#QAbstractAnimation

        **QAbstractAnimation::QAbstractAnimation(QObject * parent = nullptr)**

        Constructs the QAbstractAnimation base class, and passes **parent** to
        **QObject** 's constructor.

        **See also** **QVariantAnimation**  and **QAnimationGroup** .
        """
        ...

    def updateDirection(self, direction: "QAbstractAnimation.Direction") -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#updateDirection

        **[virtual protected] void
        QAbstractAnimation::updateDirection(QAbstractAnimation::Direction
        direction )**

        This virtual function is called by **QAbstractAnimation**  when the
        direction of the animation is changed. The **direction** argument is the
        new direction.

        **See also** **setDirection** () and **direction** ().
        """
        ...

    def updateState(
        self, newState: "QAbstractAnimation.State", oldState: "QAbstractAnimation.State"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#updateState

        **[virtual protected] void
        QAbstractAnimation::updateState(QAbstractAnimation::State newState ,
        QAbstractAnimation::State oldState )**

        This virtual function is called by **QAbstractAnimation**  when the
        state of the animation is changed from **oldState** to **newState**.

        **See also** **start** (), **stop** (), **pause** (), and **resume** ().
        """
        ...

    def updateCurrentTime(self, currentTime: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#updateCurrentTime

        **[pure virtual protected] void
        QAbstractAnimation::updateCurrentTime(int currentTime )**

        This pure virtual function is called every time the animation's
        **currentTime** changes.

        **See also** **updateState** ().
        """
        ...

    def event(self, event: "QEvent") -> bool:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#event

        **[override virtual protected] bool QAbstractAnimation::event(QEvent *
        event )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def setCurrentTime(self, msecs: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#currentTime-prop

        **currentTime : int**

        This property holds the current time and progress of the animation

        This property describes the animation's current time. You can change the
        current time by calling setCurrentTime, or you can call **start** () and
        let the animation run, setting the current time automatically as the
        animation progresses.

        The animation's current time starts at 0, and ends at **totalDuration**
        ().

        **Access functions:**

        int **currentTime** () const
        void **setCurrentTime** (int **msecs** )

        **See also** **loopCount**  and **currentLoopTime** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#stop

        **[slot] void QAbstractAnimation::stop()**

        Stops the animation. When the animation is stopped, it emits the
        **stateChanged** () signal, and **state** () returns Stopped. The
        current time is not changed.

        If the animation stops by itself after reaching the end (i.e.,
        **currentLoopTime** () == **duration** () and **currentLoop** () >
        **loopCount** () - 1), the **finished** () signal is emitted.

        **See also** **start** () and **state** ().
        """
        ...

    def setPaused(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#setPaused

        **[slot] void QAbstractAnimation::setPaused(bool paused )**

        If **paused** is true, the animation is paused. If **paused** is false,
        the animation is resumed.

        **See also** **state** (), **pause** (), and **resume** ().
        """
        ...

    def resume(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#resume

        **[slot] void QAbstractAnimation::resume()**

        Resumes the animation after it was paused. When the animation is
        resumed, it emits the resumed() and **stateChanged** () signals. The
        currenttime is not changed.

        **See also** **start** (), **pause** (), and **state** ().
        """
        ...

    def pause(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#pause

        **[slot] void QAbstractAnimation::pause()**

        Pauses the animation. When the animation is paused, **state** () returns
        Paused. The value of **currentTime**  will remain unchanged until
        **resume** () or **start** () is called. If you want to continue from
        the current time, call **resume** ().

        **See also** **start** (), **state** (), and **resume** ().
        """
        ...

    def start(self, policy: "QAbstractAnimation.DeletionPolicy" = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#start

        **[slot] void
        QAbstractAnimation::start(QAbstractAnimation::DeletionPolicy policy =
        KeepWhenStopped)**

        Starts the animation. The **policy** argument says whether or not the
        animation should be deleted when it's done. When the animation starts,
        the **stateChanged** () signal is emitted, and **state** () returns
        Running. When control reaches the event loop, the animation will run by
        itself, periodically calling **updateCurrentTime** () as the animation
        progresses.

        If the animation is currently stopped or has already reached the end,
        calling start() will rewind the animation and start again from the
        beginning. When the animation reaches the end, the animation will either
        stop, or if the loop level is more than 1, it will rewind and continue
        from the beginning.

        If the animation is already running, this function does nothing.

        **See also** **stop** () and **state** ().
        """
        ...

    def totalDuration(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#totalDuration

        **int QAbstractAnimation::totalDuration() const**

        Returns the total and effective duration of the animation, including the
        loop count.

        **See also** **duration** () and **currentTime** .
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#duration

        **[pure virtual] int QAbstractAnimation::duration() const**

        This pure virtual function returns the duration of the animation, and
        defines for how long **QAbstractAnimation**  should update the current
        time. This duration is local, and does not include the loop count.

        A return value of -1 indicates that the animation has no defined
        duration; the animation should run forever until stopped. This is useful
        for animations that are not time driven, or where you cannot easily
        predict its duration (e.g., event driven audio playback in a game).

        If the animation is a parallel **QAnimationGroup** , the duration will
        be the longest duration of all its animations. If the animation is a
        sequential **QAnimationGroup** , the duration will be the sum of the
        duration of all its animations.

        **Note:** Getter function for property duration.

        **See also** **loopCount** .
        """
        ...

    def currentLoop(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#currentLoop-prop

        **currentLoop : const int**

        This property holds the current loop of the animation

        This property describes the current loop of the animation. By default,
        the animation's loop count is 1, and so the current loop will always be
        0. If the loop count is 2 and the animation runs past its duration, it
        will automatically rewind and restart at current time 0, and current
        loop 1, and so on.

        When the current loop changes, **QAbstractAnimation**  emits the
        **currentLoopChanged** () signal.

        **Access functions:**

        int **currentLoop** () const

        **Notifier signal:**

        void ****currentLoopChanged** ** (int **currentLoop** )
        """
        ...

    def setLoopCount(self, loopCount: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#loopCount-prop

        **loopCount : int**

        This property holds the loop count of the animation

        This property describes the loop count of the animation as an integer.
        By default this value is 1, indicating that the animation should run
        once only, and then stop. By changing it you can let the animation loop
        several times. With a value of 0, the animation will not run at all, and
        with a value of -1, the animation will loop forever until stopped. It is
        not supported to have loop on an animation that has an undefined
        duration. It will only run once.

        **Access functions:**

        int **loopCount** () const
        void **setLoopCount** (int **loopCount** )
        """
        ...

    def loopCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#loopCount-prop

        **loopCount : int**

        This property holds the loop count of the animation

        This property describes the loop count of the animation as an integer.
        By default this value is 1, indicating that the animation should run
        once only, and then stop. By changing it you can let the animation loop
        several times. With a value of 0, the animation will not run at all, and
        with a value of -1, the animation will loop forever until stopped. It is
        not supported to have loop on an animation that has an undefined
        duration. It will only run once.

        **Access functions:**

        int **loopCount** () const
        void **setLoopCount** (int **loopCount** )
        """
        ...

    def currentLoopTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#currentLoopTime

        **int QAbstractAnimation::currentLoopTime() const**

        Returns the current time inside the current loop. It can go from 0 to
        **duration** ().

        **See also** **duration** () and **currentTime** .
        """
        ...

    def currentTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#currentTime-prop

        **currentTime : int**

        This property holds the current time and progress of the animation

        This property describes the animation's current time. You can change the
        current time by calling setCurrentTime, or you can call **start** () and
        let the animation run, setting the current time automatically as the
        animation progresses.

        The animation's current time starts at 0, and ends at **totalDuration**
        ().

        **Access functions:**

        int **currentTime** () const
        void **setCurrentTime** (int **msecs** )

        **See also** **loopCount**  and **currentLoopTime** ().
        """
        ...

    def setDirection(self, direction: "QAbstractAnimation.Direction") -> None:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#direction-prop

        **direction : Direction**

        This property holds the direction of the animation when it is in
        **Running**  state.

        This direction indicates whether the time moves from 0 towards the
        animation duration, or from the value of the duration and towards 0
        after **start** () has been called.

        By default, this property is set to **Forward** .

        **Access functions:**

        QAbstractAnimation::Direction **direction** () const
        void
        **setDirection** (QAbstractAnimation::Direction **direction** )

        **Notifier signal:**

        void ****directionChanged** ** (QAbstractAnimation::Direction
        **newDirection** )
        """
        ...

    def direction(self) -> "QAbstractAnimation.Direction":
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#direction-prop

        **direction : Direction**

        This property holds the direction of the animation when it is in
        **Running**  state.

        This direction indicates whether the time moves from 0 towards the
        animation duration, or from the value of the duration and towards 0
        after **start** () has been called.

        By default, this property is set to **Forward** .

        **Access functions:**

        QAbstractAnimation::Direction **direction** () const
        void
        **setDirection** (QAbstractAnimation::Direction **direction** )

        **Notifier signal:**

        void ****directionChanged** ** (QAbstractAnimation::Direction
        **newDirection** )
        """
        ...

    def group(self) -> "QAnimationGroup":
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#group

        **QAnimationGroup *QAbstractAnimation::group() const**

        If this animation is part of a **QAnimationGroup** , this function
        returns a pointer to the group; otherwise, it returns `nullptr`.

        **See also** **QAnimationGroup::addAnimation** ().
        """
        ...

    def state(self) -> "QAbstractAnimation.State":
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#state-prop

        **state : const State**

        state of the animation.

        This property describes the current state of the animation. When the
        animation state changes, **QAbstractAnimation**  emits the
        **stateChanged** () signal.

        **Access functions:**

        QAbstractAnimation::State **state** () const

        **Notifier signal:**

        void ****stateChanged** ** (QAbstractAnimation::State **newState** ,
        QAbstractAnimation::State **oldState** )

        **Member Function Documentation**
        """
        ...

    @property
    def currentLoopChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#currentLoopChanged

        **[signal] void QAbstractAnimation::currentLoopChanged(int currentLoop
        )**

        **QAbstractAnimation**  emits this signal whenever the current loop
        changes. **currentLoop** is the current loop.

        **Note:** Notifier signal for property **currentLoop** .

        **See also** **currentLoop** () and **loopCount** ().
        """
        ...

    @property
    def directionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#directionChanged

        **[signal] void
        QAbstractAnimation::directionChanged(QAbstractAnimation::Direction
        newDirection )**

        **QAbstractAnimation**  emits this signal whenever the direction has
        been changed. **newDirection** is the new direction.

        **Note:** Notifier signal for property **direction** .

        **See also** **direction** .
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#finished

        **[signal] void QAbstractAnimation::finished()**

        **QAbstractAnimation**  emits this signal after the animation has
        stopped and has reached the end.

        This signal is emitted after **stateChanged** ().

        **See also** **stateChanged** ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qabstractanimation.html#stateChanged

        **[signal] void
        QAbstractAnimation::stateChanged(QAbstractAnimation::State newState ,
        QAbstractAnimation::State oldState )**

        **QAbstractAnimation**  emits this signal whenever the state of the
        animation has changed from **oldState** to **newState**. This signal is
        emitted after the virtual **updateState** () function is called.

        **Note:** Notifier signal for property **state** .

        **See also** **updateState** ().
        """
        ...
