"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtBluetooth import *


class QBluetoothDeviceInfo(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html

    **Detailed Description**

    QBluetoothDeviceInfo provides information about a Bluetooth device's name,
    address and class of device.
    """

    class Field(int):
        None_: QBluetoothDeviceInfo = ...
        RSSI: QBluetoothDeviceInfo = ...
        ManufacturerData: QBluetoothDeviceInfo = ...
        All: QBluetoothDeviceInfo = ...

    class CoreConfiguration(int):
        UnknownCoreConfiguration: QBluetoothDeviceInfo = ...
        LowEnergyCoreConfiguration: QBluetoothDeviceInfo = ...
        BaseRateCoreConfiguration: QBluetoothDeviceInfo = ...
        BaseRateAndLowEnergyCoreConfiguration: QBluetoothDeviceInfo = ...

    class DataCompleteness(int):
        DataComplete: QBluetoothDeviceInfo = ...
        DataIncomplete: QBluetoothDeviceInfo = ...
        DataUnavailable: QBluetoothDeviceInfo = ...

    class ServiceClass(int):
        NoService: QBluetoothDeviceInfo = ...
        PositioningService: QBluetoothDeviceInfo = ...
        NetworkingService: QBluetoothDeviceInfo = ...
        RenderingService: QBluetoothDeviceInfo = ...
        CapturingService: QBluetoothDeviceInfo = ...
        ObjectTransferService: QBluetoothDeviceInfo = ...
        AudioService: QBluetoothDeviceInfo = ...
        TelephonyService: QBluetoothDeviceInfo = ...
        InformationService: QBluetoothDeviceInfo = ...
        AllServices: QBluetoothDeviceInfo = ...

    class MinorHealthClass(int):
        UncategorizedHealthDevice: QBluetoothDeviceInfo = ...
        HealthBloodPressureMonitor: QBluetoothDeviceInfo = ...
        HealthThermometer: QBluetoothDeviceInfo = ...
        HealthWeightScale: QBluetoothDeviceInfo = ...
        HealthGlucoseMeter: QBluetoothDeviceInfo = ...
        HealthPulseOximeter: QBluetoothDeviceInfo = ...
        HealthDataDisplay: QBluetoothDeviceInfo = ...
        HealthStepCounter: QBluetoothDeviceInfo = ...

    class MinorToyClass(int):
        UncategorizedToy: QBluetoothDeviceInfo = ...
        ToyRobot: QBluetoothDeviceInfo = ...
        ToyVehicle: QBluetoothDeviceInfo = ...
        ToyDoll: QBluetoothDeviceInfo = ...
        ToyController: QBluetoothDeviceInfo = ...
        ToyGame: QBluetoothDeviceInfo = ...

    class MinorWearableClass(int):
        UncategorizedWearableDevice: QBluetoothDeviceInfo = ...
        WearableWristWatch: QBluetoothDeviceInfo = ...
        WearablePager: QBluetoothDeviceInfo = ...
        WearableJacket: QBluetoothDeviceInfo = ...
        WearableHelmet: QBluetoothDeviceInfo = ...
        WearableGlasses: QBluetoothDeviceInfo = ...

    class MinorImagingClass(int):
        UncategorizedImagingDevice: QBluetoothDeviceInfo = ...
        ImageDisplay: QBluetoothDeviceInfo = ...
        ImageCamera: QBluetoothDeviceInfo = ...
        ImageScanner: QBluetoothDeviceInfo = ...
        ImagePrinter: QBluetoothDeviceInfo = ...

    class MinorPeripheralClass(int):
        UncategorizedPeripheral: QBluetoothDeviceInfo = ...
        KeyboardPeripheral: QBluetoothDeviceInfo = ...
        PointingDevicePeripheral: QBluetoothDeviceInfo = ...
        KeyboardWithPointingDevicePeripheral: QBluetoothDeviceInfo = ...
        JoystickPeripheral: QBluetoothDeviceInfo = ...
        GamepadPeripheral: QBluetoothDeviceInfo = ...
        RemoteControlPeripheral: QBluetoothDeviceInfo = ...
        SensingDevicePeripheral: QBluetoothDeviceInfo = ...
        DigitizerTabletPeripheral: QBluetoothDeviceInfo = ...
        CardReaderPeripheral: QBluetoothDeviceInfo = ...

    class MinorAudioVideoClass(int):
        UncategorizedAudioVideoDevice: QBluetoothDeviceInfo = ...
        WearableHeadsetDevice: QBluetoothDeviceInfo = ...
        HandsFreeDevice: QBluetoothDeviceInfo = ...
        Microphone: QBluetoothDeviceInfo = ...
        Loudspeaker: QBluetoothDeviceInfo = ...
        Headphones: QBluetoothDeviceInfo = ...
        PortableAudioDevice: QBluetoothDeviceInfo = ...
        CarAudio: QBluetoothDeviceInfo = ...
        SetTopBox: QBluetoothDeviceInfo = ...
        HiFiAudioDevice: QBluetoothDeviceInfo = ...
        Vcr: QBluetoothDeviceInfo = ...
        VideoCamera: QBluetoothDeviceInfo = ...
        Camcorder: QBluetoothDeviceInfo = ...
        VideoMonitor: QBluetoothDeviceInfo = ...
        VideoDisplayAndLoudspeaker: QBluetoothDeviceInfo = ...
        VideoConferencing: QBluetoothDeviceInfo = ...
        GamingDevice: QBluetoothDeviceInfo = ...

    class MinorNetworkClass(int):
        NetworkFullService: QBluetoothDeviceInfo = ...
        NetworkLoadFactorOne: QBluetoothDeviceInfo = ...
        NetworkLoadFactorTwo: QBluetoothDeviceInfo = ...
        NetworkLoadFactorThree: QBluetoothDeviceInfo = ...
        NetworkLoadFactorFour: QBluetoothDeviceInfo = ...
        NetworkLoadFactorFive: QBluetoothDeviceInfo = ...
        NetworkLoadFactorSix: QBluetoothDeviceInfo = ...
        NetworkNoService: QBluetoothDeviceInfo = ...

    class MinorPhoneClass(int):
        UncategorizedPhone: QBluetoothDeviceInfo = ...
        CellularPhone: QBluetoothDeviceInfo = ...
        CordlessPhone: QBluetoothDeviceInfo = ...
        SmartPhone: QBluetoothDeviceInfo = ...
        WiredModemOrVoiceGatewayPhone: QBluetoothDeviceInfo = ...
        CommonIsdnAccessPhone: QBluetoothDeviceInfo = ...

    class MinorComputerClass(int):
        UncategorizedComputer: QBluetoothDeviceInfo = ...
        DesktopComputer: QBluetoothDeviceInfo = ...
        ServerComputer: QBluetoothDeviceInfo = ...
        LaptopComputer: QBluetoothDeviceInfo = ...
        HandheldClamShellComputer: QBluetoothDeviceInfo = ...
        HandheldComputer: QBluetoothDeviceInfo = ...
        WearableComputer: QBluetoothDeviceInfo = ...

    class MinorMiscellaneousClass(int):
        UncategorizedMiscellaneous: QBluetoothDeviceInfo = ...

    class MajorDeviceClass(int):
        MiscellaneousDevice: QBluetoothDeviceInfo = ...
        ComputerDevice: QBluetoothDeviceInfo = ...
        PhoneDevice: QBluetoothDeviceInfo = ...
        LANAccessDevice: QBluetoothDeviceInfo = ...
        NetworkDevice: QBluetoothDeviceInfo = ...
        AudioVideoDevice: QBluetoothDeviceInfo = ...
        PeripheralDevice: QBluetoothDeviceInfo = ...
        ImagingDevice: QBluetoothDeviceInfo = ...
        WearableDevice: QBluetoothDeviceInfo = ...
        ToyDevice: QBluetoothDeviceInfo = ...
        HealthDevice: QBluetoothDeviceInfo = ...
        UncategorizedDevice: QBluetoothDeviceInfo = ...

    class ServiceClasses(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QBluetoothDeviceInfo.ServiceClasses",
                "QBluetoothDeviceInfo.ServiceClass",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QBluetoothDeviceInfo.ServiceClasses") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QBluetoothDeviceInfo.ServiceClasses":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class CoreConfigurations(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QBluetoothDeviceInfo.CoreConfigurations",
                "QBluetoothDeviceInfo.CoreConfiguration",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QBluetoothDeviceInfo.CoreConfigurations") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QBluetoothDeviceInfo.CoreConfigurations":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class Fields(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QBluetoothDeviceInfo.Fields", "QBluetoothDeviceInfo.Field"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QBluetoothDeviceInfo.Fields") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QBluetoothDeviceInfo.Fields":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo()**

        Constructs an invalid QBluetoothDeviceInfo object.
        """
        ...

    @typing.overload
    def __init__(
        self, address: QBluetoothAddress, name: str, classOfDevice: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-1

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo(const QBluetoothAddress &
        address , const QString & name , quint32 classOfDevice )**

        Constructs a QBluetoothDeviceInfo object with Bluetooth address
        **address** , device name **name** and the encoded class of device
        **classOfDevice**.

        The **classOfDevice** parameter is encoded in the following format

        BitsSizeDescription
        0 - 12Unused, set to 0.
        2 - 76Minor device
        class.
        8 - 125Major device class.
        13 - 2311Service class.
        """
        ...

    @typing.overload
    def __init__(self, uuid: "QBluetoothUuid", name: str, classOfDevice: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-2

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo(const QBluetoothUuid & uuid
        , const QString & name , quint32 classOfDevice )**

        Constructs a QBluetoothDeviceInfo object with unique **uuid** , device
        name **name** and the encoded class of device **classOfDevice**.

        This constructor is required for Low Energy devices on macOS and iOS.
        CoreBluetooth API hides addresses and provides unique UUIDs to identify
        a device. This UUID is not the same thing as a service UUID and is
        required to work later with CoreBluetooth API and discovered devices.

        This function was introduced in Qt 5.5.
        """
        ...

    @typing.overload
    def __init__(self, other: "QBluetoothDeviceInfo") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#QBluetoothDeviceInfo-3

        **QBluetoothDeviceInfo::QBluetoothDeviceInfo(const QBluetoothDeviceInfo
        & other )**

        Constructs a QBluetoothDeviceInfo that is a copy of **other**.
        """
        ...

    def setManufacturerData(
        self,
        manufacturerId: int,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setManufacturerData

        **bool QBluetoothDeviceInfo::setManufacturerData(quint16 manufacturerId
        , const QByteArray & data )**

        Sets the advertised manufacturer **data** for the given
        **manufacturerId**. Returns `true` if it was inserted, `false` if it was
        already known.

        Since Qt 5.14, different values for **data** and the same
        **manufacturerId** no longer replace each other but are accumulated for
        the duration of a device scan.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerData** .
        """
        ...

    @typing.overload
    def manufacturerData(self, manufacturerId: int) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#manufacturerData

        **QByteArray QBluetoothDeviceInfo::manufacturerData(quint16
        manufacturerId ) const**

        Returns the data associated with the given **manufacturerId**.

        Manufacturer data is defined by the Supplement to the Bluetooth Core
        Specification and consists of two segments:

        * Manufacturer specific identifier code from the **Assigned Numbers**
        Company Identifiers document
          * Sequence of arbitrary data octets

        The interpretation of the data octets is defined by the manufacturer
        specified by the company identifier.

        **Note:** The remote device may provide multiple data entries per
        manufacturerId. This function only returns the first entry. If all
        entries are needed use **manufacturerData** () which returns a multi
        hash.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerIds** () and **setManufacturerData** ().
        """
        ...

    @typing.overload
    def manufacturerData(self) -> typing.Dict[int, QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#manufacturerData-1

        **QHash<quint16, QByteArray> QBluetoothDeviceInfo::manufacturerData()
        const**

        Returns the complete set of all manufacturer data.

        Some devices may provide multiple manufacturer data entries per
        manufacturer ID. An example might be a Bluetooth Low Energy device that
        sends a different manufacturer data via advertisement packets and scan
        response packets respectively. Therefore the returned hash table may
        have multiple entries per manufacturer ID or hash key.

        This function was introduced in Qt 5.12.

        **See also** **setManufacturerData** .
        """
        ...

    def manufacturerIds(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#manufacturerIds

        **QVector<quint16> QBluetoothDeviceInfo::manufacturerIds() const**

        Returns all manufacturer ids attached to this device information.

        This function was introduced in Qt 5.12.

        **See also** **manufacturerData** () and **setManufacturerData** ().
        """
        ...

    def deviceUuid(self) -> "QBluetoothUuid":
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#deviceUuid

        **QBluetoothUuid QBluetoothDeviceInfo::deviceUuid() const**

        Returns a unique identifier for a Bluetooth device without an address.

        In general, this uuid is invalid on every platform but macOS and iOS. It
        is used as a workaround for those two platforms as they do not provide
        Bluetooth addresses for found Bluetooth Low Energy devices. Every other
        platform uses **address** () instead.

        This function was introduced in Qt 5.5.

        **See also** **setDeviceUuid** ().
        """
        ...

    def setDeviceUuid(self, uuid: "QBluetoothUuid") -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setDeviceUuid

        **void QBluetoothDeviceInfo::setDeviceUuid(const QBluetoothUuid & uuid
        )**

        Sets the unique identifier **uuid** for Bluetooth devices, that do not
        have addresses. This happens on macOS and iOS, where the CoreBluetooth
        API hides addresses, but provides UUIDs to identify devices/peripherals.

        This uuid is invalid on any other platform.

        This function was introduced in Qt 5.5.

        **See also** **deviceUuid** ().
        """
        ...

    def coreConfigurations(self) -> "QBluetoothDeviceInfo.CoreConfigurations":
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#coreConfigurations

        **QBluetoothDeviceInfo::CoreConfigurations
        QBluetoothDeviceInfo::coreConfigurations() const**

        Returns the configuration of the device. If device configuration is not
        set, basic rate device configuration will be returned.

        This function was introduced in Qt 5.4.

        **See also** **setCoreConfigurations** ().
        """
        ...

    def setCoreConfigurations(
        self,
        coreConfigs: typing.Union[
            "QBluetoothDeviceInfo.CoreConfigurations",
            "QBluetoothDeviceInfo.CoreConfiguration",
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setCoreConfigurations

        **void QBluetoothDeviceInfo::setCoreConfigurations(QBluetoothDeviceInfo:
        :CoreConfigurations coreConfigs )**

        Sets the **CoreConfigurations**  of the device to **coreConfigs**. This
        will help to make a difference between regular and Low Energy devices.

        This function was introduced in Qt 5.4.

        **See also** **coreConfigurations** ().
        """
        ...

    def serviceUuidsCompleteness(self) -> "QBluetoothDeviceInfo.DataCompleteness":
        ...

    def serviceUuids(
        self,
    ) -> typing.Tuple[
        typing.List["QBluetoothUuid"], "QBluetoothDeviceInfo.DataCompleteness"
    ]:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#serviceUuids

        **QList<QBluetoothUuid> QBluetoothDeviceInfo::serviceUuids(QBluetoothDev
        iceInfo::DataCompleteness * completeness = nullptr) const**

        Returns the list of service UUIDS supported by the device. If
        **completeness** is not 0 it will be set to **DataComplete**  and the
        complete list of UUIDs supported by the device is returned.
        **DataIncomplete**  if additional service UUIDs are supported by the
        device and **DataUnavailable**  if no service UUID information is
        available.

        This function requires both the Bluetooth devices to support the 2.1
        specification.

        **See also** **setServiceUuids** ().
        """
        ...

    @typing.overload
    def setServiceUuids(
        self,
        uuids: typing.Iterable["QBluetoothUuid"],
        completeness: "QBluetoothDeviceInfo.DataCompleteness",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setServiceUuids-1

        **void QBluetoothDeviceInfo::setServiceUuids(const
        QVector<QBluetoothUuid> & uuids )**

        Sets the list of service UUIDs to **uuids**.

        This function was introduced in Qt 5.13.
        """
        ...

    @typing.overload
    def setServiceUuids(self, uuids: typing.Iterable["QBluetoothUuid"]) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setServiceUuids-1

        **void QBluetoothDeviceInfo::setServiceUuids(const
        QVector<QBluetoothUuid> & uuids )**

        Sets the list of service UUIDs to **uuids**.

        This function was introduced in Qt 5.13.
        """
        ...

    def setRssi(self, signal: int) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setRssi

        **void QBluetoothDeviceInfo::setRssi(qint16 signal )**

        Set the **signal** strength value, used internally.

        **See also** **rssi** ().
        """
        ...

    def rssi(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#rssi

        **qint16 QBluetoothDeviceInfo::rssi() const**

        Returns the signal strength when the device was last scanned

        **See also** **setRssi** ().
        """
        ...

    def minorDeviceClass(self) -> int:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#minorDeviceClass

        **quint8 QBluetoothDeviceInfo::minorDeviceClass() const**

        Returns the minor device class of the device. The actual information is
        context dependent on the value of **majorDeviceClass** ().

        **See also** **MinorAudioVideoClass** , **MinorComputerClass** ,
        **MinorHealthClass** , **MinorImagingClass** ,
        **MinorMiscellaneousClass** , **MinorNetworkClass** ,
        **MinorPeripheralClass** , **MinorPhoneClass** , **MinorToyClass** , and
        **MinorWearableClass** .
        """
        ...

    def majorDeviceClass(self) -> "QBluetoothDeviceInfo.MajorDeviceClass":
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#majorDeviceClass

        **QBluetoothDeviceInfo::MajorDeviceClass
        QBluetoothDeviceInfo::majorDeviceClass() const**

        Returns the major device class of the device.
        """
        ...

    def serviceClasses(self) -> "QBluetoothDeviceInfo.ServiceClasses":
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#serviceClasses

        **QBluetoothDeviceInfo::ServiceClasses
        QBluetoothDeviceInfo::serviceClasses() const**

        Returns the service class of the device.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#name

        **QString QBluetoothDeviceInfo::name() const**

        Returns the name assigned to the device.
        """
        ...

    def address(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#address

        **QBluetoothAddress QBluetoothDeviceInfo::address() const**

        Returns the address of the device.

        **Note:** On iOS and macOS this address is invalid. Instead
        **deviceUuid** () should be used. Those two platforms do not expose
        Bluetooth addresses for found Bluetooth devices and utilize unique
        device identifiers.

        **See also** **deviceUuid** ().
        """
        ...

    def setCached(self, cached: bool) -> None:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#setCached

        **void QBluetoothDeviceInfo::setCached(bool cached )**

        Used by the system to set the **cached** flag if the
        **QBluetoothDeviceInfo**  is created from cached data. Cached
        information may not be as accurate as data read from an active device.

        **See also** **isCached** ().
        """
        ...

    def isCached(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#isCached

        **bool QBluetoothDeviceInfo::isCached() const**

        Returns true if the **QBluetoothDeviceInfo**  object is created from
        cached data.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbluetoothdeviceinfo.html#isValid

        **bool QBluetoothDeviceInfo::isValid() const**

        Returns true if the **QBluetoothDeviceInfo**  object is valid, otherwise
        returns false.
        """
        ...
