#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 595
#define LARGE_STATE_COUNT 63
#define SYMBOL_COUNT 161
#define ALIAS_COUNT 2
#define TOKEN_COUNT 116
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 11
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 35

enum {
  anon_sym_COLONmanuscript_COLON = 1,
  anon_sym_COLON_COLON = 2,
  anon_sym_COLONparagraph_COLON = 3,
  anon_sym_COLONappendix_COLON = 4,
  anon_sym_COLONbibliography_COLON = 5,
  anon_sym_COLONtoc_COLON = 6,
  aux_sym_specialblock_token1 = 7,
  aux_sym_specialblock_token2 = 8,
  aux_sym_specialblock_token3 = 9,
  aux_sym_specialblock_token4 = 10,
  aux_sym_specialblock_token5 = 11,
  anon_sym_COLONmathblock_COLON = 12,
  anon_sym_COLONcodeblock_COLON = 13,
  anon_sym_COLONalgorithm_COLON = 14,
  anon_sym_COLONcaption_COLON = 15,
  anon_sym_COLONitem_COLON = 16,
  anon_sym_COLONprev_COLON = 17,
  anon_sym_COLONprev2_COLON = 18,
  anon_sym_COLONprev3_COLON = 19,
  aux_sym_specialinline_token1 = 20,
  aux_sym_specialinline_token2 = 21,
  anon_sym_COLONmath_COLON = 22,
  anon_sym_COLONcode_COLON = 23,
  aux_sym_specialinline_token3 = 24,
  anon_sym_STAR = 25,
  aux_sym_specialinline_token4 = 26,
  anon_sym_SLASH = 27,
  anon_sym_COLONref_COLON = 28,
  aux_sym_specialinline_token5 = 29,
  anon_sym_COMMA = 30,
  anon_sym_COLONprevious_COLON = 31,
  aux_sym_specialinline_token6 = 32,
  anon_sym_COLONurl_COLON = 33,
  aux_sym_specialinline_token7 = 34,
  anon_sym_COLONcite_COLON = 35,
  aux_sym_specialinline_token8 = 36,
  anon_sym_COLONqed_COLON = 37,
  anon_sym_LBRACE = 38,
  anon_sym_RBRACE = 39,
  aux_sym_metaval_any_token1 = 40,
  aux_sym_metaval_any_inline_token1 = 41,
  anon_sym_COLONtable_COLON = 42,
  anon_sym_COLONthead_COLON = 43,
  anon_sym_COLONtbody_COLON = 44,
  anon_sym_COLONtr_COLON = 45,
  anon_sym_COLON = 46,
  anon_sym_COLONtd_COLON = 47,
  anon_sym_COLONbibtex_COLON = 48,
  anon_sym_AT = 49,
  aux_sym_bibitem_token1 = 50,
  aux_sym_bibitem_token2 = 51,
  aux_sym_bibitempair_token1 = 52,
  anon_sym_EQ = 53,
  aux_sym_bibitempair_token2 = 54,
  anon_sym_COLONassume_COLON = 55,
  anon_sym_COLONsuppose_COLON = 56,
  anon_sym_COLONprove_COLON = 57,
  anon_sym_COLONthen_COLON = 58,
  anon_sym_COLONnew_COLON = 59,
  anon_sym_COLONlet_COLON = 60,
  anon_sym_COLONcase_COLON = 61,
  anon_sym_COLONdefine_COLON = 62,
  anon_sym_COLONwrite_COLON = 63,
  anon_sym_COLONwlog_COLON = 64,
  anon_sym_COLONsuffices_COLON = 65,
  anon_sym_COLONclaim_COLON = 66,
  anon_sym_COLON_PIPE_DASH_COLON = 67,
  anon_sym_COLON_COLON2 = 68,
  anon_sym_COLONdraft_COLON = 69,
  anon_sym_COLONnote_COLON = 70,
  anon_sym_COLONspan_COLON = 71,
  anon_sym_COLONabstract_COLON = 72,
  anon_sym_COLONauthor_COLON = 73,
  anon_sym_COLONdefinition_COLON = 74,
  anon_sym_COLONenumerate_COLON = 75,
  anon_sym_COLONitemize_COLON = 76,
  anon_sym_COLONlemma_COLON = 77,
  anon_sym_COLONfigure_COLON = 78,
  anon_sym_COLONp_COLON = 79,
  anon_sym_COLONproof_COLON = 80,
  anon_sym_COLONproposition_COLON = 81,
  anon_sym_COLONremark_COLON = 82,
  anon_sym_COLONsection_COLON = 83,
  anon_sym_COLONsketch_COLON = 84,
  anon_sym_COLONsubsection_COLON = 85,
  anon_sym_COLONsubsubsection_COLON = 86,
  anon_sym_COLONsubsubsubsection_COLON = 87,
  anon_sym_COLONstep_COLON = 88,
  anon_sym_COLONtheorem_COLON = 89,
  anon_sym_COLONaffiliation_COLON = 90,
  anon_sym_COLONemail_COLON = 91,
  anon_sym_COLONlabel_COLON = 92,
  anon_sym_COLONname_COLON = 93,
  anon_sym_COLONreftext_COLON = 94,
  anon_sym_COLONtitle_COLON = 95,
  anon_sym_COLONgoal_COLON = 96,
  anon_sym_COLONnonum_COLON = 97,
  anon_sym_COLONstrong_COLON = 98,
  anon_sym_COLONemphas_COLON = 99,
  anon_sym_COLONisclaim_COLON = 100,
  anon_sym_COLONkeywords_COLON = 101,
  anon_sym_COLONMSC_COLON = 102,
  anon_sym_COLONtypes_COLON = 103,
  anon_sym_COLONdate_COLON = 104,
  anon_sym_COLONpath_COLON = 105,
  anon_sym_COLONscale_COLON = 106,
  sym_comment = 107,
  sym_upto_brace_or_comma_text = 108,
  sym_asis_dollar_text = 109,
  sym_asis_two_dollars_text = 110,
  sym_asis_backtick_text = 111,
  sym_asis_three_backticks_text = 112,
  sym_asis_halmos_text = 113,
  sym_text = 114,
  sym_paragraph_end = 115,
  sym_source_file = 116,
  sym_block = 117,
  sym_paragraph = 118,
  sym_inline = 119,
  sym_construct = 120,
  sym_specialblock = 121,
  sym_caption = 122,
  sym_item = 123,
  sym_specialinline = 124,
  sym_specialconstruct = 125,
  sym_inlinemeta = 126,
  sym_blockmeta = 127,
  sym_inlinemetapair = 128,
  sym_pair = 129,
  sym_metaval_any = 130,
  sym_metaval_any_inline = 131,
  sym_metaval_text = 132,
  sym_metaval_text_inline = 133,
  sym_metaval_list = 134,
  sym_metaval_list_inline = 135,
  sym_table = 136,
  sym_thead = 137,
  sym_tbody = 138,
  sym_tr = 139,
  sym_trshort = 140,
  sym_td = 141,
  sym_tdcontent = 142,
  sym_bibtex = 143,
  sym_bibitem = 144,
  sym_bibitempair = 145,
  sym_metakey_text = 146,
  sym_metakey_bool = 147,
  sym_metakey_list = 148,
  sym_metakey_any = 149,
  aux_sym_source_file_repeat1 = 150,
  aux_sym_paragraph_repeat1 = 151,
  aux_sym_inline_repeat1 = 152,
  aux_sym_inlinemeta_repeat1 = 153,
  aux_sym_blockmeta_repeat1 = 154,
  aux_sym_metaval_list_repeat1 = 155,
  aux_sym_thead_repeat1 = 156,
  aux_sym_tr_repeat1 = 157,
  aux_sym_trshort_repeat1 = 158,
  aux_sym_bibtex_repeat1 = 159,
  aux_sym_bibitem_repeat1 = 160,
  anon_alias_sym_math = 161,
  anon_alias_sym_mathblock = 162,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_COLONmanuscript_COLON] = "manuscript",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLONparagraph_COLON] = ":paragraph:",
  [anon_sym_COLONappendix_COLON] = "appendix",
  [anon_sym_COLONbibliography_COLON] = "bibliography",
  [anon_sym_COLONtoc_COLON] = "toc",
  [aux_sym_specialblock_token1] = "section",
  [aux_sym_specialblock_token2] = "subsection",
  [aux_sym_specialblock_token3] = "subsubsection",
  [aux_sym_specialblock_token4] = "mathblock",
  [aux_sym_specialblock_token5] = "specialblock_token5",
  [anon_sym_COLONmathblock_COLON] = "mathblock",
  [anon_sym_COLONcodeblock_COLON] = "codeblock",
  [anon_sym_COLONalgorithm_COLON] = "algorithm",
  [anon_sym_COLONcaption_COLON] = ":caption:",
  [anon_sym_COLONitem_COLON] = ":item:",
  [anon_sym_COLONprev_COLON] = "prev",
  [anon_sym_COLONprev2_COLON] = "prev2",
  [anon_sym_COLONprev3_COLON] = "prev3",
  [aux_sym_specialinline_token1] = "math",
  [aux_sym_specialinline_token2] = "specialinline_token2",
  [anon_sym_COLONmath_COLON] = "math",
  [anon_sym_COLONcode_COLON] = "code",
  [aux_sym_specialinline_token3] = "spanstrong",
  [anon_sym_STAR] = "*",
  [aux_sym_specialinline_token4] = "spanemphas",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLONref_COLON] = "ref",
  [aux_sym_specialinline_token5] = "text",
  [anon_sym_COMMA] = ",",
  [anon_sym_COLONprevious_COLON] = "previous",
  [aux_sym_specialinline_token6] = "text",
  [anon_sym_COLONurl_COLON] = "url",
  [aux_sym_specialinline_token7] = "text",
  [anon_sym_COLONcite_COLON] = "cite",
  [aux_sym_specialinline_token8] = "text",
  [anon_sym_COLONqed_COLON] = "qed",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [aux_sym_metaval_any_token1] = "text",
  [aux_sym_metaval_any_inline_token1] = "text",
  [anon_sym_COLONtable_COLON] = ":table:",
  [anon_sym_COLONthead_COLON] = ":thead:",
  [anon_sym_COLONtbody_COLON] = ":tbody:",
  [anon_sym_COLONtr_COLON] = ":tr:",
  [anon_sym_COLON] = ":",
  [anon_sym_COLONtd_COLON] = ":td:",
  [anon_sym_COLONbibtex_COLON] = ":bibtex:",
  [anon_sym_AT] = "@",
  [aux_sym_bibitem_token1] = "kind",
  [aux_sym_bibitem_token2] = "label",
  [aux_sym_bibitempair_token1] = "key",
  [anon_sym_EQ] = "=",
  [aux_sym_bibitempair_token2] = "value",
  [anon_sym_COLONassume_COLON] = "assume",
  [anon_sym_COLONsuppose_COLON] = "suppose",
  [anon_sym_COLONprove_COLON] = "prove",
  [anon_sym_COLONthen_COLON] = "then",
  [anon_sym_COLONnew_COLON] = "new",
  [anon_sym_COLONlet_COLON] = "let",
  [anon_sym_COLONcase_COLON] = "case",
  [anon_sym_COLONdefine_COLON] = "define",
  [anon_sym_COLONwrite_COLON] = "write",
  [anon_sym_COLONwlog_COLON] = "wlog",
  [anon_sym_COLONsuffices_COLON] = "suffices",
  [anon_sym_COLONclaim_COLON] = "claim",
  [anon_sym_COLON_PIPE_DASH_COLON] = "claim",
  [anon_sym_COLON_COLON2] = "claim",
  [anon_sym_COLONdraft_COLON] = "draft",
  [anon_sym_COLONnote_COLON] = "note",
  [anon_sym_COLONspan_COLON] = "span",
  [anon_sym_COLONabstract_COLON] = "abstract",
  [anon_sym_COLONauthor_COLON] = "author",
  [anon_sym_COLONdefinition_COLON] = "definition",
  [anon_sym_COLONenumerate_COLON] = "enumerate",
  [anon_sym_COLONitemize_COLON] = "itemize",
  [anon_sym_COLONlemma_COLON] = "lemma",
  [anon_sym_COLONfigure_COLON] = "figure",
  [anon_sym_COLONp_COLON] = "subproof",
  [anon_sym_COLONproof_COLON] = "proof",
  [anon_sym_COLONproposition_COLON] = "proposition",
  [anon_sym_COLONremark_COLON] = "remark",
  [anon_sym_COLONsection_COLON] = "section",
  [anon_sym_COLONsketch_COLON] = "sketch",
  [anon_sym_COLONsubsection_COLON] = "subsection",
  [anon_sym_COLONsubsubsection_COLON] = "subsubsection",
  [anon_sym_COLONsubsubsubsection_COLON] = "subsubsubsection",
  [anon_sym_COLONstep_COLON] = "step",
  [anon_sym_COLONtheorem_COLON] = "theorem",
  [anon_sym_COLONaffiliation_COLON] = "affiliation",
  [anon_sym_COLONemail_COLON] = "email",
  [anon_sym_COLONlabel_COLON] = "label",
  [anon_sym_COLONname_COLON] = "name",
  [anon_sym_COLONreftext_COLON] = "reftext",
  [anon_sym_COLONtitle_COLON] = "title",
  [anon_sym_COLONgoal_COLON] = "goal",
  [anon_sym_COLONnonum_COLON] = "nonum",
  [anon_sym_COLONstrong_COLON] = "strong",
  [anon_sym_COLONemphas_COLON] = "emphas",
  [anon_sym_COLONisclaim_COLON] = "isclaim",
  [anon_sym_COLONkeywords_COLON] = "keywords",
  [anon_sym_COLONMSC_COLON] = "MSC",
  [anon_sym_COLONtypes_COLON] = "types",
  [anon_sym_COLONdate_COLON] = "date",
  [anon_sym_COLONpath_COLON] = "path",
  [anon_sym_COLONscale_COLON] = "scale",
  [sym_comment] = "comment",
  [sym_upto_brace_or_comma_text] = "metaval_list_item",
  [sym_asis_dollar_text] = "asis_text",
  [sym_asis_two_dollars_text] = "asis_text",
  [sym_asis_backtick_text] = "asis_text",
  [sym_asis_three_backticks_text] = "asis_text",
  [sym_asis_halmos_text] = "asis_text",
  [sym_text] = "text",
  [sym_paragraph_end] = "paragraph_end",
  [sym_source_file] = "source_file",
  [sym_block] = "block",
  [sym_paragraph] = "paragraph",
  [sym_inline] = "inline",
  [sym_construct] = "construct",
  [sym_specialblock] = "specialblock",
  [sym_caption] = "caption",
  [sym_item] = "item",
  [sym_specialinline] = "specialinline",
  [sym_specialconstruct] = "specialconstruct",
  [sym_inlinemeta] = "inlinemeta",
  [sym_blockmeta] = "blockmeta",
  [sym_inlinemetapair] = "pair",
  [sym_pair] = "pair",
  [sym_metaval_any] = "metaval_any",
  [sym_metaval_any_inline] = "metaval_any",
  [sym_metaval_text] = "metaval_text",
  [sym_metaval_text_inline] = "metaval_text",
  [sym_metaval_list] = "metaval_list",
  [sym_metaval_list_inline] = "metaval_list",
  [sym_table] = "table",
  [sym_thead] = "thead",
  [sym_tbody] = "tbody",
  [sym_tr] = "tr",
  [sym_trshort] = "trshort",
  [sym_td] = "td",
  [sym_tdcontent] = "tdcontent",
  [sym_bibtex] = "bibtex",
  [sym_bibitem] = "bibitem",
  [sym_bibitempair] = "bibitempair",
  [sym_metakey_text] = "metakey_text",
  [sym_metakey_bool] = "metakey_bool",
  [sym_metakey_list] = "metakey_list",
  [sym_metakey_any] = "metakey_any",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_paragraph_repeat1] = "paragraph_repeat1",
  [aux_sym_inline_repeat1] = "inline_repeat1",
  [aux_sym_inlinemeta_repeat1] = "inlinemeta_repeat1",
  [aux_sym_blockmeta_repeat1] = "blockmeta_repeat1",
  [aux_sym_metaval_list_repeat1] = "metaval_list_repeat1",
  [aux_sym_thead_repeat1] = "thead_repeat1",
  [aux_sym_tr_repeat1] = "tr_repeat1",
  [aux_sym_trshort_repeat1] = "trshort_repeat1",
  [aux_sym_bibtex_repeat1] = "bibtex_repeat1",
  [aux_sym_bibitem_repeat1] = "bibitem_repeat1",
  [anon_alias_sym_math] = "math",
  [anon_alias_sym_mathblock] = "mathblock",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_COLONmanuscript_COLON] = anon_sym_COLONmanuscript_COLON,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLONparagraph_COLON] = anon_sym_COLONparagraph_COLON,
  [anon_sym_COLONappendix_COLON] = anon_sym_COLONappendix_COLON,
  [anon_sym_COLONbibliography_COLON] = anon_sym_COLONbibliography_COLON,
  [anon_sym_COLONtoc_COLON] = anon_sym_COLONtoc_COLON,
  [aux_sym_specialblock_token1] = aux_sym_specialblock_token1,
  [aux_sym_specialblock_token2] = aux_sym_specialblock_token2,
  [aux_sym_specialblock_token3] = aux_sym_specialblock_token3,
  [aux_sym_specialblock_token4] = aux_sym_specialblock_token4,
  [aux_sym_specialblock_token5] = aux_sym_specialblock_token5,
  [anon_sym_COLONmathblock_COLON] = aux_sym_specialblock_token4,
  [anon_sym_COLONcodeblock_COLON] = anon_sym_COLONcodeblock_COLON,
  [anon_sym_COLONalgorithm_COLON] = anon_sym_COLONalgorithm_COLON,
  [anon_sym_COLONcaption_COLON] = anon_sym_COLONcaption_COLON,
  [anon_sym_COLONitem_COLON] = anon_sym_COLONitem_COLON,
  [anon_sym_COLONprev_COLON] = anon_sym_COLONprev_COLON,
  [anon_sym_COLONprev2_COLON] = anon_sym_COLONprev2_COLON,
  [anon_sym_COLONprev3_COLON] = anon_sym_COLONprev3_COLON,
  [aux_sym_specialinline_token1] = aux_sym_specialinline_token1,
  [aux_sym_specialinline_token2] = aux_sym_specialinline_token2,
  [anon_sym_COLONmath_COLON] = aux_sym_specialinline_token1,
  [anon_sym_COLONcode_COLON] = anon_sym_COLONcode_COLON,
  [aux_sym_specialinline_token3] = aux_sym_specialinline_token3,
  [anon_sym_STAR] = anon_sym_STAR,
  [aux_sym_specialinline_token4] = aux_sym_specialinline_token4,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLONref_COLON] = anon_sym_COLONref_COLON,
  [aux_sym_specialinline_token5] = sym_text,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_COLONprevious_COLON] = anon_sym_COLONprevious_COLON,
  [aux_sym_specialinline_token6] = sym_text,
  [anon_sym_COLONurl_COLON] = anon_sym_COLONurl_COLON,
  [aux_sym_specialinline_token7] = sym_text,
  [anon_sym_COLONcite_COLON] = anon_sym_COLONcite_COLON,
  [aux_sym_specialinline_token8] = sym_text,
  [anon_sym_COLONqed_COLON] = anon_sym_COLONqed_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [aux_sym_metaval_any_token1] = aux_sym_metaval_any_token1,
  [aux_sym_metaval_any_inline_token1] = aux_sym_metaval_any_token1,
  [anon_sym_COLONtable_COLON] = anon_sym_COLONtable_COLON,
  [anon_sym_COLONthead_COLON] = anon_sym_COLONthead_COLON,
  [anon_sym_COLONtbody_COLON] = anon_sym_COLONtbody_COLON,
  [anon_sym_COLONtr_COLON] = anon_sym_COLONtr_COLON,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_COLONtd_COLON] = anon_sym_COLONtd_COLON,
  [anon_sym_COLONbibtex_COLON] = anon_sym_COLONbibtex_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [aux_sym_bibitem_token1] = aux_sym_bibitem_token1,
  [aux_sym_bibitem_token2] = aux_sym_bibitem_token2,
  [aux_sym_bibitempair_token1] = aux_sym_bibitempair_token1,
  [anon_sym_EQ] = anon_sym_EQ,
  [aux_sym_bibitempair_token2] = aux_sym_bibitempair_token2,
  [anon_sym_COLONassume_COLON] = anon_sym_COLONassume_COLON,
  [anon_sym_COLONsuppose_COLON] = anon_sym_COLONsuppose_COLON,
  [anon_sym_COLONprove_COLON] = anon_sym_COLONprove_COLON,
  [anon_sym_COLONthen_COLON] = anon_sym_COLONthen_COLON,
  [anon_sym_COLONnew_COLON] = anon_sym_COLONnew_COLON,
  [anon_sym_COLONlet_COLON] = anon_sym_COLONlet_COLON,
  [anon_sym_COLONcase_COLON] = anon_sym_COLONcase_COLON,
  [anon_sym_COLONdefine_COLON] = anon_sym_COLONdefine_COLON,
  [anon_sym_COLONwrite_COLON] = anon_sym_COLONwrite_COLON,
  [anon_sym_COLONwlog_COLON] = anon_sym_COLONwlog_COLON,
  [anon_sym_COLONsuffices_COLON] = anon_sym_COLONsuffices_COLON,
  [anon_sym_COLONclaim_COLON] = anon_sym_COLONclaim_COLON,
  [anon_sym_COLON_PIPE_DASH_COLON] = anon_sym_COLONclaim_COLON,
  [anon_sym_COLON_COLON2] = anon_sym_COLONclaim_COLON,
  [anon_sym_COLONdraft_COLON] = anon_sym_COLONdraft_COLON,
  [anon_sym_COLONnote_COLON] = anon_sym_COLONnote_COLON,
  [anon_sym_COLONspan_COLON] = anon_sym_COLONspan_COLON,
  [anon_sym_COLONabstract_COLON] = anon_sym_COLONabstract_COLON,
  [anon_sym_COLONauthor_COLON] = anon_sym_COLONauthor_COLON,
  [anon_sym_COLONdefinition_COLON] = anon_sym_COLONdefinition_COLON,
  [anon_sym_COLONenumerate_COLON] = anon_sym_COLONenumerate_COLON,
  [anon_sym_COLONitemize_COLON] = anon_sym_COLONitemize_COLON,
  [anon_sym_COLONlemma_COLON] = anon_sym_COLONlemma_COLON,
  [anon_sym_COLONfigure_COLON] = anon_sym_COLONfigure_COLON,
  [anon_sym_COLONp_COLON] = anon_sym_COLONp_COLON,
  [anon_sym_COLONproof_COLON] = anon_sym_COLONproof_COLON,
  [anon_sym_COLONproposition_COLON] = anon_sym_COLONproposition_COLON,
  [anon_sym_COLONremark_COLON] = anon_sym_COLONremark_COLON,
  [anon_sym_COLONsection_COLON] = aux_sym_specialblock_token1,
  [anon_sym_COLONsketch_COLON] = anon_sym_COLONsketch_COLON,
  [anon_sym_COLONsubsection_COLON] = aux_sym_specialblock_token2,
  [anon_sym_COLONsubsubsection_COLON] = aux_sym_specialblock_token3,
  [anon_sym_COLONsubsubsubsection_COLON] = anon_sym_COLONsubsubsubsection_COLON,
  [anon_sym_COLONstep_COLON] = anon_sym_COLONstep_COLON,
  [anon_sym_COLONtheorem_COLON] = anon_sym_COLONtheorem_COLON,
  [anon_sym_COLONaffiliation_COLON] = anon_sym_COLONaffiliation_COLON,
  [anon_sym_COLONemail_COLON] = anon_sym_COLONemail_COLON,
  [anon_sym_COLONlabel_COLON] = aux_sym_bibitem_token2,
  [anon_sym_COLONname_COLON] = anon_sym_COLONname_COLON,
  [anon_sym_COLONreftext_COLON] = anon_sym_COLONreftext_COLON,
  [anon_sym_COLONtitle_COLON] = anon_sym_COLONtitle_COLON,
  [anon_sym_COLONgoal_COLON] = anon_sym_COLONgoal_COLON,
  [anon_sym_COLONnonum_COLON] = anon_sym_COLONnonum_COLON,
  [anon_sym_COLONstrong_COLON] = anon_sym_COLONstrong_COLON,
  [anon_sym_COLONemphas_COLON] = anon_sym_COLONemphas_COLON,
  [anon_sym_COLONisclaim_COLON] = anon_sym_COLONisclaim_COLON,
  [anon_sym_COLONkeywords_COLON] = anon_sym_COLONkeywords_COLON,
  [anon_sym_COLONMSC_COLON] = anon_sym_COLONMSC_COLON,
  [anon_sym_COLONtypes_COLON] = anon_sym_COLONtypes_COLON,
  [anon_sym_COLONdate_COLON] = anon_sym_COLONdate_COLON,
  [anon_sym_COLONpath_COLON] = anon_sym_COLONpath_COLON,
  [anon_sym_COLONscale_COLON] = anon_sym_COLONscale_COLON,
  [sym_comment] = sym_comment,
  [sym_upto_brace_or_comma_text] = sym_upto_brace_or_comma_text,
  [sym_asis_dollar_text] = sym_asis_dollar_text,
  [sym_asis_two_dollars_text] = sym_asis_dollar_text,
  [sym_asis_backtick_text] = sym_asis_dollar_text,
  [sym_asis_three_backticks_text] = sym_asis_dollar_text,
  [sym_asis_halmos_text] = sym_asis_dollar_text,
  [sym_text] = sym_text,
  [sym_paragraph_end] = sym_paragraph_end,
  [sym_source_file] = sym_source_file,
  [sym_block] = sym_block,
  [sym_paragraph] = sym_paragraph,
  [sym_inline] = sym_inline,
  [sym_construct] = sym_construct,
  [sym_specialblock] = sym_specialblock,
  [sym_caption] = sym_caption,
  [sym_item] = sym_item,
  [sym_specialinline] = sym_specialinline,
  [sym_specialconstruct] = sym_specialconstruct,
  [sym_inlinemeta] = sym_inlinemeta,
  [sym_blockmeta] = sym_blockmeta,
  [sym_inlinemetapair] = sym_inlinemetapair,
  [sym_pair] = sym_inlinemetapair,
  [sym_metaval_any] = sym_metaval_any,
  [sym_metaval_any_inline] = sym_metaval_any,
  [sym_metaval_text] = sym_metaval_text,
  [sym_metaval_text_inline] = sym_metaval_text,
  [sym_metaval_list] = sym_metaval_list,
  [sym_metaval_list_inline] = sym_metaval_list,
  [sym_table] = sym_table,
  [sym_thead] = sym_thead,
  [sym_tbody] = sym_tbody,
  [sym_tr] = sym_tr,
  [sym_trshort] = sym_trshort,
  [sym_td] = sym_td,
  [sym_tdcontent] = sym_tdcontent,
  [sym_bibtex] = sym_bibtex,
  [sym_bibitem] = sym_bibitem,
  [sym_bibitempair] = sym_bibitempair,
  [sym_metakey_text] = sym_metakey_text,
  [sym_metakey_bool] = sym_metakey_bool,
  [sym_metakey_list] = sym_metakey_list,
  [sym_metakey_any] = sym_metakey_any,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_paragraph_repeat1] = aux_sym_paragraph_repeat1,
  [aux_sym_inline_repeat1] = aux_sym_inline_repeat1,
  [aux_sym_inlinemeta_repeat1] = aux_sym_inlinemeta_repeat1,
  [aux_sym_blockmeta_repeat1] = aux_sym_blockmeta_repeat1,
  [aux_sym_metaval_list_repeat1] = aux_sym_metaval_list_repeat1,
  [aux_sym_thead_repeat1] = aux_sym_thead_repeat1,
  [aux_sym_tr_repeat1] = aux_sym_tr_repeat1,
  [aux_sym_trshort_repeat1] = aux_sym_trshort_repeat1,
  [aux_sym_bibtex_repeat1] = aux_sym_bibtex_repeat1,
  [aux_sym_bibitem_repeat1] = aux_sym_bibitem_repeat1,
  [anon_alias_sym_math] = anon_alias_sym_math,
  [anon_alias_sym_mathblock] = anon_alias_sym_mathblock,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_COLONmanuscript_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONparagraph_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONappendix_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONbibliography_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONtoc_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialblock_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialblock_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialblock_token3] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialblock_token4] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialblock_token5] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLONmathblock_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONcodeblock_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONalgorithm_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONcaption_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONitem_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONprev_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONprev2_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONprev3_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLONmath_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONcode_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token3] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_specialinline_token4] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONref_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token5] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONprevious_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token6] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONurl_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token7] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONcite_COLON] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_specialinline_token8] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONqed_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_metaval_any_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_metaval_any_inline_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONtable_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONthead_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONtbody_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONtr_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONtd_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLONbibtex_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_bibitem_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_bibitem_token2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_bibitempair_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_bibitempair_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONassume_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsuppose_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONprove_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONthen_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONnew_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONlet_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONcase_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONdefine_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONwrite_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONwlog_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsuffices_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONclaim_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_PIPE_DASH_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONdraft_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONnote_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONspan_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONabstract_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONauthor_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONdefinition_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONenumerate_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONitemize_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONlemma_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONfigure_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONp_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONproof_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONproposition_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONremark_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsection_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsketch_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsubsection_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsubsubsection_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONsubsubsubsection_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONstep_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONtheorem_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONaffiliation_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONemail_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONlabel_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONname_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONreftext_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONtitle_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONgoal_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONnonum_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONstrong_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONemphas_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONisclaim_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONkeywords_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONMSC_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONtypes_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONdate_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONpath_COLON] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONscale_COLON] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_upto_brace_or_comma_text] = {
    .visible = true,
    .named = true,
  },
  [sym_asis_dollar_text] = {
    .visible = true,
    .named = true,
  },
  [sym_asis_two_dollars_text] = {
    .visible = true,
    .named = true,
  },
  [sym_asis_backtick_text] = {
    .visible = true,
    .named = true,
  },
  [sym_asis_three_backticks_text] = {
    .visible = true,
    .named = true,
  },
  [sym_asis_halmos_text] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_paragraph_end] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_construct] = {
    .visible = true,
    .named = true,
  },
  [sym_specialblock] = {
    .visible = true,
    .named = true,
  },
  [sym_caption] = {
    .visible = true,
    .named = true,
  },
  [sym_item] = {
    .visible = true,
    .named = true,
  },
  [sym_specialinline] = {
    .visible = true,
    .named = true,
  },
  [sym_specialconstruct] = {
    .visible = true,
    .named = true,
  },
  [sym_inlinemeta] = {
    .visible = true,
    .named = true,
  },
  [sym_blockmeta] = {
    .visible = true,
    .named = true,
  },
  [sym_inlinemetapair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_any] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_any_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_text] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_text_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_list] = {
    .visible = true,
    .named = true,
  },
  [sym_metaval_list_inline] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym_thead] = {
    .visible = true,
    .named = true,
  },
  [sym_tbody] = {
    .visible = true,
    .named = true,
  },
  [sym_tr] = {
    .visible = true,
    .named = true,
  },
  [sym_trshort] = {
    .visible = true,
    .named = true,
  },
  [sym_td] = {
    .visible = true,
    .named = true,
  },
  [sym_tdcontent] = {
    .visible = true,
    .named = true,
  },
  [sym_bibtex] = {
    .visible = true,
    .named = true,
  },
  [sym_bibitem] = {
    .visible = true,
    .named = true,
  },
  [sym_bibitempair] = {
    .visible = true,
    .named = true,
  },
  [sym_metakey_text] = {
    .visible = true,
    .named = true,
  },
  [sym_metakey_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_metakey_list] = {
    .visible = true,
    .named = true,
  },
  [sym_metakey_any] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_paragraph_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inlinemeta_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_blockmeta_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_metaval_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_thead_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trshort_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bibtex_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bibitem_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_math] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_mathblock] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_body = 1,
  field_caption = 2,
  field_head = 3,
  field_kind = 4,
  field_label = 5,
  field_meta = 6,
  field_reftext = 7,
  field_tag = 8,
  field_target = 9,
  field_targetlabels = 10,
  field_title = 11,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_caption] = "caption",
  [field_head] = "head",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_meta] = "meta",
  [field_reftext] = "reftext",
  [field_tag] = "tag",
  [field_target] = "target",
  [field_targetlabels] = "targetlabels",
  [field_title] = "title",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 0, .length = 1},
  [7] = {.index = 0, .length = 1},
  [8] = {.index = 0, .length = 1},
  [9] = {.index = 0, .length = 1},
  [10] = {.index = 5, .length = 2},
  [11] = {.index = 7, .length = 2},
  [12] = {.index = 9, .length = 2},
  [13] = {.index = 11, .length = 2},
  [14] = {.index = 13, .length = 2},
  [15] = {.index = 15, .length = 3},
  [16] = {.index = 1, .length = 2},
  [17] = {.index = 1, .length = 2},
  [18] = {.index = 18, .length = 1},
  [19] = {.index = 1, .length = 2},
  [20] = {.index = 1, .length = 2},
  [21] = {.index = 19, .length = 3},
  [22] = {.index = 22, .length = 3},
  [23] = {.index = 25, .length = 3},
  [24] = {.index = 28, .length = 3},
  [25] = {.index = 31, .length = 3},
  [26] = {.index = 34, .length = 3},
  [27] = {.index = 37, .length = 3},
  [28] = {.index = 40, .length = 3},
  [29] = {.index = 43, .length = 4},
  [30] = {.index = 47, .length = 4},
  [31] = {.index = 51, .length = 4},
  [32] = {.index = 55, .length = 4},
  [33] = {.index = 59, .length = 5},
  [34] = {.index = 64, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_tag, 0},
  [1] =
    {field_meta, 1},
    {field_tag, 0},
  [3] =
    {field_tag, 0},
    {field_title, 1},
  [5] =
    {field_tag, 0},
    {field_target, 1},
  [7] =
    {field_tag, 0},
    {field_targetlabels, 1},
  [9] =
    {field_caption, 1},
    {field_tag, 0},
  [11] =
    {field_head, 1},
    {field_tag, 0},
  [13] =
    {field_body, 1},
    {field_tag, 0},
  [15] =
    {field_meta, 2},
    {field_tag, 0},
    {field_title, 1},
  [18] =
    {field_meta, 1},
  [19] =
    {field_caption, 2},
    {field_meta, 1},
    {field_tag, 0},
  [22] =
    {field_head, 2},
    {field_meta, 1},
    {field_tag, 0},
  [25] =
    {field_body, 2},
    {field_meta, 1},
    {field_tag, 0},
  [28] =
    {field_caption, 2},
    {field_head, 1},
    {field_tag, 0},
  [31] =
    {field_body, 2},
    {field_head, 1},
    {field_tag, 0},
  [34] =
    {field_body, 1},
    {field_caption, 2},
    {field_tag, 0},
  [37] =
    {field_reftext, 3},
    {field_tag, 0},
    {field_target, 1},
  [40] =
    {field_reftext, 3},
    {field_tag, 0},
    {field_targetlabels, 1},
  [43] =
    {field_caption, 3},
    {field_head, 2},
    {field_meta, 1},
    {field_tag, 0},
  [47] =
    {field_body, 3},
    {field_head, 2},
    {field_meta, 1},
    {field_tag, 0},
  [51] =
    {field_body, 2},
    {field_caption, 3},
    {field_meta, 1},
    {field_tag, 0},
  [55] =
    {field_body, 2},
    {field_caption, 3},
    {field_head, 1},
    {field_tag, 0},
  [59] =
    {field_body, 3},
    {field_caption, 4},
    {field_head, 2},
    {field_meta, 1},
    {field_tag, 0},
  [64] =
    {field_kind, 1},
    {field_label, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [3] = {
    [0] = aux_sym_metaval_any_token1,
  },
  [4] = {
    [0] = sym_upto_brace_or_comma_text,
  },
  [6] = {
    [2] = anon_alias_sym_mathblock,
  },
  [7] = {
    [0] = anon_sym_COLONcodeblock_COLON,
  },
  [8] = {
    [2] = anon_alias_sym_math,
  },
  [9] = {
    [0] = anon_sym_COLONcode_COLON,
  },
  [16] = {
    [3] = anon_alias_sym_mathblock,
  },
  [17] = {
    [0] = anon_sym_COLONcodeblock_COLON,
  },
  [19] = {
    [3] = anon_alias_sym_math,
  },
  [20] = {
    [0] = anon_sym_COLONcode_COLON,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(461);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(482);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(488);
      if (lookahead == ',') ADVANCE(495);
      if (lookahead == '/') ADVANCE(490);
      if (lookahead == ':') ADVANCE(521);
      if (lookahead == '=') ADVANCE(532);
      if (lookahead == '@') ADVANCE(526);
      if (lookahead == '`') ADVANCE(484);
      if (lookahead == 'a') ADVANCE(371);
      if (lookahead == 'b') ADVANCE(346);
      if (lookahead == 'd') ADVANCE(340);
      if (lookahead == 'e') ADVANCE(169);
      if (lookahead == 'j') ADVANCE(335);
      if (lookahead == 'n') ADVANCE(436);
      if (lookahead == 'p') ADVANCE(437);
      if (lookahead == 's') ADVANCE(332);
      if (lookahead == 't') ADVANCE(251);
      if (lookahead == 'u') ADVANCE(372);
      if (lookahead == 'v') ADVANCE(334);
      if (lookahead == 'y') ADVANCE(182);
      if (lookahead == '{') ADVANCE(511);
      if (lookahead == '}') ADVANCE(512);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(497);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(1)
      if (lookahead == '%') ADVANCE(588);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(4);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(513);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(3);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(513);
      if (lookahead != 0) ADVANCE(3);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(514);
      if (lookahead == '%') ADVANCE(588);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(4);
      if (lookahead != 0) ADVANCE(2);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '%') ADVANCE(591);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(458);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(8);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 6:
      if (lookahead == '\n') ADVANCE(515);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(458);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(7);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '\n') ADVANCE(515);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '}') ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '\n') ADVANCE(516);
      if (lookahead == '%') ADVANCE(591);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(458);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(8);
      if (lookahead != 0) ADVANCE(6);
      END_STATE();
    case 9:
      if (lookahead == ' ') ADVANCE(468);
      if (lookahead == '#') ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == ' ') ADVANCE(469);
      if (lookahead == '#') ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == ' ') ADVANCE(470);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(481);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(488);
      if (lookahead == '/') ADVANCE(489);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == '`') ADVANCE(483);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '$') ADVANCE(481);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(487);
      if (lookahead == '/') ADVANCE(490);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == '`') ADVANCE(483);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '$') ADVANCE(481);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(487);
      if (lookahead == '/') ADVANCE(489);
      if (lookahead == ':') ADVANCE(27);
      if (lookahead == '`') ADVANCE(483);
      if (lookahead == '{') ADVANCE(511);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '$') ADVANCE(481);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(487);
      if (lookahead == '/') ADVANCE(489);
      if (lookahead == ':') ADVANCE(522);
      if (lookahead == '`') ADVANCE(483);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '$') ADVANCE(481);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(487);
      if (lookahead == '/') ADVANCE(489);
      if (lookahead == ':') ADVANCE(523);
      if (lookahead == '`') ADVANCE(483);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '%') ADVANCE(507);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(508);
      if (lookahead != 0 &&
          lookahead != ':') ADVANCE(509);
      END_STATE();
    case 18:
      if (lookahead == '%') ADVANCE(504);
      if (lookahead == 'h') ADVANCE(503);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 19:
      if (lookahead == '%') ADVANCE(492);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(493);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(494);
      END_STATE();
    case 20:
      if (lookahead == '%') ADVANCE(528);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(529);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(530);
      END_STATE();
    case 21:
      if (lookahead == '%') ADVANCE(533);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(534);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(535);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(32);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(459);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(23);
      END_STATE();
    case 25:
      if (lookahead == '2') ADVANCE(63);
      if (lookahead == '3') ADVANCE(64);
      if (lookahead == ':') ADVANCE(478);
      if (lookahead == 'i') ADVANCE(344);
      END_STATE();
    case 26:
      if (lookahead == ':') ADVANCE(463);
      if (lookahead == 'M') ADVANCE(109);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(136);
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'f') ADVANCE(250);
      if (lookahead == 'g') ADVANCE(342);
      if (lookahead == 'i') ADVANCE(390);
      if (lookahead == 'k') ADVANCE(172);
      if (lookahead == 'l') ADVANCE(117);
      if (lookahead == 'm') ADVANCE(113);
      if (lookahead == 'n') ADVANCE(115);
      if (lookahead == 'p') ADVANCE(28);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(174);
      if (lookahead == 's') ADVANCE(149);
      if (lookahead == 't') ADVANCE(127);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 27:
      if (lookahead == ':') ADVANCE(463);
      if (lookahead == 'a') ADVANCE(392);
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'd') ADVANCE(212);
      if (lookahead == 'l') ADVANCE(191);
      if (lookahead == 'm') ADVANCE(125);
      if (lookahead == 'n') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(377);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(362);
      if (lookahead == 't') ADVANCE(163);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 28:
      if (lookahead == ':') ADVANCE(560);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'r') ADVANCE(176);
      END_STATE();
    case 29:
      if (lookahead == ':') ADVANCE(549);
      END_STATE();
    case 30:
      if (lookahead == ':') ADVANCE(524);
      END_STATE();
    case 31:
      if (lookahead == ':') ADVANCE(520);
      END_STATE();
    case 32:
      if (lookahead == ':') ADVANCE(548);
      END_STATE();
    case 33:
      if (lookahead == ':') ADVANCE(583);
      END_STATE();
    case 34:
      if (lookahead == ':') ADVANCE(541);
      END_STATE();
    case 35:
      if (lookahead == ':') ADVANCE(540);
      END_STATE();
    case 36:
      if (lookahead == ':') ADVANCE(510);
      END_STATE();
    case 37:
      if (lookahead == ':') ADVANCE(491);
      END_STATE();
    case 38:
      if (lookahead == ':') ADVANCE(491);
      if (lookahead == 't') ADVANCE(184);
      END_STATE();
    case 39:
      if (lookahead == ':') ADVANCE(467);
      END_STATE();
    case 40:
      if (lookahead == ':') ADVANCE(498);
      END_STATE();
    case 41:
      if (lookahead == ':') ADVANCE(542);
      END_STATE();
    case 42:
      if (lookahead == ':') ADVANCE(506);
      END_STATE();
    case 43:
      if (lookahead == ':') ADVANCE(486);
      END_STATE();
    case 44:
      if (lookahead == ':') ADVANCE(486);
      if (lookahead == 'b') ADVANCE(290);
      END_STATE();
    case 45:
      if (lookahead == ':') ADVANCE(585);
      END_STATE();
    case 46:
      if (lookahead == ':') ADVANCE(577);
      END_STATE();
    case 47:
      if (lookahead == ':') ADVANCE(477);
      if (lookahead == 'i') ADVANCE(457);
      END_STATE();
    case 48:
      if (lookahead == ':') ADVANCE(485);
      END_STATE();
    case 49:
      if (lookahead == ':') ADVANCE(485);
      if (lookahead == 'b') ADVANCE(298);
      END_STATE();
    case 50:
      if (lookahead == ':') ADVANCE(574);
      END_STATE();
    case 51:
      if (lookahead == ':') ADVANCE(551);
      END_STATE();
    case 52:
      if (lookahead == ':') ADVANCE(586);
      END_STATE();
    case 53:
      if (lookahead == ':') ADVANCE(552);
      END_STATE();
    case 54:
      if (lookahead == ':') ADVANCE(569);
      END_STATE();
    case 55:
      if (lookahead == ':') ADVANCE(539);
      END_STATE();
    case 56:
      if (lookahead == ':') ADVANCE(545);
      END_STATE();
    case 57:
      if (lookahead == ':') ADVANCE(547);
      END_STATE();
    case 58:
      if (lookahead == ':') ADVANCE(550);
      END_STATE();
    case 59:
      if (lookahead == ':') ADVANCE(572);
      END_STATE();
    case 60:
      if (lookahead == ':') ADVANCE(573);
      END_STATE();
    case 61:
      if (lookahead == ':') ADVANCE(558);
      END_STATE();
    case 62:
      if (lookahead == ':') ADVANCE(578);
      END_STATE();
    case 63:
      if (lookahead == ':') ADVANCE(479);
      END_STATE();
    case 64:
      if (lookahead == ':') ADVANCE(480);
      END_STATE();
    case 65:
      if (lookahead == ':') ADVANCE(561);
      END_STATE();
    case 66:
      if (lookahead == ':') ADVANCE(538);
      END_STATE();
    case 67:
      if (lookahead == ':') ADVANCE(587);
      END_STATE();
    case 68:
      if (lookahead == ':') ADVANCE(517);
      END_STATE();
    case 69:
      if (lookahead == ':') ADVANCE(519);
      END_STATE();
    case 70:
      if (lookahead == ':') ADVANCE(518);
      END_STATE();
    case 71:
      if (lookahead == ':') ADVANCE(576);
      END_STATE();
    case 72:
      if (lookahead == ':') ADVANCE(584);
      END_STATE();
    case 73:
      if (lookahead == ':') ADVANCE(544);
      END_STATE();
    case 74:
      if (lookahead == ':') ADVANCE(536);
      END_STATE();
    case 75:
      if (lookahead == ':') ADVANCE(554);
      END_STATE();
    case 76:
      if (lookahead == ':') ADVANCE(525);
      END_STATE();
    case 77:
      if (lookahead == ':') ADVANCE(543);
      END_STATE();
    case 78:
      if (lookahead == ':') ADVANCE(580);
      END_STATE();
    case 79:
      if (lookahead == ':') ADVANCE(559);
      END_STATE();
    case 80:
      if (lookahead == ':') ADVANCE(563);
      END_STATE();
    case 81:
      if (lookahead == ':') ADVANCE(565);
      END_STATE();
    case 82:
      if (lookahead == ':') ADVANCE(579);
      END_STATE();
    case 83:
      if (lookahead == ':') ADVANCE(476);
      END_STATE();
    case 84:
      if (lookahead == ':') ADVANCE(581);
      END_STATE();
    case 85:
      if (lookahead == ':') ADVANCE(557);
      END_STATE();
    case 86:
      if (lookahead == ':') ADVANCE(575);
      END_STATE();
    case 87:
      if (lookahead == ':') ADVANCE(564);
      END_STATE();
    case 88:
      if (lookahead == ':') ADVANCE(537);
      END_STATE();
    case 89:
      if (lookahead == ':') ADVANCE(570);
      END_STATE();
    case 90:
      if (lookahead == ':') ADVANCE(553);
      END_STATE();
    case 91:
      if (lookahead == ':') ADVANCE(465);
      END_STATE();
    case 92:
      if (lookahead == ':') ADVANCE(582);
      END_STATE();
    case 93:
      if (lookahead == ':') ADVANCE(496);
      END_STATE();
    case 94:
      if (lookahead == ':') ADVANCE(546);
      END_STATE();
    case 95:
      if (lookahead == ':') ADVANCE(475);
      END_STATE();
    case 96:
      if (lookahead == ':') ADVANCE(474);
      END_STATE();
    case 97:
      if (lookahead == ':') ADVANCE(556);
      END_STATE();
    case 98:
      if (lookahead == ':') ADVANCE(473);
      END_STATE();
    case 99:
      if (lookahead == ':') ADVANCE(464);
      END_STATE();
    case 100:
      if (lookahead == ':') ADVANCE(555);
      END_STATE();
    case 101:
      if (lookahead == ':') ADVANCE(462);
      END_STATE();
    case 102:
      if (lookahead == ':') ADVANCE(566);
      END_STATE();
    case 103:
      if (lookahead == ':') ADVANCE(571);
      END_STATE();
    case 104:
      if (lookahead == ':') ADVANCE(562);
      END_STATE();
    case 105:
      if (lookahead == ':') ADVANCE(466);
      END_STATE();
    case 106:
      if (lookahead == ':') ADVANCE(567);
      END_STATE();
    case 107:
      if (lookahead == ':') ADVANCE(568);
      END_STATE();
    case 108:
      if (lookahead == 'C') ADVANCE(33);
      END_STATE();
    case 109:
      if (lookahead == 'S') ADVANCE(108);
      END_STATE();
    case 110:
      if (lookahead == '`') ADVANCE(472);
      END_STATE();
    case 111:
      if (lookahead == 'a') ADVANCE(282);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(368);
      if (lookahead == 'i') ADVANCE(421);
      if (lookahead == 'l') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(166);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(316);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 115:
      if (lookahead == 'a') ADVANCE(312);
      if (lookahead == 'e') ADVANCE(448);
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(373);
      END_STATE();
    case 117:
      if (lookahead == 'a') ADVANCE(144);
      if (lookahead == 'e') ADVANCE(302);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 119:
      if (lookahead == 'a') ADVANCE(369);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(253);
      END_STATE();
    case 121:
      if (lookahead == 'a') ADVANCE(374);
      END_STATE();
    case 122:
      if (lookahead == 'a') ADVANCE(158);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(267);
      if (lookahead == 'p') ADVANCE(237);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(392);
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'd') ADVANCE(212);
      if (lookahead == 'l') ADVANCE(191);
      if (lookahead == 'm') ADVANCE(125);
      if (lookahead == 'n') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(377);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(362);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 125:
      if (lookahead == 'a') ADVANCE(424);
      END_STATE();
    case 126:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(148);
      if (lookahead == 'b') ADVANCE(339);
      if (lookahead == 'd') ADVANCE(30);
      if (lookahead == 'h') ADVANCE(178);
      if (lookahead == 'i') ADVANCE(429);
      if (lookahead == 'o') ADVANCE(151);
      if (lookahead == 'r') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(365);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(224);
      END_STATE();
    case 129:
      if (lookahead == 'a') ADVANCE(168);
      if (lookahead == 'n') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(384);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(288);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(363);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(294);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(399);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(268);
      END_STATE();
    case 135:
      if (lookahead == 'a') ADVANCE(385);
      END_STATE();
    case 136:
      if (lookahead == 'a') ADVANCE(422);
      if (lookahead == 'e') ADVANCE(223);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 137:
      if (lookahead == 'a') ADVANCE(396);
      if (lookahead == 'i') ADVANCE(421);
      if (lookahead == 'l') ADVANCE(120);
      if (lookahead == 'o') ADVANCE(171);
      END_STATE();
    case 138:
      if (lookahead == 'a') ADVANCE(427);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(432);
      END_STATE();
    case 140:
      if (lookahead == 'b') ADVANCE(395);
      if (lookahead == 'f') ADVANCE(222);
      if (lookahead == 'l') ADVANCE(231);
      if (lookahead == 'p') ADVANCE(364);
      if (lookahead == 's') ADVANCE(404);
      if (lookahead == 'u') ADVANCE(420);
      END_STATE();
    case 141:
      if (lookahead == 'b') ADVANCE(293);
      END_STATE();
    case 142:
      if (lookahead == 'b') ADVANCE(391);
      if (lookahead == 'f') ADVANCE(225);
      if (lookahead == 'p') ADVANCE(366);
      END_STATE();
    case 143:
      if (lookahead == 'b') ADVANCE(285);
      END_STATE();
    case 144:
      if (lookahead == 'b') ADVANCE(213);
      END_STATE();
    case 145:
      if (lookahead == 'b') ADVANCE(186);
      END_STATE();
    case 146:
      if (lookahead == 'b') ADVANCE(403);
      END_STATE();
    case 147:
      if (lookahead == 'b') ADVANCE(397);
      END_STATE();
    case 148:
      if (lookahead == 'b') ADVANCE(295);
      END_STATE();
    case 149:
      if (lookahead == 'c') ADVANCE(132);
      if (lookahead == 'e') ADVANCE(159);
      if (lookahead == 'k') ADVANCE(190);
      if (lookahead == 'p') ADVANCE(114);
      if (lookahead == 't') ADVANCE(183);
      if (lookahead == 'u') ADVANCE(142);
      END_STATE();
    case 150:
      if (lookahead == 'c') ADVANCE(297);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(39);
      END_STATE();
    case 152:
      if (lookahead == 'c') ADVANCE(382);
      END_STATE();
    case 153:
      if (lookahead == 'c') ADVANCE(280);
      END_STATE();
    case 154:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(215);
      END_STATE();
    case 156:
      if (lookahead == 'c') ADVANCE(281);
      END_STATE();
    case 157:
      if (lookahead == 'c') ADVANCE(289);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(418);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(428);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(431);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(434);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(435);
      END_STATE();
    case 163:
      if (lookahead == 'd') ADVANCE(30);
      if (lookahead == 'h') ADVANCE(216);
      END_STATE();
    case 164:
      if (lookahead == 'd') ADVANCE(455);
      END_STATE();
    case 165:
      if (lookahead == 'd') ADVANCE(36);
      END_STATE();
    case 166:
      if (lookahead == 'd') ADVANCE(180);
      END_STATE();
    case 167:
      if (lookahead == 'd') ADVANCE(265);
      END_STATE();
    case 168:
      if (lookahead == 'd') ADVANCE(70);
      END_STATE();
    case 169:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 170:
      if (lookahead == 'd') ADVANCE(400);
      END_STATE();
    case 171:
      if (lookahead == 'd') ADVANCE(209);
      END_STATE();
    case 172:
      if (lookahead == 'e') ADVANCE(454);
      END_STATE();
    case 173:
      if (lookahead == 'e') ADVANCE(448);
      if (lookahead == 'o') ADVANCE(425);
      END_STATE();
    case 174:
      if (lookahead == 'e') ADVANCE(220);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(531);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(446);
      if (lookahead == 'o') ADVANCE(337);
      END_STATE();
    case 177:
      if (lookahead == 'e') ADVANCE(446);
      if (lookahead == 'o') ADVANCE(447);
      END_STATE();
    case 178:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 179:
      if (lookahead == 'e') ADVANCE(527);
      END_STATE();
    case 180:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 181:
      if (lookahead == 'e') ADVANCE(451);
      END_STATE();
    case 182:
      if (lookahead == 'e') ADVANCE(116);
      END_STATE();
    case 183:
      if (lookahead == 'e') ADVANCE(367);
      if (lookahead == 'r') ADVANCE(343);
      END_STATE();
    case 184:
      if (lookahead == 'e') ADVANCE(453);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(301);
      END_STATE();
    case 188:
      if (lookahead == 'e') ADVANCE(328);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(398);
      END_STATE();
    case 190:
      if (lookahead == 'e') ADVANCE(410);
      END_STATE();
    case 191:
      if (lookahead == 'e') ADVANCE(413);
      END_STATE();
    case 192:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 194:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 196:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 197:
      if (lookahead == 'e') ADVANCE(66);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 199:
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 200:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 201:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 202:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 203:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(77);
      if (lookahead == 'i') ADVANCE(430);
      END_STATE();
    case 205:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 206:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(88);
      END_STATE();
    case 208:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(228);
      END_STATE();
    case 211:
      if (lookahead == 'e') ADVANCE(381);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(226);
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 213:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 214:
      if (lookahead == 'e') ADVANCE(309);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(402);
      END_STATE();
    case 216:
      if (lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(160);
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(161);
      if (lookahead == 'u') ADVANCE(147);
      END_STATE();
    case 219:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 220:
      if (lookahead == 'f') ADVANCE(38);
      if (lookahead == 'm') ADVANCE(121);
      END_STATE();
    case 221:
      if (lookahead == 'f') ADVANCE(408);
      END_STATE();
    case 222:
      if (lookahead == 'f') ADVANCE(266);
      END_STATE();
    case 223:
      if (lookahead == 'f') ADVANCE(252);
      END_STATE();
    case 224:
      if (lookahead == 'f') ADVANCE(416);
      END_STATE();
    case 225:
      if (lookahead == 'f') ADVANCE(256);
      END_STATE();
    case 226:
      if (lookahead == 'f') ADVANCE(257);
      END_STATE();
    case 227:
      if (lookahead == 'f') ADVANCE(65);
      END_STATE();
    case 228:
      if (lookahead == 'f') ADVANCE(37);
      END_STATE();
    case 229:
      if (lookahead == 'f') ADVANCE(225);
      if (lookahead == 'p') ADVANCE(366);
      END_STATE();
    case 230:
      if (lookahead == 'g') ADVANCE(440);
      END_STATE();
    case 231:
      if (lookahead == 'g') ADVANCE(341);
      END_STATE();
    case 232:
      if (lookahead == 'g') ADVANCE(56);
      END_STATE();
    case 233:
      if (lookahead == 'g') ADVANCE(82);
      END_STATE();
    case 234:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 235:
      if (lookahead == 'g') ADVANCE(387);
      END_STATE();
    case 236:
      if (lookahead == 'h') ADVANCE(49);
      END_STATE();
    case 237:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 238:
      if (lookahead == 'h') ADVANCE(336);
      END_STATE();
    case 239:
      if (lookahead == 'h') ADVANCE(348);
      END_STATE();
    case 240:
      if (lookahead == 'h') ADVANCE(186);
      END_STATE();
    case 241:
      if (lookahead == 'h') ADVANCE(52);
      END_STATE();
    case 242:
      if (lookahead == 'h') ADVANCE(216);
      END_STATE();
    case 243:
      if (lookahead == 'h') ADVANCE(81);
      END_STATE();
    case 244:
      if (lookahead == 'h') ADVANCE(99);
      END_STATE();
    case 245:
      if (lookahead == 'h') ADVANCE(48);
      END_STATE();
    case 246:
      if (lookahead == 'h') ADVANCE(456);
      END_STATE();
    case 247:
      if (lookahead == 'h') ADVANCE(310);
      END_STATE();
    case 248:
      if (lookahead == 'i') ADVANCE(531);
      END_STATE();
    case 249:
      if (lookahead == 'i') ADVANCE(141);
      END_STATE();
    case 250:
      if (lookahead == 'i') ADVANCE(230);
      END_STATE();
    case 251:
      if (lookahead == 'i') ADVANCE(412);
      END_STATE();
    case 252:
      if (lookahead == 'i') ADVANCE(315);
      END_STATE();
    case 253:
      if (lookahead == 'i') ADVANCE(306);
      END_STATE();
    case 254:
      if (lookahead == 'i') ADVANCE(370);
      END_STATE();
    case 255:
      if (lookahead == 'i') ADVANCE(394);
      END_STATE();
    case 256:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(331);
      END_STATE();
    case 258:
      if (lookahead == 'i') ADVANCE(414);
      END_STATE();
    case 259:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 260:
      if (lookahead == 'i') ADVANCE(345);
      END_STATE();
    case 261:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 262:
      if (lookahead == 'i') ADVANCE(352);
      END_STATE();
    case 263:
      if (lookahead == 'i') ADVANCE(415);
      END_STATE();
    case 264:
      if (lookahead == 'i') ADVANCE(157);
      END_STATE();
    case 265:
      if (lookahead == 'i') ADVANCE(452);
      END_STATE();
    case 266:
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 267:
      if (lookahead == 'i') ADVANCE(291);
      END_STATE();
    case 268:
      if (lookahead == 'i') ADVANCE(308);
      END_STATE();
    case 269:
      if (lookahead == 'i') ADVANCE(353);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(426);
      END_STATE();
    case 271:
      if (lookahead == 'i') ADVANCE(354);
      END_STATE();
    case 272:
      if (lookahead == 'i') ADVANCE(355);
      END_STATE();
    case 273:
      if (lookahead == 'i') ADVANCE(356);
      END_STATE();
    case 274:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 275:
      if (lookahead == 'i') ADVANCE(358);
      END_STATE();
    case 276:
      if (lookahead == 'i') ADVANCE(359);
      END_STATE();
    case 277:
      if (lookahead == 'i') ADVANCE(433);
      END_STATE();
    case 278:
      if (lookahead == 'k') ADVANCE(527);
      END_STATE();
    case 279:
      if (lookahead == 'k') ADVANCE(80);
      END_STATE();
    case 280:
      if (lookahead == 'k') ADVANCE(96);
      END_STATE();
    case 281:
      if (lookahead == 'k') ADVANCE(98);
      END_STATE();
    case 282:
      if (lookahead == 'l') ADVANCE(531);
      END_STATE();
    case 283:
      if (lookahead == 'l') ADVANCE(338);
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 284:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 285:
      if (lookahead == 'l') ADVANCE(255);
      END_STATE();
    case 286:
      if (lookahead == 'l') ADVANCE(259);
      END_STATE();
    case 287:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 288:
      if (lookahead == 'l') ADVANCE(46);
      END_STATE();
    case 289:
      if (lookahead == 'l') ADVANCE(179);
      END_STATE();
    case 290:
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 291:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 292:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 293:
      if (lookahead == 'l') ADVANCE(261);
      if (lookahead == 't') ADVANCE(181);
      END_STATE();
    case 294:
      if (lookahead == 'l') ADVANCE(198);
      END_STATE();
    case 295:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 296:
      if (lookahead == 'l') ADVANCE(200);
      END_STATE();
    case 297:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(361);
      END_STATE();
    case 299:
      if (lookahead == 'l') ADVANCE(443);
      END_STATE();
    case 300:
      if (lookahead == 'm') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(441);
      END_STATE();
    case 301:
      if (lookahead == 'm') ADVANCE(47);
      END_STATE();
    case 302:
      if (lookahead == 'm') ADVANCE(303);
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 303:
      if (lookahead == 'm') ADVANCE(126);
      END_STATE();
    case 304:
      if (lookahead == 'm') ADVANCE(175);
      END_STATE();
    case 305:
      if (lookahead == 'm') ADVANCE(211);
      END_STATE();
    case 306:
      if (lookahead == 'm') ADVANCE(57);
      END_STATE();
    case 307:
      if (lookahead == 'm') ADVANCE(62);
      END_STATE();
    case 308:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 309:
      if (lookahead == 'm') ADVANCE(89);
      END_STATE();
    case 310:
      if (lookahead == 'm') ADVANCE(95);
      END_STATE();
    case 311:
      if (lookahead == 'm') ADVANCE(145);
      END_STATE();
    case 312:
      if (lookahead == 'm') ADVANCE(195);
      END_STATE();
    case 313:
      if (lookahead == 'm') ADVANCE(202);
      END_STATE();
    case 314:
      if (lookahead == 'n') ADVANCE(531);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 316:
      if (lookahead == 'n') ADVANCE(439);
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 317:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 318:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 319:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 320:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 321:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 322:
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 323:
      if (lookahead == 'n') ADVANCE(102);
      END_STATE();
    case 324:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 325:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 326:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 327:
      if (lookahead == 'n') ADVANCE(107);
      END_STATE();
    case 328:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 329:
      if (lookahead == 'n') ADVANCE(233);
      END_STATE();
    case 330:
      if (lookahead == 'n') ADVANCE(442);
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 331:
      if (lookahead == 'n') ADVANCE(203);
      END_STATE();
    case 332:
      if (lookahead == 'o') ADVANCE(221);
      END_STATE();
    case 333:
      if (lookahead == 'o') ADVANCE(278);
      END_STATE();
    case 334:
      if (lookahead == 'o') ADVANCE(299);
      END_STATE();
    case 335:
      if (lookahead == 'o') ADVANCE(438);
      END_STATE();
    case 336:
      if (lookahead == 'o') ADVANCE(373);
      END_STATE();
    case 337:
      if (lookahead == 'o') ADVANCE(227);
      if (lookahead == 'p') ADVANCE(347);
      if (lookahead == 'v') ADVANCE(197);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(232);
      END_STATE();
    case 339:
      if (lookahead == 'o') ADVANCE(164);
      END_STATE();
    case 340:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 341:
      if (lookahead == 'o') ADVANCE(388);
      END_STATE();
    case 342:
      if (lookahead == 'o') ADVANCE(130);
      END_STATE();
    case 343:
      if (lookahead == 'o') ADVANCE(329);
      END_STATE();
    case 344:
      if (lookahead == 'o') ADVANCE(444);
      END_STATE();
    case 345:
      if (lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 346:
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 347:
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 348:
      if (lookahead == 'o') ADVANCE(386);
      END_STATE();
    case 349:
      if (lookahead == 'o') ADVANCE(405);
      END_STATE();
    case 350:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 351:
      if (lookahead == 'o') ADVANCE(378);
      END_STATE();
    case 352:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 353:
      if (lookahead == 'o') ADVANCE(321);
      END_STATE();
    case 354:
      if (lookahead == 'o') ADVANCE(322);
      END_STATE();
    case 355:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 356:
      if (lookahead == 'o') ADVANCE(324);
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(325);
      END_STATE();
    case 358:
      if (lookahead == 'o') ADVANCE(326);
      END_STATE();
    case 359:
      if (lookahead == 'o') ADVANCE(327);
      END_STATE();
    case 360:
      if (lookahead == 'o') ADVANCE(235);
      END_STATE();
    case 361:
      if (lookahead == 'o') ADVANCE(156);
      END_STATE();
    case 362:
      if (lookahead == 'p') ADVANCE(114);
      if (lookahead == 'u') ADVANCE(229);
      END_STATE();
    case 363:
      if (lookahead == 'p') ADVANCE(246);
      END_STATE();
    case 364:
      if (lookahead == 'p') ADVANCE(188);
      END_STATE();
    case 365:
      if (lookahead == 'p') ADVANCE(189);
      END_STATE();
    case 366:
      if (lookahead == 'p') ADVANCE(349);
      END_STATE();
    case 367:
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 368:
      if (lookahead == 'p') ADVANCE(423);
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 369:
      if (lookahead == 'p') ADVANCE(244);
      END_STATE();
    case 370:
      if (lookahead == 'p') ADVANCE(419);
      END_STATE();
    case 371:
      if (lookahead == 'r') ADVANCE(411);
      if (lookahead == 'u') ADVANCE(407);
      END_STATE();
    case 372:
      if (lookahead == 'r') ADVANCE(282);
      END_STATE();
    case 373:
      if (lookahead == 'r') ADVANCE(531);
      END_STATE();
    case 374:
      if (lookahead == 'r') ADVANCE(279);
      END_STATE();
    case 375:
      if (lookahead == 'r') ADVANCE(317);
      END_STATE();
    case 376:
      if (lookahead == 'r') ADVANCE(284);
      END_STATE();
    case 377:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 378:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 379:
      if (lookahead == 'r') ADVANCE(118);
      if (lookahead == 't') ADVANCE(241);
      END_STATE();
    case 380:
      if (lookahead == 'r') ADVANCE(122);
      END_STATE();
    case 381:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 382:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 383:
      if (lookahead == 'r') ADVANCE(119);
      END_STATE();
    case 384:
      if (lookahead == 'r') ADVANCE(214);
      END_STATE();
    case 385:
      if (lookahead == 'r') ADVANCE(179);
      END_STATE();
    case 386:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 387:
      if (lookahead == 'r') ADVANCE(131);
      END_STATE();
    case 388:
      if (lookahead == 'r') ADVANCE(258);
      END_STATE();
    case 389:
      if (lookahead == 'r') ADVANCE(205);
      END_STATE();
    case 390:
      if (lookahead == 's') ADVANCE(150);
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 391:
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 392:
      if (lookahead == 's') ADVANCE(404);
      END_STATE();
    case 393:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 394:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 395:
      if (lookahead == 's') ADVANCE(409);
      END_STATE();
    case 396:
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 397:
      if (lookahead == 's') ADVANCE(219);
      END_STATE();
    case 398:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 399:
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 400:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 401:
      if (lookahead == 's') ADVANCE(93);
      END_STATE();
    case 402:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 403:
      if (lookahead == 's') ADVANCE(218);
      END_STATE();
    case 404:
      if (lookahead == 's') ADVANCE(445);
      END_STATE();
    case 405:
      if (lookahead == 's') ADVANCE(207);
      END_STATE();
    case 406:
      if (lookahead == 's') ADVANCE(277);
      END_STATE();
    case 407:
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 408:
      if (lookahead == 't') ADVANCE(450);
      END_STATE();
    case 409:
      if (lookahead == 't') ADVANCE(380);
      END_STATE();
    case 410:
      if (lookahead == 't') ADVANCE(154);
      END_STATE();
    case 411:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 412:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 413:
      if (lookahead == 't') ADVANCE(34);
      END_STATE();
    case 414:
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 415:
      if (lookahead == 't') ADVANCE(260);
      END_STATE();
    case 416:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 417:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 418:
      if (lookahead == 't') ADVANCE(90);
      END_STATE();
    case 419:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 420:
      if (lookahead == 't') ADVANCE(239);
      END_STATE();
    case 421:
      if (lookahead == 't') ADVANCE(193);
      END_STATE();
    case 422:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 423:
      if (lookahead == 't') ADVANCE(262);
      END_STATE();
    case 424:
      if (lookahead == 't') ADVANCE(245);
      END_STATE();
    case 425:
      if (lookahead == 't') ADVANCE(196);
      END_STATE();
    case 426:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 427:
      if (lookahead == 't') ADVANCE(208);
      END_STATE();
    case 428:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 429:
      if (lookahead == 't') ADVANCE(296);
      END_STATE();
    case 430:
      if (lookahead == 't') ADVANCE(271);
      END_STATE();
    case 431:
      if (lookahead == 't') ADVANCE(272);
      END_STATE();
    case 432:
      if (lookahead == 't') ADVANCE(273);
      END_STATE();
    case 433:
      if (lookahead == 't') ADVANCE(274);
      END_STATE();
    case 434:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 435:
      if (lookahead == 't') ADVANCE(276);
      END_STATE();
    case 436:
      if (lookahead == 'u') ADVANCE(311);
      END_STATE();
    case 437:
      if (lookahead == 'u') ADVANCE(143);
      END_STATE();
    case 438:
      if (lookahead == 'u') ADVANCE(375);
      END_STATE();
    case 439:
      if (lookahead == 'u') ADVANCE(393);
      END_STATE();
    case 440:
      if (lookahead == 'u') ADVANCE(389);
      END_STATE();
    case 441:
      if (lookahead == 'u') ADVANCE(305);
      END_STATE();
    case 442:
      if (lookahead == 'u') ADVANCE(307);
      END_STATE();
    case 443:
      if (lookahead == 'u') ADVANCE(304);
      END_STATE();
    case 444:
      if (lookahead == 'u') ADVANCE(401);
      END_STATE();
    case 445:
      if (lookahead == 'u') ADVANCE(313);
      END_STATE();
    case 446:
      if (lookahead == 'v') ADVANCE(25);
      END_STATE();
    case 447:
      if (lookahead == 'v') ADVANCE(197);
      END_STATE();
    case 448:
      if (lookahead == 'w') ADVANCE(35);
      END_STATE();
    case 449:
      if (lookahead == 'w') ADVANCE(351);
      END_STATE();
    case 450:
      if (lookahead == 'w') ADVANCE(135);
      END_STATE();
    case 451:
      if (lookahead == 'x') ADVANCE(76);
      END_STATE();
    case 452:
      if (lookahead == 'x') ADVANCE(91);
      END_STATE();
    case 453:
      if (lookahead == 'x') ADVANCE(417);
      END_STATE();
    case 454:
      if (lookahead == 'y') ADVANCE(449);
      END_STATE();
    case 455:
      if (lookahead == 'y') ADVANCE(69);
      END_STATE();
    case 456:
      if (lookahead == 'y') ADVANCE(105);
      END_STATE();
    case 457:
      if (lookahead == 'z') ADVANCE(206);
      END_STATE();
    case 458:
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(458);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(7);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 459:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 460:
      if (eof) ADVANCE(461);
      if (lookahead == '#') ADVANCE(9);
      if (lookahead == '$') ADVANCE(482);
      if (lookahead == '%') ADVANCE(593);
      if (lookahead == '*') ADVANCE(487);
      if (lookahead == ',') ADVANCE(495);
      if (lookahead == '/') ADVANCE(489);
      if (lookahead == ':') ADVANCE(26);
      if (lookahead == '`') ADVANCE(484);
      if (lookahead == '}') ADVANCE(512);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(460)
      END_STATE();
    case 461:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_COLONmanuscript_COLON);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_COLONparagraph_COLON);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_COLONappendix_COLON);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_COLONbibliography_COLON);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_COLONtoc_COLON);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(aux_sym_specialblock_token1);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(aux_sym_specialblock_token2);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(aux_sym_specialblock_token3);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(aux_sym_specialblock_token4);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(aux_sym_specialblock_token5);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_COLONmathblock_COLON);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_COLONcodeblock_COLON);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_COLONalgorithm_COLON);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_COLONcaption_COLON);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_COLONitem_COLON);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_COLONprev_COLON);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_COLONprev2_COLON);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_COLONprev3_COLON);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(aux_sym_specialinline_token1);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(aux_sym_specialinline_token1);
      if (lookahead == '$') ADVANCE(471);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(aux_sym_specialinline_token2);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(aux_sym_specialinline_token2);
      if (lookahead == '`') ADVANCE(110);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_COLONmath_COLON);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_COLONcode_COLON);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(aux_sym_specialinline_token3);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(aux_sym_specialinline_token4);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_COLONref_COLON);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(aux_sym_specialinline_token5);
      if (lookahead == '\n') ADVANCE(494);
      if (lookahead == ',' ||
          lookahead == ':') ADVANCE(593);
      if (lookahead != 0) ADVANCE(492);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(aux_sym_specialinline_token5);
      if (lookahead == '%') ADVANCE(492);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(493);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(494);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(aux_sym_specialinline_token5);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(494);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(anon_sym_COLONprevious_COLON);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(aux_sym_specialinline_token6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(497);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_COLONurl_COLON);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead == 's') ADVANCE(500);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(505);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == ':') ADVANCE(24);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',') ADVANCE(505);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == 'p') ADVANCE(499);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == 't') ADVANCE(501);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == 't') ADVANCE(502);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == ',' ||
          lookahead == ':') ADVANCE(593);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(504);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(aux_sym_specialinline_token7);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != ':') ADVANCE(505);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_COLONcite_COLON);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(aux_sym_specialinline_token8);
      if (lookahead == '\n') ADVANCE(509);
      if (lookahead == ':') ADVANCE(593);
      if (lookahead != 0) ADVANCE(507);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(aux_sym_specialinline_token8);
      if (lookahead == '%') ADVANCE(507);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(508);
      if (lookahead != 0 &&
          lookahead != ':') ADVANCE(509);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(aux_sym_specialinline_token8);
      if (lookahead != 0 &&
          lookahead != ':') ADVANCE(509);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_COLONqed_COLON);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(aux_sym_metaval_any_token1);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(aux_sym_metaval_any_token1);
      if (lookahead == '%') ADVANCE(588);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(4);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(2);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(aux_sym_metaval_any_inline_token1);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(aux_sym_metaval_any_inline_token1);
      if (lookahead == '%') ADVANCE(591);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(458);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(8);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(6);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_COLONtable_COLON);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_COLONthead_COLON);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_COLONtbody_COLON);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_COLONtr_COLON);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(463);
      if (lookahead == 'M') ADVANCE(109);
      if (lookahead == 'a') ADVANCE(140);
      if (lookahead == 'b') ADVANCE(249);
      if (lookahead == 'c') ADVANCE(112);
      if (lookahead == 'd') ADVANCE(136);
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'f') ADVANCE(250);
      if (lookahead == 'g') ADVANCE(342);
      if (lookahead == 'i') ADVANCE(390);
      if (lookahead == 'k') ADVANCE(172);
      if (lookahead == 'l') ADVANCE(117);
      if (lookahead == 'm') ADVANCE(113);
      if (lookahead == 'n') ADVANCE(115);
      if (lookahead == 'p') ADVANCE(28);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(174);
      if (lookahead == 's') ADVANCE(149);
      if (lookahead == 't') ADVANCE(127);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(463);
      if (lookahead == 'a') ADVANCE(392);
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'd') ADVANCE(212);
      if (lookahead == 'l') ADVANCE(191);
      if (lookahead == 'm') ADVANCE(125);
      if (lookahead == 'n') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(377);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(362);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == 'a') ADVANCE(392);
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == 'd') ADVANCE(212);
      if (lookahead == 'l') ADVANCE(191);
      if (lookahead == 'm') ADVANCE(125);
      if (lookahead == 'n') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(377);
      if (lookahead == 'q') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(210);
      if (lookahead == 's') ADVANCE(362);
      if (lookahead == 't') ADVANCE(242);
      if (lookahead == 'u') ADVANCE(376);
      if (lookahead == 'w') ADVANCE(283);
      if (lookahead == '|') ADVANCE(22);
      if (lookahead == 8866) ADVANCE(29);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_COLONtd_COLON);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_COLONbibtex_COLON);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(aux_sym_bibitem_token1);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(aux_sym_bibitem_token2);
      if (lookahead == '\n') ADVANCE(530);
      if (lookahead == ',') ADVANCE(593);
      if (lookahead != 0) ADVANCE(528);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(aux_sym_bibitem_token2);
      if (lookahead == '%') ADVANCE(528);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(529);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(530);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(aux_sym_bibitem_token2);
      if (lookahead != 0 &&
          lookahead != ',') ADVANCE(530);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(aux_sym_bibitempair_token1);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(aux_sym_bibitempair_token2);
      if (lookahead == '\n') ADVANCE(535);
      if (lookahead == '}') ADVANCE(593);
      if (lookahead != 0) ADVANCE(533);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(aux_sym_bibitempair_token2);
      if (lookahead == '%') ADVANCE(533);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(534);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(535);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(aux_sym_bibitempair_token2);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(535);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_COLONassume_COLON);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_COLONsuppose_COLON);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_COLONprove_COLON);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_COLONthen_COLON);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_COLONnew_COLON);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_COLONlet_COLON);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_COLONcase_COLON);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_COLONdefine_COLON);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_COLONwrite_COLON);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(anon_sym_COLONwlog_COLON);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(anon_sym_COLONsuffices_COLON);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_COLONclaim_COLON);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_COLON_PIPE_DASH_COLON);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_COLON_COLON2);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_COLONdraft_COLON);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_COLONnote_COLON);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(anon_sym_COLONspan_COLON);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_COLONabstract_COLON);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(anon_sym_COLONauthor_COLON);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_COLONdefinition_COLON);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(anon_sym_COLONenumerate_COLON);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_COLONitemize_COLON);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_COLONlemma_COLON);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(anon_sym_COLONfigure_COLON);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(anon_sym_COLONp_COLON);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(anon_sym_COLONproof_COLON);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_COLONproposition_COLON);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(anon_sym_COLONremark_COLON);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_COLONsection_COLON);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(anon_sym_COLONsketch_COLON);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(anon_sym_COLONsubsection_COLON);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_COLONsubsubsection_COLON);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_COLONsubsubsubsection_COLON);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_COLONstep_COLON);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_COLONtheorem_COLON);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(anon_sym_COLONaffiliation_COLON);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_COLONemail_COLON);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_COLONlabel_COLON);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(anon_sym_COLONname_COLON);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_COLONreftext_COLON);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_COLONtitle_COLON);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_COLONgoal_COLON);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_COLONnonum_COLON);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_COLONstrong_COLON);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_COLONemphas_COLON);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_COLONisclaim_COLON);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_COLONkeywords_COLON);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_COLONMSC_COLON);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_COLONtypes_COLON);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(anon_sym_COLONdate_COLON);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(anon_sym_COLONpath_COLON);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(anon_sym_COLONscale_COLON);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(513);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(589);
      if (lookahead != 0) ADVANCE(588);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(513);
      if (lookahead != 0) ADVANCE(589);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(515);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(593);
      if (lookahead != 0) ADVANCE(590);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(515);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(592);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(590);
      if (lookahead != 0) ADVANCE(591);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == ',' ||
          lookahead == '}') ADVANCE(592);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(590);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(591);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(593);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 460},
  [2] = {.lex_state = 460, .external_lex_state = 2},
  [3] = {.lex_state = 460, .external_lex_state = 2},
  [4] = {.lex_state = 460, .external_lex_state = 2},
  [5] = {.lex_state = 460, .external_lex_state = 2},
  [6] = {.lex_state = 460, .external_lex_state = 2},
  [7] = {.lex_state = 460, .external_lex_state = 2},
  [8] = {.lex_state = 460, .external_lex_state = 2},
  [9] = {.lex_state = 460, .external_lex_state = 2},
  [10] = {.lex_state = 460, .external_lex_state = 2},
  [11] = {.lex_state = 460, .external_lex_state = 2},
  [12] = {.lex_state = 460, .external_lex_state = 2},
  [13] = {.lex_state = 460, .external_lex_state = 2},
  [14] = {.lex_state = 460, .external_lex_state = 2},
  [15] = {.lex_state = 460, .external_lex_state = 2},
  [16] = {.lex_state = 460, .external_lex_state = 2},
  [17] = {.lex_state = 460, .external_lex_state = 2},
  [18] = {.lex_state = 460, .external_lex_state = 2},
  [19] = {.lex_state = 460, .external_lex_state = 2},
  [20] = {.lex_state = 460, .external_lex_state = 2},
  [21] = {.lex_state = 460, .external_lex_state = 2},
  [22] = {.lex_state = 460, .external_lex_state = 2},
  [23] = {.lex_state = 460, .external_lex_state = 2},
  [24] = {.lex_state = 460, .external_lex_state = 2},
  [25] = {.lex_state = 460, .external_lex_state = 2},
  [26] = {.lex_state = 460, .external_lex_state = 2},
  [27] = {.lex_state = 460, .external_lex_state = 2},
  [28] = {.lex_state = 460, .external_lex_state = 2},
  [29] = {.lex_state = 460, .external_lex_state = 2},
  [30] = {.lex_state = 460, .external_lex_state = 2},
  [31] = {.lex_state = 460, .external_lex_state = 2},
  [32] = {.lex_state = 460, .external_lex_state = 2},
  [33] = {.lex_state = 460, .external_lex_state = 2},
  [34] = {.lex_state = 460, .external_lex_state = 2},
  [35] = {.lex_state = 460, .external_lex_state = 2},
  [36] = {.lex_state = 460, .external_lex_state = 2},
  [37] = {.lex_state = 460, .external_lex_state = 2},
  [38] = {.lex_state = 460, .external_lex_state = 2},
  [39] = {.lex_state = 460, .external_lex_state = 2},
  [40] = {.lex_state = 460, .external_lex_state = 2},
  [41] = {.lex_state = 460, .external_lex_state = 2},
  [42] = {.lex_state = 460, .external_lex_state = 2},
  [43] = {.lex_state = 460, .external_lex_state = 2},
  [44] = {.lex_state = 460, .external_lex_state = 2},
  [45] = {.lex_state = 460, .external_lex_state = 2},
  [46] = {.lex_state = 460, .external_lex_state = 2},
  [47] = {.lex_state = 460, .external_lex_state = 2},
  [48] = {.lex_state = 460, .external_lex_state = 2},
  [49] = {.lex_state = 460, .external_lex_state = 2},
  [50] = {.lex_state = 460, .external_lex_state = 2},
  [51] = {.lex_state = 460, .external_lex_state = 2},
  [52] = {.lex_state = 460, .external_lex_state = 2},
  [53] = {.lex_state = 460, .external_lex_state = 2},
  [54] = {.lex_state = 460, .external_lex_state = 2},
  [55] = {.lex_state = 460, .external_lex_state = 2},
  [56] = {.lex_state = 460, .external_lex_state = 2},
  [57] = {.lex_state = 460, .external_lex_state = 2},
  [58] = {.lex_state = 460, .external_lex_state = 2},
  [59] = {.lex_state = 460, .external_lex_state = 2},
  [60] = {.lex_state = 460, .external_lex_state = 2},
  [61] = {.lex_state = 460, .external_lex_state = 2},
  [62] = {.lex_state = 460, .external_lex_state = 2},
  [63] = {.lex_state = 14, .external_lex_state = 2},
  [64] = {.lex_state = 14, .external_lex_state = 2},
  [65] = {.lex_state = 14, .external_lex_state = 2},
  [66] = {.lex_state = 14, .external_lex_state = 2},
  [67] = {.lex_state = 14, .external_lex_state = 2},
  [68] = {.lex_state = 14, .external_lex_state = 2},
  [69] = {.lex_state = 14, .external_lex_state = 2},
  [70] = {.lex_state = 14, .external_lex_state = 2},
  [71] = {.lex_state = 14, .external_lex_state = 2},
  [72] = {.lex_state = 14, .external_lex_state = 2},
  [73] = {.lex_state = 14, .external_lex_state = 2},
  [74] = {.lex_state = 14, .external_lex_state = 2},
  [75] = {.lex_state = 14, .external_lex_state = 2},
  [76] = {.lex_state = 14, .external_lex_state = 2},
  [77] = {.lex_state = 15, .external_lex_state = 2},
  [78] = {.lex_state = 15, .external_lex_state = 2},
  [79] = {.lex_state = 14, .external_lex_state = 2},
  [80] = {.lex_state = 14, .external_lex_state = 2},
  [81] = {.lex_state = 14, .external_lex_state = 2},
  [82] = {.lex_state = 14, .external_lex_state = 3},
  [83] = {.lex_state = 14, .external_lex_state = 2},
  [84] = {.lex_state = 14, .external_lex_state = 2},
  [85] = {.lex_state = 14, .external_lex_state = 2},
  [86] = {.lex_state = 14, .external_lex_state = 2},
  [87] = {.lex_state = 14, .external_lex_state = 2},
  [88] = {.lex_state = 16, .external_lex_state = 2},
  [89] = {.lex_state = 13, .external_lex_state = 2},
  [90] = {.lex_state = 13, .external_lex_state = 2},
  [91] = {.lex_state = 14, .external_lex_state = 2},
  [92] = {.lex_state = 12, .external_lex_state = 2},
  [93] = {.lex_state = 14, .external_lex_state = 2},
  [94] = {.lex_state = 14, .external_lex_state = 2},
  [95] = {.lex_state = 13, .external_lex_state = 2},
  [96] = {.lex_state = 12, .external_lex_state = 2},
  [97] = {.lex_state = 13, .external_lex_state = 2},
  [98] = {.lex_state = 13, .external_lex_state = 2},
  [99] = {.lex_state = 14, .external_lex_state = 2},
  [100] = {.lex_state = 14, .external_lex_state = 2},
  [101] = {.lex_state = 14, .external_lex_state = 3},
  [102] = {.lex_state = 14, .external_lex_state = 2},
  [103] = {.lex_state = 12, .external_lex_state = 2},
  [104] = {.lex_state = 14, .external_lex_state = 2},
  [105] = {.lex_state = 14, .external_lex_state = 2},
  [106] = {.lex_state = 14, .external_lex_state = 2},
  [107] = {.lex_state = 14, .external_lex_state = 3},
  [108] = {.lex_state = 14, .external_lex_state = 2},
  [109] = {.lex_state = 14, .external_lex_state = 2},
  [110] = {.lex_state = 14, .external_lex_state = 2},
  [111] = {.lex_state = 14, .external_lex_state = 2},
  [112] = {.lex_state = 14, .external_lex_state = 3},
  [113] = {.lex_state = 12, .external_lex_state = 2},
  [114] = {.lex_state = 13, .external_lex_state = 2},
  [115] = {.lex_state = 14, .external_lex_state = 3},
  [116] = {.lex_state = 14, .external_lex_state = 2},
  [117] = {.lex_state = 14, .external_lex_state = 2},
  [118] = {.lex_state = 14, .external_lex_state = 3},
  [119] = {.lex_state = 13, .external_lex_state = 2},
  [120] = {.lex_state = 14, .external_lex_state = 2},
  [121] = {.lex_state = 12, .external_lex_state = 2},
  [122] = {.lex_state = 14, .external_lex_state = 3},
  [123] = {.lex_state = 14, .external_lex_state = 3},
  [124] = {.lex_state = 12, .external_lex_state = 2},
  [125] = {.lex_state = 14, .external_lex_state = 3},
  [126] = {.lex_state = 13, .external_lex_state = 2},
  [127] = {.lex_state = 12, .external_lex_state = 2},
  [128] = {.lex_state = 14, .external_lex_state = 2},
  [129] = {.lex_state = 14, .external_lex_state = 2},
  [130] = {.lex_state = 14, .external_lex_state = 2},
  [131] = {.lex_state = 14, .external_lex_state = 2},
  [132] = {.lex_state = 13, .external_lex_state = 2},
  [133] = {.lex_state = 12, .external_lex_state = 2},
  [134] = {.lex_state = 14, .external_lex_state = 2},
  [135] = {.lex_state = 12, .external_lex_state = 2},
  [136] = {.lex_state = 14, .external_lex_state = 2},
  [137] = {.lex_state = 14, .external_lex_state = 2},
  [138] = {.lex_state = 14, .external_lex_state = 2},
  [139] = {.lex_state = 14, .external_lex_state = 2},
  [140] = {.lex_state = 14, .external_lex_state = 2},
  [141] = {.lex_state = 13, .external_lex_state = 2},
  [142] = {.lex_state = 12, .external_lex_state = 2},
  [143] = {.lex_state = 13, .external_lex_state = 2},
  [144] = {.lex_state = 16, .external_lex_state = 2},
  [145] = {.lex_state = 12, .external_lex_state = 2},
  [146] = {.lex_state = 14, .external_lex_state = 2},
  [147] = {.lex_state = 14, .external_lex_state = 2},
  [148] = {.lex_state = 14, .external_lex_state = 2},
  [149] = {.lex_state = 14, .external_lex_state = 2},
  [150] = {.lex_state = 15, .external_lex_state = 2},
  [151] = {.lex_state = 15, .external_lex_state = 2},
  [152] = {.lex_state = 15, .external_lex_state = 2},
  [153] = {.lex_state = 15, .external_lex_state = 2},
  [154] = {.lex_state = 15, .external_lex_state = 2},
  [155] = {.lex_state = 15, .external_lex_state = 2},
  [156] = {.lex_state = 15, .external_lex_state = 2},
  [157] = {.lex_state = 15, .external_lex_state = 2},
  [158] = {.lex_state = 15, .external_lex_state = 2},
  [159] = {.lex_state = 15, .external_lex_state = 2},
  [160] = {.lex_state = 15, .external_lex_state = 2},
  [161] = {.lex_state = 15, .external_lex_state = 2},
  [162] = {.lex_state = 15, .external_lex_state = 2},
  [163] = {.lex_state = 15, .external_lex_state = 2},
  [164] = {.lex_state = 15, .external_lex_state = 2},
  [165] = {.lex_state = 15, .external_lex_state = 2},
  [166] = {.lex_state = 15, .external_lex_state = 2},
  [167] = {.lex_state = 15, .external_lex_state = 2},
  [168] = {.lex_state = 15, .external_lex_state = 2},
  [169] = {.lex_state = 15, .external_lex_state = 2},
  [170] = {.lex_state = 15, .external_lex_state = 2},
  [171] = {.lex_state = 15, .external_lex_state = 2},
  [172] = {.lex_state = 14, .external_lex_state = 3},
  [173] = {.lex_state = 12, .external_lex_state = 2},
  [174] = {.lex_state = 16, .external_lex_state = 2},
  [175] = {.lex_state = 16, .external_lex_state = 2},
  [176] = {.lex_state = 16, .external_lex_state = 2},
  [177] = {.lex_state = 16, .external_lex_state = 2},
  [178] = {.lex_state = 16, .external_lex_state = 2},
  [179] = {.lex_state = 13, .external_lex_state = 2},
  [180] = {.lex_state = 13, .external_lex_state = 2},
  [181] = {.lex_state = 14, .external_lex_state = 2},
  [182] = {.lex_state = 16, .external_lex_state = 2},
  [183] = {.lex_state = 16, .external_lex_state = 2},
  [184] = {.lex_state = 16, .external_lex_state = 2},
  [185] = {.lex_state = 16, .external_lex_state = 2},
  [186] = {.lex_state = 16, .external_lex_state = 2},
  [187] = {.lex_state = 13, .external_lex_state = 2},
  [188] = {.lex_state = 13, .external_lex_state = 2},
  [189] = {.lex_state = 14, .external_lex_state = 3},
  [190] = {.lex_state = 14, .external_lex_state = 3},
  [191] = {.lex_state = 14, .external_lex_state = 3},
  [192] = {.lex_state = 13, .external_lex_state = 2},
  [193] = {.lex_state = 13, .external_lex_state = 2},
  [194] = {.lex_state = 13, .external_lex_state = 2},
  [195] = {.lex_state = 14, .external_lex_state = 3},
  [196] = {.lex_state = 13, .external_lex_state = 2},
  [197] = {.lex_state = 16, .external_lex_state = 2},
  [198] = {.lex_state = 13, .external_lex_state = 2},
  [199] = {.lex_state = 13, .external_lex_state = 2},
  [200] = {.lex_state = 16, .external_lex_state = 2},
  [201] = {.lex_state = 14, .external_lex_state = 3},
  [202] = {.lex_state = 14, .external_lex_state = 3},
  [203] = {.lex_state = 16, .external_lex_state = 2},
  [204] = {.lex_state = 16, .external_lex_state = 2},
  [205] = {.lex_state = 14, .external_lex_state = 3},
  [206] = {.lex_state = 13, .external_lex_state = 2},
  [207] = {.lex_state = 14, .external_lex_state = 3},
  [208] = {.lex_state = 16, .external_lex_state = 2},
  [209] = {.lex_state = 13, .external_lex_state = 2},
  [210] = {.lex_state = 16, .external_lex_state = 2},
  [211] = {.lex_state = 14, .external_lex_state = 3},
  [212] = {.lex_state = 14, .external_lex_state = 3},
  [213] = {.lex_state = 16, .external_lex_state = 2},
  [214] = {.lex_state = 13, .external_lex_state = 2},
  [215] = {.lex_state = 16, .external_lex_state = 2},
  [216] = {.lex_state = 16, .external_lex_state = 2},
  [217] = {.lex_state = 13, .external_lex_state = 2},
  [218] = {.lex_state = 12, .external_lex_state = 2},
  [219] = {.lex_state = 16, .external_lex_state = 2},
  [220] = {.lex_state = 14, .external_lex_state = 2},
  [221] = {.lex_state = 12, .external_lex_state = 2},
  [222] = {.lex_state = 13, .external_lex_state = 2},
  [223] = {.lex_state = 14, .external_lex_state = 3},
  [224] = {.lex_state = 14, .external_lex_state = 3},
  [225] = {.lex_state = 16, .external_lex_state = 2},
  [226] = {.lex_state = 14, .external_lex_state = 3},
  [227] = {.lex_state = 12, .external_lex_state = 2},
  [228] = {.lex_state = 12, .external_lex_state = 2},
  [229] = {.lex_state = 14, .external_lex_state = 3},
  [230] = {.lex_state = 12, .external_lex_state = 2},
  [231] = {.lex_state = 14, .external_lex_state = 3},
  [232] = {.lex_state = 12, .external_lex_state = 2},
  [233] = {.lex_state = 14, .external_lex_state = 3},
  [234] = {.lex_state = 14, .external_lex_state = 3},
  [235] = {.lex_state = 12, .external_lex_state = 2},
  [236] = {.lex_state = 13, .external_lex_state = 2},
  [237] = {.lex_state = 14, .external_lex_state = 3},
  [238] = {.lex_state = 13, .external_lex_state = 2},
  [239] = {.lex_state = 13, .external_lex_state = 2},
  [240] = {.lex_state = 12, .external_lex_state = 2},
  [241] = {.lex_state = 12, .external_lex_state = 2},
  [242] = {.lex_state = 12, .external_lex_state = 2},
  [243] = {.lex_state = 14, .external_lex_state = 3},
  [244] = {.lex_state = 12, .external_lex_state = 2},
  [245] = {.lex_state = 16, .external_lex_state = 2},
  [246] = {.lex_state = 12, .external_lex_state = 2},
  [247] = {.lex_state = 14, .external_lex_state = 3},
  [248] = {.lex_state = 12, .external_lex_state = 2},
  [249] = {.lex_state = 14, .external_lex_state = 3},
  [250] = {.lex_state = 12, .external_lex_state = 2},
  [251] = {.lex_state = 12, .external_lex_state = 2},
  [252] = {.lex_state = 12, .external_lex_state = 2},
  [253] = {.lex_state = 13, .external_lex_state = 2},
  [254] = {.lex_state = 12, .external_lex_state = 2},
  [255] = {.lex_state = 12, .external_lex_state = 2},
  [256] = {.lex_state = 12, .external_lex_state = 2},
  [257] = {.lex_state = 13, .external_lex_state = 2},
  [258] = {.lex_state = 13, .external_lex_state = 2},
  [259] = {.lex_state = 13, .external_lex_state = 2},
  [260] = {.lex_state = 12, .external_lex_state = 2},
  [261] = {.lex_state = 12, .external_lex_state = 2},
  [262] = {.lex_state = 14, .external_lex_state = 2},
  [263] = {.lex_state = 460},
  [264] = {.lex_state = 460},
  [265] = {.lex_state = 460},
  [266] = {.lex_state = 460, .external_lex_state = 4},
  [267] = {.lex_state = 460, .external_lex_state = 5},
  [268] = {.lex_state = 460, .external_lex_state = 6},
  [269] = {.lex_state = 460, .external_lex_state = 6},
  [270] = {.lex_state = 460, .external_lex_state = 6},
  [271] = {.lex_state = 460, .external_lex_state = 4},
  [272] = {.lex_state = 460, .external_lex_state = 5},
  [273] = {.lex_state = 460, .external_lex_state = 6},
  [274] = {.lex_state = 460, .external_lex_state = 4},
  [275] = {.lex_state = 460, .external_lex_state = 5},
  [276] = {.lex_state = 460},
  [277] = {.lex_state = 460},
  [278] = {.lex_state = 460},
  [279] = {.lex_state = 460},
  [280] = {.lex_state = 460},
  [281] = {.lex_state = 460},
  [282] = {.lex_state = 460},
  [283] = {.lex_state = 460},
  [284] = {.lex_state = 460},
  [285] = {.lex_state = 460},
  [286] = {.lex_state = 460},
  [287] = {.lex_state = 460},
  [288] = {.lex_state = 460},
  [289] = {.lex_state = 460},
  [290] = {.lex_state = 460},
  [291] = {.lex_state = 460},
  [292] = {.lex_state = 460, .external_lex_state = 6},
  [293] = {.lex_state = 460, .external_lex_state = 4},
  [294] = {.lex_state = 460, .external_lex_state = 5},
  [295] = {.lex_state = 460, .external_lex_state = 5},
  [296] = {.lex_state = 460, .external_lex_state = 6},
  [297] = {.lex_state = 460, .external_lex_state = 6},
  [298] = {.lex_state = 460, .external_lex_state = 6},
  [299] = {.lex_state = 460, .external_lex_state = 4},
  [300] = {.lex_state = 460, .external_lex_state = 6},
  [301] = {.lex_state = 460, .external_lex_state = 4},
  [302] = {.lex_state = 460, .external_lex_state = 5},
  [303] = {.lex_state = 460, .external_lex_state = 4},
  [304] = {.lex_state = 460, .external_lex_state = 6},
  [305] = {.lex_state = 460, .external_lex_state = 4},
  [306] = {.lex_state = 460, .external_lex_state = 5},
  [307] = {.lex_state = 460, .external_lex_state = 5},
  [308] = {.lex_state = 460, .external_lex_state = 4},
  [309] = {.lex_state = 460, .external_lex_state = 4},
  [310] = {.lex_state = 460, .external_lex_state = 6},
  [311] = {.lex_state = 460, .external_lex_state = 5},
  [312] = {.lex_state = 460, .external_lex_state = 5},
  [313] = {.lex_state = 460},
  [314] = {.lex_state = 460},
  [315] = {.lex_state = 460},
  [316] = {.lex_state = 460},
  [317] = {.lex_state = 460},
  [318] = {.lex_state = 460},
  [319] = {.lex_state = 460},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 460},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 460},
  [324] = {.lex_state = 460},
  [325] = {.lex_state = 460},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 460},
  [328] = {.lex_state = 0, .external_lex_state = 7},
  [329] = {.lex_state = 460},
  [330] = {.lex_state = 460},
  [331] = {.lex_state = 0, .external_lex_state = 2},
  [332] = {.lex_state = 0, .external_lex_state = 8},
  [333] = {.lex_state = 0, .external_lex_state = 2},
  [334] = {.lex_state = 0, .external_lex_state = 2},
  [335] = {.lex_state = 0, .external_lex_state = 6},
  [336] = {.lex_state = 460},
  [337] = {.lex_state = 0, .external_lex_state = 6},
  [338] = {.lex_state = 0, .external_lex_state = 2},
  [339] = {.lex_state = 0, .external_lex_state = 2},
  [340] = {.lex_state = 0, .external_lex_state = 9},
  [341] = {.lex_state = 0, .external_lex_state = 7},
  [342] = {.lex_state = 460},
  [343] = {.lex_state = 460},
  [344] = {.lex_state = 460},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0, .external_lex_state = 6},
  [347] = {.lex_state = 460},
  [348] = {.lex_state = 0, .external_lex_state = 9},
  [349] = {.lex_state = 0, .external_lex_state = 6},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 460},
  [352] = {.lex_state = 0, .external_lex_state = 6},
  [353] = {.lex_state = 0, .external_lex_state = 6},
  [354] = {.lex_state = 0, .external_lex_state = 6},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0, .external_lex_state = 9},
  [357] = {.lex_state = 0, .external_lex_state = 6},
  [358] = {.lex_state = 0, .external_lex_state = 9},
  [359] = {.lex_state = 0, .external_lex_state = 7},
  [360] = {.lex_state = 0, .external_lex_state = 7},
  [361] = {.lex_state = 0, .external_lex_state = 7},
  [362] = {.lex_state = 0, .external_lex_state = 6},
  [363] = {.lex_state = 0, .external_lex_state = 6},
  [364] = {.lex_state = 0, .external_lex_state = 9},
  [365] = {.lex_state = 460},
  [366] = {.lex_state = 460},
  [367] = {.lex_state = 15},
  [368] = {.lex_state = 0, .external_lex_state = 8},
  [369] = {.lex_state = 0, .external_lex_state = 8},
  [370] = {.lex_state = 0, .external_lex_state = 8},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0, .external_lex_state = 8},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 460},
  [375] = {.lex_state = 460},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 460},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 460},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 15},
  [383] = {.lex_state = 0, .external_lex_state = 8},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0, .external_lex_state = 8},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0, .external_lex_state = 2},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0, .external_lex_state = 8},
  [395] = {.lex_state = 0},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0, .external_lex_state = 2},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 8},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0, .external_lex_state = 2},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 1},
  [404] = {.lex_state = 0},
  [405] = {.lex_state = 0, .external_lex_state = 8},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 0, .external_lex_state = 2},
  [408] = {.lex_state = 0, .external_lex_state = 8},
  [409] = {.lex_state = 1},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 0, .external_lex_state = 8},
  [415] = {.lex_state = 0, .external_lex_state = 2},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 0},
  [419] = {.lex_state = 0},
  [420] = {.lex_state = 0, .external_lex_state = 2},
  [421] = {.lex_state = 5},
  [422] = {.lex_state = 0, .external_lex_state = 8},
  [423] = {.lex_state = 0},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0, .external_lex_state = 8},
  [426] = {.lex_state = 1},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0, .external_lex_state = 8},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 0},
  [436] = {.lex_state = 0, .external_lex_state = 8},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 14},
  [441] = {.lex_state = 14},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 0},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 14},
  [449] = {.lex_state = 14},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 0},
  [454] = {.lex_state = 0, .external_lex_state = 6},
  [455] = {.lex_state = 14},
  [456] = {.lex_state = 14},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 0, .external_lex_state = 6},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0, .external_lex_state = 9},
  [467] = {.lex_state = 14},
  [468] = {.lex_state = 0, .external_lex_state = 7},
  [469] = {.lex_state = 0, .external_lex_state = 7},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 14},
  [473] = {.lex_state = 14},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 14},
  [477] = {.lex_state = 0, .external_lex_state = 6},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 14},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0, .external_lex_state = 6},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0, .external_lex_state = 5},
  [484] = {.lex_state = 14},
  [485] = {.lex_state = 14},
  [486] = {.lex_state = 14},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0, .external_lex_state = 4},
  [491] = {.lex_state = 14},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 14},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0, .external_lex_state = 2},
  [499] = {.lex_state = 0, .external_lex_state = 2},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 14},
  [503] = {.lex_state = 14},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0, .external_lex_state = 9},
  [511] = {.lex_state = 0, .external_lex_state = 2},
  [512] = {.lex_state = 17},
  [513] = {.lex_state = 18},
  [514] = {.lex_state = 14},
  [515] = {.lex_state = 14},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 19},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 19},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 18},
  [531] = {.lex_state = 17},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0, .external_lex_state = 7},
  [535] = {.lex_state = 0, .external_lex_state = 9},
  [536] = {.lex_state = 0, .external_lex_state = 6},
  [537] = {.lex_state = 0, .external_lex_state = 6},
  [538] = {.lex_state = 0, .external_lex_state = 8},
  [539] = {.lex_state = 0, .external_lex_state = 2},
  [540] = {.lex_state = 0, .external_lex_state = 2},
  [541] = {.lex_state = 20},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0, .external_lex_state = 6},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 19},
  [547] = {.lex_state = 0},
  [548] = {.lex_state = 18},
  [549] = {.lex_state = 17},
  [550] = {.lex_state = 0, .external_lex_state = 2},
  [551] = {.lex_state = 0, .external_lex_state = 7},
  [552] = {.lex_state = 0, .external_lex_state = 9},
  [553] = {.lex_state = 0, .external_lex_state = 6},
  [554] = {.lex_state = 0, .external_lex_state = 6},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0, .external_lex_state = 2},
  [557] = {.lex_state = 0, .external_lex_state = 2},
  [558] = {.lex_state = 0, .external_lex_state = 6},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 16},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 19},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 18},
  [566] = {.lex_state = 17},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0, .external_lex_state = 7},
  [569] = {.lex_state = 0, .external_lex_state = 9},
  [570] = {.lex_state = 0, .external_lex_state = 6},
  [571] = {.lex_state = 0, .external_lex_state = 6},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0, .external_lex_state = 2},
  [574] = {.lex_state = 0, .external_lex_state = 2},
  [575] = {.lex_state = 21},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0, .external_lex_state = 8},
  [580] = {.lex_state = 19},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 18},
  [583] = {.lex_state = 17},
  [584] = {.lex_state = 0, .external_lex_state = 7},
  [585] = {.lex_state = 0, .external_lex_state = 9},
  [586] = {.lex_state = 0, .external_lex_state = 6},
  [587] = {.lex_state = 0, .external_lex_state = 6},
  [588] = {.lex_state = 0, .external_lex_state = 2},
  [589] = {.lex_state = 0, .external_lex_state = 2},
  [590] = {.lex_state = 5},
  [591] = {.lex_state = 0, .external_lex_state = 9},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0, .external_lex_state = 7},
  [594] = {.lex_state = 0},
};

enum {
  ts_external_token_upto_brace_or_comma_text = 0,
  ts_external_token_asis_dollar_text = 1,
  ts_external_token_asis_two_dollars_text = 2,
  ts_external_token_asis_backtick_text = 3,
  ts_external_token_asis_three_backticks_text = 4,
  ts_external_token_asis_halmos_text = 5,
  ts_external_token_text = 6,
  ts_external_token_paragraph_end = 7,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_upto_brace_or_comma_text] = sym_upto_brace_or_comma_text,
  [ts_external_token_asis_dollar_text] = sym_asis_dollar_text,
  [ts_external_token_asis_two_dollars_text] = sym_asis_two_dollars_text,
  [ts_external_token_asis_backtick_text] = sym_asis_backtick_text,
  [ts_external_token_asis_three_backticks_text] = sym_asis_three_backticks_text,
  [ts_external_token_asis_halmos_text] = sym_asis_halmos_text,
  [ts_external_token_text] = sym_text,
  [ts_external_token_paragraph_end] = sym_paragraph_end,
};

static const bool ts_external_scanner_states[10][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_upto_brace_or_comma_text] = true,
    [ts_external_token_asis_dollar_text] = true,
    [ts_external_token_asis_two_dollars_text] = true,
    [ts_external_token_asis_backtick_text] = true,
    [ts_external_token_asis_three_backticks_text] = true,
    [ts_external_token_asis_halmos_text] = true,
    [ts_external_token_text] = true,
    [ts_external_token_paragraph_end] = true,
  },
  [2] = {
    [ts_external_token_text] = true,
  },
  [3] = {
    [ts_external_token_text] = true,
    [ts_external_token_paragraph_end] = true,
  },
  [4] = {
    [ts_external_token_asis_two_dollars_text] = true,
  },
  [5] = {
    [ts_external_token_asis_three_backticks_text] = true,
  },
  [6] = {
    [ts_external_token_asis_halmos_text] = true,
  },
  [7] = {
    [ts_external_token_asis_dollar_text] = true,
  },
  [8] = {
    [ts_external_token_upto_brace_or_comma_text] = true,
  },
  [9] = {
    [ts_external_token_asis_backtick_text] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLONmanuscript_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(1),
    [anon_sym_COLONappendix_COLON] = ACTIONS(1),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(1),
    [anon_sym_COLONtoc_COLON] = ACTIONS(1),
    [aux_sym_specialblock_token1] = ACTIONS(1),
    [aux_sym_specialblock_token2] = ACTIONS(1),
    [aux_sym_specialblock_token3] = ACTIONS(1),
    [aux_sym_specialblock_token4] = ACTIONS(1),
    [aux_sym_specialblock_token5] = ACTIONS(1),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(1),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(1),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(1),
    [anon_sym_COLONcaption_COLON] = ACTIONS(1),
    [anon_sym_COLONitem_COLON] = ACTIONS(1),
    [anon_sym_COLONprev_COLON] = ACTIONS(1),
    [anon_sym_COLONprev2_COLON] = ACTIONS(1),
    [anon_sym_COLONprev3_COLON] = ACTIONS(1),
    [aux_sym_specialinline_token1] = ACTIONS(1),
    [aux_sym_specialinline_token2] = ACTIONS(1),
    [anon_sym_COLONmath_COLON] = ACTIONS(1),
    [anon_sym_COLONcode_COLON] = ACTIONS(1),
    [aux_sym_specialinline_token3] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [aux_sym_specialinline_token4] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLONref_COLON] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_COLONprevious_COLON] = ACTIONS(1),
    [aux_sym_specialinline_token6] = ACTIONS(1),
    [anon_sym_COLONurl_COLON] = ACTIONS(1),
    [anon_sym_COLONcite_COLON] = ACTIONS(1),
    [anon_sym_COLONqed_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLONtable_COLON] = ACTIONS(1),
    [anon_sym_COLONthead_COLON] = ACTIONS(1),
    [anon_sym_COLONtbody_COLON] = ACTIONS(1),
    [anon_sym_COLONtr_COLON] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_COLONtd_COLON] = ACTIONS(1),
    [anon_sym_COLONbibtex_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [aux_sym_bibitem_token1] = ACTIONS(1),
    [aux_sym_bibitempair_token1] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLONassume_COLON] = ACTIONS(1),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(1),
    [anon_sym_COLONprove_COLON] = ACTIONS(1),
    [anon_sym_COLONthen_COLON] = ACTIONS(1),
    [anon_sym_COLONnew_COLON] = ACTIONS(1),
    [anon_sym_COLONlet_COLON] = ACTIONS(1),
    [anon_sym_COLONcase_COLON] = ACTIONS(1),
    [anon_sym_COLONdefine_COLON] = ACTIONS(1),
    [anon_sym_COLONwrite_COLON] = ACTIONS(1),
    [anon_sym_COLONwlog_COLON] = ACTIONS(1),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(1),
    [anon_sym_COLONclaim_COLON] = ACTIONS(1),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON2] = ACTIONS(1),
    [anon_sym_COLONdraft_COLON] = ACTIONS(1),
    [anon_sym_COLONnote_COLON] = ACTIONS(1),
    [anon_sym_COLONspan_COLON] = ACTIONS(1),
    [anon_sym_COLONabstract_COLON] = ACTIONS(1),
    [anon_sym_COLONauthor_COLON] = ACTIONS(1),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(1),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(1),
    [anon_sym_COLONitemize_COLON] = ACTIONS(1),
    [anon_sym_COLONlemma_COLON] = ACTIONS(1),
    [anon_sym_COLONfigure_COLON] = ACTIONS(1),
    [anon_sym_COLONp_COLON] = ACTIONS(1),
    [anon_sym_COLONproof_COLON] = ACTIONS(1),
    [anon_sym_COLONproposition_COLON] = ACTIONS(1),
    [anon_sym_COLONremark_COLON] = ACTIONS(1),
    [anon_sym_COLONsection_COLON] = ACTIONS(1),
    [anon_sym_COLONsketch_COLON] = ACTIONS(1),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(1),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(1),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(1),
    [anon_sym_COLONstep_COLON] = ACTIONS(1),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(1),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(1),
    [anon_sym_COLONemail_COLON] = ACTIONS(1),
    [anon_sym_COLONlabel_COLON] = ACTIONS(1),
    [anon_sym_COLONname_COLON] = ACTIONS(1),
    [anon_sym_COLONreftext_COLON] = ACTIONS(1),
    [anon_sym_COLONtitle_COLON] = ACTIONS(1),
    [anon_sym_COLONgoal_COLON] = ACTIONS(1),
    [anon_sym_COLONnonum_COLON] = ACTIONS(1),
    [anon_sym_COLONstrong_COLON] = ACTIONS(1),
    [anon_sym_COLONemphas_COLON] = ACTIONS(1),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(1),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(1),
    [anon_sym_COLONMSC_COLON] = ACTIONS(1),
    [anon_sym_COLONtypes_COLON] = ACTIONS(1),
    [anon_sym_COLONdate_COLON] = ACTIONS(1),
    [anon_sym_COLONpath_COLON] = ACTIONS(1),
    [anon_sym_COLONscale_COLON] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_upto_brace_or_comma_text] = ACTIONS(1),
    [sym_asis_dollar_text] = ACTIONS(1),
    [sym_asis_two_dollars_text] = ACTIONS(1),
    [sym_asis_backtick_text] = ACTIONS(1),
    [sym_asis_three_backticks_text] = ACTIONS(1),
    [sym_asis_halmos_text] = ACTIONS(1),
    [sym_text] = ACTIONS(1),
    [sym_paragraph_end] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(452),
    [anon_sym_COLONmanuscript_COLON] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_block] = STATE(18),
    [sym_paragraph] = STATE(18),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(18),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_blockmeta] = STATE(17),
    [sym_pair] = STATE(6),
    [sym_table] = STATE(43),
    [sym_metakey_text] = STATE(397),
    [sym_metakey_bool] = STATE(12),
    [sym_metakey_list] = STATE(338),
    [sym_metakey_any] = STATE(403),
    [aux_sym_source_file_repeat1] = STATE(18),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [aux_sym_blockmeta_repeat1] = STATE(6),
    [anon_sym_COLON_COLON] = ACTIONS(7),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(61),
    [anon_sym_COLONemail_COLON] = ACTIONS(61),
    [anon_sym_COLONlabel_COLON] = ACTIONS(61),
    [anon_sym_COLONname_COLON] = ACTIONS(61),
    [anon_sym_COLONreftext_COLON] = ACTIONS(61),
    [anon_sym_COLONtitle_COLON] = ACTIONS(61),
    [anon_sym_COLONgoal_COLON] = ACTIONS(61),
    [anon_sym_COLONnonum_COLON] = ACTIONS(63),
    [anon_sym_COLONstrong_COLON] = ACTIONS(63),
    [anon_sym_COLONemphas_COLON] = ACTIONS(63),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(63),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(65),
    [anon_sym_COLONMSC_COLON] = ACTIONS(65),
    [anon_sym_COLONtypes_COLON] = ACTIONS(65),
    [anon_sym_COLONdate_COLON] = ACTIONS(67),
    [anon_sym_COLONpath_COLON] = ACTIONS(67),
    [anon_sym_COLONscale_COLON] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [3] = {
    [sym_block] = STATE(22),
    [sym_paragraph] = STATE(22),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(22),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_blockmeta] = STATE(15),
    [sym_pair] = STATE(6),
    [sym_table] = STATE(43),
    [sym_metakey_text] = STATE(397),
    [sym_metakey_bool] = STATE(12),
    [sym_metakey_list] = STATE(338),
    [sym_metakey_any] = STATE(403),
    [aux_sym_source_file_repeat1] = STATE(22),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [aux_sym_blockmeta_repeat1] = STATE(6),
    [anon_sym_COLON_COLON] = ACTIONS(71),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(61),
    [anon_sym_COLONemail_COLON] = ACTIONS(61),
    [anon_sym_COLONlabel_COLON] = ACTIONS(61),
    [anon_sym_COLONname_COLON] = ACTIONS(61),
    [anon_sym_COLONreftext_COLON] = ACTIONS(61),
    [anon_sym_COLONtitle_COLON] = ACTIONS(61),
    [anon_sym_COLONgoal_COLON] = ACTIONS(61),
    [anon_sym_COLONnonum_COLON] = ACTIONS(63),
    [anon_sym_COLONstrong_COLON] = ACTIONS(63),
    [anon_sym_COLONemphas_COLON] = ACTIONS(63),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(63),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(65),
    [anon_sym_COLONMSC_COLON] = ACTIONS(65),
    [anon_sym_COLONtypes_COLON] = ACTIONS(65),
    [anon_sym_COLONdate_COLON] = ACTIONS(67),
    [anon_sym_COLONpath_COLON] = ACTIONS(67),
    [anon_sym_COLONscale_COLON] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [4] = {
    [sym_block] = STATE(21),
    [sym_paragraph] = STATE(21),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(21),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_blockmeta] = STATE(14),
    [sym_pair] = STATE(6),
    [sym_table] = STATE(43),
    [sym_metakey_text] = STATE(397),
    [sym_metakey_bool] = STATE(12),
    [sym_metakey_list] = STATE(338),
    [sym_metakey_any] = STATE(403),
    [aux_sym_source_file_repeat1] = STATE(21),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [aux_sym_blockmeta_repeat1] = STATE(6),
    [anon_sym_COLON_COLON] = ACTIONS(73),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(61),
    [anon_sym_COLONemail_COLON] = ACTIONS(61),
    [anon_sym_COLONlabel_COLON] = ACTIONS(61),
    [anon_sym_COLONname_COLON] = ACTIONS(61),
    [anon_sym_COLONreftext_COLON] = ACTIONS(61),
    [anon_sym_COLONtitle_COLON] = ACTIONS(61),
    [anon_sym_COLONgoal_COLON] = ACTIONS(61),
    [anon_sym_COLONnonum_COLON] = ACTIONS(63),
    [anon_sym_COLONstrong_COLON] = ACTIONS(63),
    [anon_sym_COLONemphas_COLON] = ACTIONS(63),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(63),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(65),
    [anon_sym_COLONMSC_COLON] = ACTIONS(65),
    [anon_sym_COLONtypes_COLON] = ACTIONS(65),
    [anon_sym_COLONdate_COLON] = ACTIONS(67),
    [anon_sym_COLONpath_COLON] = ACTIONS(67),
    [anon_sym_COLONscale_COLON] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [5] = {
    [sym_pair] = STATE(5),
    [sym_metakey_text] = STATE(397),
    [sym_metakey_bool] = STATE(12),
    [sym_metakey_list] = STATE(338),
    [sym_metakey_any] = STATE(403),
    [aux_sym_blockmeta_repeat1] = STATE(5),
    [anon_sym_COLON_COLON] = ACTIONS(75),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(75),
    [anon_sym_COLONappendix_COLON] = ACTIONS(75),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(75),
    [anon_sym_COLONtoc_COLON] = ACTIONS(75),
    [aux_sym_specialblock_token1] = ACTIONS(75),
    [aux_sym_specialblock_token2] = ACTIONS(75),
    [aux_sym_specialblock_token3] = ACTIONS(75),
    [aux_sym_specialblock_token4] = ACTIONS(75),
    [aux_sym_specialblock_token5] = ACTIONS(75),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(75),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(75),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(75),
    [anon_sym_COLONcaption_COLON] = ACTIONS(75),
    [anon_sym_COLONitem_COLON] = ACTIONS(75),
    [anon_sym_COLONprev_COLON] = ACTIONS(75),
    [anon_sym_COLONprev2_COLON] = ACTIONS(75),
    [anon_sym_COLONprev3_COLON] = ACTIONS(75),
    [aux_sym_specialinline_token1] = ACTIONS(77),
    [aux_sym_specialinline_token2] = ACTIONS(77),
    [anon_sym_COLONmath_COLON] = ACTIONS(75),
    [anon_sym_COLONcode_COLON] = ACTIONS(75),
    [aux_sym_specialinline_token3] = ACTIONS(75),
    [aux_sym_specialinline_token4] = ACTIONS(75),
    [anon_sym_COLONref_COLON] = ACTIONS(75),
    [anon_sym_COLONprevious_COLON] = ACTIONS(75),
    [anon_sym_COLONurl_COLON] = ACTIONS(75),
    [anon_sym_COLONcite_COLON] = ACTIONS(75),
    [anon_sym_COLONqed_COLON] = ACTIONS(75),
    [anon_sym_COLONtable_COLON] = ACTIONS(75),
    [anon_sym_COLONassume_COLON] = ACTIONS(75),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(75),
    [anon_sym_COLONprove_COLON] = ACTIONS(75),
    [anon_sym_COLONthen_COLON] = ACTIONS(75),
    [anon_sym_COLONnew_COLON] = ACTIONS(75),
    [anon_sym_COLONlet_COLON] = ACTIONS(75),
    [anon_sym_COLONcase_COLON] = ACTIONS(75),
    [anon_sym_COLONdefine_COLON] = ACTIONS(75),
    [anon_sym_COLONwrite_COLON] = ACTIONS(75),
    [anon_sym_COLONwlog_COLON] = ACTIONS(75),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(75),
    [anon_sym_COLONclaim_COLON] = ACTIONS(75),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(75),
    [anon_sym_COLON_COLON2] = ACTIONS(75),
    [anon_sym_COLONdraft_COLON] = ACTIONS(75),
    [anon_sym_COLONnote_COLON] = ACTIONS(75),
    [anon_sym_COLONspan_COLON] = ACTIONS(75),
    [anon_sym_COLONabstract_COLON] = ACTIONS(75),
    [anon_sym_COLONauthor_COLON] = ACTIONS(75),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(75),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(75),
    [anon_sym_COLONitemize_COLON] = ACTIONS(75),
    [anon_sym_COLONlemma_COLON] = ACTIONS(75),
    [anon_sym_COLONfigure_COLON] = ACTIONS(75),
    [anon_sym_COLONp_COLON] = ACTIONS(75),
    [anon_sym_COLONproof_COLON] = ACTIONS(75),
    [anon_sym_COLONproposition_COLON] = ACTIONS(75),
    [anon_sym_COLONremark_COLON] = ACTIONS(75),
    [anon_sym_COLONsection_COLON] = ACTIONS(75),
    [anon_sym_COLONsketch_COLON] = ACTIONS(75),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(75),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(75),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(75),
    [anon_sym_COLONstep_COLON] = ACTIONS(75),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(75),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(79),
    [anon_sym_COLONemail_COLON] = ACTIONS(79),
    [anon_sym_COLONlabel_COLON] = ACTIONS(79),
    [anon_sym_COLONname_COLON] = ACTIONS(79),
    [anon_sym_COLONreftext_COLON] = ACTIONS(79),
    [anon_sym_COLONtitle_COLON] = ACTIONS(79),
    [anon_sym_COLONgoal_COLON] = ACTIONS(79),
    [anon_sym_COLONnonum_COLON] = ACTIONS(82),
    [anon_sym_COLONstrong_COLON] = ACTIONS(82),
    [anon_sym_COLONemphas_COLON] = ACTIONS(82),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(82),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(85),
    [anon_sym_COLONMSC_COLON] = ACTIONS(85),
    [anon_sym_COLONtypes_COLON] = ACTIONS(85),
    [anon_sym_COLONdate_COLON] = ACTIONS(88),
    [anon_sym_COLONpath_COLON] = ACTIONS(88),
    [anon_sym_COLONscale_COLON] = ACTIONS(88),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(75),
  },
  [6] = {
    [sym_pair] = STATE(5),
    [sym_metakey_text] = STATE(397),
    [sym_metakey_bool] = STATE(12),
    [sym_metakey_list] = STATE(338),
    [sym_metakey_any] = STATE(403),
    [aux_sym_blockmeta_repeat1] = STATE(5),
    [anon_sym_COLON_COLON] = ACTIONS(91),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(91),
    [anon_sym_COLONappendix_COLON] = ACTIONS(91),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(91),
    [anon_sym_COLONtoc_COLON] = ACTIONS(91),
    [aux_sym_specialblock_token1] = ACTIONS(91),
    [aux_sym_specialblock_token2] = ACTIONS(91),
    [aux_sym_specialblock_token3] = ACTIONS(91),
    [aux_sym_specialblock_token4] = ACTIONS(91),
    [aux_sym_specialblock_token5] = ACTIONS(91),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(91),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(91),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(91),
    [anon_sym_COLONcaption_COLON] = ACTIONS(91),
    [anon_sym_COLONitem_COLON] = ACTIONS(91),
    [anon_sym_COLONprev_COLON] = ACTIONS(91),
    [anon_sym_COLONprev2_COLON] = ACTIONS(91),
    [anon_sym_COLONprev3_COLON] = ACTIONS(91),
    [aux_sym_specialinline_token1] = ACTIONS(93),
    [aux_sym_specialinline_token2] = ACTIONS(93),
    [anon_sym_COLONmath_COLON] = ACTIONS(91),
    [anon_sym_COLONcode_COLON] = ACTIONS(91),
    [aux_sym_specialinline_token3] = ACTIONS(91),
    [aux_sym_specialinline_token4] = ACTIONS(91),
    [anon_sym_COLONref_COLON] = ACTIONS(91),
    [anon_sym_COLONprevious_COLON] = ACTIONS(91),
    [anon_sym_COLONurl_COLON] = ACTIONS(91),
    [anon_sym_COLONcite_COLON] = ACTIONS(91),
    [anon_sym_COLONqed_COLON] = ACTIONS(91),
    [anon_sym_COLONtable_COLON] = ACTIONS(91),
    [anon_sym_COLONassume_COLON] = ACTIONS(91),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(91),
    [anon_sym_COLONprove_COLON] = ACTIONS(91),
    [anon_sym_COLONthen_COLON] = ACTIONS(91),
    [anon_sym_COLONnew_COLON] = ACTIONS(91),
    [anon_sym_COLONlet_COLON] = ACTIONS(91),
    [anon_sym_COLONcase_COLON] = ACTIONS(91),
    [anon_sym_COLONdefine_COLON] = ACTIONS(91),
    [anon_sym_COLONwrite_COLON] = ACTIONS(91),
    [anon_sym_COLONwlog_COLON] = ACTIONS(91),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(91),
    [anon_sym_COLONclaim_COLON] = ACTIONS(91),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(91),
    [anon_sym_COLON_COLON2] = ACTIONS(91),
    [anon_sym_COLONdraft_COLON] = ACTIONS(91),
    [anon_sym_COLONnote_COLON] = ACTIONS(91),
    [anon_sym_COLONspan_COLON] = ACTIONS(91),
    [anon_sym_COLONabstract_COLON] = ACTIONS(91),
    [anon_sym_COLONauthor_COLON] = ACTIONS(91),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(91),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(91),
    [anon_sym_COLONitemize_COLON] = ACTIONS(91),
    [anon_sym_COLONlemma_COLON] = ACTIONS(91),
    [anon_sym_COLONfigure_COLON] = ACTIONS(91),
    [anon_sym_COLONp_COLON] = ACTIONS(91),
    [anon_sym_COLONproof_COLON] = ACTIONS(91),
    [anon_sym_COLONproposition_COLON] = ACTIONS(91),
    [anon_sym_COLONremark_COLON] = ACTIONS(91),
    [anon_sym_COLONsection_COLON] = ACTIONS(91),
    [anon_sym_COLONsketch_COLON] = ACTIONS(91),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(91),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(91),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(91),
    [anon_sym_COLONstep_COLON] = ACTIONS(91),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(91),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(61),
    [anon_sym_COLONemail_COLON] = ACTIONS(61),
    [anon_sym_COLONlabel_COLON] = ACTIONS(61),
    [anon_sym_COLONname_COLON] = ACTIONS(61),
    [anon_sym_COLONreftext_COLON] = ACTIONS(61),
    [anon_sym_COLONtitle_COLON] = ACTIONS(61),
    [anon_sym_COLONgoal_COLON] = ACTIONS(61),
    [anon_sym_COLONnonum_COLON] = ACTIONS(63),
    [anon_sym_COLONstrong_COLON] = ACTIONS(63),
    [anon_sym_COLONemphas_COLON] = ACTIONS(63),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(63),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(65),
    [anon_sym_COLONMSC_COLON] = ACTIONS(65),
    [anon_sym_COLONtypes_COLON] = ACTIONS(65),
    [anon_sym_COLONdate_COLON] = ACTIONS(67),
    [anon_sym_COLONpath_COLON] = ACTIONS(67),
    [anon_sym_COLONscale_COLON] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(91),
  },
  [7] = {
    [anon_sym_COLON_COLON] = ACTIONS(95),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(95),
    [anon_sym_COLONappendix_COLON] = ACTIONS(95),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(95),
    [anon_sym_COLONtoc_COLON] = ACTIONS(95),
    [aux_sym_specialblock_token1] = ACTIONS(95),
    [aux_sym_specialblock_token2] = ACTIONS(95),
    [aux_sym_specialblock_token3] = ACTIONS(95),
    [aux_sym_specialblock_token4] = ACTIONS(95),
    [aux_sym_specialblock_token5] = ACTIONS(95),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(95),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(95),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(95),
    [anon_sym_COLONcaption_COLON] = ACTIONS(95),
    [anon_sym_COLONitem_COLON] = ACTIONS(95),
    [anon_sym_COLONprev_COLON] = ACTIONS(95),
    [anon_sym_COLONprev2_COLON] = ACTIONS(95),
    [anon_sym_COLONprev3_COLON] = ACTIONS(95),
    [aux_sym_specialinline_token1] = ACTIONS(97),
    [aux_sym_specialinline_token2] = ACTIONS(97),
    [anon_sym_COLONmath_COLON] = ACTIONS(95),
    [anon_sym_COLONcode_COLON] = ACTIONS(95),
    [aux_sym_specialinline_token3] = ACTIONS(95),
    [aux_sym_specialinline_token4] = ACTIONS(95),
    [anon_sym_COLONref_COLON] = ACTIONS(95),
    [anon_sym_COLONprevious_COLON] = ACTIONS(95),
    [anon_sym_COLONurl_COLON] = ACTIONS(95),
    [anon_sym_COLONcite_COLON] = ACTIONS(95),
    [anon_sym_COLONqed_COLON] = ACTIONS(95),
    [anon_sym_COLONtable_COLON] = ACTIONS(95),
    [anon_sym_COLONassume_COLON] = ACTIONS(95),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(95),
    [anon_sym_COLONprove_COLON] = ACTIONS(95),
    [anon_sym_COLONthen_COLON] = ACTIONS(95),
    [anon_sym_COLONnew_COLON] = ACTIONS(95),
    [anon_sym_COLONlet_COLON] = ACTIONS(95),
    [anon_sym_COLONcase_COLON] = ACTIONS(95),
    [anon_sym_COLONdefine_COLON] = ACTIONS(95),
    [anon_sym_COLONwrite_COLON] = ACTIONS(95),
    [anon_sym_COLONwlog_COLON] = ACTIONS(95),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(95),
    [anon_sym_COLONclaim_COLON] = ACTIONS(95),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(95),
    [anon_sym_COLON_COLON2] = ACTIONS(95),
    [anon_sym_COLONdraft_COLON] = ACTIONS(95),
    [anon_sym_COLONnote_COLON] = ACTIONS(95),
    [anon_sym_COLONspan_COLON] = ACTIONS(95),
    [anon_sym_COLONabstract_COLON] = ACTIONS(95),
    [anon_sym_COLONauthor_COLON] = ACTIONS(95),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(95),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(95),
    [anon_sym_COLONitemize_COLON] = ACTIONS(95),
    [anon_sym_COLONlemma_COLON] = ACTIONS(95),
    [anon_sym_COLONfigure_COLON] = ACTIONS(95),
    [anon_sym_COLONp_COLON] = ACTIONS(95),
    [anon_sym_COLONproof_COLON] = ACTIONS(95),
    [anon_sym_COLONproposition_COLON] = ACTIONS(95),
    [anon_sym_COLONremark_COLON] = ACTIONS(95),
    [anon_sym_COLONsection_COLON] = ACTIONS(95),
    [anon_sym_COLONsketch_COLON] = ACTIONS(95),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(95),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(95),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(95),
    [anon_sym_COLONstep_COLON] = ACTIONS(95),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(95),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(95),
    [anon_sym_COLONemail_COLON] = ACTIONS(95),
    [anon_sym_COLONlabel_COLON] = ACTIONS(95),
    [anon_sym_COLONname_COLON] = ACTIONS(95),
    [anon_sym_COLONreftext_COLON] = ACTIONS(95),
    [anon_sym_COLONtitle_COLON] = ACTIONS(95),
    [anon_sym_COLONgoal_COLON] = ACTIONS(95),
    [anon_sym_COLONnonum_COLON] = ACTIONS(95),
    [anon_sym_COLONstrong_COLON] = ACTIONS(95),
    [anon_sym_COLONemphas_COLON] = ACTIONS(95),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(95),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(95),
    [anon_sym_COLONMSC_COLON] = ACTIONS(95),
    [anon_sym_COLONtypes_COLON] = ACTIONS(95),
    [anon_sym_COLONdate_COLON] = ACTIONS(95),
    [anon_sym_COLONpath_COLON] = ACTIONS(95),
    [anon_sym_COLONscale_COLON] = ACTIONS(95),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(95),
  },
  [8] = {
    [anon_sym_COLON_COLON] = ACTIONS(99),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(99),
    [anon_sym_COLONappendix_COLON] = ACTIONS(99),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(99),
    [anon_sym_COLONtoc_COLON] = ACTIONS(99),
    [aux_sym_specialblock_token1] = ACTIONS(99),
    [aux_sym_specialblock_token2] = ACTIONS(99),
    [aux_sym_specialblock_token3] = ACTIONS(99),
    [aux_sym_specialblock_token4] = ACTIONS(99),
    [aux_sym_specialblock_token5] = ACTIONS(99),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(99),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(99),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(99),
    [anon_sym_COLONcaption_COLON] = ACTIONS(99),
    [anon_sym_COLONitem_COLON] = ACTIONS(99),
    [anon_sym_COLONprev_COLON] = ACTIONS(99),
    [anon_sym_COLONprev2_COLON] = ACTIONS(99),
    [anon_sym_COLONprev3_COLON] = ACTIONS(99),
    [aux_sym_specialinline_token1] = ACTIONS(101),
    [aux_sym_specialinline_token2] = ACTIONS(101),
    [anon_sym_COLONmath_COLON] = ACTIONS(99),
    [anon_sym_COLONcode_COLON] = ACTIONS(99),
    [aux_sym_specialinline_token3] = ACTIONS(99),
    [aux_sym_specialinline_token4] = ACTIONS(99),
    [anon_sym_COLONref_COLON] = ACTIONS(99),
    [anon_sym_COLONprevious_COLON] = ACTIONS(99),
    [anon_sym_COLONurl_COLON] = ACTIONS(99),
    [anon_sym_COLONcite_COLON] = ACTIONS(99),
    [anon_sym_COLONqed_COLON] = ACTIONS(99),
    [anon_sym_COLONtable_COLON] = ACTIONS(99),
    [anon_sym_COLONassume_COLON] = ACTIONS(99),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(99),
    [anon_sym_COLONprove_COLON] = ACTIONS(99),
    [anon_sym_COLONthen_COLON] = ACTIONS(99),
    [anon_sym_COLONnew_COLON] = ACTIONS(99),
    [anon_sym_COLONlet_COLON] = ACTIONS(99),
    [anon_sym_COLONcase_COLON] = ACTIONS(99),
    [anon_sym_COLONdefine_COLON] = ACTIONS(99),
    [anon_sym_COLONwrite_COLON] = ACTIONS(99),
    [anon_sym_COLONwlog_COLON] = ACTIONS(99),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(99),
    [anon_sym_COLONclaim_COLON] = ACTIONS(99),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(99),
    [anon_sym_COLON_COLON2] = ACTIONS(99),
    [anon_sym_COLONdraft_COLON] = ACTIONS(99),
    [anon_sym_COLONnote_COLON] = ACTIONS(99),
    [anon_sym_COLONspan_COLON] = ACTIONS(99),
    [anon_sym_COLONabstract_COLON] = ACTIONS(99),
    [anon_sym_COLONauthor_COLON] = ACTIONS(99),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(99),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(99),
    [anon_sym_COLONitemize_COLON] = ACTIONS(99),
    [anon_sym_COLONlemma_COLON] = ACTIONS(99),
    [anon_sym_COLONfigure_COLON] = ACTIONS(99),
    [anon_sym_COLONp_COLON] = ACTIONS(99),
    [anon_sym_COLONproof_COLON] = ACTIONS(99),
    [anon_sym_COLONproposition_COLON] = ACTIONS(99),
    [anon_sym_COLONremark_COLON] = ACTIONS(99),
    [anon_sym_COLONsection_COLON] = ACTIONS(99),
    [anon_sym_COLONsketch_COLON] = ACTIONS(99),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(99),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(99),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(99),
    [anon_sym_COLONstep_COLON] = ACTIONS(99),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(99),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(99),
    [anon_sym_COLONemail_COLON] = ACTIONS(99),
    [anon_sym_COLONlabel_COLON] = ACTIONS(99),
    [anon_sym_COLONname_COLON] = ACTIONS(99),
    [anon_sym_COLONreftext_COLON] = ACTIONS(99),
    [anon_sym_COLONtitle_COLON] = ACTIONS(99),
    [anon_sym_COLONgoal_COLON] = ACTIONS(99),
    [anon_sym_COLONnonum_COLON] = ACTIONS(99),
    [anon_sym_COLONstrong_COLON] = ACTIONS(99),
    [anon_sym_COLONemphas_COLON] = ACTIONS(99),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(99),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(99),
    [anon_sym_COLONMSC_COLON] = ACTIONS(99),
    [anon_sym_COLONtypes_COLON] = ACTIONS(99),
    [anon_sym_COLONdate_COLON] = ACTIONS(99),
    [anon_sym_COLONpath_COLON] = ACTIONS(99),
    [anon_sym_COLONscale_COLON] = ACTIONS(99),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(99),
  },
  [9] = {
    [anon_sym_COLON_COLON] = ACTIONS(103),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(103),
    [anon_sym_COLONappendix_COLON] = ACTIONS(103),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(103),
    [anon_sym_COLONtoc_COLON] = ACTIONS(103),
    [aux_sym_specialblock_token1] = ACTIONS(103),
    [aux_sym_specialblock_token2] = ACTIONS(103),
    [aux_sym_specialblock_token3] = ACTIONS(103),
    [aux_sym_specialblock_token4] = ACTIONS(103),
    [aux_sym_specialblock_token5] = ACTIONS(103),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(103),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(103),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(103),
    [anon_sym_COLONcaption_COLON] = ACTIONS(103),
    [anon_sym_COLONitem_COLON] = ACTIONS(103),
    [anon_sym_COLONprev_COLON] = ACTIONS(103),
    [anon_sym_COLONprev2_COLON] = ACTIONS(103),
    [anon_sym_COLONprev3_COLON] = ACTIONS(103),
    [aux_sym_specialinline_token1] = ACTIONS(105),
    [aux_sym_specialinline_token2] = ACTIONS(105),
    [anon_sym_COLONmath_COLON] = ACTIONS(103),
    [anon_sym_COLONcode_COLON] = ACTIONS(103),
    [aux_sym_specialinline_token3] = ACTIONS(103),
    [aux_sym_specialinline_token4] = ACTIONS(103),
    [anon_sym_COLONref_COLON] = ACTIONS(103),
    [anon_sym_COLONprevious_COLON] = ACTIONS(103),
    [anon_sym_COLONurl_COLON] = ACTIONS(103),
    [anon_sym_COLONcite_COLON] = ACTIONS(103),
    [anon_sym_COLONqed_COLON] = ACTIONS(103),
    [anon_sym_COLONtable_COLON] = ACTIONS(103),
    [anon_sym_COLONassume_COLON] = ACTIONS(103),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(103),
    [anon_sym_COLONprove_COLON] = ACTIONS(103),
    [anon_sym_COLONthen_COLON] = ACTIONS(103),
    [anon_sym_COLONnew_COLON] = ACTIONS(103),
    [anon_sym_COLONlet_COLON] = ACTIONS(103),
    [anon_sym_COLONcase_COLON] = ACTIONS(103),
    [anon_sym_COLONdefine_COLON] = ACTIONS(103),
    [anon_sym_COLONwrite_COLON] = ACTIONS(103),
    [anon_sym_COLONwlog_COLON] = ACTIONS(103),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(103),
    [anon_sym_COLONclaim_COLON] = ACTIONS(103),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(103),
    [anon_sym_COLON_COLON2] = ACTIONS(103),
    [anon_sym_COLONdraft_COLON] = ACTIONS(103),
    [anon_sym_COLONnote_COLON] = ACTIONS(103),
    [anon_sym_COLONspan_COLON] = ACTIONS(103),
    [anon_sym_COLONabstract_COLON] = ACTIONS(103),
    [anon_sym_COLONauthor_COLON] = ACTIONS(103),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(103),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(103),
    [anon_sym_COLONitemize_COLON] = ACTIONS(103),
    [anon_sym_COLONlemma_COLON] = ACTIONS(103),
    [anon_sym_COLONfigure_COLON] = ACTIONS(103),
    [anon_sym_COLONp_COLON] = ACTIONS(103),
    [anon_sym_COLONproof_COLON] = ACTIONS(103),
    [anon_sym_COLONproposition_COLON] = ACTIONS(103),
    [anon_sym_COLONremark_COLON] = ACTIONS(103),
    [anon_sym_COLONsection_COLON] = ACTIONS(103),
    [anon_sym_COLONsketch_COLON] = ACTIONS(103),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(103),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(103),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(103),
    [anon_sym_COLONstep_COLON] = ACTIONS(103),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(103),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(103),
    [anon_sym_COLONemail_COLON] = ACTIONS(103),
    [anon_sym_COLONlabel_COLON] = ACTIONS(103),
    [anon_sym_COLONname_COLON] = ACTIONS(103),
    [anon_sym_COLONreftext_COLON] = ACTIONS(103),
    [anon_sym_COLONtitle_COLON] = ACTIONS(103),
    [anon_sym_COLONgoal_COLON] = ACTIONS(103),
    [anon_sym_COLONnonum_COLON] = ACTIONS(103),
    [anon_sym_COLONstrong_COLON] = ACTIONS(103),
    [anon_sym_COLONemphas_COLON] = ACTIONS(103),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(103),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(103),
    [anon_sym_COLONMSC_COLON] = ACTIONS(103),
    [anon_sym_COLONtypes_COLON] = ACTIONS(103),
    [anon_sym_COLONdate_COLON] = ACTIONS(103),
    [anon_sym_COLONpath_COLON] = ACTIONS(103),
    [anon_sym_COLONscale_COLON] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(103),
  },
  [10] = {
    [anon_sym_COLON_COLON] = ACTIONS(107),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(107),
    [anon_sym_COLONappendix_COLON] = ACTIONS(107),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(107),
    [anon_sym_COLONtoc_COLON] = ACTIONS(107),
    [aux_sym_specialblock_token1] = ACTIONS(107),
    [aux_sym_specialblock_token2] = ACTIONS(107),
    [aux_sym_specialblock_token3] = ACTIONS(107),
    [aux_sym_specialblock_token4] = ACTIONS(107),
    [aux_sym_specialblock_token5] = ACTIONS(107),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(107),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(107),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(107),
    [anon_sym_COLONcaption_COLON] = ACTIONS(107),
    [anon_sym_COLONitem_COLON] = ACTIONS(107),
    [anon_sym_COLONprev_COLON] = ACTIONS(107),
    [anon_sym_COLONprev2_COLON] = ACTIONS(107),
    [anon_sym_COLONprev3_COLON] = ACTIONS(107),
    [aux_sym_specialinline_token1] = ACTIONS(109),
    [aux_sym_specialinline_token2] = ACTIONS(109),
    [anon_sym_COLONmath_COLON] = ACTIONS(107),
    [anon_sym_COLONcode_COLON] = ACTIONS(107),
    [aux_sym_specialinline_token3] = ACTIONS(107),
    [aux_sym_specialinline_token4] = ACTIONS(107),
    [anon_sym_COLONref_COLON] = ACTIONS(107),
    [anon_sym_COLONprevious_COLON] = ACTIONS(107),
    [anon_sym_COLONurl_COLON] = ACTIONS(107),
    [anon_sym_COLONcite_COLON] = ACTIONS(107),
    [anon_sym_COLONqed_COLON] = ACTIONS(107),
    [anon_sym_COLONtable_COLON] = ACTIONS(107),
    [anon_sym_COLONassume_COLON] = ACTIONS(107),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(107),
    [anon_sym_COLONprove_COLON] = ACTIONS(107),
    [anon_sym_COLONthen_COLON] = ACTIONS(107),
    [anon_sym_COLONnew_COLON] = ACTIONS(107),
    [anon_sym_COLONlet_COLON] = ACTIONS(107),
    [anon_sym_COLONcase_COLON] = ACTIONS(107),
    [anon_sym_COLONdefine_COLON] = ACTIONS(107),
    [anon_sym_COLONwrite_COLON] = ACTIONS(107),
    [anon_sym_COLONwlog_COLON] = ACTIONS(107),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(107),
    [anon_sym_COLONclaim_COLON] = ACTIONS(107),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(107),
    [anon_sym_COLON_COLON2] = ACTIONS(107),
    [anon_sym_COLONdraft_COLON] = ACTIONS(107),
    [anon_sym_COLONnote_COLON] = ACTIONS(107),
    [anon_sym_COLONspan_COLON] = ACTIONS(107),
    [anon_sym_COLONabstract_COLON] = ACTIONS(107),
    [anon_sym_COLONauthor_COLON] = ACTIONS(107),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(107),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(107),
    [anon_sym_COLONitemize_COLON] = ACTIONS(107),
    [anon_sym_COLONlemma_COLON] = ACTIONS(107),
    [anon_sym_COLONfigure_COLON] = ACTIONS(107),
    [anon_sym_COLONp_COLON] = ACTIONS(107),
    [anon_sym_COLONproof_COLON] = ACTIONS(107),
    [anon_sym_COLONproposition_COLON] = ACTIONS(107),
    [anon_sym_COLONremark_COLON] = ACTIONS(107),
    [anon_sym_COLONsection_COLON] = ACTIONS(107),
    [anon_sym_COLONsketch_COLON] = ACTIONS(107),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(107),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(107),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(107),
    [anon_sym_COLONstep_COLON] = ACTIONS(107),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(107),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(107),
    [anon_sym_COLONemail_COLON] = ACTIONS(107),
    [anon_sym_COLONlabel_COLON] = ACTIONS(107),
    [anon_sym_COLONname_COLON] = ACTIONS(107),
    [anon_sym_COLONreftext_COLON] = ACTIONS(107),
    [anon_sym_COLONtitle_COLON] = ACTIONS(107),
    [anon_sym_COLONgoal_COLON] = ACTIONS(107),
    [anon_sym_COLONnonum_COLON] = ACTIONS(107),
    [anon_sym_COLONstrong_COLON] = ACTIONS(107),
    [anon_sym_COLONemphas_COLON] = ACTIONS(107),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(107),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(107),
    [anon_sym_COLONMSC_COLON] = ACTIONS(107),
    [anon_sym_COLONtypes_COLON] = ACTIONS(107),
    [anon_sym_COLONdate_COLON] = ACTIONS(107),
    [anon_sym_COLONpath_COLON] = ACTIONS(107),
    [anon_sym_COLONscale_COLON] = ACTIONS(107),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(107),
  },
  [11] = {
    [anon_sym_COLON_COLON] = ACTIONS(111),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(111),
    [anon_sym_COLONappendix_COLON] = ACTIONS(111),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(111),
    [anon_sym_COLONtoc_COLON] = ACTIONS(111),
    [aux_sym_specialblock_token1] = ACTIONS(111),
    [aux_sym_specialblock_token2] = ACTIONS(111),
    [aux_sym_specialblock_token3] = ACTIONS(111),
    [aux_sym_specialblock_token4] = ACTIONS(111),
    [aux_sym_specialblock_token5] = ACTIONS(111),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(111),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(111),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(111),
    [anon_sym_COLONcaption_COLON] = ACTIONS(111),
    [anon_sym_COLONitem_COLON] = ACTIONS(111),
    [anon_sym_COLONprev_COLON] = ACTIONS(111),
    [anon_sym_COLONprev2_COLON] = ACTIONS(111),
    [anon_sym_COLONprev3_COLON] = ACTIONS(111),
    [aux_sym_specialinline_token1] = ACTIONS(113),
    [aux_sym_specialinline_token2] = ACTIONS(113),
    [anon_sym_COLONmath_COLON] = ACTIONS(111),
    [anon_sym_COLONcode_COLON] = ACTIONS(111),
    [aux_sym_specialinline_token3] = ACTIONS(111),
    [aux_sym_specialinline_token4] = ACTIONS(111),
    [anon_sym_COLONref_COLON] = ACTIONS(111),
    [anon_sym_COLONprevious_COLON] = ACTIONS(111),
    [anon_sym_COLONurl_COLON] = ACTIONS(111),
    [anon_sym_COLONcite_COLON] = ACTIONS(111),
    [anon_sym_COLONqed_COLON] = ACTIONS(111),
    [anon_sym_COLONtable_COLON] = ACTIONS(111),
    [anon_sym_COLONassume_COLON] = ACTIONS(111),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(111),
    [anon_sym_COLONprove_COLON] = ACTIONS(111),
    [anon_sym_COLONthen_COLON] = ACTIONS(111),
    [anon_sym_COLONnew_COLON] = ACTIONS(111),
    [anon_sym_COLONlet_COLON] = ACTIONS(111),
    [anon_sym_COLONcase_COLON] = ACTIONS(111),
    [anon_sym_COLONdefine_COLON] = ACTIONS(111),
    [anon_sym_COLONwrite_COLON] = ACTIONS(111),
    [anon_sym_COLONwlog_COLON] = ACTIONS(111),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(111),
    [anon_sym_COLONclaim_COLON] = ACTIONS(111),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(111),
    [anon_sym_COLON_COLON2] = ACTIONS(111),
    [anon_sym_COLONdraft_COLON] = ACTIONS(111),
    [anon_sym_COLONnote_COLON] = ACTIONS(111),
    [anon_sym_COLONspan_COLON] = ACTIONS(111),
    [anon_sym_COLONabstract_COLON] = ACTIONS(111),
    [anon_sym_COLONauthor_COLON] = ACTIONS(111),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(111),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(111),
    [anon_sym_COLONitemize_COLON] = ACTIONS(111),
    [anon_sym_COLONlemma_COLON] = ACTIONS(111),
    [anon_sym_COLONfigure_COLON] = ACTIONS(111),
    [anon_sym_COLONp_COLON] = ACTIONS(111),
    [anon_sym_COLONproof_COLON] = ACTIONS(111),
    [anon_sym_COLONproposition_COLON] = ACTIONS(111),
    [anon_sym_COLONremark_COLON] = ACTIONS(111),
    [anon_sym_COLONsection_COLON] = ACTIONS(111),
    [anon_sym_COLONsketch_COLON] = ACTIONS(111),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(111),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(111),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(111),
    [anon_sym_COLONstep_COLON] = ACTIONS(111),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(111),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(111),
    [anon_sym_COLONemail_COLON] = ACTIONS(111),
    [anon_sym_COLONlabel_COLON] = ACTIONS(111),
    [anon_sym_COLONname_COLON] = ACTIONS(111),
    [anon_sym_COLONreftext_COLON] = ACTIONS(111),
    [anon_sym_COLONtitle_COLON] = ACTIONS(111),
    [anon_sym_COLONgoal_COLON] = ACTIONS(111),
    [anon_sym_COLONnonum_COLON] = ACTIONS(111),
    [anon_sym_COLONstrong_COLON] = ACTIONS(111),
    [anon_sym_COLONemphas_COLON] = ACTIONS(111),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(111),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(111),
    [anon_sym_COLONMSC_COLON] = ACTIONS(111),
    [anon_sym_COLONtypes_COLON] = ACTIONS(111),
    [anon_sym_COLONdate_COLON] = ACTIONS(111),
    [anon_sym_COLONpath_COLON] = ACTIONS(111),
    [anon_sym_COLONscale_COLON] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(111),
  },
  [12] = {
    [anon_sym_COLON_COLON] = ACTIONS(115),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(115),
    [anon_sym_COLONappendix_COLON] = ACTIONS(115),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(115),
    [anon_sym_COLONtoc_COLON] = ACTIONS(115),
    [aux_sym_specialblock_token1] = ACTIONS(115),
    [aux_sym_specialblock_token2] = ACTIONS(115),
    [aux_sym_specialblock_token3] = ACTIONS(115),
    [aux_sym_specialblock_token4] = ACTIONS(115),
    [aux_sym_specialblock_token5] = ACTIONS(115),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(115),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(115),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(115),
    [anon_sym_COLONcaption_COLON] = ACTIONS(115),
    [anon_sym_COLONitem_COLON] = ACTIONS(115),
    [anon_sym_COLONprev_COLON] = ACTIONS(115),
    [anon_sym_COLONprev2_COLON] = ACTIONS(115),
    [anon_sym_COLONprev3_COLON] = ACTIONS(115),
    [aux_sym_specialinline_token1] = ACTIONS(117),
    [aux_sym_specialinline_token2] = ACTIONS(117),
    [anon_sym_COLONmath_COLON] = ACTIONS(115),
    [anon_sym_COLONcode_COLON] = ACTIONS(115),
    [aux_sym_specialinline_token3] = ACTIONS(115),
    [aux_sym_specialinline_token4] = ACTIONS(115),
    [anon_sym_COLONref_COLON] = ACTIONS(115),
    [anon_sym_COLONprevious_COLON] = ACTIONS(115),
    [anon_sym_COLONurl_COLON] = ACTIONS(115),
    [anon_sym_COLONcite_COLON] = ACTIONS(115),
    [anon_sym_COLONqed_COLON] = ACTIONS(115),
    [anon_sym_COLONtable_COLON] = ACTIONS(115),
    [anon_sym_COLONassume_COLON] = ACTIONS(115),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(115),
    [anon_sym_COLONprove_COLON] = ACTIONS(115),
    [anon_sym_COLONthen_COLON] = ACTIONS(115),
    [anon_sym_COLONnew_COLON] = ACTIONS(115),
    [anon_sym_COLONlet_COLON] = ACTIONS(115),
    [anon_sym_COLONcase_COLON] = ACTIONS(115),
    [anon_sym_COLONdefine_COLON] = ACTIONS(115),
    [anon_sym_COLONwrite_COLON] = ACTIONS(115),
    [anon_sym_COLONwlog_COLON] = ACTIONS(115),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(115),
    [anon_sym_COLONclaim_COLON] = ACTIONS(115),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(115),
    [anon_sym_COLON_COLON2] = ACTIONS(115),
    [anon_sym_COLONdraft_COLON] = ACTIONS(115),
    [anon_sym_COLONnote_COLON] = ACTIONS(115),
    [anon_sym_COLONspan_COLON] = ACTIONS(115),
    [anon_sym_COLONabstract_COLON] = ACTIONS(115),
    [anon_sym_COLONauthor_COLON] = ACTIONS(115),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(115),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(115),
    [anon_sym_COLONitemize_COLON] = ACTIONS(115),
    [anon_sym_COLONlemma_COLON] = ACTIONS(115),
    [anon_sym_COLONfigure_COLON] = ACTIONS(115),
    [anon_sym_COLONp_COLON] = ACTIONS(115),
    [anon_sym_COLONproof_COLON] = ACTIONS(115),
    [anon_sym_COLONproposition_COLON] = ACTIONS(115),
    [anon_sym_COLONremark_COLON] = ACTIONS(115),
    [anon_sym_COLONsection_COLON] = ACTIONS(115),
    [anon_sym_COLONsketch_COLON] = ACTIONS(115),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(115),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(115),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(115),
    [anon_sym_COLONstep_COLON] = ACTIONS(115),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(115),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(115),
    [anon_sym_COLONemail_COLON] = ACTIONS(115),
    [anon_sym_COLONlabel_COLON] = ACTIONS(115),
    [anon_sym_COLONname_COLON] = ACTIONS(115),
    [anon_sym_COLONreftext_COLON] = ACTIONS(115),
    [anon_sym_COLONtitle_COLON] = ACTIONS(115),
    [anon_sym_COLONgoal_COLON] = ACTIONS(115),
    [anon_sym_COLONnonum_COLON] = ACTIONS(115),
    [anon_sym_COLONstrong_COLON] = ACTIONS(115),
    [anon_sym_COLONemphas_COLON] = ACTIONS(115),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(115),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(115),
    [anon_sym_COLONMSC_COLON] = ACTIONS(115),
    [anon_sym_COLONtypes_COLON] = ACTIONS(115),
    [anon_sym_COLONdate_COLON] = ACTIONS(115),
    [anon_sym_COLONpath_COLON] = ACTIONS(115),
    [anon_sym_COLONscale_COLON] = ACTIONS(115),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(115),
  },
  [13] = {
    [anon_sym_COLON_COLON] = ACTIONS(119),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(119),
    [anon_sym_COLONappendix_COLON] = ACTIONS(119),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(119),
    [anon_sym_COLONtoc_COLON] = ACTIONS(119),
    [aux_sym_specialblock_token1] = ACTIONS(119),
    [aux_sym_specialblock_token2] = ACTIONS(119),
    [aux_sym_specialblock_token3] = ACTIONS(119),
    [aux_sym_specialblock_token4] = ACTIONS(119),
    [aux_sym_specialblock_token5] = ACTIONS(119),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(119),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(119),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(119),
    [anon_sym_COLONcaption_COLON] = ACTIONS(119),
    [anon_sym_COLONitem_COLON] = ACTIONS(119),
    [anon_sym_COLONprev_COLON] = ACTIONS(119),
    [anon_sym_COLONprev2_COLON] = ACTIONS(119),
    [anon_sym_COLONprev3_COLON] = ACTIONS(119),
    [aux_sym_specialinline_token1] = ACTIONS(121),
    [aux_sym_specialinline_token2] = ACTIONS(121),
    [anon_sym_COLONmath_COLON] = ACTIONS(119),
    [anon_sym_COLONcode_COLON] = ACTIONS(119),
    [aux_sym_specialinline_token3] = ACTIONS(119),
    [aux_sym_specialinline_token4] = ACTIONS(119),
    [anon_sym_COLONref_COLON] = ACTIONS(119),
    [anon_sym_COLONprevious_COLON] = ACTIONS(119),
    [anon_sym_COLONurl_COLON] = ACTIONS(119),
    [anon_sym_COLONcite_COLON] = ACTIONS(119),
    [anon_sym_COLONqed_COLON] = ACTIONS(119),
    [anon_sym_COLONtable_COLON] = ACTIONS(119),
    [anon_sym_COLONassume_COLON] = ACTIONS(119),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(119),
    [anon_sym_COLONprove_COLON] = ACTIONS(119),
    [anon_sym_COLONthen_COLON] = ACTIONS(119),
    [anon_sym_COLONnew_COLON] = ACTIONS(119),
    [anon_sym_COLONlet_COLON] = ACTIONS(119),
    [anon_sym_COLONcase_COLON] = ACTIONS(119),
    [anon_sym_COLONdefine_COLON] = ACTIONS(119),
    [anon_sym_COLONwrite_COLON] = ACTIONS(119),
    [anon_sym_COLONwlog_COLON] = ACTIONS(119),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(119),
    [anon_sym_COLONclaim_COLON] = ACTIONS(119),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(119),
    [anon_sym_COLON_COLON2] = ACTIONS(119),
    [anon_sym_COLONdraft_COLON] = ACTIONS(119),
    [anon_sym_COLONnote_COLON] = ACTIONS(119),
    [anon_sym_COLONspan_COLON] = ACTIONS(119),
    [anon_sym_COLONabstract_COLON] = ACTIONS(119),
    [anon_sym_COLONauthor_COLON] = ACTIONS(119),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(119),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(119),
    [anon_sym_COLONitemize_COLON] = ACTIONS(119),
    [anon_sym_COLONlemma_COLON] = ACTIONS(119),
    [anon_sym_COLONfigure_COLON] = ACTIONS(119),
    [anon_sym_COLONp_COLON] = ACTIONS(119),
    [anon_sym_COLONproof_COLON] = ACTIONS(119),
    [anon_sym_COLONproposition_COLON] = ACTIONS(119),
    [anon_sym_COLONremark_COLON] = ACTIONS(119),
    [anon_sym_COLONsection_COLON] = ACTIONS(119),
    [anon_sym_COLONsketch_COLON] = ACTIONS(119),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(119),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(119),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(119),
    [anon_sym_COLONstep_COLON] = ACTIONS(119),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(119),
    [anon_sym_COLONaffiliation_COLON] = ACTIONS(119),
    [anon_sym_COLONemail_COLON] = ACTIONS(119),
    [anon_sym_COLONlabel_COLON] = ACTIONS(119),
    [anon_sym_COLONname_COLON] = ACTIONS(119),
    [anon_sym_COLONreftext_COLON] = ACTIONS(119),
    [anon_sym_COLONtitle_COLON] = ACTIONS(119),
    [anon_sym_COLONgoal_COLON] = ACTIONS(119),
    [anon_sym_COLONnonum_COLON] = ACTIONS(119),
    [anon_sym_COLONstrong_COLON] = ACTIONS(119),
    [anon_sym_COLONemphas_COLON] = ACTIONS(119),
    [anon_sym_COLONisclaim_COLON] = ACTIONS(119),
    [anon_sym_COLONkeywords_COLON] = ACTIONS(119),
    [anon_sym_COLONMSC_COLON] = ACTIONS(119),
    [anon_sym_COLONtypes_COLON] = ACTIONS(119),
    [anon_sym_COLONdate_COLON] = ACTIONS(119),
    [anon_sym_COLONpath_COLON] = ACTIONS(119),
    [anon_sym_COLONscale_COLON] = ACTIONS(119),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(119),
  },
  [14] = {
    [sym_block] = STATE(16),
    [sym_paragraph] = STATE(16),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(16),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(16),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(123),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [15] = {
    [sym_block] = STATE(19),
    [sym_paragraph] = STATE(19),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(19),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(19),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(125),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [16] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(127),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [17] = {
    [sym_block] = STATE(23),
    [sym_paragraph] = STATE(23),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(23),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(23),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(129),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [18] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(131),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [19] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(133),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [20] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(135),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(137),
    [anon_sym_COLONappendix_COLON] = ACTIONS(140),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(143),
    [anon_sym_COLONtoc_COLON] = ACTIONS(143),
    [aux_sym_specialblock_token1] = ACTIONS(146),
    [aux_sym_specialblock_token2] = ACTIONS(146),
    [aux_sym_specialblock_token3] = ACTIONS(146),
    [aux_sym_specialblock_token4] = ACTIONS(149),
    [aux_sym_specialblock_token5] = ACTIONS(152),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(155),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(158),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(155),
    [anon_sym_COLONcaption_COLON] = ACTIONS(161),
    [anon_sym_COLONitem_COLON] = ACTIONS(164),
    [anon_sym_COLONprev_COLON] = ACTIONS(167),
    [anon_sym_COLONprev2_COLON] = ACTIONS(167),
    [anon_sym_COLONprev3_COLON] = ACTIONS(167),
    [aux_sym_specialinline_token1] = ACTIONS(170),
    [aux_sym_specialinline_token2] = ACTIONS(173),
    [anon_sym_COLONmath_COLON] = ACTIONS(176),
    [anon_sym_COLONcode_COLON] = ACTIONS(179),
    [aux_sym_specialinline_token3] = ACTIONS(182),
    [aux_sym_specialinline_token4] = ACTIONS(185),
    [anon_sym_COLONref_COLON] = ACTIONS(188),
    [anon_sym_COLONprevious_COLON] = ACTIONS(191),
    [anon_sym_COLONurl_COLON] = ACTIONS(194),
    [anon_sym_COLONcite_COLON] = ACTIONS(197),
    [anon_sym_COLONqed_COLON] = ACTIONS(200),
    [anon_sym_COLONtable_COLON] = ACTIONS(203),
    [anon_sym_COLONassume_COLON] = ACTIONS(206),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(206),
    [anon_sym_COLONprove_COLON] = ACTIONS(206),
    [anon_sym_COLONthen_COLON] = ACTIONS(206),
    [anon_sym_COLONnew_COLON] = ACTIONS(206),
    [anon_sym_COLONlet_COLON] = ACTIONS(206),
    [anon_sym_COLONcase_COLON] = ACTIONS(206),
    [anon_sym_COLONdefine_COLON] = ACTIONS(206),
    [anon_sym_COLONwrite_COLON] = ACTIONS(206),
    [anon_sym_COLONwlog_COLON] = ACTIONS(206),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(206),
    [anon_sym_COLONclaim_COLON] = ACTIONS(206),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(206),
    [anon_sym_COLON_COLON2] = ACTIONS(206),
    [anon_sym_COLONdraft_COLON] = ACTIONS(209),
    [anon_sym_COLONnote_COLON] = ACTIONS(209),
    [anon_sym_COLONspan_COLON] = ACTIONS(209),
    [anon_sym_COLONabstract_COLON] = ACTIONS(212),
    [anon_sym_COLONauthor_COLON] = ACTIONS(212),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(212),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(212),
    [anon_sym_COLONitemize_COLON] = ACTIONS(212),
    [anon_sym_COLONlemma_COLON] = ACTIONS(212),
    [anon_sym_COLONfigure_COLON] = ACTIONS(212),
    [anon_sym_COLONp_COLON] = ACTIONS(212),
    [anon_sym_COLONproof_COLON] = ACTIONS(212),
    [anon_sym_COLONproposition_COLON] = ACTIONS(212),
    [anon_sym_COLONremark_COLON] = ACTIONS(212),
    [anon_sym_COLONsection_COLON] = ACTIONS(212),
    [anon_sym_COLONsketch_COLON] = ACTIONS(212),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(212),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(212),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(212),
    [anon_sym_COLONstep_COLON] = ACTIONS(212),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(212),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(215),
  },
  [21] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(218),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [22] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(220),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [23] = {
    [sym_block] = STATE(20),
    [sym_paragraph] = STATE(20),
    [sym_inline] = STATE(82),
    [sym_construct] = STATE(82),
    [sym_specialblock] = STATE(20),
    [sym_caption] = STATE(39),
    [sym_item] = STATE(39),
    [sym_specialinline] = STATE(82),
    [sym_specialconstruct] = STATE(82),
    [sym_table] = STATE(43),
    [aux_sym_source_file_repeat1] = STATE(20),
    [aux_sym_paragraph_repeat1] = STATE(82),
    [anon_sym_COLON_COLON] = ACTIONS(222),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(9),
    [anon_sym_COLONappendix_COLON] = ACTIONS(11),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(13),
    [anon_sym_COLONtoc_COLON] = ACTIONS(13),
    [aux_sym_specialblock_token1] = ACTIONS(15),
    [aux_sym_specialblock_token2] = ACTIONS(15),
    [aux_sym_specialblock_token3] = ACTIONS(15),
    [aux_sym_specialblock_token4] = ACTIONS(17),
    [aux_sym_specialblock_token5] = ACTIONS(19),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(21),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(23),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(21),
    [anon_sym_COLONcaption_COLON] = ACTIONS(25),
    [anon_sym_COLONitem_COLON] = ACTIONS(27),
    [anon_sym_COLONprev_COLON] = ACTIONS(29),
    [anon_sym_COLONprev2_COLON] = ACTIONS(29),
    [anon_sym_COLONprev3_COLON] = ACTIONS(29),
    [aux_sym_specialinline_token1] = ACTIONS(31),
    [aux_sym_specialinline_token2] = ACTIONS(33),
    [anon_sym_COLONmath_COLON] = ACTIONS(35),
    [anon_sym_COLONcode_COLON] = ACTIONS(37),
    [aux_sym_specialinline_token3] = ACTIONS(39),
    [aux_sym_specialinline_token4] = ACTIONS(41),
    [anon_sym_COLONref_COLON] = ACTIONS(43),
    [anon_sym_COLONprevious_COLON] = ACTIONS(45),
    [anon_sym_COLONurl_COLON] = ACTIONS(47),
    [anon_sym_COLONcite_COLON] = ACTIONS(49),
    [anon_sym_COLONqed_COLON] = ACTIONS(51),
    [anon_sym_COLONtable_COLON] = ACTIONS(53),
    [anon_sym_COLONassume_COLON] = ACTIONS(55),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(55),
    [anon_sym_COLONprove_COLON] = ACTIONS(55),
    [anon_sym_COLONthen_COLON] = ACTIONS(55),
    [anon_sym_COLONnew_COLON] = ACTIONS(55),
    [anon_sym_COLONlet_COLON] = ACTIONS(55),
    [anon_sym_COLONcase_COLON] = ACTIONS(55),
    [anon_sym_COLONdefine_COLON] = ACTIONS(55),
    [anon_sym_COLONwrite_COLON] = ACTIONS(55),
    [anon_sym_COLONwlog_COLON] = ACTIONS(55),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(55),
    [anon_sym_COLONclaim_COLON] = ACTIONS(55),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(55),
    [anon_sym_COLON_COLON2] = ACTIONS(55),
    [anon_sym_COLONdraft_COLON] = ACTIONS(57),
    [anon_sym_COLONnote_COLON] = ACTIONS(57),
    [anon_sym_COLONspan_COLON] = ACTIONS(57),
    [anon_sym_COLONabstract_COLON] = ACTIONS(59),
    [anon_sym_COLONauthor_COLON] = ACTIONS(59),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(59),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(59),
    [anon_sym_COLONitemize_COLON] = ACTIONS(59),
    [anon_sym_COLONlemma_COLON] = ACTIONS(59),
    [anon_sym_COLONfigure_COLON] = ACTIONS(59),
    [anon_sym_COLONp_COLON] = ACTIONS(59),
    [anon_sym_COLONproof_COLON] = ACTIONS(59),
    [anon_sym_COLONproposition_COLON] = ACTIONS(59),
    [anon_sym_COLONremark_COLON] = ACTIONS(59),
    [anon_sym_COLONsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsketch_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(59),
    [anon_sym_COLONstep_COLON] = ACTIONS(59),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(59),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(69),
  },
  [24] = {
    [anon_sym_COLON_COLON] = ACTIONS(224),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(224),
    [anon_sym_COLONappendix_COLON] = ACTIONS(224),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(224),
    [anon_sym_COLONtoc_COLON] = ACTIONS(224),
    [aux_sym_specialblock_token1] = ACTIONS(224),
    [aux_sym_specialblock_token2] = ACTIONS(224),
    [aux_sym_specialblock_token3] = ACTIONS(224),
    [aux_sym_specialblock_token4] = ACTIONS(224),
    [aux_sym_specialblock_token5] = ACTIONS(224),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(224),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(224),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(224),
    [anon_sym_COLONcaption_COLON] = ACTIONS(224),
    [anon_sym_COLONitem_COLON] = ACTIONS(224),
    [anon_sym_COLONprev_COLON] = ACTIONS(224),
    [anon_sym_COLONprev2_COLON] = ACTIONS(224),
    [anon_sym_COLONprev3_COLON] = ACTIONS(224),
    [aux_sym_specialinline_token1] = ACTIONS(226),
    [aux_sym_specialinline_token2] = ACTIONS(226),
    [anon_sym_COLONmath_COLON] = ACTIONS(224),
    [anon_sym_COLONcode_COLON] = ACTIONS(224),
    [aux_sym_specialinline_token3] = ACTIONS(224),
    [aux_sym_specialinline_token4] = ACTIONS(224),
    [anon_sym_COLONref_COLON] = ACTIONS(224),
    [anon_sym_COLONprevious_COLON] = ACTIONS(224),
    [anon_sym_COLONurl_COLON] = ACTIONS(224),
    [anon_sym_COLONcite_COLON] = ACTIONS(224),
    [anon_sym_COLONqed_COLON] = ACTIONS(224),
    [anon_sym_COLONtable_COLON] = ACTIONS(224),
    [anon_sym_COLONassume_COLON] = ACTIONS(224),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(224),
    [anon_sym_COLONprove_COLON] = ACTIONS(224),
    [anon_sym_COLONthen_COLON] = ACTIONS(224),
    [anon_sym_COLONnew_COLON] = ACTIONS(224),
    [anon_sym_COLONlet_COLON] = ACTIONS(224),
    [anon_sym_COLONcase_COLON] = ACTIONS(224),
    [anon_sym_COLONdefine_COLON] = ACTIONS(224),
    [anon_sym_COLONwrite_COLON] = ACTIONS(224),
    [anon_sym_COLONwlog_COLON] = ACTIONS(224),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(224),
    [anon_sym_COLONclaim_COLON] = ACTIONS(224),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(224),
    [anon_sym_COLON_COLON2] = ACTIONS(224),
    [anon_sym_COLONdraft_COLON] = ACTIONS(224),
    [anon_sym_COLONnote_COLON] = ACTIONS(224),
    [anon_sym_COLONspan_COLON] = ACTIONS(224),
    [anon_sym_COLONabstract_COLON] = ACTIONS(224),
    [anon_sym_COLONauthor_COLON] = ACTIONS(224),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(224),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(224),
    [anon_sym_COLONitemize_COLON] = ACTIONS(224),
    [anon_sym_COLONlemma_COLON] = ACTIONS(224),
    [anon_sym_COLONfigure_COLON] = ACTIONS(224),
    [anon_sym_COLONp_COLON] = ACTIONS(224),
    [anon_sym_COLONproof_COLON] = ACTIONS(224),
    [anon_sym_COLONproposition_COLON] = ACTIONS(224),
    [anon_sym_COLONremark_COLON] = ACTIONS(224),
    [anon_sym_COLONsection_COLON] = ACTIONS(224),
    [anon_sym_COLONsketch_COLON] = ACTIONS(224),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(224),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(224),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(224),
    [anon_sym_COLONstep_COLON] = ACTIONS(224),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(224),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(224),
  },
  [25] = {
    [anon_sym_COLON_COLON] = ACTIONS(228),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(228),
    [anon_sym_COLONappendix_COLON] = ACTIONS(228),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(228),
    [anon_sym_COLONtoc_COLON] = ACTIONS(228),
    [aux_sym_specialblock_token1] = ACTIONS(228),
    [aux_sym_specialblock_token2] = ACTIONS(228),
    [aux_sym_specialblock_token3] = ACTIONS(228),
    [aux_sym_specialblock_token4] = ACTIONS(228),
    [aux_sym_specialblock_token5] = ACTIONS(228),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(228),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(228),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(228),
    [anon_sym_COLONcaption_COLON] = ACTIONS(228),
    [anon_sym_COLONitem_COLON] = ACTIONS(228),
    [anon_sym_COLONprev_COLON] = ACTIONS(228),
    [anon_sym_COLONprev2_COLON] = ACTIONS(228),
    [anon_sym_COLONprev3_COLON] = ACTIONS(228),
    [aux_sym_specialinline_token1] = ACTIONS(230),
    [aux_sym_specialinline_token2] = ACTIONS(230),
    [anon_sym_COLONmath_COLON] = ACTIONS(228),
    [anon_sym_COLONcode_COLON] = ACTIONS(228),
    [aux_sym_specialinline_token3] = ACTIONS(228),
    [aux_sym_specialinline_token4] = ACTIONS(228),
    [anon_sym_COLONref_COLON] = ACTIONS(228),
    [anon_sym_COLONprevious_COLON] = ACTIONS(228),
    [anon_sym_COLONurl_COLON] = ACTIONS(228),
    [anon_sym_COLONcite_COLON] = ACTIONS(228),
    [anon_sym_COLONqed_COLON] = ACTIONS(228),
    [anon_sym_COLONtable_COLON] = ACTIONS(228),
    [anon_sym_COLONassume_COLON] = ACTIONS(228),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(228),
    [anon_sym_COLONprove_COLON] = ACTIONS(228),
    [anon_sym_COLONthen_COLON] = ACTIONS(228),
    [anon_sym_COLONnew_COLON] = ACTIONS(228),
    [anon_sym_COLONlet_COLON] = ACTIONS(228),
    [anon_sym_COLONcase_COLON] = ACTIONS(228),
    [anon_sym_COLONdefine_COLON] = ACTIONS(228),
    [anon_sym_COLONwrite_COLON] = ACTIONS(228),
    [anon_sym_COLONwlog_COLON] = ACTIONS(228),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(228),
    [anon_sym_COLONclaim_COLON] = ACTIONS(228),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(228),
    [anon_sym_COLON_COLON2] = ACTIONS(228),
    [anon_sym_COLONdraft_COLON] = ACTIONS(228),
    [anon_sym_COLONnote_COLON] = ACTIONS(228),
    [anon_sym_COLONspan_COLON] = ACTIONS(228),
    [anon_sym_COLONabstract_COLON] = ACTIONS(228),
    [anon_sym_COLONauthor_COLON] = ACTIONS(228),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(228),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(228),
    [anon_sym_COLONitemize_COLON] = ACTIONS(228),
    [anon_sym_COLONlemma_COLON] = ACTIONS(228),
    [anon_sym_COLONfigure_COLON] = ACTIONS(228),
    [anon_sym_COLONp_COLON] = ACTIONS(228),
    [anon_sym_COLONproof_COLON] = ACTIONS(228),
    [anon_sym_COLONproposition_COLON] = ACTIONS(228),
    [anon_sym_COLONremark_COLON] = ACTIONS(228),
    [anon_sym_COLONsection_COLON] = ACTIONS(228),
    [anon_sym_COLONsketch_COLON] = ACTIONS(228),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(228),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(228),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(228),
    [anon_sym_COLONstep_COLON] = ACTIONS(228),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(228),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(228),
  },
  [26] = {
    [anon_sym_COLON_COLON] = ACTIONS(232),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(232),
    [anon_sym_COLONappendix_COLON] = ACTIONS(232),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(232),
    [anon_sym_COLONtoc_COLON] = ACTIONS(232),
    [aux_sym_specialblock_token1] = ACTIONS(232),
    [aux_sym_specialblock_token2] = ACTIONS(232),
    [aux_sym_specialblock_token3] = ACTIONS(232),
    [aux_sym_specialblock_token4] = ACTIONS(232),
    [aux_sym_specialblock_token5] = ACTIONS(232),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(232),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(232),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(232),
    [anon_sym_COLONcaption_COLON] = ACTIONS(232),
    [anon_sym_COLONitem_COLON] = ACTIONS(232),
    [anon_sym_COLONprev_COLON] = ACTIONS(232),
    [anon_sym_COLONprev2_COLON] = ACTIONS(232),
    [anon_sym_COLONprev3_COLON] = ACTIONS(232),
    [aux_sym_specialinline_token1] = ACTIONS(234),
    [aux_sym_specialinline_token2] = ACTIONS(234),
    [anon_sym_COLONmath_COLON] = ACTIONS(232),
    [anon_sym_COLONcode_COLON] = ACTIONS(232),
    [aux_sym_specialinline_token3] = ACTIONS(232),
    [aux_sym_specialinline_token4] = ACTIONS(232),
    [anon_sym_COLONref_COLON] = ACTIONS(232),
    [anon_sym_COLONprevious_COLON] = ACTIONS(232),
    [anon_sym_COLONurl_COLON] = ACTIONS(232),
    [anon_sym_COLONcite_COLON] = ACTIONS(232),
    [anon_sym_COLONqed_COLON] = ACTIONS(232),
    [anon_sym_COLONtable_COLON] = ACTIONS(232),
    [anon_sym_COLONassume_COLON] = ACTIONS(232),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(232),
    [anon_sym_COLONprove_COLON] = ACTIONS(232),
    [anon_sym_COLONthen_COLON] = ACTIONS(232),
    [anon_sym_COLONnew_COLON] = ACTIONS(232),
    [anon_sym_COLONlet_COLON] = ACTIONS(232),
    [anon_sym_COLONcase_COLON] = ACTIONS(232),
    [anon_sym_COLONdefine_COLON] = ACTIONS(232),
    [anon_sym_COLONwrite_COLON] = ACTIONS(232),
    [anon_sym_COLONwlog_COLON] = ACTIONS(232),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(232),
    [anon_sym_COLONclaim_COLON] = ACTIONS(232),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(232),
    [anon_sym_COLON_COLON2] = ACTIONS(232),
    [anon_sym_COLONdraft_COLON] = ACTIONS(232),
    [anon_sym_COLONnote_COLON] = ACTIONS(232),
    [anon_sym_COLONspan_COLON] = ACTIONS(232),
    [anon_sym_COLONabstract_COLON] = ACTIONS(232),
    [anon_sym_COLONauthor_COLON] = ACTIONS(232),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(232),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(232),
    [anon_sym_COLONitemize_COLON] = ACTIONS(232),
    [anon_sym_COLONlemma_COLON] = ACTIONS(232),
    [anon_sym_COLONfigure_COLON] = ACTIONS(232),
    [anon_sym_COLONp_COLON] = ACTIONS(232),
    [anon_sym_COLONproof_COLON] = ACTIONS(232),
    [anon_sym_COLONproposition_COLON] = ACTIONS(232),
    [anon_sym_COLONremark_COLON] = ACTIONS(232),
    [anon_sym_COLONsection_COLON] = ACTIONS(232),
    [anon_sym_COLONsketch_COLON] = ACTIONS(232),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(232),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(232),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(232),
    [anon_sym_COLONstep_COLON] = ACTIONS(232),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(232),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(232),
  },
  [27] = {
    [anon_sym_COLON_COLON] = ACTIONS(236),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(236),
    [anon_sym_COLONappendix_COLON] = ACTIONS(236),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(236),
    [anon_sym_COLONtoc_COLON] = ACTIONS(236),
    [aux_sym_specialblock_token1] = ACTIONS(236),
    [aux_sym_specialblock_token2] = ACTIONS(236),
    [aux_sym_specialblock_token3] = ACTIONS(236),
    [aux_sym_specialblock_token4] = ACTIONS(236),
    [aux_sym_specialblock_token5] = ACTIONS(236),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(236),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(236),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(236),
    [anon_sym_COLONcaption_COLON] = ACTIONS(236),
    [anon_sym_COLONitem_COLON] = ACTIONS(236),
    [anon_sym_COLONprev_COLON] = ACTIONS(236),
    [anon_sym_COLONprev2_COLON] = ACTIONS(236),
    [anon_sym_COLONprev3_COLON] = ACTIONS(236),
    [aux_sym_specialinline_token1] = ACTIONS(238),
    [aux_sym_specialinline_token2] = ACTIONS(238),
    [anon_sym_COLONmath_COLON] = ACTIONS(236),
    [anon_sym_COLONcode_COLON] = ACTIONS(236),
    [aux_sym_specialinline_token3] = ACTIONS(236),
    [aux_sym_specialinline_token4] = ACTIONS(236),
    [anon_sym_COLONref_COLON] = ACTIONS(236),
    [anon_sym_COLONprevious_COLON] = ACTIONS(236),
    [anon_sym_COLONurl_COLON] = ACTIONS(236),
    [anon_sym_COLONcite_COLON] = ACTIONS(236),
    [anon_sym_COLONqed_COLON] = ACTIONS(236),
    [anon_sym_COLONtable_COLON] = ACTIONS(236),
    [anon_sym_COLONassume_COLON] = ACTIONS(236),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(236),
    [anon_sym_COLONprove_COLON] = ACTIONS(236),
    [anon_sym_COLONthen_COLON] = ACTIONS(236),
    [anon_sym_COLONnew_COLON] = ACTIONS(236),
    [anon_sym_COLONlet_COLON] = ACTIONS(236),
    [anon_sym_COLONcase_COLON] = ACTIONS(236),
    [anon_sym_COLONdefine_COLON] = ACTIONS(236),
    [anon_sym_COLONwrite_COLON] = ACTIONS(236),
    [anon_sym_COLONwlog_COLON] = ACTIONS(236),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(236),
    [anon_sym_COLONclaim_COLON] = ACTIONS(236),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(236),
    [anon_sym_COLON_COLON2] = ACTIONS(236),
    [anon_sym_COLONdraft_COLON] = ACTIONS(236),
    [anon_sym_COLONnote_COLON] = ACTIONS(236),
    [anon_sym_COLONspan_COLON] = ACTIONS(236),
    [anon_sym_COLONabstract_COLON] = ACTIONS(236),
    [anon_sym_COLONauthor_COLON] = ACTIONS(236),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(236),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(236),
    [anon_sym_COLONitemize_COLON] = ACTIONS(236),
    [anon_sym_COLONlemma_COLON] = ACTIONS(236),
    [anon_sym_COLONfigure_COLON] = ACTIONS(236),
    [anon_sym_COLONp_COLON] = ACTIONS(236),
    [anon_sym_COLONproof_COLON] = ACTIONS(236),
    [anon_sym_COLONproposition_COLON] = ACTIONS(236),
    [anon_sym_COLONremark_COLON] = ACTIONS(236),
    [anon_sym_COLONsection_COLON] = ACTIONS(236),
    [anon_sym_COLONsketch_COLON] = ACTIONS(236),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(236),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(236),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(236),
    [anon_sym_COLONstep_COLON] = ACTIONS(236),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(236),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(236),
  },
  [28] = {
    [anon_sym_COLON_COLON] = ACTIONS(240),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(240),
    [anon_sym_COLONappendix_COLON] = ACTIONS(240),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(240),
    [anon_sym_COLONtoc_COLON] = ACTIONS(240),
    [aux_sym_specialblock_token1] = ACTIONS(240),
    [aux_sym_specialblock_token2] = ACTIONS(240),
    [aux_sym_specialblock_token3] = ACTIONS(240),
    [aux_sym_specialblock_token4] = ACTIONS(240),
    [aux_sym_specialblock_token5] = ACTIONS(240),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(240),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(240),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(240),
    [anon_sym_COLONcaption_COLON] = ACTIONS(240),
    [anon_sym_COLONitem_COLON] = ACTIONS(240),
    [anon_sym_COLONprev_COLON] = ACTIONS(240),
    [anon_sym_COLONprev2_COLON] = ACTIONS(240),
    [anon_sym_COLONprev3_COLON] = ACTIONS(240),
    [aux_sym_specialinline_token1] = ACTIONS(242),
    [aux_sym_specialinline_token2] = ACTIONS(242),
    [anon_sym_COLONmath_COLON] = ACTIONS(240),
    [anon_sym_COLONcode_COLON] = ACTIONS(240),
    [aux_sym_specialinline_token3] = ACTIONS(240),
    [aux_sym_specialinline_token4] = ACTIONS(240),
    [anon_sym_COLONref_COLON] = ACTIONS(240),
    [anon_sym_COLONprevious_COLON] = ACTIONS(240),
    [anon_sym_COLONurl_COLON] = ACTIONS(240),
    [anon_sym_COLONcite_COLON] = ACTIONS(240),
    [anon_sym_COLONqed_COLON] = ACTIONS(240),
    [anon_sym_COLONtable_COLON] = ACTIONS(240),
    [anon_sym_COLONassume_COLON] = ACTIONS(240),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(240),
    [anon_sym_COLONprove_COLON] = ACTIONS(240),
    [anon_sym_COLONthen_COLON] = ACTIONS(240),
    [anon_sym_COLONnew_COLON] = ACTIONS(240),
    [anon_sym_COLONlet_COLON] = ACTIONS(240),
    [anon_sym_COLONcase_COLON] = ACTIONS(240),
    [anon_sym_COLONdefine_COLON] = ACTIONS(240),
    [anon_sym_COLONwrite_COLON] = ACTIONS(240),
    [anon_sym_COLONwlog_COLON] = ACTIONS(240),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(240),
    [anon_sym_COLONclaim_COLON] = ACTIONS(240),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(240),
    [anon_sym_COLON_COLON2] = ACTIONS(240),
    [anon_sym_COLONdraft_COLON] = ACTIONS(240),
    [anon_sym_COLONnote_COLON] = ACTIONS(240),
    [anon_sym_COLONspan_COLON] = ACTIONS(240),
    [anon_sym_COLONabstract_COLON] = ACTIONS(240),
    [anon_sym_COLONauthor_COLON] = ACTIONS(240),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(240),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(240),
    [anon_sym_COLONitemize_COLON] = ACTIONS(240),
    [anon_sym_COLONlemma_COLON] = ACTIONS(240),
    [anon_sym_COLONfigure_COLON] = ACTIONS(240),
    [anon_sym_COLONp_COLON] = ACTIONS(240),
    [anon_sym_COLONproof_COLON] = ACTIONS(240),
    [anon_sym_COLONproposition_COLON] = ACTIONS(240),
    [anon_sym_COLONremark_COLON] = ACTIONS(240),
    [anon_sym_COLONsection_COLON] = ACTIONS(240),
    [anon_sym_COLONsketch_COLON] = ACTIONS(240),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(240),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(240),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(240),
    [anon_sym_COLONstep_COLON] = ACTIONS(240),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(240),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(240),
  },
  [29] = {
    [anon_sym_COLON_COLON] = ACTIONS(244),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(244),
    [anon_sym_COLONappendix_COLON] = ACTIONS(244),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(244),
    [anon_sym_COLONtoc_COLON] = ACTIONS(244),
    [aux_sym_specialblock_token1] = ACTIONS(244),
    [aux_sym_specialblock_token2] = ACTIONS(244),
    [aux_sym_specialblock_token3] = ACTIONS(244),
    [aux_sym_specialblock_token4] = ACTIONS(244),
    [aux_sym_specialblock_token5] = ACTIONS(244),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(244),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(244),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(244),
    [anon_sym_COLONcaption_COLON] = ACTIONS(244),
    [anon_sym_COLONitem_COLON] = ACTIONS(244),
    [anon_sym_COLONprev_COLON] = ACTIONS(244),
    [anon_sym_COLONprev2_COLON] = ACTIONS(244),
    [anon_sym_COLONprev3_COLON] = ACTIONS(244),
    [aux_sym_specialinline_token1] = ACTIONS(246),
    [aux_sym_specialinline_token2] = ACTIONS(246),
    [anon_sym_COLONmath_COLON] = ACTIONS(244),
    [anon_sym_COLONcode_COLON] = ACTIONS(244),
    [aux_sym_specialinline_token3] = ACTIONS(244),
    [aux_sym_specialinline_token4] = ACTIONS(244),
    [anon_sym_COLONref_COLON] = ACTIONS(244),
    [anon_sym_COLONprevious_COLON] = ACTIONS(244),
    [anon_sym_COLONurl_COLON] = ACTIONS(244),
    [anon_sym_COLONcite_COLON] = ACTIONS(244),
    [anon_sym_COLONqed_COLON] = ACTIONS(244),
    [anon_sym_COLONtable_COLON] = ACTIONS(244),
    [anon_sym_COLONassume_COLON] = ACTIONS(244),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(244),
    [anon_sym_COLONprove_COLON] = ACTIONS(244),
    [anon_sym_COLONthen_COLON] = ACTIONS(244),
    [anon_sym_COLONnew_COLON] = ACTIONS(244),
    [anon_sym_COLONlet_COLON] = ACTIONS(244),
    [anon_sym_COLONcase_COLON] = ACTIONS(244),
    [anon_sym_COLONdefine_COLON] = ACTIONS(244),
    [anon_sym_COLONwrite_COLON] = ACTIONS(244),
    [anon_sym_COLONwlog_COLON] = ACTIONS(244),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(244),
    [anon_sym_COLONclaim_COLON] = ACTIONS(244),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(244),
    [anon_sym_COLON_COLON2] = ACTIONS(244),
    [anon_sym_COLONdraft_COLON] = ACTIONS(244),
    [anon_sym_COLONnote_COLON] = ACTIONS(244),
    [anon_sym_COLONspan_COLON] = ACTIONS(244),
    [anon_sym_COLONabstract_COLON] = ACTIONS(244),
    [anon_sym_COLONauthor_COLON] = ACTIONS(244),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(244),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(244),
    [anon_sym_COLONitemize_COLON] = ACTIONS(244),
    [anon_sym_COLONlemma_COLON] = ACTIONS(244),
    [anon_sym_COLONfigure_COLON] = ACTIONS(244),
    [anon_sym_COLONp_COLON] = ACTIONS(244),
    [anon_sym_COLONproof_COLON] = ACTIONS(244),
    [anon_sym_COLONproposition_COLON] = ACTIONS(244),
    [anon_sym_COLONremark_COLON] = ACTIONS(244),
    [anon_sym_COLONsection_COLON] = ACTIONS(244),
    [anon_sym_COLONsketch_COLON] = ACTIONS(244),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(244),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(244),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(244),
    [anon_sym_COLONstep_COLON] = ACTIONS(244),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(244),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(244),
  },
  [30] = {
    [anon_sym_COLON_COLON] = ACTIONS(248),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(248),
    [anon_sym_COLONappendix_COLON] = ACTIONS(248),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(248),
    [anon_sym_COLONtoc_COLON] = ACTIONS(248),
    [aux_sym_specialblock_token1] = ACTIONS(248),
    [aux_sym_specialblock_token2] = ACTIONS(248),
    [aux_sym_specialblock_token3] = ACTIONS(248),
    [aux_sym_specialblock_token4] = ACTIONS(248),
    [aux_sym_specialblock_token5] = ACTIONS(248),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(248),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(248),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(248),
    [anon_sym_COLONcaption_COLON] = ACTIONS(248),
    [anon_sym_COLONitem_COLON] = ACTIONS(248),
    [anon_sym_COLONprev_COLON] = ACTIONS(248),
    [anon_sym_COLONprev2_COLON] = ACTIONS(248),
    [anon_sym_COLONprev3_COLON] = ACTIONS(248),
    [aux_sym_specialinline_token1] = ACTIONS(250),
    [aux_sym_specialinline_token2] = ACTIONS(250),
    [anon_sym_COLONmath_COLON] = ACTIONS(248),
    [anon_sym_COLONcode_COLON] = ACTIONS(248),
    [aux_sym_specialinline_token3] = ACTIONS(248),
    [aux_sym_specialinline_token4] = ACTIONS(248),
    [anon_sym_COLONref_COLON] = ACTIONS(248),
    [anon_sym_COLONprevious_COLON] = ACTIONS(248),
    [anon_sym_COLONurl_COLON] = ACTIONS(248),
    [anon_sym_COLONcite_COLON] = ACTIONS(248),
    [anon_sym_COLONqed_COLON] = ACTIONS(248),
    [anon_sym_COLONtable_COLON] = ACTIONS(248),
    [anon_sym_COLONassume_COLON] = ACTIONS(248),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(248),
    [anon_sym_COLONprove_COLON] = ACTIONS(248),
    [anon_sym_COLONthen_COLON] = ACTIONS(248),
    [anon_sym_COLONnew_COLON] = ACTIONS(248),
    [anon_sym_COLONlet_COLON] = ACTIONS(248),
    [anon_sym_COLONcase_COLON] = ACTIONS(248),
    [anon_sym_COLONdefine_COLON] = ACTIONS(248),
    [anon_sym_COLONwrite_COLON] = ACTIONS(248),
    [anon_sym_COLONwlog_COLON] = ACTIONS(248),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(248),
    [anon_sym_COLONclaim_COLON] = ACTIONS(248),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(248),
    [anon_sym_COLON_COLON2] = ACTIONS(248),
    [anon_sym_COLONdraft_COLON] = ACTIONS(248),
    [anon_sym_COLONnote_COLON] = ACTIONS(248),
    [anon_sym_COLONspan_COLON] = ACTIONS(248),
    [anon_sym_COLONabstract_COLON] = ACTIONS(248),
    [anon_sym_COLONauthor_COLON] = ACTIONS(248),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(248),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(248),
    [anon_sym_COLONitemize_COLON] = ACTIONS(248),
    [anon_sym_COLONlemma_COLON] = ACTIONS(248),
    [anon_sym_COLONfigure_COLON] = ACTIONS(248),
    [anon_sym_COLONp_COLON] = ACTIONS(248),
    [anon_sym_COLONproof_COLON] = ACTIONS(248),
    [anon_sym_COLONproposition_COLON] = ACTIONS(248),
    [anon_sym_COLONremark_COLON] = ACTIONS(248),
    [anon_sym_COLONsection_COLON] = ACTIONS(248),
    [anon_sym_COLONsketch_COLON] = ACTIONS(248),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(248),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(248),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(248),
    [anon_sym_COLONstep_COLON] = ACTIONS(248),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(248),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(248),
  },
  [31] = {
    [anon_sym_COLON_COLON] = ACTIONS(252),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(252),
    [anon_sym_COLONappendix_COLON] = ACTIONS(252),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(252),
    [anon_sym_COLONtoc_COLON] = ACTIONS(252),
    [aux_sym_specialblock_token1] = ACTIONS(252),
    [aux_sym_specialblock_token2] = ACTIONS(252),
    [aux_sym_specialblock_token3] = ACTIONS(252),
    [aux_sym_specialblock_token4] = ACTIONS(252),
    [aux_sym_specialblock_token5] = ACTIONS(252),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(252),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(252),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(252),
    [anon_sym_COLONcaption_COLON] = ACTIONS(252),
    [anon_sym_COLONitem_COLON] = ACTIONS(252),
    [anon_sym_COLONprev_COLON] = ACTIONS(252),
    [anon_sym_COLONprev2_COLON] = ACTIONS(252),
    [anon_sym_COLONprev3_COLON] = ACTIONS(252),
    [aux_sym_specialinline_token1] = ACTIONS(254),
    [aux_sym_specialinline_token2] = ACTIONS(254),
    [anon_sym_COLONmath_COLON] = ACTIONS(252),
    [anon_sym_COLONcode_COLON] = ACTIONS(252),
    [aux_sym_specialinline_token3] = ACTIONS(252),
    [aux_sym_specialinline_token4] = ACTIONS(252),
    [anon_sym_COLONref_COLON] = ACTIONS(252),
    [anon_sym_COLONprevious_COLON] = ACTIONS(252),
    [anon_sym_COLONurl_COLON] = ACTIONS(252),
    [anon_sym_COLONcite_COLON] = ACTIONS(252),
    [anon_sym_COLONqed_COLON] = ACTIONS(252),
    [anon_sym_COLONtable_COLON] = ACTIONS(252),
    [anon_sym_COLONassume_COLON] = ACTIONS(252),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(252),
    [anon_sym_COLONprove_COLON] = ACTIONS(252),
    [anon_sym_COLONthen_COLON] = ACTIONS(252),
    [anon_sym_COLONnew_COLON] = ACTIONS(252),
    [anon_sym_COLONlet_COLON] = ACTIONS(252),
    [anon_sym_COLONcase_COLON] = ACTIONS(252),
    [anon_sym_COLONdefine_COLON] = ACTIONS(252),
    [anon_sym_COLONwrite_COLON] = ACTIONS(252),
    [anon_sym_COLONwlog_COLON] = ACTIONS(252),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(252),
    [anon_sym_COLONclaim_COLON] = ACTIONS(252),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(252),
    [anon_sym_COLON_COLON2] = ACTIONS(252),
    [anon_sym_COLONdraft_COLON] = ACTIONS(252),
    [anon_sym_COLONnote_COLON] = ACTIONS(252),
    [anon_sym_COLONspan_COLON] = ACTIONS(252),
    [anon_sym_COLONabstract_COLON] = ACTIONS(252),
    [anon_sym_COLONauthor_COLON] = ACTIONS(252),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(252),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(252),
    [anon_sym_COLONitemize_COLON] = ACTIONS(252),
    [anon_sym_COLONlemma_COLON] = ACTIONS(252),
    [anon_sym_COLONfigure_COLON] = ACTIONS(252),
    [anon_sym_COLONp_COLON] = ACTIONS(252),
    [anon_sym_COLONproof_COLON] = ACTIONS(252),
    [anon_sym_COLONproposition_COLON] = ACTIONS(252),
    [anon_sym_COLONremark_COLON] = ACTIONS(252),
    [anon_sym_COLONsection_COLON] = ACTIONS(252),
    [anon_sym_COLONsketch_COLON] = ACTIONS(252),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(252),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(252),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(252),
    [anon_sym_COLONstep_COLON] = ACTIONS(252),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(252),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(252),
  },
  [32] = {
    [anon_sym_COLON_COLON] = ACTIONS(256),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(256),
    [anon_sym_COLONappendix_COLON] = ACTIONS(256),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(256),
    [anon_sym_COLONtoc_COLON] = ACTIONS(256),
    [aux_sym_specialblock_token1] = ACTIONS(256),
    [aux_sym_specialblock_token2] = ACTIONS(256),
    [aux_sym_specialblock_token3] = ACTIONS(256),
    [aux_sym_specialblock_token4] = ACTIONS(256),
    [aux_sym_specialblock_token5] = ACTIONS(256),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(256),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(256),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(256),
    [anon_sym_COLONcaption_COLON] = ACTIONS(256),
    [anon_sym_COLONitem_COLON] = ACTIONS(256),
    [anon_sym_COLONprev_COLON] = ACTIONS(256),
    [anon_sym_COLONprev2_COLON] = ACTIONS(256),
    [anon_sym_COLONprev3_COLON] = ACTIONS(256),
    [aux_sym_specialinline_token1] = ACTIONS(258),
    [aux_sym_specialinline_token2] = ACTIONS(258),
    [anon_sym_COLONmath_COLON] = ACTIONS(256),
    [anon_sym_COLONcode_COLON] = ACTIONS(256),
    [aux_sym_specialinline_token3] = ACTIONS(256),
    [aux_sym_specialinline_token4] = ACTIONS(256),
    [anon_sym_COLONref_COLON] = ACTIONS(256),
    [anon_sym_COLONprevious_COLON] = ACTIONS(256),
    [anon_sym_COLONurl_COLON] = ACTIONS(256),
    [anon_sym_COLONcite_COLON] = ACTIONS(256),
    [anon_sym_COLONqed_COLON] = ACTIONS(256),
    [anon_sym_COLONtable_COLON] = ACTIONS(256),
    [anon_sym_COLONassume_COLON] = ACTIONS(256),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(256),
    [anon_sym_COLONprove_COLON] = ACTIONS(256),
    [anon_sym_COLONthen_COLON] = ACTIONS(256),
    [anon_sym_COLONnew_COLON] = ACTIONS(256),
    [anon_sym_COLONlet_COLON] = ACTIONS(256),
    [anon_sym_COLONcase_COLON] = ACTIONS(256),
    [anon_sym_COLONdefine_COLON] = ACTIONS(256),
    [anon_sym_COLONwrite_COLON] = ACTIONS(256),
    [anon_sym_COLONwlog_COLON] = ACTIONS(256),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(256),
    [anon_sym_COLONclaim_COLON] = ACTIONS(256),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(256),
    [anon_sym_COLON_COLON2] = ACTIONS(256),
    [anon_sym_COLONdraft_COLON] = ACTIONS(256),
    [anon_sym_COLONnote_COLON] = ACTIONS(256),
    [anon_sym_COLONspan_COLON] = ACTIONS(256),
    [anon_sym_COLONabstract_COLON] = ACTIONS(256),
    [anon_sym_COLONauthor_COLON] = ACTIONS(256),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(256),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(256),
    [anon_sym_COLONitemize_COLON] = ACTIONS(256),
    [anon_sym_COLONlemma_COLON] = ACTIONS(256),
    [anon_sym_COLONfigure_COLON] = ACTIONS(256),
    [anon_sym_COLONp_COLON] = ACTIONS(256),
    [anon_sym_COLONproof_COLON] = ACTIONS(256),
    [anon_sym_COLONproposition_COLON] = ACTIONS(256),
    [anon_sym_COLONremark_COLON] = ACTIONS(256),
    [anon_sym_COLONsection_COLON] = ACTIONS(256),
    [anon_sym_COLONsketch_COLON] = ACTIONS(256),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(256),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(256),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(256),
    [anon_sym_COLONstep_COLON] = ACTIONS(256),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(256),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(256),
  },
  [33] = {
    [anon_sym_COLON_COLON] = ACTIONS(260),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(260),
    [anon_sym_COLONappendix_COLON] = ACTIONS(260),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(260),
    [anon_sym_COLONtoc_COLON] = ACTIONS(260),
    [aux_sym_specialblock_token1] = ACTIONS(260),
    [aux_sym_specialblock_token2] = ACTIONS(260),
    [aux_sym_specialblock_token3] = ACTIONS(260),
    [aux_sym_specialblock_token4] = ACTIONS(260),
    [aux_sym_specialblock_token5] = ACTIONS(260),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(260),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(260),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(260),
    [anon_sym_COLONcaption_COLON] = ACTIONS(260),
    [anon_sym_COLONitem_COLON] = ACTIONS(260),
    [anon_sym_COLONprev_COLON] = ACTIONS(260),
    [anon_sym_COLONprev2_COLON] = ACTIONS(260),
    [anon_sym_COLONprev3_COLON] = ACTIONS(260),
    [aux_sym_specialinline_token1] = ACTIONS(262),
    [aux_sym_specialinline_token2] = ACTIONS(262),
    [anon_sym_COLONmath_COLON] = ACTIONS(260),
    [anon_sym_COLONcode_COLON] = ACTIONS(260),
    [aux_sym_specialinline_token3] = ACTIONS(260),
    [aux_sym_specialinline_token4] = ACTIONS(260),
    [anon_sym_COLONref_COLON] = ACTIONS(260),
    [anon_sym_COLONprevious_COLON] = ACTIONS(260),
    [anon_sym_COLONurl_COLON] = ACTIONS(260),
    [anon_sym_COLONcite_COLON] = ACTIONS(260),
    [anon_sym_COLONqed_COLON] = ACTIONS(260),
    [anon_sym_COLONtable_COLON] = ACTIONS(260),
    [anon_sym_COLONassume_COLON] = ACTIONS(260),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(260),
    [anon_sym_COLONprove_COLON] = ACTIONS(260),
    [anon_sym_COLONthen_COLON] = ACTIONS(260),
    [anon_sym_COLONnew_COLON] = ACTIONS(260),
    [anon_sym_COLONlet_COLON] = ACTIONS(260),
    [anon_sym_COLONcase_COLON] = ACTIONS(260),
    [anon_sym_COLONdefine_COLON] = ACTIONS(260),
    [anon_sym_COLONwrite_COLON] = ACTIONS(260),
    [anon_sym_COLONwlog_COLON] = ACTIONS(260),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(260),
    [anon_sym_COLONclaim_COLON] = ACTIONS(260),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(260),
    [anon_sym_COLON_COLON2] = ACTIONS(260),
    [anon_sym_COLONdraft_COLON] = ACTIONS(260),
    [anon_sym_COLONnote_COLON] = ACTIONS(260),
    [anon_sym_COLONspan_COLON] = ACTIONS(260),
    [anon_sym_COLONabstract_COLON] = ACTIONS(260),
    [anon_sym_COLONauthor_COLON] = ACTIONS(260),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(260),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(260),
    [anon_sym_COLONitemize_COLON] = ACTIONS(260),
    [anon_sym_COLONlemma_COLON] = ACTIONS(260),
    [anon_sym_COLONfigure_COLON] = ACTIONS(260),
    [anon_sym_COLONp_COLON] = ACTIONS(260),
    [anon_sym_COLONproof_COLON] = ACTIONS(260),
    [anon_sym_COLONproposition_COLON] = ACTIONS(260),
    [anon_sym_COLONremark_COLON] = ACTIONS(260),
    [anon_sym_COLONsection_COLON] = ACTIONS(260),
    [anon_sym_COLONsketch_COLON] = ACTIONS(260),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(260),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(260),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(260),
    [anon_sym_COLONstep_COLON] = ACTIONS(260),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(260),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(260),
  },
  [34] = {
    [anon_sym_COLON_COLON] = ACTIONS(264),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(264),
    [anon_sym_COLONappendix_COLON] = ACTIONS(264),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(264),
    [anon_sym_COLONtoc_COLON] = ACTIONS(264),
    [aux_sym_specialblock_token1] = ACTIONS(264),
    [aux_sym_specialblock_token2] = ACTIONS(264),
    [aux_sym_specialblock_token3] = ACTIONS(264),
    [aux_sym_specialblock_token4] = ACTIONS(264),
    [aux_sym_specialblock_token5] = ACTIONS(264),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(264),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(264),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(264),
    [anon_sym_COLONcaption_COLON] = ACTIONS(264),
    [anon_sym_COLONitem_COLON] = ACTIONS(264),
    [anon_sym_COLONprev_COLON] = ACTIONS(264),
    [anon_sym_COLONprev2_COLON] = ACTIONS(264),
    [anon_sym_COLONprev3_COLON] = ACTIONS(264),
    [aux_sym_specialinline_token1] = ACTIONS(266),
    [aux_sym_specialinline_token2] = ACTIONS(266),
    [anon_sym_COLONmath_COLON] = ACTIONS(264),
    [anon_sym_COLONcode_COLON] = ACTIONS(264),
    [aux_sym_specialinline_token3] = ACTIONS(264),
    [aux_sym_specialinline_token4] = ACTIONS(264),
    [anon_sym_COLONref_COLON] = ACTIONS(264),
    [anon_sym_COLONprevious_COLON] = ACTIONS(264),
    [anon_sym_COLONurl_COLON] = ACTIONS(264),
    [anon_sym_COLONcite_COLON] = ACTIONS(264),
    [anon_sym_COLONqed_COLON] = ACTIONS(264),
    [anon_sym_COLONtable_COLON] = ACTIONS(264),
    [anon_sym_COLONassume_COLON] = ACTIONS(264),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(264),
    [anon_sym_COLONprove_COLON] = ACTIONS(264),
    [anon_sym_COLONthen_COLON] = ACTIONS(264),
    [anon_sym_COLONnew_COLON] = ACTIONS(264),
    [anon_sym_COLONlet_COLON] = ACTIONS(264),
    [anon_sym_COLONcase_COLON] = ACTIONS(264),
    [anon_sym_COLONdefine_COLON] = ACTIONS(264),
    [anon_sym_COLONwrite_COLON] = ACTIONS(264),
    [anon_sym_COLONwlog_COLON] = ACTIONS(264),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(264),
    [anon_sym_COLONclaim_COLON] = ACTIONS(264),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(264),
    [anon_sym_COLON_COLON2] = ACTIONS(264),
    [anon_sym_COLONdraft_COLON] = ACTIONS(264),
    [anon_sym_COLONnote_COLON] = ACTIONS(264),
    [anon_sym_COLONspan_COLON] = ACTIONS(264),
    [anon_sym_COLONabstract_COLON] = ACTIONS(264),
    [anon_sym_COLONauthor_COLON] = ACTIONS(264),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(264),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(264),
    [anon_sym_COLONitemize_COLON] = ACTIONS(264),
    [anon_sym_COLONlemma_COLON] = ACTIONS(264),
    [anon_sym_COLONfigure_COLON] = ACTIONS(264),
    [anon_sym_COLONp_COLON] = ACTIONS(264),
    [anon_sym_COLONproof_COLON] = ACTIONS(264),
    [anon_sym_COLONproposition_COLON] = ACTIONS(264),
    [anon_sym_COLONremark_COLON] = ACTIONS(264),
    [anon_sym_COLONsection_COLON] = ACTIONS(264),
    [anon_sym_COLONsketch_COLON] = ACTIONS(264),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(264),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(264),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(264),
    [anon_sym_COLONstep_COLON] = ACTIONS(264),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(264),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(264),
  },
  [35] = {
    [anon_sym_COLON_COLON] = ACTIONS(268),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(268),
    [anon_sym_COLONappendix_COLON] = ACTIONS(268),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(268),
    [anon_sym_COLONtoc_COLON] = ACTIONS(268),
    [aux_sym_specialblock_token1] = ACTIONS(268),
    [aux_sym_specialblock_token2] = ACTIONS(268),
    [aux_sym_specialblock_token3] = ACTIONS(268),
    [aux_sym_specialblock_token4] = ACTIONS(268),
    [aux_sym_specialblock_token5] = ACTIONS(268),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(268),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(268),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(268),
    [anon_sym_COLONcaption_COLON] = ACTIONS(268),
    [anon_sym_COLONitem_COLON] = ACTIONS(268),
    [anon_sym_COLONprev_COLON] = ACTIONS(268),
    [anon_sym_COLONprev2_COLON] = ACTIONS(268),
    [anon_sym_COLONprev3_COLON] = ACTIONS(268),
    [aux_sym_specialinline_token1] = ACTIONS(270),
    [aux_sym_specialinline_token2] = ACTIONS(270),
    [anon_sym_COLONmath_COLON] = ACTIONS(268),
    [anon_sym_COLONcode_COLON] = ACTIONS(268),
    [aux_sym_specialinline_token3] = ACTIONS(268),
    [aux_sym_specialinline_token4] = ACTIONS(268),
    [anon_sym_COLONref_COLON] = ACTIONS(268),
    [anon_sym_COLONprevious_COLON] = ACTIONS(268),
    [anon_sym_COLONurl_COLON] = ACTIONS(268),
    [anon_sym_COLONcite_COLON] = ACTIONS(268),
    [anon_sym_COLONqed_COLON] = ACTIONS(268),
    [anon_sym_COLONtable_COLON] = ACTIONS(268),
    [anon_sym_COLONassume_COLON] = ACTIONS(268),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(268),
    [anon_sym_COLONprove_COLON] = ACTIONS(268),
    [anon_sym_COLONthen_COLON] = ACTIONS(268),
    [anon_sym_COLONnew_COLON] = ACTIONS(268),
    [anon_sym_COLONlet_COLON] = ACTIONS(268),
    [anon_sym_COLONcase_COLON] = ACTIONS(268),
    [anon_sym_COLONdefine_COLON] = ACTIONS(268),
    [anon_sym_COLONwrite_COLON] = ACTIONS(268),
    [anon_sym_COLONwlog_COLON] = ACTIONS(268),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(268),
    [anon_sym_COLONclaim_COLON] = ACTIONS(268),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(268),
    [anon_sym_COLON_COLON2] = ACTIONS(268),
    [anon_sym_COLONdraft_COLON] = ACTIONS(268),
    [anon_sym_COLONnote_COLON] = ACTIONS(268),
    [anon_sym_COLONspan_COLON] = ACTIONS(268),
    [anon_sym_COLONabstract_COLON] = ACTIONS(268),
    [anon_sym_COLONauthor_COLON] = ACTIONS(268),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(268),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(268),
    [anon_sym_COLONitemize_COLON] = ACTIONS(268),
    [anon_sym_COLONlemma_COLON] = ACTIONS(268),
    [anon_sym_COLONfigure_COLON] = ACTIONS(268),
    [anon_sym_COLONp_COLON] = ACTIONS(268),
    [anon_sym_COLONproof_COLON] = ACTIONS(268),
    [anon_sym_COLONproposition_COLON] = ACTIONS(268),
    [anon_sym_COLONremark_COLON] = ACTIONS(268),
    [anon_sym_COLONsection_COLON] = ACTIONS(268),
    [anon_sym_COLONsketch_COLON] = ACTIONS(268),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(268),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(268),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(268),
    [anon_sym_COLONstep_COLON] = ACTIONS(268),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(268),
  },
  [36] = {
    [anon_sym_COLON_COLON] = ACTIONS(272),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(272),
    [anon_sym_COLONappendix_COLON] = ACTIONS(272),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(272),
    [anon_sym_COLONtoc_COLON] = ACTIONS(272),
    [aux_sym_specialblock_token1] = ACTIONS(272),
    [aux_sym_specialblock_token2] = ACTIONS(272),
    [aux_sym_specialblock_token3] = ACTIONS(272),
    [aux_sym_specialblock_token4] = ACTIONS(272),
    [aux_sym_specialblock_token5] = ACTIONS(272),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(272),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(272),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(272),
    [anon_sym_COLONcaption_COLON] = ACTIONS(272),
    [anon_sym_COLONitem_COLON] = ACTIONS(272),
    [anon_sym_COLONprev_COLON] = ACTIONS(272),
    [anon_sym_COLONprev2_COLON] = ACTIONS(272),
    [anon_sym_COLONprev3_COLON] = ACTIONS(272),
    [aux_sym_specialinline_token1] = ACTIONS(274),
    [aux_sym_specialinline_token2] = ACTIONS(274),
    [anon_sym_COLONmath_COLON] = ACTIONS(272),
    [anon_sym_COLONcode_COLON] = ACTIONS(272),
    [aux_sym_specialinline_token3] = ACTIONS(272),
    [aux_sym_specialinline_token4] = ACTIONS(272),
    [anon_sym_COLONref_COLON] = ACTIONS(272),
    [anon_sym_COLONprevious_COLON] = ACTIONS(272),
    [anon_sym_COLONurl_COLON] = ACTIONS(272),
    [anon_sym_COLONcite_COLON] = ACTIONS(272),
    [anon_sym_COLONqed_COLON] = ACTIONS(272),
    [anon_sym_COLONtable_COLON] = ACTIONS(272),
    [anon_sym_COLONassume_COLON] = ACTIONS(272),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(272),
    [anon_sym_COLONprove_COLON] = ACTIONS(272),
    [anon_sym_COLONthen_COLON] = ACTIONS(272),
    [anon_sym_COLONnew_COLON] = ACTIONS(272),
    [anon_sym_COLONlet_COLON] = ACTIONS(272),
    [anon_sym_COLONcase_COLON] = ACTIONS(272),
    [anon_sym_COLONdefine_COLON] = ACTIONS(272),
    [anon_sym_COLONwrite_COLON] = ACTIONS(272),
    [anon_sym_COLONwlog_COLON] = ACTIONS(272),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(272),
    [anon_sym_COLONclaim_COLON] = ACTIONS(272),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(272),
    [anon_sym_COLON_COLON2] = ACTIONS(272),
    [anon_sym_COLONdraft_COLON] = ACTIONS(272),
    [anon_sym_COLONnote_COLON] = ACTIONS(272),
    [anon_sym_COLONspan_COLON] = ACTIONS(272),
    [anon_sym_COLONabstract_COLON] = ACTIONS(272),
    [anon_sym_COLONauthor_COLON] = ACTIONS(272),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(272),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(272),
    [anon_sym_COLONitemize_COLON] = ACTIONS(272),
    [anon_sym_COLONlemma_COLON] = ACTIONS(272),
    [anon_sym_COLONfigure_COLON] = ACTIONS(272),
    [anon_sym_COLONp_COLON] = ACTIONS(272),
    [anon_sym_COLONproof_COLON] = ACTIONS(272),
    [anon_sym_COLONproposition_COLON] = ACTIONS(272),
    [anon_sym_COLONremark_COLON] = ACTIONS(272),
    [anon_sym_COLONsection_COLON] = ACTIONS(272),
    [anon_sym_COLONsketch_COLON] = ACTIONS(272),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(272),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(272),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(272),
    [anon_sym_COLONstep_COLON] = ACTIONS(272),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(272),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(272),
  },
  [37] = {
    [anon_sym_COLON_COLON] = ACTIONS(276),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(276),
    [anon_sym_COLONappendix_COLON] = ACTIONS(276),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(276),
    [anon_sym_COLONtoc_COLON] = ACTIONS(276),
    [aux_sym_specialblock_token1] = ACTIONS(276),
    [aux_sym_specialblock_token2] = ACTIONS(276),
    [aux_sym_specialblock_token3] = ACTIONS(276),
    [aux_sym_specialblock_token4] = ACTIONS(276),
    [aux_sym_specialblock_token5] = ACTIONS(276),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(276),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(276),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(276),
    [anon_sym_COLONcaption_COLON] = ACTIONS(276),
    [anon_sym_COLONitem_COLON] = ACTIONS(276),
    [anon_sym_COLONprev_COLON] = ACTIONS(276),
    [anon_sym_COLONprev2_COLON] = ACTIONS(276),
    [anon_sym_COLONprev3_COLON] = ACTIONS(276),
    [aux_sym_specialinline_token1] = ACTIONS(278),
    [aux_sym_specialinline_token2] = ACTIONS(278),
    [anon_sym_COLONmath_COLON] = ACTIONS(276),
    [anon_sym_COLONcode_COLON] = ACTIONS(276),
    [aux_sym_specialinline_token3] = ACTIONS(276),
    [aux_sym_specialinline_token4] = ACTIONS(276),
    [anon_sym_COLONref_COLON] = ACTIONS(276),
    [anon_sym_COLONprevious_COLON] = ACTIONS(276),
    [anon_sym_COLONurl_COLON] = ACTIONS(276),
    [anon_sym_COLONcite_COLON] = ACTIONS(276),
    [anon_sym_COLONqed_COLON] = ACTIONS(276),
    [anon_sym_COLONtable_COLON] = ACTIONS(276),
    [anon_sym_COLONassume_COLON] = ACTIONS(276),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(276),
    [anon_sym_COLONprove_COLON] = ACTIONS(276),
    [anon_sym_COLONthen_COLON] = ACTIONS(276),
    [anon_sym_COLONnew_COLON] = ACTIONS(276),
    [anon_sym_COLONlet_COLON] = ACTIONS(276),
    [anon_sym_COLONcase_COLON] = ACTIONS(276),
    [anon_sym_COLONdefine_COLON] = ACTIONS(276),
    [anon_sym_COLONwrite_COLON] = ACTIONS(276),
    [anon_sym_COLONwlog_COLON] = ACTIONS(276),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(276),
    [anon_sym_COLONclaim_COLON] = ACTIONS(276),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(276),
    [anon_sym_COLON_COLON2] = ACTIONS(276),
    [anon_sym_COLONdraft_COLON] = ACTIONS(276),
    [anon_sym_COLONnote_COLON] = ACTIONS(276),
    [anon_sym_COLONspan_COLON] = ACTIONS(276),
    [anon_sym_COLONabstract_COLON] = ACTIONS(276),
    [anon_sym_COLONauthor_COLON] = ACTIONS(276),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(276),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(276),
    [anon_sym_COLONitemize_COLON] = ACTIONS(276),
    [anon_sym_COLONlemma_COLON] = ACTIONS(276),
    [anon_sym_COLONfigure_COLON] = ACTIONS(276),
    [anon_sym_COLONp_COLON] = ACTIONS(276),
    [anon_sym_COLONproof_COLON] = ACTIONS(276),
    [anon_sym_COLONproposition_COLON] = ACTIONS(276),
    [anon_sym_COLONremark_COLON] = ACTIONS(276),
    [anon_sym_COLONsection_COLON] = ACTIONS(276),
    [anon_sym_COLONsketch_COLON] = ACTIONS(276),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(276),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(276),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(276),
    [anon_sym_COLONstep_COLON] = ACTIONS(276),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(276),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(276),
  },
  [38] = {
    [anon_sym_COLON_COLON] = ACTIONS(280),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(280),
    [anon_sym_COLONappendix_COLON] = ACTIONS(280),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(280),
    [anon_sym_COLONtoc_COLON] = ACTIONS(280),
    [aux_sym_specialblock_token1] = ACTIONS(280),
    [aux_sym_specialblock_token2] = ACTIONS(280),
    [aux_sym_specialblock_token3] = ACTIONS(280),
    [aux_sym_specialblock_token4] = ACTIONS(280),
    [aux_sym_specialblock_token5] = ACTIONS(280),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(280),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(280),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(280),
    [anon_sym_COLONcaption_COLON] = ACTIONS(280),
    [anon_sym_COLONitem_COLON] = ACTIONS(280),
    [anon_sym_COLONprev_COLON] = ACTIONS(280),
    [anon_sym_COLONprev2_COLON] = ACTIONS(280),
    [anon_sym_COLONprev3_COLON] = ACTIONS(280),
    [aux_sym_specialinline_token1] = ACTIONS(282),
    [aux_sym_specialinline_token2] = ACTIONS(282),
    [anon_sym_COLONmath_COLON] = ACTIONS(280),
    [anon_sym_COLONcode_COLON] = ACTIONS(280),
    [aux_sym_specialinline_token3] = ACTIONS(280),
    [aux_sym_specialinline_token4] = ACTIONS(280),
    [anon_sym_COLONref_COLON] = ACTIONS(280),
    [anon_sym_COLONprevious_COLON] = ACTIONS(280),
    [anon_sym_COLONurl_COLON] = ACTIONS(280),
    [anon_sym_COLONcite_COLON] = ACTIONS(280),
    [anon_sym_COLONqed_COLON] = ACTIONS(280),
    [anon_sym_COLONtable_COLON] = ACTIONS(280),
    [anon_sym_COLONassume_COLON] = ACTIONS(280),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(280),
    [anon_sym_COLONprove_COLON] = ACTIONS(280),
    [anon_sym_COLONthen_COLON] = ACTIONS(280),
    [anon_sym_COLONnew_COLON] = ACTIONS(280),
    [anon_sym_COLONlet_COLON] = ACTIONS(280),
    [anon_sym_COLONcase_COLON] = ACTIONS(280),
    [anon_sym_COLONdefine_COLON] = ACTIONS(280),
    [anon_sym_COLONwrite_COLON] = ACTIONS(280),
    [anon_sym_COLONwlog_COLON] = ACTIONS(280),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(280),
    [anon_sym_COLONclaim_COLON] = ACTIONS(280),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(280),
    [anon_sym_COLON_COLON2] = ACTIONS(280),
    [anon_sym_COLONdraft_COLON] = ACTIONS(280),
    [anon_sym_COLONnote_COLON] = ACTIONS(280),
    [anon_sym_COLONspan_COLON] = ACTIONS(280),
    [anon_sym_COLONabstract_COLON] = ACTIONS(280),
    [anon_sym_COLONauthor_COLON] = ACTIONS(280),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(280),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(280),
    [anon_sym_COLONitemize_COLON] = ACTIONS(280),
    [anon_sym_COLONlemma_COLON] = ACTIONS(280),
    [anon_sym_COLONfigure_COLON] = ACTIONS(280),
    [anon_sym_COLONp_COLON] = ACTIONS(280),
    [anon_sym_COLONproof_COLON] = ACTIONS(280),
    [anon_sym_COLONproposition_COLON] = ACTIONS(280),
    [anon_sym_COLONremark_COLON] = ACTIONS(280),
    [anon_sym_COLONsection_COLON] = ACTIONS(280),
    [anon_sym_COLONsketch_COLON] = ACTIONS(280),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(280),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(280),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(280),
    [anon_sym_COLONstep_COLON] = ACTIONS(280),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(280),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(280),
  },
  [39] = {
    [anon_sym_COLON_COLON] = ACTIONS(284),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(284),
    [anon_sym_COLONappendix_COLON] = ACTIONS(284),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(284),
    [anon_sym_COLONtoc_COLON] = ACTIONS(284),
    [aux_sym_specialblock_token1] = ACTIONS(284),
    [aux_sym_specialblock_token2] = ACTIONS(284),
    [aux_sym_specialblock_token3] = ACTIONS(284),
    [aux_sym_specialblock_token4] = ACTIONS(284),
    [aux_sym_specialblock_token5] = ACTIONS(284),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(284),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(284),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(284),
    [anon_sym_COLONcaption_COLON] = ACTIONS(284),
    [anon_sym_COLONitem_COLON] = ACTIONS(284),
    [anon_sym_COLONprev_COLON] = ACTIONS(284),
    [anon_sym_COLONprev2_COLON] = ACTIONS(284),
    [anon_sym_COLONprev3_COLON] = ACTIONS(284),
    [aux_sym_specialinline_token1] = ACTIONS(286),
    [aux_sym_specialinline_token2] = ACTIONS(286),
    [anon_sym_COLONmath_COLON] = ACTIONS(284),
    [anon_sym_COLONcode_COLON] = ACTIONS(284),
    [aux_sym_specialinline_token3] = ACTIONS(284),
    [aux_sym_specialinline_token4] = ACTIONS(284),
    [anon_sym_COLONref_COLON] = ACTIONS(284),
    [anon_sym_COLONprevious_COLON] = ACTIONS(284),
    [anon_sym_COLONurl_COLON] = ACTIONS(284),
    [anon_sym_COLONcite_COLON] = ACTIONS(284),
    [anon_sym_COLONqed_COLON] = ACTIONS(284),
    [anon_sym_COLONtable_COLON] = ACTIONS(284),
    [anon_sym_COLONassume_COLON] = ACTIONS(284),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(284),
    [anon_sym_COLONprove_COLON] = ACTIONS(284),
    [anon_sym_COLONthen_COLON] = ACTIONS(284),
    [anon_sym_COLONnew_COLON] = ACTIONS(284),
    [anon_sym_COLONlet_COLON] = ACTIONS(284),
    [anon_sym_COLONcase_COLON] = ACTIONS(284),
    [anon_sym_COLONdefine_COLON] = ACTIONS(284),
    [anon_sym_COLONwrite_COLON] = ACTIONS(284),
    [anon_sym_COLONwlog_COLON] = ACTIONS(284),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(284),
    [anon_sym_COLONclaim_COLON] = ACTIONS(284),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(284),
    [anon_sym_COLON_COLON2] = ACTIONS(284),
    [anon_sym_COLONdraft_COLON] = ACTIONS(284),
    [anon_sym_COLONnote_COLON] = ACTIONS(284),
    [anon_sym_COLONspan_COLON] = ACTIONS(284),
    [anon_sym_COLONabstract_COLON] = ACTIONS(284),
    [anon_sym_COLONauthor_COLON] = ACTIONS(284),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(284),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(284),
    [anon_sym_COLONitemize_COLON] = ACTIONS(284),
    [anon_sym_COLONlemma_COLON] = ACTIONS(284),
    [anon_sym_COLONfigure_COLON] = ACTIONS(284),
    [anon_sym_COLONp_COLON] = ACTIONS(284),
    [anon_sym_COLONproof_COLON] = ACTIONS(284),
    [anon_sym_COLONproposition_COLON] = ACTIONS(284),
    [anon_sym_COLONremark_COLON] = ACTIONS(284),
    [anon_sym_COLONsection_COLON] = ACTIONS(284),
    [anon_sym_COLONsketch_COLON] = ACTIONS(284),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(284),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(284),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(284),
    [anon_sym_COLONstep_COLON] = ACTIONS(284),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(284),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(284),
  },
  [40] = {
    [anon_sym_COLON_COLON] = ACTIONS(288),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(288),
    [anon_sym_COLONappendix_COLON] = ACTIONS(288),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(288),
    [anon_sym_COLONtoc_COLON] = ACTIONS(288),
    [aux_sym_specialblock_token1] = ACTIONS(288),
    [aux_sym_specialblock_token2] = ACTIONS(288),
    [aux_sym_specialblock_token3] = ACTIONS(288),
    [aux_sym_specialblock_token4] = ACTIONS(288),
    [aux_sym_specialblock_token5] = ACTIONS(288),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(288),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(288),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(288),
    [anon_sym_COLONcaption_COLON] = ACTIONS(288),
    [anon_sym_COLONitem_COLON] = ACTIONS(288),
    [anon_sym_COLONprev_COLON] = ACTIONS(288),
    [anon_sym_COLONprev2_COLON] = ACTIONS(288),
    [anon_sym_COLONprev3_COLON] = ACTIONS(288),
    [aux_sym_specialinline_token1] = ACTIONS(290),
    [aux_sym_specialinline_token2] = ACTIONS(290),
    [anon_sym_COLONmath_COLON] = ACTIONS(288),
    [anon_sym_COLONcode_COLON] = ACTIONS(288),
    [aux_sym_specialinline_token3] = ACTIONS(288),
    [aux_sym_specialinline_token4] = ACTIONS(288),
    [anon_sym_COLONref_COLON] = ACTIONS(288),
    [anon_sym_COLONprevious_COLON] = ACTIONS(288),
    [anon_sym_COLONurl_COLON] = ACTIONS(288),
    [anon_sym_COLONcite_COLON] = ACTIONS(288),
    [anon_sym_COLONqed_COLON] = ACTIONS(288),
    [anon_sym_COLONtable_COLON] = ACTIONS(288),
    [anon_sym_COLONassume_COLON] = ACTIONS(288),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(288),
    [anon_sym_COLONprove_COLON] = ACTIONS(288),
    [anon_sym_COLONthen_COLON] = ACTIONS(288),
    [anon_sym_COLONnew_COLON] = ACTIONS(288),
    [anon_sym_COLONlet_COLON] = ACTIONS(288),
    [anon_sym_COLONcase_COLON] = ACTIONS(288),
    [anon_sym_COLONdefine_COLON] = ACTIONS(288),
    [anon_sym_COLONwrite_COLON] = ACTIONS(288),
    [anon_sym_COLONwlog_COLON] = ACTIONS(288),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(288),
    [anon_sym_COLONclaim_COLON] = ACTIONS(288),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(288),
    [anon_sym_COLON_COLON2] = ACTIONS(288),
    [anon_sym_COLONdraft_COLON] = ACTIONS(288),
    [anon_sym_COLONnote_COLON] = ACTIONS(288),
    [anon_sym_COLONspan_COLON] = ACTIONS(288),
    [anon_sym_COLONabstract_COLON] = ACTIONS(288),
    [anon_sym_COLONauthor_COLON] = ACTIONS(288),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(288),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(288),
    [anon_sym_COLONitemize_COLON] = ACTIONS(288),
    [anon_sym_COLONlemma_COLON] = ACTIONS(288),
    [anon_sym_COLONfigure_COLON] = ACTIONS(288),
    [anon_sym_COLONp_COLON] = ACTIONS(288),
    [anon_sym_COLONproof_COLON] = ACTIONS(288),
    [anon_sym_COLONproposition_COLON] = ACTIONS(288),
    [anon_sym_COLONremark_COLON] = ACTIONS(288),
    [anon_sym_COLONsection_COLON] = ACTIONS(288),
    [anon_sym_COLONsketch_COLON] = ACTIONS(288),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(288),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(288),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(288),
    [anon_sym_COLONstep_COLON] = ACTIONS(288),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(288),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(288),
  },
  [41] = {
    [anon_sym_COLON_COLON] = ACTIONS(292),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(292),
    [anon_sym_COLONappendix_COLON] = ACTIONS(292),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(292),
    [anon_sym_COLONtoc_COLON] = ACTIONS(292),
    [aux_sym_specialblock_token1] = ACTIONS(292),
    [aux_sym_specialblock_token2] = ACTIONS(292),
    [aux_sym_specialblock_token3] = ACTIONS(292),
    [aux_sym_specialblock_token4] = ACTIONS(292),
    [aux_sym_specialblock_token5] = ACTIONS(292),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(292),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(292),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(292),
    [anon_sym_COLONcaption_COLON] = ACTIONS(292),
    [anon_sym_COLONitem_COLON] = ACTIONS(292),
    [anon_sym_COLONprev_COLON] = ACTIONS(292),
    [anon_sym_COLONprev2_COLON] = ACTIONS(292),
    [anon_sym_COLONprev3_COLON] = ACTIONS(292),
    [aux_sym_specialinline_token1] = ACTIONS(294),
    [aux_sym_specialinline_token2] = ACTIONS(294),
    [anon_sym_COLONmath_COLON] = ACTIONS(292),
    [anon_sym_COLONcode_COLON] = ACTIONS(292),
    [aux_sym_specialinline_token3] = ACTIONS(292),
    [aux_sym_specialinline_token4] = ACTIONS(292),
    [anon_sym_COLONref_COLON] = ACTIONS(292),
    [anon_sym_COLONprevious_COLON] = ACTIONS(292),
    [anon_sym_COLONurl_COLON] = ACTIONS(292),
    [anon_sym_COLONcite_COLON] = ACTIONS(292),
    [anon_sym_COLONqed_COLON] = ACTIONS(292),
    [anon_sym_COLONtable_COLON] = ACTIONS(292),
    [anon_sym_COLONassume_COLON] = ACTIONS(292),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(292),
    [anon_sym_COLONprove_COLON] = ACTIONS(292),
    [anon_sym_COLONthen_COLON] = ACTIONS(292),
    [anon_sym_COLONnew_COLON] = ACTIONS(292),
    [anon_sym_COLONlet_COLON] = ACTIONS(292),
    [anon_sym_COLONcase_COLON] = ACTIONS(292),
    [anon_sym_COLONdefine_COLON] = ACTIONS(292),
    [anon_sym_COLONwrite_COLON] = ACTIONS(292),
    [anon_sym_COLONwlog_COLON] = ACTIONS(292),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(292),
    [anon_sym_COLONclaim_COLON] = ACTIONS(292),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(292),
    [anon_sym_COLON_COLON2] = ACTIONS(292),
    [anon_sym_COLONdraft_COLON] = ACTIONS(292),
    [anon_sym_COLONnote_COLON] = ACTIONS(292),
    [anon_sym_COLONspan_COLON] = ACTIONS(292),
    [anon_sym_COLONabstract_COLON] = ACTIONS(292),
    [anon_sym_COLONauthor_COLON] = ACTIONS(292),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(292),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(292),
    [anon_sym_COLONitemize_COLON] = ACTIONS(292),
    [anon_sym_COLONlemma_COLON] = ACTIONS(292),
    [anon_sym_COLONfigure_COLON] = ACTIONS(292),
    [anon_sym_COLONp_COLON] = ACTIONS(292),
    [anon_sym_COLONproof_COLON] = ACTIONS(292),
    [anon_sym_COLONproposition_COLON] = ACTIONS(292),
    [anon_sym_COLONremark_COLON] = ACTIONS(292),
    [anon_sym_COLONsection_COLON] = ACTIONS(292),
    [anon_sym_COLONsketch_COLON] = ACTIONS(292),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(292),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(292),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(292),
    [anon_sym_COLONstep_COLON] = ACTIONS(292),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(292),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(292),
  },
  [42] = {
    [anon_sym_COLON_COLON] = ACTIONS(296),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(296),
    [anon_sym_COLONappendix_COLON] = ACTIONS(296),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(296),
    [anon_sym_COLONtoc_COLON] = ACTIONS(296),
    [aux_sym_specialblock_token1] = ACTIONS(296),
    [aux_sym_specialblock_token2] = ACTIONS(296),
    [aux_sym_specialblock_token3] = ACTIONS(296),
    [aux_sym_specialblock_token4] = ACTIONS(296),
    [aux_sym_specialblock_token5] = ACTIONS(296),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(296),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(296),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(296),
    [anon_sym_COLONcaption_COLON] = ACTIONS(296),
    [anon_sym_COLONitem_COLON] = ACTIONS(296),
    [anon_sym_COLONprev_COLON] = ACTIONS(296),
    [anon_sym_COLONprev2_COLON] = ACTIONS(296),
    [anon_sym_COLONprev3_COLON] = ACTIONS(296),
    [aux_sym_specialinline_token1] = ACTIONS(298),
    [aux_sym_specialinline_token2] = ACTIONS(298),
    [anon_sym_COLONmath_COLON] = ACTIONS(296),
    [anon_sym_COLONcode_COLON] = ACTIONS(296),
    [aux_sym_specialinline_token3] = ACTIONS(296),
    [aux_sym_specialinline_token4] = ACTIONS(296),
    [anon_sym_COLONref_COLON] = ACTIONS(296),
    [anon_sym_COLONprevious_COLON] = ACTIONS(296),
    [anon_sym_COLONurl_COLON] = ACTIONS(296),
    [anon_sym_COLONcite_COLON] = ACTIONS(296),
    [anon_sym_COLONqed_COLON] = ACTIONS(296),
    [anon_sym_COLONtable_COLON] = ACTIONS(296),
    [anon_sym_COLONassume_COLON] = ACTIONS(296),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(296),
    [anon_sym_COLONprove_COLON] = ACTIONS(296),
    [anon_sym_COLONthen_COLON] = ACTIONS(296),
    [anon_sym_COLONnew_COLON] = ACTIONS(296),
    [anon_sym_COLONlet_COLON] = ACTIONS(296),
    [anon_sym_COLONcase_COLON] = ACTIONS(296),
    [anon_sym_COLONdefine_COLON] = ACTIONS(296),
    [anon_sym_COLONwrite_COLON] = ACTIONS(296),
    [anon_sym_COLONwlog_COLON] = ACTIONS(296),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(296),
    [anon_sym_COLONclaim_COLON] = ACTIONS(296),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(296),
    [anon_sym_COLON_COLON2] = ACTIONS(296),
    [anon_sym_COLONdraft_COLON] = ACTIONS(296),
    [anon_sym_COLONnote_COLON] = ACTIONS(296),
    [anon_sym_COLONspan_COLON] = ACTIONS(296),
    [anon_sym_COLONabstract_COLON] = ACTIONS(296),
    [anon_sym_COLONauthor_COLON] = ACTIONS(296),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(296),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(296),
    [anon_sym_COLONitemize_COLON] = ACTIONS(296),
    [anon_sym_COLONlemma_COLON] = ACTIONS(296),
    [anon_sym_COLONfigure_COLON] = ACTIONS(296),
    [anon_sym_COLONp_COLON] = ACTIONS(296),
    [anon_sym_COLONproof_COLON] = ACTIONS(296),
    [anon_sym_COLONproposition_COLON] = ACTIONS(296),
    [anon_sym_COLONremark_COLON] = ACTIONS(296),
    [anon_sym_COLONsection_COLON] = ACTIONS(296),
    [anon_sym_COLONsketch_COLON] = ACTIONS(296),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(296),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(296),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(296),
    [anon_sym_COLONstep_COLON] = ACTIONS(296),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(296),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(296),
  },
  [43] = {
    [anon_sym_COLON_COLON] = ACTIONS(300),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(300),
    [anon_sym_COLONappendix_COLON] = ACTIONS(300),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(300),
    [anon_sym_COLONtoc_COLON] = ACTIONS(300),
    [aux_sym_specialblock_token1] = ACTIONS(300),
    [aux_sym_specialblock_token2] = ACTIONS(300),
    [aux_sym_specialblock_token3] = ACTIONS(300),
    [aux_sym_specialblock_token4] = ACTIONS(300),
    [aux_sym_specialblock_token5] = ACTIONS(300),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(300),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(300),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(300),
    [anon_sym_COLONcaption_COLON] = ACTIONS(300),
    [anon_sym_COLONitem_COLON] = ACTIONS(300),
    [anon_sym_COLONprev_COLON] = ACTIONS(300),
    [anon_sym_COLONprev2_COLON] = ACTIONS(300),
    [anon_sym_COLONprev3_COLON] = ACTIONS(300),
    [aux_sym_specialinline_token1] = ACTIONS(302),
    [aux_sym_specialinline_token2] = ACTIONS(302),
    [anon_sym_COLONmath_COLON] = ACTIONS(300),
    [anon_sym_COLONcode_COLON] = ACTIONS(300),
    [aux_sym_specialinline_token3] = ACTIONS(300),
    [aux_sym_specialinline_token4] = ACTIONS(300),
    [anon_sym_COLONref_COLON] = ACTIONS(300),
    [anon_sym_COLONprevious_COLON] = ACTIONS(300),
    [anon_sym_COLONurl_COLON] = ACTIONS(300),
    [anon_sym_COLONcite_COLON] = ACTIONS(300),
    [anon_sym_COLONqed_COLON] = ACTIONS(300),
    [anon_sym_COLONtable_COLON] = ACTIONS(300),
    [anon_sym_COLONassume_COLON] = ACTIONS(300),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(300),
    [anon_sym_COLONprove_COLON] = ACTIONS(300),
    [anon_sym_COLONthen_COLON] = ACTIONS(300),
    [anon_sym_COLONnew_COLON] = ACTIONS(300),
    [anon_sym_COLONlet_COLON] = ACTIONS(300),
    [anon_sym_COLONcase_COLON] = ACTIONS(300),
    [anon_sym_COLONdefine_COLON] = ACTIONS(300),
    [anon_sym_COLONwrite_COLON] = ACTIONS(300),
    [anon_sym_COLONwlog_COLON] = ACTIONS(300),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(300),
    [anon_sym_COLONclaim_COLON] = ACTIONS(300),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(300),
    [anon_sym_COLON_COLON2] = ACTIONS(300),
    [anon_sym_COLONdraft_COLON] = ACTIONS(300),
    [anon_sym_COLONnote_COLON] = ACTIONS(300),
    [anon_sym_COLONspan_COLON] = ACTIONS(300),
    [anon_sym_COLONabstract_COLON] = ACTIONS(300),
    [anon_sym_COLONauthor_COLON] = ACTIONS(300),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(300),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(300),
    [anon_sym_COLONitemize_COLON] = ACTIONS(300),
    [anon_sym_COLONlemma_COLON] = ACTIONS(300),
    [anon_sym_COLONfigure_COLON] = ACTIONS(300),
    [anon_sym_COLONp_COLON] = ACTIONS(300),
    [anon_sym_COLONproof_COLON] = ACTIONS(300),
    [anon_sym_COLONproposition_COLON] = ACTIONS(300),
    [anon_sym_COLONremark_COLON] = ACTIONS(300),
    [anon_sym_COLONsection_COLON] = ACTIONS(300),
    [anon_sym_COLONsketch_COLON] = ACTIONS(300),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(300),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(300),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(300),
    [anon_sym_COLONstep_COLON] = ACTIONS(300),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(300),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(300),
  },
  [44] = {
    [anon_sym_COLON_COLON] = ACTIONS(304),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(304),
    [anon_sym_COLONappendix_COLON] = ACTIONS(304),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(304),
    [anon_sym_COLONtoc_COLON] = ACTIONS(304),
    [aux_sym_specialblock_token1] = ACTIONS(304),
    [aux_sym_specialblock_token2] = ACTIONS(304),
    [aux_sym_specialblock_token3] = ACTIONS(304),
    [aux_sym_specialblock_token4] = ACTIONS(304),
    [aux_sym_specialblock_token5] = ACTIONS(304),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(304),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(304),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(304),
    [anon_sym_COLONcaption_COLON] = ACTIONS(304),
    [anon_sym_COLONitem_COLON] = ACTIONS(304),
    [anon_sym_COLONprev_COLON] = ACTIONS(304),
    [anon_sym_COLONprev2_COLON] = ACTIONS(304),
    [anon_sym_COLONprev3_COLON] = ACTIONS(304),
    [aux_sym_specialinline_token1] = ACTIONS(306),
    [aux_sym_specialinline_token2] = ACTIONS(306),
    [anon_sym_COLONmath_COLON] = ACTIONS(304),
    [anon_sym_COLONcode_COLON] = ACTIONS(304),
    [aux_sym_specialinline_token3] = ACTIONS(304),
    [aux_sym_specialinline_token4] = ACTIONS(304),
    [anon_sym_COLONref_COLON] = ACTIONS(304),
    [anon_sym_COLONprevious_COLON] = ACTIONS(304),
    [anon_sym_COLONurl_COLON] = ACTIONS(304),
    [anon_sym_COLONcite_COLON] = ACTIONS(304),
    [anon_sym_COLONqed_COLON] = ACTIONS(304),
    [anon_sym_COLONtable_COLON] = ACTIONS(304),
    [anon_sym_COLONassume_COLON] = ACTIONS(304),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(304),
    [anon_sym_COLONprove_COLON] = ACTIONS(304),
    [anon_sym_COLONthen_COLON] = ACTIONS(304),
    [anon_sym_COLONnew_COLON] = ACTIONS(304),
    [anon_sym_COLONlet_COLON] = ACTIONS(304),
    [anon_sym_COLONcase_COLON] = ACTIONS(304),
    [anon_sym_COLONdefine_COLON] = ACTIONS(304),
    [anon_sym_COLONwrite_COLON] = ACTIONS(304),
    [anon_sym_COLONwlog_COLON] = ACTIONS(304),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(304),
    [anon_sym_COLONclaim_COLON] = ACTIONS(304),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(304),
    [anon_sym_COLON_COLON2] = ACTIONS(304),
    [anon_sym_COLONdraft_COLON] = ACTIONS(304),
    [anon_sym_COLONnote_COLON] = ACTIONS(304),
    [anon_sym_COLONspan_COLON] = ACTIONS(304),
    [anon_sym_COLONabstract_COLON] = ACTIONS(304),
    [anon_sym_COLONauthor_COLON] = ACTIONS(304),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(304),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(304),
    [anon_sym_COLONitemize_COLON] = ACTIONS(304),
    [anon_sym_COLONlemma_COLON] = ACTIONS(304),
    [anon_sym_COLONfigure_COLON] = ACTIONS(304),
    [anon_sym_COLONp_COLON] = ACTIONS(304),
    [anon_sym_COLONproof_COLON] = ACTIONS(304),
    [anon_sym_COLONproposition_COLON] = ACTIONS(304),
    [anon_sym_COLONremark_COLON] = ACTIONS(304),
    [anon_sym_COLONsection_COLON] = ACTIONS(304),
    [anon_sym_COLONsketch_COLON] = ACTIONS(304),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(304),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(304),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(304),
    [anon_sym_COLONstep_COLON] = ACTIONS(304),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(304),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(304),
  },
  [45] = {
    [anon_sym_COLON_COLON] = ACTIONS(308),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(308),
    [anon_sym_COLONappendix_COLON] = ACTIONS(308),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(308),
    [anon_sym_COLONtoc_COLON] = ACTIONS(308),
    [aux_sym_specialblock_token1] = ACTIONS(308),
    [aux_sym_specialblock_token2] = ACTIONS(308),
    [aux_sym_specialblock_token3] = ACTIONS(308),
    [aux_sym_specialblock_token4] = ACTIONS(308),
    [aux_sym_specialblock_token5] = ACTIONS(308),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(308),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(308),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(308),
    [anon_sym_COLONcaption_COLON] = ACTIONS(308),
    [anon_sym_COLONitem_COLON] = ACTIONS(308),
    [anon_sym_COLONprev_COLON] = ACTIONS(308),
    [anon_sym_COLONprev2_COLON] = ACTIONS(308),
    [anon_sym_COLONprev3_COLON] = ACTIONS(308),
    [aux_sym_specialinline_token1] = ACTIONS(310),
    [aux_sym_specialinline_token2] = ACTIONS(310),
    [anon_sym_COLONmath_COLON] = ACTIONS(308),
    [anon_sym_COLONcode_COLON] = ACTIONS(308),
    [aux_sym_specialinline_token3] = ACTIONS(308),
    [aux_sym_specialinline_token4] = ACTIONS(308),
    [anon_sym_COLONref_COLON] = ACTIONS(308),
    [anon_sym_COLONprevious_COLON] = ACTIONS(308),
    [anon_sym_COLONurl_COLON] = ACTIONS(308),
    [anon_sym_COLONcite_COLON] = ACTIONS(308),
    [anon_sym_COLONqed_COLON] = ACTIONS(308),
    [anon_sym_COLONtable_COLON] = ACTIONS(308),
    [anon_sym_COLONassume_COLON] = ACTIONS(308),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(308),
    [anon_sym_COLONprove_COLON] = ACTIONS(308),
    [anon_sym_COLONthen_COLON] = ACTIONS(308),
    [anon_sym_COLONnew_COLON] = ACTIONS(308),
    [anon_sym_COLONlet_COLON] = ACTIONS(308),
    [anon_sym_COLONcase_COLON] = ACTIONS(308),
    [anon_sym_COLONdefine_COLON] = ACTIONS(308),
    [anon_sym_COLONwrite_COLON] = ACTIONS(308),
    [anon_sym_COLONwlog_COLON] = ACTIONS(308),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(308),
    [anon_sym_COLONclaim_COLON] = ACTIONS(308),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(308),
    [anon_sym_COLON_COLON2] = ACTIONS(308),
    [anon_sym_COLONdraft_COLON] = ACTIONS(308),
    [anon_sym_COLONnote_COLON] = ACTIONS(308),
    [anon_sym_COLONspan_COLON] = ACTIONS(308),
    [anon_sym_COLONabstract_COLON] = ACTIONS(308),
    [anon_sym_COLONauthor_COLON] = ACTIONS(308),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(308),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(308),
    [anon_sym_COLONitemize_COLON] = ACTIONS(308),
    [anon_sym_COLONlemma_COLON] = ACTIONS(308),
    [anon_sym_COLONfigure_COLON] = ACTIONS(308),
    [anon_sym_COLONp_COLON] = ACTIONS(308),
    [anon_sym_COLONproof_COLON] = ACTIONS(308),
    [anon_sym_COLONproposition_COLON] = ACTIONS(308),
    [anon_sym_COLONremark_COLON] = ACTIONS(308),
    [anon_sym_COLONsection_COLON] = ACTIONS(308),
    [anon_sym_COLONsketch_COLON] = ACTIONS(308),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(308),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(308),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(308),
    [anon_sym_COLONstep_COLON] = ACTIONS(308),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(308),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(308),
  },
  [46] = {
    [anon_sym_COLON_COLON] = ACTIONS(312),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(312),
    [anon_sym_COLONappendix_COLON] = ACTIONS(312),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(312),
    [anon_sym_COLONtoc_COLON] = ACTIONS(312),
    [aux_sym_specialblock_token1] = ACTIONS(312),
    [aux_sym_specialblock_token2] = ACTIONS(312),
    [aux_sym_specialblock_token3] = ACTIONS(312),
    [aux_sym_specialblock_token4] = ACTIONS(312),
    [aux_sym_specialblock_token5] = ACTIONS(312),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(312),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(312),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(312),
    [anon_sym_COLONcaption_COLON] = ACTIONS(312),
    [anon_sym_COLONitem_COLON] = ACTIONS(312),
    [anon_sym_COLONprev_COLON] = ACTIONS(312),
    [anon_sym_COLONprev2_COLON] = ACTIONS(312),
    [anon_sym_COLONprev3_COLON] = ACTIONS(312),
    [aux_sym_specialinline_token1] = ACTIONS(314),
    [aux_sym_specialinline_token2] = ACTIONS(314),
    [anon_sym_COLONmath_COLON] = ACTIONS(312),
    [anon_sym_COLONcode_COLON] = ACTIONS(312),
    [aux_sym_specialinline_token3] = ACTIONS(312),
    [aux_sym_specialinline_token4] = ACTIONS(312),
    [anon_sym_COLONref_COLON] = ACTIONS(312),
    [anon_sym_COLONprevious_COLON] = ACTIONS(312),
    [anon_sym_COLONurl_COLON] = ACTIONS(312),
    [anon_sym_COLONcite_COLON] = ACTIONS(312),
    [anon_sym_COLONqed_COLON] = ACTIONS(312),
    [anon_sym_COLONtable_COLON] = ACTIONS(312),
    [anon_sym_COLONassume_COLON] = ACTIONS(312),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(312),
    [anon_sym_COLONprove_COLON] = ACTIONS(312),
    [anon_sym_COLONthen_COLON] = ACTIONS(312),
    [anon_sym_COLONnew_COLON] = ACTIONS(312),
    [anon_sym_COLONlet_COLON] = ACTIONS(312),
    [anon_sym_COLONcase_COLON] = ACTIONS(312),
    [anon_sym_COLONdefine_COLON] = ACTIONS(312),
    [anon_sym_COLONwrite_COLON] = ACTIONS(312),
    [anon_sym_COLONwlog_COLON] = ACTIONS(312),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(312),
    [anon_sym_COLONclaim_COLON] = ACTIONS(312),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(312),
    [anon_sym_COLON_COLON2] = ACTIONS(312),
    [anon_sym_COLONdraft_COLON] = ACTIONS(312),
    [anon_sym_COLONnote_COLON] = ACTIONS(312),
    [anon_sym_COLONspan_COLON] = ACTIONS(312),
    [anon_sym_COLONabstract_COLON] = ACTIONS(312),
    [anon_sym_COLONauthor_COLON] = ACTIONS(312),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(312),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(312),
    [anon_sym_COLONitemize_COLON] = ACTIONS(312),
    [anon_sym_COLONlemma_COLON] = ACTIONS(312),
    [anon_sym_COLONfigure_COLON] = ACTIONS(312),
    [anon_sym_COLONp_COLON] = ACTIONS(312),
    [anon_sym_COLONproof_COLON] = ACTIONS(312),
    [anon_sym_COLONproposition_COLON] = ACTIONS(312),
    [anon_sym_COLONremark_COLON] = ACTIONS(312),
    [anon_sym_COLONsection_COLON] = ACTIONS(312),
    [anon_sym_COLONsketch_COLON] = ACTIONS(312),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(312),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(312),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(312),
    [anon_sym_COLONstep_COLON] = ACTIONS(312),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(312),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(312),
  },
  [47] = {
    [anon_sym_COLON_COLON] = ACTIONS(316),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(316),
    [anon_sym_COLONappendix_COLON] = ACTIONS(316),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(316),
    [anon_sym_COLONtoc_COLON] = ACTIONS(316),
    [aux_sym_specialblock_token1] = ACTIONS(316),
    [aux_sym_specialblock_token2] = ACTIONS(316),
    [aux_sym_specialblock_token3] = ACTIONS(316),
    [aux_sym_specialblock_token4] = ACTIONS(316),
    [aux_sym_specialblock_token5] = ACTIONS(316),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(316),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(316),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(316),
    [anon_sym_COLONcaption_COLON] = ACTIONS(316),
    [anon_sym_COLONitem_COLON] = ACTIONS(316),
    [anon_sym_COLONprev_COLON] = ACTIONS(316),
    [anon_sym_COLONprev2_COLON] = ACTIONS(316),
    [anon_sym_COLONprev3_COLON] = ACTIONS(316),
    [aux_sym_specialinline_token1] = ACTIONS(318),
    [aux_sym_specialinline_token2] = ACTIONS(318),
    [anon_sym_COLONmath_COLON] = ACTIONS(316),
    [anon_sym_COLONcode_COLON] = ACTIONS(316),
    [aux_sym_specialinline_token3] = ACTIONS(316),
    [aux_sym_specialinline_token4] = ACTIONS(316),
    [anon_sym_COLONref_COLON] = ACTIONS(316),
    [anon_sym_COLONprevious_COLON] = ACTIONS(316),
    [anon_sym_COLONurl_COLON] = ACTIONS(316),
    [anon_sym_COLONcite_COLON] = ACTIONS(316),
    [anon_sym_COLONqed_COLON] = ACTIONS(316),
    [anon_sym_COLONtable_COLON] = ACTIONS(316),
    [anon_sym_COLONassume_COLON] = ACTIONS(316),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(316),
    [anon_sym_COLONprove_COLON] = ACTIONS(316),
    [anon_sym_COLONthen_COLON] = ACTIONS(316),
    [anon_sym_COLONnew_COLON] = ACTIONS(316),
    [anon_sym_COLONlet_COLON] = ACTIONS(316),
    [anon_sym_COLONcase_COLON] = ACTIONS(316),
    [anon_sym_COLONdefine_COLON] = ACTIONS(316),
    [anon_sym_COLONwrite_COLON] = ACTIONS(316),
    [anon_sym_COLONwlog_COLON] = ACTIONS(316),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(316),
    [anon_sym_COLONclaim_COLON] = ACTIONS(316),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(316),
    [anon_sym_COLON_COLON2] = ACTIONS(316),
    [anon_sym_COLONdraft_COLON] = ACTIONS(316),
    [anon_sym_COLONnote_COLON] = ACTIONS(316),
    [anon_sym_COLONspan_COLON] = ACTIONS(316),
    [anon_sym_COLONabstract_COLON] = ACTIONS(316),
    [anon_sym_COLONauthor_COLON] = ACTIONS(316),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(316),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(316),
    [anon_sym_COLONitemize_COLON] = ACTIONS(316),
    [anon_sym_COLONlemma_COLON] = ACTIONS(316),
    [anon_sym_COLONfigure_COLON] = ACTIONS(316),
    [anon_sym_COLONp_COLON] = ACTIONS(316),
    [anon_sym_COLONproof_COLON] = ACTIONS(316),
    [anon_sym_COLONproposition_COLON] = ACTIONS(316),
    [anon_sym_COLONremark_COLON] = ACTIONS(316),
    [anon_sym_COLONsection_COLON] = ACTIONS(316),
    [anon_sym_COLONsketch_COLON] = ACTIONS(316),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(316),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(316),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(316),
    [anon_sym_COLONstep_COLON] = ACTIONS(316),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(316),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(316),
  },
  [48] = {
    [anon_sym_COLON_COLON] = ACTIONS(320),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(320),
    [anon_sym_COLONappendix_COLON] = ACTIONS(320),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(320),
    [anon_sym_COLONtoc_COLON] = ACTIONS(320),
    [aux_sym_specialblock_token1] = ACTIONS(320),
    [aux_sym_specialblock_token2] = ACTIONS(320),
    [aux_sym_specialblock_token3] = ACTIONS(320),
    [aux_sym_specialblock_token4] = ACTIONS(320),
    [aux_sym_specialblock_token5] = ACTIONS(320),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(320),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(320),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(320),
    [anon_sym_COLONcaption_COLON] = ACTIONS(320),
    [anon_sym_COLONitem_COLON] = ACTIONS(320),
    [anon_sym_COLONprev_COLON] = ACTIONS(320),
    [anon_sym_COLONprev2_COLON] = ACTIONS(320),
    [anon_sym_COLONprev3_COLON] = ACTIONS(320),
    [aux_sym_specialinline_token1] = ACTIONS(322),
    [aux_sym_specialinline_token2] = ACTIONS(322),
    [anon_sym_COLONmath_COLON] = ACTIONS(320),
    [anon_sym_COLONcode_COLON] = ACTIONS(320),
    [aux_sym_specialinline_token3] = ACTIONS(320),
    [aux_sym_specialinline_token4] = ACTIONS(320),
    [anon_sym_COLONref_COLON] = ACTIONS(320),
    [anon_sym_COLONprevious_COLON] = ACTIONS(320),
    [anon_sym_COLONurl_COLON] = ACTIONS(320),
    [anon_sym_COLONcite_COLON] = ACTIONS(320),
    [anon_sym_COLONqed_COLON] = ACTIONS(320),
    [anon_sym_COLONtable_COLON] = ACTIONS(320),
    [anon_sym_COLONassume_COLON] = ACTIONS(320),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(320),
    [anon_sym_COLONprove_COLON] = ACTIONS(320),
    [anon_sym_COLONthen_COLON] = ACTIONS(320),
    [anon_sym_COLONnew_COLON] = ACTIONS(320),
    [anon_sym_COLONlet_COLON] = ACTIONS(320),
    [anon_sym_COLONcase_COLON] = ACTIONS(320),
    [anon_sym_COLONdefine_COLON] = ACTIONS(320),
    [anon_sym_COLONwrite_COLON] = ACTIONS(320),
    [anon_sym_COLONwlog_COLON] = ACTIONS(320),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(320),
    [anon_sym_COLONclaim_COLON] = ACTIONS(320),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(320),
    [anon_sym_COLON_COLON2] = ACTIONS(320),
    [anon_sym_COLONdraft_COLON] = ACTIONS(320),
    [anon_sym_COLONnote_COLON] = ACTIONS(320),
    [anon_sym_COLONspan_COLON] = ACTIONS(320),
    [anon_sym_COLONabstract_COLON] = ACTIONS(320),
    [anon_sym_COLONauthor_COLON] = ACTIONS(320),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(320),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(320),
    [anon_sym_COLONitemize_COLON] = ACTIONS(320),
    [anon_sym_COLONlemma_COLON] = ACTIONS(320),
    [anon_sym_COLONfigure_COLON] = ACTIONS(320),
    [anon_sym_COLONp_COLON] = ACTIONS(320),
    [anon_sym_COLONproof_COLON] = ACTIONS(320),
    [anon_sym_COLONproposition_COLON] = ACTIONS(320),
    [anon_sym_COLONremark_COLON] = ACTIONS(320),
    [anon_sym_COLONsection_COLON] = ACTIONS(320),
    [anon_sym_COLONsketch_COLON] = ACTIONS(320),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(320),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(320),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(320),
    [anon_sym_COLONstep_COLON] = ACTIONS(320),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(320),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(320),
  },
  [49] = {
    [anon_sym_COLON_COLON] = ACTIONS(324),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(324),
    [anon_sym_COLONappendix_COLON] = ACTIONS(324),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(324),
    [anon_sym_COLONtoc_COLON] = ACTIONS(324),
    [aux_sym_specialblock_token1] = ACTIONS(324),
    [aux_sym_specialblock_token2] = ACTIONS(324),
    [aux_sym_specialblock_token3] = ACTIONS(324),
    [aux_sym_specialblock_token4] = ACTIONS(324),
    [aux_sym_specialblock_token5] = ACTIONS(324),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(324),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(324),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(324),
    [anon_sym_COLONcaption_COLON] = ACTIONS(324),
    [anon_sym_COLONitem_COLON] = ACTIONS(324),
    [anon_sym_COLONprev_COLON] = ACTIONS(324),
    [anon_sym_COLONprev2_COLON] = ACTIONS(324),
    [anon_sym_COLONprev3_COLON] = ACTIONS(324),
    [aux_sym_specialinline_token1] = ACTIONS(326),
    [aux_sym_specialinline_token2] = ACTIONS(326),
    [anon_sym_COLONmath_COLON] = ACTIONS(324),
    [anon_sym_COLONcode_COLON] = ACTIONS(324),
    [aux_sym_specialinline_token3] = ACTIONS(324),
    [aux_sym_specialinline_token4] = ACTIONS(324),
    [anon_sym_COLONref_COLON] = ACTIONS(324),
    [anon_sym_COLONprevious_COLON] = ACTIONS(324),
    [anon_sym_COLONurl_COLON] = ACTIONS(324),
    [anon_sym_COLONcite_COLON] = ACTIONS(324),
    [anon_sym_COLONqed_COLON] = ACTIONS(324),
    [anon_sym_COLONtable_COLON] = ACTIONS(324),
    [anon_sym_COLONassume_COLON] = ACTIONS(324),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(324),
    [anon_sym_COLONprove_COLON] = ACTIONS(324),
    [anon_sym_COLONthen_COLON] = ACTIONS(324),
    [anon_sym_COLONnew_COLON] = ACTIONS(324),
    [anon_sym_COLONlet_COLON] = ACTIONS(324),
    [anon_sym_COLONcase_COLON] = ACTIONS(324),
    [anon_sym_COLONdefine_COLON] = ACTIONS(324),
    [anon_sym_COLONwrite_COLON] = ACTIONS(324),
    [anon_sym_COLONwlog_COLON] = ACTIONS(324),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(324),
    [anon_sym_COLONclaim_COLON] = ACTIONS(324),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(324),
    [anon_sym_COLON_COLON2] = ACTIONS(324),
    [anon_sym_COLONdraft_COLON] = ACTIONS(324),
    [anon_sym_COLONnote_COLON] = ACTIONS(324),
    [anon_sym_COLONspan_COLON] = ACTIONS(324),
    [anon_sym_COLONabstract_COLON] = ACTIONS(324),
    [anon_sym_COLONauthor_COLON] = ACTIONS(324),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(324),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(324),
    [anon_sym_COLONitemize_COLON] = ACTIONS(324),
    [anon_sym_COLONlemma_COLON] = ACTIONS(324),
    [anon_sym_COLONfigure_COLON] = ACTIONS(324),
    [anon_sym_COLONp_COLON] = ACTIONS(324),
    [anon_sym_COLONproof_COLON] = ACTIONS(324),
    [anon_sym_COLONproposition_COLON] = ACTIONS(324),
    [anon_sym_COLONremark_COLON] = ACTIONS(324),
    [anon_sym_COLONsection_COLON] = ACTIONS(324),
    [anon_sym_COLONsketch_COLON] = ACTIONS(324),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(324),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(324),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(324),
    [anon_sym_COLONstep_COLON] = ACTIONS(324),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(324),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(324),
  },
  [50] = {
    [anon_sym_COLON_COLON] = ACTIONS(328),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(328),
    [anon_sym_COLONappendix_COLON] = ACTIONS(328),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(328),
    [anon_sym_COLONtoc_COLON] = ACTIONS(328),
    [aux_sym_specialblock_token1] = ACTIONS(328),
    [aux_sym_specialblock_token2] = ACTIONS(328),
    [aux_sym_specialblock_token3] = ACTIONS(328),
    [aux_sym_specialblock_token4] = ACTIONS(328),
    [aux_sym_specialblock_token5] = ACTIONS(328),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(328),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(328),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(328),
    [anon_sym_COLONcaption_COLON] = ACTIONS(328),
    [anon_sym_COLONitem_COLON] = ACTIONS(328),
    [anon_sym_COLONprev_COLON] = ACTIONS(328),
    [anon_sym_COLONprev2_COLON] = ACTIONS(328),
    [anon_sym_COLONprev3_COLON] = ACTIONS(328),
    [aux_sym_specialinline_token1] = ACTIONS(330),
    [aux_sym_specialinline_token2] = ACTIONS(330),
    [anon_sym_COLONmath_COLON] = ACTIONS(328),
    [anon_sym_COLONcode_COLON] = ACTIONS(328),
    [aux_sym_specialinline_token3] = ACTIONS(328),
    [aux_sym_specialinline_token4] = ACTIONS(328),
    [anon_sym_COLONref_COLON] = ACTIONS(328),
    [anon_sym_COLONprevious_COLON] = ACTIONS(328),
    [anon_sym_COLONurl_COLON] = ACTIONS(328),
    [anon_sym_COLONcite_COLON] = ACTIONS(328),
    [anon_sym_COLONqed_COLON] = ACTIONS(328),
    [anon_sym_COLONtable_COLON] = ACTIONS(328),
    [anon_sym_COLONassume_COLON] = ACTIONS(328),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(328),
    [anon_sym_COLONprove_COLON] = ACTIONS(328),
    [anon_sym_COLONthen_COLON] = ACTIONS(328),
    [anon_sym_COLONnew_COLON] = ACTIONS(328),
    [anon_sym_COLONlet_COLON] = ACTIONS(328),
    [anon_sym_COLONcase_COLON] = ACTIONS(328),
    [anon_sym_COLONdefine_COLON] = ACTIONS(328),
    [anon_sym_COLONwrite_COLON] = ACTIONS(328),
    [anon_sym_COLONwlog_COLON] = ACTIONS(328),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(328),
    [anon_sym_COLONclaim_COLON] = ACTIONS(328),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(328),
    [anon_sym_COLON_COLON2] = ACTIONS(328),
    [anon_sym_COLONdraft_COLON] = ACTIONS(328),
    [anon_sym_COLONnote_COLON] = ACTIONS(328),
    [anon_sym_COLONspan_COLON] = ACTIONS(328),
    [anon_sym_COLONabstract_COLON] = ACTIONS(328),
    [anon_sym_COLONauthor_COLON] = ACTIONS(328),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(328),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(328),
    [anon_sym_COLONitemize_COLON] = ACTIONS(328),
    [anon_sym_COLONlemma_COLON] = ACTIONS(328),
    [anon_sym_COLONfigure_COLON] = ACTIONS(328),
    [anon_sym_COLONp_COLON] = ACTIONS(328),
    [anon_sym_COLONproof_COLON] = ACTIONS(328),
    [anon_sym_COLONproposition_COLON] = ACTIONS(328),
    [anon_sym_COLONremark_COLON] = ACTIONS(328),
    [anon_sym_COLONsection_COLON] = ACTIONS(328),
    [anon_sym_COLONsketch_COLON] = ACTIONS(328),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(328),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(328),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(328),
    [anon_sym_COLONstep_COLON] = ACTIONS(328),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(328),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(328),
  },
  [51] = {
    [anon_sym_COLON_COLON] = ACTIONS(332),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(332),
    [anon_sym_COLONappendix_COLON] = ACTIONS(332),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(332),
    [anon_sym_COLONtoc_COLON] = ACTIONS(332),
    [aux_sym_specialblock_token1] = ACTIONS(332),
    [aux_sym_specialblock_token2] = ACTIONS(332),
    [aux_sym_specialblock_token3] = ACTIONS(332),
    [aux_sym_specialblock_token4] = ACTIONS(332),
    [aux_sym_specialblock_token5] = ACTIONS(332),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(332),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(332),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(332),
    [anon_sym_COLONcaption_COLON] = ACTIONS(332),
    [anon_sym_COLONitem_COLON] = ACTIONS(332),
    [anon_sym_COLONprev_COLON] = ACTIONS(332),
    [anon_sym_COLONprev2_COLON] = ACTIONS(332),
    [anon_sym_COLONprev3_COLON] = ACTIONS(332),
    [aux_sym_specialinline_token1] = ACTIONS(334),
    [aux_sym_specialinline_token2] = ACTIONS(334),
    [anon_sym_COLONmath_COLON] = ACTIONS(332),
    [anon_sym_COLONcode_COLON] = ACTIONS(332),
    [aux_sym_specialinline_token3] = ACTIONS(332),
    [aux_sym_specialinline_token4] = ACTIONS(332),
    [anon_sym_COLONref_COLON] = ACTIONS(332),
    [anon_sym_COLONprevious_COLON] = ACTIONS(332),
    [anon_sym_COLONurl_COLON] = ACTIONS(332),
    [anon_sym_COLONcite_COLON] = ACTIONS(332),
    [anon_sym_COLONqed_COLON] = ACTIONS(332),
    [anon_sym_COLONtable_COLON] = ACTIONS(332),
    [anon_sym_COLONassume_COLON] = ACTIONS(332),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(332),
    [anon_sym_COLONprove_COLON] = ACTIONS(332),
    [anon_sym_COLONthen_COLON] = ACTIONS(332),
    [anon_sym_COLONnew_COLON] = ACTIONS(332),
    [anon_sym_COLONlet_COLON] = ACTIONS(332),
    [anon_sym_COLONcase_COLON] = ACTIONS(332),
    [anon_sym_COLONdefine_COLON] = ACTIONS(332),
    [anon_sym_COLONwrite_COLON] = ACTIONS(332),
    [anon_sym_COLONwlog_COLON] = ACTIONS(332),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(332),
    [anon_sym_COLONclaim_COLON] = ACTIONS(332),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(332),
    [anon_sym_COLON_COLON2] = ACTIONS(332),
    [anon_sym_COLONdraft_COLON] = ACTIONS(332),
    [anon_sym_COLONnote_COLON] = ACTIONS(332),
    [anon_sym_COLONspan_COLON] = ACTIONS(332),
    [anon_sym_COLONabstract_COLON] = ACTIONS(332),
    [anon_sym_COLONauthor_COLON] = ACTIONS(332),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(332),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(332),
    [anon_sym_COLONitemize_COLON] = ACTIONS(332),
    [anon_sym_COLONlemma_COLON] = ACTIONS(332),
    [anon_sym_COLONfigure_COLON] = ACTIONS(332),
    [anon_sym_COLONp_COLON] = ACTIONS(332),
    [anon_sym_COLONproof_COLON] = ACTIONS(332),
    [anon_sym_COLONproposition_COLON] = ACTIONS(332),
    [anon_sym_COLONremark_COLON] = ACTIONS(332),
    [anon_sym_COLONsection_COLON] = ACTIONS(332),
    [anon_sym_COLONsketch_COLON] = ACTIONS(332),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(332),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(332),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(332),
    [anon_sym_COLONstep_COLON] = ACTIONS(332),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(332),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(332),
  },
  [52] = {
    [anon_sym_COLON_COLON] = ACTIONS(336),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(336),
    [anon_sym_COLONappendix_COLON] = ACTIONS(336),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(336),
    [anon_sym_COLONtoc_COLON] = ACTIONS(336),
    [aux_sym_specialblock_token1] = ACTIONS(336),
    [aux_sym_specialblock_token2] = ACTIONS(336),
    [aux_sym_specialblock_token3] = ACTIONS(336),
    [aux_sym_specialblock_token4] = ACTIONS(336),
    [aux_sym_specialblock_token5] = ACTIONS(336),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(336),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(336),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(336),
    [anon_sym_COLONcaption_COLON] = ACTIONS(336),
    [anon_sym_COLONitem_COLON] = ACTIONS(336),
    [anon_sym_COLONprev_COLON] = ACTIONS(336),
    [anon_sym_COLONprev2_COLON] = ACTIONS(336),
    [anon_sym_COLONprev3_COLON] = ACTIONS(336),
    [aux_sym_specialinline_token1] = ACTIONS(338),
    [aux_sym_specialinline_token2] = ACTIONS(338),
    [anon_sym_COLONmath_COLON] = ACTIONS(336),
    [anon_sym_COLONcode_COLON] = ACTIONS(336),
    [aux_sym_specialinline_token3] = ACTIONS(336),
    [aux_sym_specialinline_token4] = ACTIONS(336),
    [anon_sym_COLONref_COLON] = ACTIONS(336),
    [anon_sym_COLONprevious_COLON] = ACTIONS(336),
    [anon_sym_COLONurl_COLON] = ACTIONS(336),
    [anon_sym_COLONcite_COLON] = ACTIONS(336),
    [anon_sym_COLONqed_COLON] = ACTIONS(336),
    [anon_sym_COLONtable_COLON] = ACTIONS(336),
    [anon_sym_COLONassume_COLON] = ACTIONS(336),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(336),
    [anon_sym_COLONprove_COLON] = ACTIONS(336),
    [anon_sym_COLONthen_COLON] = ACTIONS(336),
    [anon_sym_COLONnew_COLON] = ACTIONS(336),
    [anon_sym_COLONlet_COLON] = ACTIONS(336),
    [anon_sym_COLONcase_COLON] = ACTIONS(336),
    [anon_sym_COLONdefine_COLON] = ACTIONS(336),
    [anon_sym_COLONwrite_COLON] = ACTIONS(336),
    [anon_sym_COLONwlog_COLON] = ACTIONS(336),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(336),
    [anon_sym_COLONclaim_COLON] = ACTIONS(336),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(336),
    [anon_sym_COLON_COLON2] = ACTIONS(336),
    [anon_sym_COLONdraft_COLON] = ACTIONS(336),
    [anon_sym_COLONnote_COLON] = ACTIONS(336),
    [anon_sym_COLONspan_COLON] = ACTIONS(336),
    [anon_sym_COLONabstract_COLON] = ACTIONS(336),
    [anon_sym_COLONauthor_COLON] = ACTIONS(336),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(336),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(336),
    [anon_sym_COLONitemize_COLON] = ACTIONS(336),
    [anon_sym_COLONlemma_COLON] = ACTIONS(336),
    [anon_sym_COLONfigure_COLON] = ACTIONS(336),
    [anon_sym_COLONp_COLON] = ACTIONS(336),
    [anon_sym_COLONproof_COLON] = ACTIONS(336),
    [anon_sym_COLONproposition_COLON] = ACTIONS(336),
    [anon_sym_COLONremark_COLON] = ACTIONS(336),
    [anon_sym_COLONsection_COLON] = ACTIONS(336),
    [anon_sym_COLONsketch_COLON] = ACTIONS(336),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(336),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(336),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(336),
    [anon_sym_COLONstep_COLON] = ACTIONS(336),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(336),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(336),
  },
  [53] = {
    [anon_sym_COLON_COLON] = ACTIONS(340),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(340),
    [anon_sym_COLONappendix_COLON] = ACTIONS(340),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(340),
    [anon_sym_COLONtoc_COLON] = ACTIONS(340),
    [aux_sym_specialblock_token1] = ACTIONS(340),
    [aux_sym_specialblock_token2] = ACTIONS(340),
    [aux_sym_specialblock_token3] = ACTIONS(340),
    [aux_sym_specialblock_token4] = ACTIONS(340),
    [aux_sym_specialblock_token5] = ACTIONS(340),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(340),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(340),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(340),
    [anon_sym_COLONcaption_COLON] = ACTIONS(340),
    [anon_sym_COLONitem_COLON] = ACTIONS(340),
    [anon_sym_COLONprev_COLON] = ACTIONS(340),
    [anon_sym_COLONprev2_COLON] = ACTIONS(340),
    [anon_sym_COLONprev3_COLON] = ACTIONS(340),
    [aux_sym_specialinline_token1] = ACTIONS(342),
    [aux_sym_specialinline_token2] = ACTIONS(342),
    [anon_sym_COLONmath_COLON] = ACTIONS(340),
    [anon_sym_COLONcode_COLON] = ACTIONS(340),
    [aux_sym_specialinline_token3] = ACTIONS(340),
    [aux_sym_specialinline_token4] = ACTIONS(340),
    [anon_sym_COLONref_COLON] = ACTIONS(340),
    [anon_sym_COLONprevious_COLON] = ACTIONS(340),
    [anon_sym_COLONurl_COLON] = ACTIONS(340),
    [anon_sym_COLONcite_COLON] = ACTIONS(340),
    [anon_sym_COLONqed_COLON] = ACTIONS(340),
    [anon_sym_COLONtable_COLON] = ACTIONS(340),
    [anon_sym_COLONassume_COLON] = ACTIONS(340),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(340),
    [anon_sym_COLONprove_COLON] = ACTIONS(340),
    [anon_sym_COLONthen_COLON] = ACTIONS(340),
    [anon_sym_COLONnew_COLON] = ACTIONS(340),
    [anon_sym_COLONlet_COLON] = ACTIONS(340),
    [anon_sym_COLONcase_COLON] = ACTIONS(340),
    [anon_sym_COLONdefine_COLON] = ACTIONS(340),
    [anon_sym_COLONwrite_COLON] = ACTIONS(340),
    [anon_sym_COLONwlog_COLON] = ACTIONS(340),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(340),
    [anon_sym_COLONclaim_COLON] = ACTIONS(340),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(340),
    [anon_sym_COLON_COLON2] = ACTIONS(340),
    [anon_sym_COLONdraft_COLON] = ACTIONS(340),
    [anon_sym_COLONnote_COLON] = ACTIONS(340),
    [anon_sym_COLONspan_COLON] = ACTIONS(340),
    [anon_sym_COLONabstract_COLON] = ACTIONS(340),
    [anon_sym_COLONauthor_COLON] = ACTIONS(340),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(340),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(340),
    [anon_sym_COLONitemize_COLON] = ACTIONS(340),
    [anon_sym_COLONlemma_COLON] = ACTIONS(340),
    [anon_sym_COLONfigure_COLON] = ACTIONS(340),
    [anon_sym_COLONp_COLON] = ACTIONS(340),
    [anon_sym_COLONproof_COLON] = ACTIONS(340),
    [anon_sym_COLONproposition_COLON] = ACTIONS(340),
    [anon_sym_COLONremark_COLON] = ACTIONS(340),
    [anon_sym_COLONsection_COLON] = ACTIONS(340),
    [anon_sym_COLONsketch_COLON] = ACTIONS(340),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(340),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(340),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(340),
    [anon_sym_COLONstep_COLON] = ACTIONS(340),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(340),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(340),
  },
  [54] = {
    [anon_sym_COLON_COLON] = ACTIONS(344),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(344),
    [anon_sym_COLONappendix_COLON] = ACTIONS(344),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(344),
    [anon_sym_COLONtoc_COLON] = ACTIONS(344),
    [aux_sym_specialblock_token1] = ACTIONS(344),
    [aux_sym_specialblock_token2] = ACTIONS(344),
    [aux_sym_specialblock_token3] = ACTIONS(344),
    [aux_sym_specialblock_token4] = ACTIONS(344),
    [aux_sym_specialblock_token5] = ACTIONS(344),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(344),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(344),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(344),
    [anon_sym_COLONcaption_COLON] = ACTIONS(344),
    [anon_sym_COLONitem_COLON] = ACTIONS(344),
    [anon_sym_COLONprev_COLON] = ACTIONS(344),
    [anon_sym_COLONprev2_COLON] = ACTIONS(344),
    [anon_sym_COLONprev3_COLON] = ACTIONS(344),
    [aux_sym_specialinline_token1] = ACTIONS(346),
    [aux_sym_specialinline_token2] = ACTIONS(346),
    [anon_sym_COLONmath_COLON] = ACTIONS(344),
    [anon_sym_COLONcode_COLON] = ACTIONS(344),
    [aux_sym_specialinline_token3] = ACTIONS(344),
    [aux_sym_specialinline_token4] = ACTIONS(344),
    [anon_sym_COLONref_COLON] = ACTIONS(344),
    [anon_sym_COLONprevious_COLON] = ACTIONS(344),
    [anon_sym_COLONurl_COLON] = ACTIONS(344),
    [anon_sym_COLONcite_COLON] = ACTIONS(344),
    [anon_sym_COLONqed_COLON] = ACTIONS(344),
    [anon_sym_COLONtable_COLON] = ACTIONS(344),
    [anon_sym_COLONassume_COLON] = ACTIONS(344),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(344),
    [anon_sym_COLONprove_COLON] = ACTIONS(344),
    [anon_sym_COLONthen_COLON] = ACTIONS(344),
    [anon_sym_COLONnew_COLON] = ACTIONS(344),
    [anon_sym_COLONlet_COLON] = ACTIONS(344),
    [anon_sym_COLONcase_COLON] = ACTIONS(344),
    [anon_sym_COLONdefine_COLON] = ACTIONS(344),
    [anon_sym_COLONwrite_COLON] = ACTIONS(344),
    [anon_sym_COLONwlog_COLON] = ACTIONS(344),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(344),
    [anon_sym_COLONclaim_COLON] = ACTIONS(344),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(344),
    [anon_sym_COLON_COLON2] = ACTIONS(344),
    [anon_sym_COLONdraft_COLON] = ACTIONS(344),
    [anon_sym_COLONnote_COLON] = ACTIONS(344),
    [anon_sym_COLONspan_COLON] = ACTIONS(344),
    [anon_sym_COLONabstract_COLON] = ACTIONS(344),
    [anon_sym_COLONauthor_COLON] = ACTIONS(344),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(344),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(344),
    [anon_sym_COLONitemize_COLON] = ACTIONS(344),
    [anon_sym_COLONlemma_COLON] = ACTIONS(344),
    [anon_sym_COLONfigure_COLON] = ACTIONS(344),
    [anon_sym_COLONp_COLON] = ACTIONS(344),
    [anon_sym_COLONproof_COLON] = ACTIONS(344),
    [anon_sym_COLONproposition_COLON] = ACTIONS(344),
    [anon_sym_COLONremark_COLON] = ACTIONS(344),
    [anon_sym_COLONsection_COLON] = ACTIONS(344),
    [anon_sym_COLONsketch_COLON] = ACTIONS(344),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(344),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(344),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(344),
    [anon_sym_COLONstep_COLON] = ACTIONS(344),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(344),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(344),
  },
  [55] = {
    [anon_sym_COLON_COLON] = ACTIONS(348),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(348),
    [anon_sym_COLONappendix_COLON] = ACTIONS(348),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(348),
    [anon_sym_COLONtoc_COLON] = ACTIONS(348),
    [aux_sym_specialblock_token1] = ACTIONS(348),
    [aux_sym_specialblock_token2] = ACTIONS(348),
    [aux_sym_specialblock_token3] = ACTIONS(348),
    [aux_sym_specialblock_token4] = ACTIONS(348),
    [aux_sym_specialblock_token5] = ACTIONS(348),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(348),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(348),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(348),
    [anon_sym_COLONcaption_COLON] = ACTIONS(348),
    [anon_sym_COLONitem_COLON] = ACTIONS(348),
    [anon_sym_COLONprev_COLON] = ACTIONS(348),
    [anon_sym_COLONprev2_COLON] = ACTIONS(348),
    [anon_sym_COLONprev3_COLON] = ACTIONS(348),
    [aux_sym_specialinline_token1] = ACTIONS(350),
    [aux_sym_specialinline_token2] = ACTIONS(350),
    [anon_sym_COLONmath_COLON] = ACTIONS(348),
    [anon_sym_COLONcode_COLON] = ACTIONS(348),
    [aux_sym_specialinline_token3] = ACTIONS(348),
    [aux_sym_specialinline_token4] = ACTIONS(348),
    [anon_sym_COLONref_COLON] = ACTIONS(348),
    [anon_sym_COLONprevious_COLON] = ACTIONS(348),
    [anon_sym_COLONurl_COLON] = ACTIONS(348),
    [anon_sym_COLONcite_COLON] = ACTIONS(348),
    [anon_sym_COLONqed_COLON] = ACTIONS(348),
    [anon_sym_COLONtable_COLON] = ACTIONS(348),
    [anon_sym_COLONassume_COLON] = ACTIONS(348),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(348),
    [anon_sym_COLONprove_COLON] = ACTIONS(348),
    [anon_sym_COLONthen_COLON] = ACTIONS(348),
    [anon_sym_COLONnew_COLON] = ACTIONS(348),
    [anon_sym_COLONlet_COLON] = ACTIONS(348),
    [anon_sym_COLONcase_COLON] = ACTIONS(348),
    [anon_sym_COLONdefine_COLON] = ACTIONS(348),
    [anon_sym_COLONwrite_COLON] = ACTIONS(348),
    [anon_sym_COLONwlog_COLON] = ACTIONS(348),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(348),
    [anon_sym_COLONclaim_COLON] = ACTIONS(348),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(348),
    [anon_sym_COLON_COLON2] = ACTIONS(348),
    [anon_sym_COLONdraft_COLON] = ACTIONS(348),
    [anon_sym_COLONnote_COLON] = ACTIONS(348),
    [anon_sym_COLONspan_COLON] = ACTIONS(348),
    [anon_sym_COLONabstract_COLON] = ACTIONS(348),
    [anon_sym_COLONauthor_COLON] = ACTIONS(348),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(348),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(348),
    [anon_sym_COLONitemize_COLON] = ACTIONS(348),
    [anon_sym_COLONlemma_COLON] = ACTIONS(348),
    [anon_sym_COLONfigure_COLON] = ACTIONS(348),
    [anon_sym_COLONp_COLON] = ACTIONS(348),
    [anon_sym_COLONproof_COLON] = ACTIONS(348),
    [anon_sym_COLONproposition_COLON] = ACTIONS(348),
    [anon_sym_COLONremark_COLON] = ACTIONS(348),
    [anon_sym_COLONsection_COLON] = ACTIONS(348),
    [anon_sym_COLONsketch_COLON] = ACTIONS(348),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(348),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(348),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(348),
    [anon_sym_COLONstep_COLON] = ACTIONS(348),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(348),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(348),
  },
  [56] = {
    [anon_sym_COLON_COLON] = ACTIONS(352),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(352),
    [anon_sym_COLONappendix_COLON] = ACTIONS(352),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(352),
    [anon_sym_COLONtoc_COLON] = ACTIONS(352),
    [aux_sym_specialblock_token1] = ACTIONS(352),
    [aux_sym_specialblock_token2] = ACTIONS(352),
    [aux_sym_specialblock_token3] = ACTIONS(352),
    [aux_sym_specialblock_token4] = ACTIONS(352),
    [aux_sym_specialblock_token5] = ACTIONS(352),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(352),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(352),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(352),
    [anon_sym_COLONcaption_COLON] = ACTIONS(352),
    [anon_sym_COLONitem_COLON] = ACTIONS(352),
    [anon_sym_COLONprev_COLON] = ACTIONS(352),
    [anon_sym_COLONprev2_COLON] = ACTIONS(352),
    [anon_sym_COLONprev3_COLON] = ACTIONS(352),
    [aux_sym_specialinline_token1] = ACTIONS(354),
    [aux_sym_specialinline_token2] = ACTIONS(354),
    [anon_sym_COLONmath_COLON] = ACTIONS(352),
    [anon_sym_COLONcode_COLON] = ACTIONS(352),
    [aux_sym_specialinline_token3] = ACTIONS(352),
    [aux_sym_specialinline_token4] = ACTIONS(352),
    [anon_sym_COLONref_COLON] = ACTIONS(352),
    [anon_sym_COLONprevious_COLON] = ACTIONS(352),
    [anon_sym_COLONurl_COLON] = ACTIONS(352),
    [anon_sym_COLONcite_COLON] = ACTIONS(352),
    [anon_sym_COLONqed_COLON] = ACTIONS(352),
    [anon_sym_COLONtable_COLON] = ACTIONS(352),
    [anon_sym_COLONassume_COLON] = ACTIONS(352),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(352),
    [anon_sym_COLONprove_COLON] = ACTIONS(352),
    [anon_sym_COLONthen_COLON] = ACTIONS(352),
    [anon_sym_COLONnew_COLON] = ACTIONS(352),
    [anon_sym_COLONlet_COLON] = ACTIONS(352),
    [anon_sym_COLONcase_COLON] = ACTIONS(352),
    [anon_sym_COLONdefine_COLON] = ACTIONS(352),
    [anon_sym_COLONwrite_COLON] = ACTIONS(352),
    [anon_sym_COLONwlog_COLON] = ACTIONS(352),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(352),
    [anon_sym_COLONclaim_COLON] = ACTIONS(352),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(352),
    [anon_sym_COLON_COLON2] = ACTIONS(352),
    [anon_sym_COLONdraft_COLON] = ACTIONS(352),
    [anon_sym_COLONnote_COLON] = ACTIONS(352),
    [anon_sym_COLONspan_COLON] = ACTIONS(352),
    [anon_sym_COLONabstract_COLON] = ACTIONS(352),
    [anon_sym_COLONauthor_COLON] = ACTIONS(352),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(352),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(352),
    [anon_sym_COLONitemize_COLON] = ACTIONS(352),
    [anon_sym_COLONlemma_COLON] = ACTIONS(352),
    [anon_sym_COLONfigure_COLON] = ACTIONS(352),
    [anon_sym_COLONp_COLON] = ACTIONS(352),
    [anon_sym_COLONproof_COLON] = ACTIONS(352),
    [anon_sym_COLONproposition_COLON] = ACTIONS(352),
    [anon_sym_COLONremark_COLON] = ACTIONS(352),
    [anon_sym_COLONsection_COLON] = ACTIONS(352),
    [anon_sym_COLONsketch_COLON] = ACTIONS(352),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(352),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(352),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(352),
    [anon_sym_COLONstep_COLON] = ACTIONS(352),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(352),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(352),
  },
  [57] = {
    [anon_sym_COLON_COLON] = ACTIONS(356),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(356),
    [anon_sym_COLONappendix_COLON] = ACTIONS(356),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(356),
    [anon_sym_COLONtoc_COLON] = ACTIONS(356),
    [aux_sym_specialblock_token1] = ACTIONS(356),
    [aux_sym_specialblock_token2] = ACTIONS(356),
    [aux_sym_specialblock_token3] = ACTIONS(356),
    [aux_sym_specialblock_token4] = ACTIONS(356),
    [aux_sym_specialblock_token5] = ACTIONS(356),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(356),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(356),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(356),
    [anon_sym_COLONcaption_COLON] = ACTIONS(356),
    [anon_sym_COLONitem_COLON] = ACTIONS(356),
    [anon_sym_COLONprev_COLON] = ACTIONS(356),
    [anon_sym_COLONprev2_COLON] = ACTIONS(356),
    [anon_sym_COLONprev3_COLON] = ACTIONS(356),
    [aux_sym_specialinline_token1] = ACTIONS(358),
    [aux_sym_specialinline_token2] = ACTIONS(358),
    [anon_sym_COLONmath_COLON] = ACTIONS(356),
    [anon_sym_COLONcode_COLON] = ACTIONS(356),
    [aux_sym_specialinline_token3] = ACTIONS(356),
    [aux_sym_specialinline_token4] = ACTIONS(356),
    [anon_sym_COLONref_COLON] = ACTIONS(356),
    [anon_sym_COLONprevious_COLON] = ACTIONS(356),
    [anon_sym_COLONurl_COLON] = ACTIONS(356),
    [anon_sym_COLONcite_COLON] = ACTIONS(356),
    [anon_sym_COLONqed_COLON] = ACTIONS(356),
    [anon_sym_COLONtable_COLON] = ACTIONS(356),
    [anon_sym_COLONassume_COLON] = ACTIONS(356),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(356),
    [anon_sym_COLONprove_COLON] = ACTIONS(356),
    [anon_sym_COLONthen_COLON] = ACTIONS(356),
    [anon_sym_COLONnew_COLON] = ACTIONS(356),
    [anon_sym_COLONlet_COLON] = ACTIONS(356),
    [anon_sym_COLONcase_COLON] = ACTIONS(356),
    [anon_sym_COLONdefine_COLON] = ACTIONS(356),
    [anon_sym_COLONwrite_COLON] = ACTIONS(356),
    [anon_sym_COLONwlog_COLON] = ACTIONS(356),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(356),
    [anon_sym_COLONclaim_COLON] = ACTIONS(356),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(356),
    [anon_sym_COLON_COLON2] = ACTIONS(356),
    [anon_sym_COLONdraft_COLON] = ACTIONS(356),
    [anon_sym_COLONnote_COLON] = ACTIONS(356),
    [anon_sym_COLONspan_COLON] = ACTIONS(356),
    [anon_sym_COLONabstract_COLON] = ACTIONS(356),
    [anon_sym_COLONauthor_COLON] = ACTIONS(356),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(356),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(356),
    [anon_sym_COLONitemize_COLON] = ACTIONS(356),
    [anon_sym_COLONlemma_COLON] = ACTIONS(356),
    [anon_sym_COLONfigure_COLON] = ACTIONS(356),
    [anon_sym_COLONp_COLON] = ACTIONS(356),
    [anon_sym_COLONproof_COLON] = ACTIONS(356),
    [anon_sym_COLONproposition_COLON] = ACTIONS(356),
    [anon_sym_COLONremark_COLON] = ACTIONS(356),
    [anon_sym_COLONsection_COLON] = ACTIONS(356),
    [anon_sym_COLONsketch_COLON] = ACTIONS(356),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(356),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(356),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(356),
    [anon_sym_COLONstep_COLON] = ACTIONS(356),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(356),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(356),
  },
  [58] = {
    [anon_sym_COLON_COLON] = ACTIONS(360),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(360),
    [anon_sym_COLONappendix_COLON] = ACTIONS(360),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(360),
    [anon_sym_COLONtoc_COLON] = ACTIONS(360),
    [aux_sym_specialblock_token1] = ACTIONS(360),
    [aux_sym_specialblock_token2] = ACTIONS(360),
    [aux_sym_specialblock_token3] = ACTIONS(360),
    [aux_sym_specialblock_token4] = ACTIONS(360),
    [aux_sym_specialblock_token5] = ACTIONS(360),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(360),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(360),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(360),
    [anon_sym_COLONcaption_COLON] = ACTIONS(360),
    [anon_sym_COLONitem_COLON] = ACTIONS(360),
    [anon_sym_COLONprev_COLON] = ACTIONS(360),
    [anon_sym_COLONprev2_COLON] = ACTIONS(360),
    [anon_sym_COLONprev3_COLON] = ACTIONS(360),
    [aux_sym_specialinline_token1] = ACTIONS(362),
    [aux_sym_specialinline_token2] = ACTIONS(362),
    [anon_sym_COLONmath_COLON] = ACTIONS(360),
    [anon_sym_COLONcode_COLON] = ACTIONS(360),
    [aux_sym_specialinline_token3] = ACTIONS(360),
    [aux_sym_specialinline_token4] = ACTIONS(360),
    [anon_sym_COLONref_COLON] = ACTIONS(360),
    [anon_sym_COLONprevious_COLON] = ACTIONS(360),
    [anon_sym_COLONurl_COLON] = ACTIONS(360),
    [anon_sym_COLONcite_COLON] = ACTIONS(360),
    [anon_sym_COLONqed_COLON] = ACTIONS(360),
    [anon_sym_COLONtable_COLON] = ACTIONS(360),
    [anon_sym_COLONassume_COLON] = ACTIONS(360),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(360),
    [anon_sym_COLONprove_COLON] = ACTIONS(360),
    [anon_sym_COLONthen_COLON] = ACTIONS(360),
    [anon_sym_COLONnew_COLON] = ACTIONS(360),
    [anon_sym_COLONlet_COLON] = ACTIONS(360),
    [anon_sym_COLONcase_COLON] = ACTIONS(360),
    [anon_sym_COLONdefine_COLON] = ACTIONS(360),
    [anon_sym_COLONwrite_COLON] = ACTIONS(360),
    [anon_sym_COLONwlog_COLON] = ACTIONS(360),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(360),
    [anon_sym_COLONclaim_COLON] = ACTIONS(360),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(360),
    [anon_sym_COLON_COLON2] = ACTIONS(360),
    [anon_sym_COLONdraft_COLON] = ACTIONS(360),
    [anon_sym_COLONnote_COLON] = ACTIONS(360),
    [anon_sym_COLONspan_COLON] = ACTIONS(360),
    [anon_sym_COLONabstract_COLON] = ACTIONS(360),
    [anon_sym_COLONauthor_COLON] = ACTIONS(360),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(360),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(360),
    [anon_sym_COLONitemize_COLON] = ACTIONS(360),
    [anon_sym_COLONlemma_COLON] = ACTIONS(360),
    [anon_sym_COLONfigure_COLON] = ACTIONS(360),
    [anon_sym_COLONp_COLON] = ACTIONS(360),
    [anon_sym_COLONproof_COLON] = ACTIONS(360),
    [anon_sym_COLONproposition_COLON] = ACTIONS(360),
    [anon_sym_COLONremark_COLON] = ACTIONS(360),
    [anon_sym_COLONsection_COLON] = ACTIONS(360),
    [anon_sym_COLONsketch_COLON] = ACTIONS(360),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(360),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(360),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(360),
    [anon_sym_COLONstep_COLON] = ACTIONS(360),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(360),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(360),
  },
  [59] = {
    [anon_sym_COLON_COLON] = ACTIONS(364),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(364),
    [anon_sym_COLONappendix_COLON] = ACTIONS(364),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(364),
    [anon_sym_COLONtoc_COLON] = ACTIONS(364),
    [aux_sym_specialblock_token1] = ACTIONS(364),
    [aux_sym_specialblock_token2] = ACTIONS(364),
    [aux_sym_specialblock_token3] = ACTIONS(364),
    [aux_sym_specialblock_token4] = ACTIONS(364),
    [aux_sym_specialblock_token5] = ACTIONS(364),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(364),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(364),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(364),
    [anon_sym_COLONcaption_COLON] = ACTIONS(364),
    [anon_sym_COLONitem_COLON] = ACTIONS(364),
    [anon_sym_COLONprev_COLON] = ACTIONS(364),
    [anon_sym_COLONprev2_COLON] = ACTIONS(364),
    [anon_sym_COLONprev3_COLON] = ACTIONS(364),
    [aux_sym_specialinline_token1] = ACTIONS(366),
    [aux_sym_specialinline_token2] = ACTIONS(366),
    [anon_sym_COLONmath_COLON] = ACTIONS(364),
    [anon_sym_COLONcode_COLON] = ACTIONS(364),
    [aux_sym_specialinline_token3] = ACTIONS(364),
    [aux_sym_specialinline_token4] = ACTIONS(364),
    [anon_sym_COLONref_COLON] = ACTIONS(364),
    [anon_sym_COLONprevious_COLON] = ACTIONS(364),
    [anon_sym_COLONurl_COLON] = ACTIONS(364),
    [anon_sym_COLONcite_COLON] = ACTIONS(364),
    [anon_sym_COLONqed_COLON] = ACTIONS(364),
    [anon_sym_COLONtable_COLON] = ACTIONS(364),
    [anon_sym_COLONassume_COLON] = ACTIONS(364),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(364),
    [anon_sym_COLONprove_COLON] = ACTIONS(364),
    [anon_sym_COLONthen_COLON] = ACTIONS(364),
    [anon_sym_COLONnew_COLON] = ACTIONS(364),
    [anon_sym_COLONlet_COLON] = ACTIONS(364),
    [anon_sym_COLONcase_COLON] = ACTIONS(364),
    [anon_sym_COLONdefine_COLON] = ACTIONS(364),
    [anon_sym_COLONwrite_COLON] = ACTIONS(364),
    [anon_sym_COLONwlog_COLON] = ACTIONS(364),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(364),
    [anon_sym_COLONclaim_COLON] = ACTIONS(364),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(364),
    [anon_sym_COLON_COLON2] = ACTIONS(364),
    [anon_sym_COLONdraft_COLON] = ACTIONS(364),
    [anon_sym_COLONnote_COLON] = ACTIONS(364),
    [anon_sym_COLONspan_COLON] = ACTIONS(364),
    [anon_sym_COLONabstract_COLON] = ACTIONS(364),
    [anon_sym_COLONauthor_COLON] = ACTIONS(364),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(364),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(364),
    [anon_sym_COLONitemize_COLON] = ACTIONS(364),
    [anon_sym_COLONlemma_COLON] = ACTIONS(364),
    [anon_sym_COLONfigure_COLON] = ACTIONS(364),
    [anon_sym_COLONp_COLON] = ACTIONS(364),
    [anon_sym_COLONproof_COLON] = ACTIONS(364),
    [anon_sym_COLONproposition_COLON] = ACTIONS(364),
    [anon_sym_COLONremark_COLON] = ACTIONS(364),
    [anon_sym_COLONsection_COLON] = ACTIONS(364),
    [anon_sym_COLONsketch_COLON] = ACTIONS(364),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(364),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(364),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(364),
    [anon_sym_COLONstep_COLON] = ACTIONS(364),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(364),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(364),
  },
  [60] = {
    [anon_sym_COLON_COLON] = ACTIONS(368),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(368),
    [anon_sym_COLONappendix_COLON] = ACTIONS(368),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(368),
    [anon_sym_COLONtoc_COLON] = ACTIONS(368),
    [aux_sym_specialblock_token1] = ACTIONS(368),
    [aux_sym_specialblock_token2] = ACTIONS(368),
    [aux_sym_specialblock_token3] = ACTIONS(368),
    [aux_sym_specialblock_token4] = ACTIONS(368),
    [aux_sym_specialblock_token5] = ACTIONS(368),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(368),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(368),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(368),
    [anon_sym_COLONcaption_COLON] = ACTIONS(368),
    [anon_sym_COLONitem_COLON] = ACTIONS(368),
    [anon_sym_COLONprev_COLON] = ACTIONS(368),
    [anon_sym_COLONprev2_COLON] = ACTIONS(368),
    [anon_sym_COLONprev3_COLON] = ACTIONS(368),
    [aux_sym_specialinline_token1] = ACTIONS(370),
    [aux_sym_specialinline_token2] = ACTIONS(370),
    [anon_sym_COLONmath_COLON] = ACTIONS(368),
    [anon_sym_COLONcode_COLON] = ACTIONS(368),
    [aux_sym_specialinline_token3] = ACTIONS(368),
    [aux_sym_specialinline_token4] = ACTIONS(368),
    [anon_sym_COLONref_COLON] = ACTIONS(368),
    [anon_sym_COLONprevious_COLON] = ACTIONS(368),
    [anon_sym_COLONurl_COLON] = ACTIONS(368),
    [anon_sym_COLONcite_COLON] = ACTIONS(368),
    [anon_sym_COLONqed_COLON] = ACTIONS(368),
    [anon_sym_COLONtable_COLON] = ACTIONS(368),
    [anon_sym_COLONassume_COLON] = ACTIONS(368),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(368),
    [anon_sym_COLONprove_COLON] = ACTIONS(368),
    [anon_sym_COLONthen_COLON] = ACTIONS(368),
    [anon_sym_COLONnew_COLON] = ACTIONS(368),
    [anon_sym_COLONlet_COLON] = ACTIONS(368),
    [anon_sym_COLONcase_COLON] = ACTIONS(368),
    [anon_sym_COLONdefine_COLON] = ACTIONS(368),
    [anon_sym_COLONwrite_COLON] = ACTIONS(368),
    [anon_sym_COLONwlog_COLON] = ACTIONS(368),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(368),
    [anon_sym_COLONclaim_COLON] = ACTIONS(368),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(368),
    [anon_sym_COLON_COLON2] = ACTIONS(368),
    [anon_sym_COLONdraft_COLON] = ACTIONS(368),
    [anon_sym_COLONnote_COLON] = ACTIONS(368),
    [anon_sym_COLONspan_COLON] = ACTIONS(368),
    [anon_sym_COLONabstract_COLON] = ACTIONS(368),
    [anon_sym_COLONauthor_COLON] = ACTIONS(368),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(368),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(368),
    [anon_sym_COLONitemize_COLON] = ACTIONS(368),
    [anon_sym_COLONlemma_COLON] = ACTIONS(368),
    [anon_sym_COLONfigure_COLON] = ACTIONS(368),
    [anon_sym_COLONp_COLON] = ACTIONS(368),
    [anon_sym_COLONproof_COLON] = ACTIONS(368),
    [anon_sym_COLONproposition_COLON] = ACTIONS(368),
    [anon_sym_COLONremark_COLON] = ACTIONS(368),
    [anon_sym_COLONsection_COLON] = ACTIONS(368),
    [anon_sym_COLONsketch_COLON] = ACTIONS(368),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(368),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(368),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(368),
    [anon_sym_COLONstep_COLON] = ACTIONS(368),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(368),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(368),
  },
  [61] = {
    [anon_sym_COLON_COLON] = ACTIONS(372),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(372),
    [anon_sym_COLONappendix_COLON] = ACTIONS(372),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(372),
    [anon_sym_COLONtoc_COLON] = ACTIONS(372),
    [aux_sym_specialblock_token1] = ACTIONS(372),
    [aux_sym_specialblock_token2] = ACTIONS(372),
    [aux_sym_specialblock_token3] = ACTIONS(372),
    [aux_sym_specialblock_token4] = ACTIONS(372),
    [aux_sym_specialblock_token5] = ACTIONS(372),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(372),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(372),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(372),
    [anon_sym_COLONcaption_COLON] = ACTIONS(372),
    [anon_sym_COLONitem_COLON] = ACTIONS(372),
    [anon_sym_COLONprev_COLON] = ACTIONS(372),
    [anon_sym_COLONprev2_COLON] = ACTIONS(372),
    [anon_sym_COLONprev3_COLON] = ACTIONS(372),
    [aux_sym_specialinline_token1] = ACTIONS(374),
    [aux_sym_specialinline_token2] = ACTIONS(374),
    [anon_sym_COLONmath_COLON] = ACTIONS(372),
    [anon_sym_COLONcode_COLON] = ACTIONS(372),
    [aux_sym_specialinline_token3] = ACTIONS(372),
    [aux_sym_specialinline_token4] = ACTIONS(372),
    [anon_sym_COLONref_COLON] = ACTIONS(372),
    [anon_sym_COLONprevious_COLON] = ACTIONS(372),
    [anon_sym_COLONurl_COLON] = ACTIONS(372),
    [anon_sym_COLONcite_COLON] = ACTIONS(372),
    [anon_sym_COLONqed_COLON] = ACTIONS(372),
    [anon_sym_COLONtable_COLON] = ACTIONS(372),
    [anon_sym_COLONassume_COLON] = ACTIONS(372),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(372),
    [anon_sym_COLONprove_COLON] = ACTIONS(372),
    [anon_sym_COLONthen_COLON] = ACTIONS(372),
    [anon_sym_COLONnew_COLON] = ACTIONS(372),
    [anon_sym_COLONlet_COLON] = ACTIONS(372),
    [anon_sym_COLONcase_COLON] = ACTIONS(372),
    [anon_sym_COLONdefine_COLON] = ACTIONS(372),
    [anon_sym_COLONwrite_COLON] = ACTIONS(372),
    [anon_sym_COLONwlog_COLON] = ACTIONS(372),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(372),
    [anon_sym_COLONclaim_COLON] = ACTIONS(372),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(372),
    [anon_sym_COLON_COLON2] = ACTIONS(372),
    [anon_sym_COLONdraft_COLON] = ACTIONS(372),
    [anon_sym_COLONnote_COLON] = ACTIONS(372),
    [anon_sym_COLONspan_COLON] = ACTIONS(372),
    [anon_sym_COLONabstract_COLON] = ACTIONS(372),
    [anon_sym_COLONauthor_COLON] = ACTIONS(372),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(372),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(372),
    [anon_sym_COLONitemize_COLON] = ACTIONS(372),
    [anon_sym_COLONlemma_COLON] = ACTIONS(372),
    [anon_sym_COLONfigure_COLON] = ACTIONS(372),
    [anon_sym_COLONp_COLON] = ACTIONS(372),
    [anon_sym_COLONproof_COLON] = ACTIONS(372),
    [anon_sym_COLONproposition_COLON] = ACTIONS(372),
    [anon_sym_COLONremark_COLON] = ACTIONS(372),
    [anon_sym_COLONsection_COLON] = ACTIONS(372),
    [anon_sym_COLONsketch_COLON] = ACTIONS(372),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(372),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(372),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(372),
    [anon_sym_COLONstep_COLON] = ACTIONS(372),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(372),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(372),
  },
  [62] = {
    [anon_sym_COLON_COLON] = ACTIONS(376),
    [anon_sym_COLONparagraph_COLON] = ACTIONS(376),
    [anon_sym_COLONappendix_COLON] = ACTIONS(376),
    [anon_sym_COLONbibliography_COLON] = ACTIONS(376),
    [anon_sym_COLONtoc_COLON] = ACTIONS(376),
    [aux_sym_specialblock_token1] = ACTIONS(376),
    [aux_sym_specialblock_token2] = ACTIONS(376),
    [aux_sym_specialblock_token3] = ACTIONS(376),
    [aux_sym_specialblock_token4] = ACTIONS(376),
    [aux_sym_specialblock_token5] = ACTIONS(376),
    [anon_sym_COLONmathblock_COLON] = ACTIONS(376),
    [anon_sym_COLONcodeblock_COLON] = ACTIONS(376),
    [anon_sym_COLONalgorithm_COLON] = ACTIONS(376),
    [anon_sym_COLONcaption_COLON] = ACTIONS(376),
    [anon_sym_COLONitem_COLON] = ACTIONS(376),
    [anon_sym_COLONprev_COLON] = ACTIONS(376),
    [anon_sym_COLONprev2_COLON] = ACTIONS(376),
    [anon_sym_COLONprev3_COLON] = ACTIONS(376),
    [aux_sym_specialinline_token1] = ACTIONS(378),
    [aux_sym_specialinline_token2] = ACTIONS(378),
    [anon_sym_COLONmath_COLON] = ACTIONS(376),
    [anon_sym_COLONcode_COLON] = ACTIONS(376),
    [aux_sym_specialinline_token3] = ACTIONS(376),
    [aux_sym_specialinline_token4] = ACTIONS(376),
    [anon_sym_COLONref_COLON] = ACTIONS(376),
    [anon_sym_COLONprevious_COLON] = ACTIONS(376),
    [anon_sym_COLONurl_COLON] = ACTIONS(376),
    [anon_sym_COLONcite_COLON] = ACTIONS(376),
    [anon_sym_COLONqed_COLON] = ACTIONS(376),
    [anon_sym_COLONtable_COLON] = ACTIONS(376),
    [anon_sym_COLONassume_COLON] = ACTIONS(376),
    [anon_sym_COLONsuppose_COLON] = ACTIONS(376),
    [anon_sym_COLONprove_COLON] = ACTIONS(376),
    [anon_sym_COLONthen_COLON] = ACTIONS(376),
    [anon_sym_COLONnew_COLON] = ACTIONS(376),
    [anon_sym_COLONlet_COLON] = ACTIONS(376),
    [anon_sym_COLONcase_COLON] = ACTIONS(376),
    [anon_sym_COLONdefine_COLON] = ACTIONS(376),
    [anon_sym_COLONwrite_COLON] = ACTIONS(376),
    [anon_sym_COLONwlog_COLON] = ACTIONS(376),
    [anon_sym_COLONsuffices_COLON] = ACTIONS(376),
    [anon_sym_COLONclaim_COLON] = ACTIONS(376),
    [anon_sym_COLON_PIPE_DASH_COLON] = ACTIONS(376),
    [anon_sym_COLON_COLON2] = ACTIONS(376),
    [anon_sym_COLONdraft_COLON] = ACTIONS(376),
    [anon_sym_COLONnote_COLON] = ACTIONS(376),
    [anon_sym_COLONspan_COLON] = ACTIONS(376),
    [anon_sym_COLONabstract_COLON] = ACTIONS(376),
    [anon_sym_COLONauthor_COLON] = ACTIONS(376),
    [anon_sym_COLONdefinition_COLON] = ACTIONS(376),
    [anon_sym_COLONenumerate_COLON] = ACTIONS(376),
    [anon_sym_COLONitemize_COLON] = ACTIONS(376),
    [anon_sym_COLONlemma_COLON] = ACTIONS(376),
    [anon_sym_COLONfigure_COLON] = ACTIONS(376),
    [anon_sym_COLONp_COLON] = ACTIONS(376),
    [anon_sym_COLONproof_COLON] = ACTIONS(376),
    [anon_sym_COLONproposition_COLON] = ACTIONS(376),
    [anon_sym_COLONremark_COLON] = ACTIONS(376),
    [anon_sym_COLONsection_COLON] = ACTIONS(376),
    [anon_sym_COLONsketch_COLON] = ACTIONS(376),
    [anon_sym_COLONsubsection_COLON] = ACTIONS(376),
    [anon_sym_COLONsubsubsection_COLON] = ACTIONS(376),
    [anon_sym_COLONsubsubsubsection_COLON] = ACTIONS(376),
    [anon_sym_COLONstep_COLON] = ACTIONS(376),
    [anon_sym_COLONtheorem_COLON] = ACTIONS(376),
    [sym_comment] = ACTIONS(3),
    [sym_text] = ACTIONS(376),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(404), 1,
      anon_sym_COLONtd_COLON,
    ACTIONS(410), 1,
      sym_text,
    STATE(81), 1,
      aux_sym_trshort_repeat1,
    STATE(382), 1,
      sym_tdcontent,
    STATE(321), 2,
      sym_td,
      aux_sym_tr_repeat1,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(78), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [86] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(412), 1,
      anon_sym_COLON_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(416), 1,
      sym_text,
    STATE(83), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(128), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [168] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(418), 1,
      anon_sym_COLON_COLON,
    ACTIONS(420), 1,
      sym_text,
    STATE(129), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(130), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [250] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(422), 1,
      anon_sym_COLON_COLON,
    ACTIONS(424), 1,
      sym_text,
    STATE(109), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(108), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [332] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(426), 1,
      anon_sym_COLON_COLON,
    ACTIONS(428), 1,
      sym_text,
    STATE(117), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(110), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [414] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(410), 1,
      sym_text,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    STATE(138), 1,
      sym_inlinemeta,
    STATE(544), 1,
      sym_tdcontent,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(78), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [496] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(430), 1,
      anon_sym_COLON_COLON,
    ACTIONS(432), 1,
      sym_text,
    STATE(93), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(94), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [578] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(434), 1,
      anon_sym_COLON_COLON,
    ACTIONS(436), 1,
      sym_text,
    STATE(137), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(136), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [660] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(438), 1,
      anon_sym_COLON_COLON,
    ACTIONS(440), 1,
      sym_text,
    STATE(131), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(120), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [742] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(442), 1,
      anon_sym_COLON_COLON,
    ACTIONS(444), 1,
      sym_text,
    STATE(99), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(100), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [824] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(446), 1,
      anon_sym_COLON_COLON,
    ACTIONS(448), 1,
      sym_text,
    STATE(86), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(87), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [906] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(450), 1,
      anon_sym_COLON_COLON,
    ACTIONS(452), 1,
      sym_text,
    STATE(84), 1,
      sym_inlinemeta,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(85), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [988] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 1,
      aux_sym_specialinline_token1,
    ACTIONS(460), 1,
      aux_sym_specialinline_token2,
    ACTIONS(463), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(466), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(469), 1,
      aux_sym_specialinline_token3,
    ACTIONS(472), 1,
      aux_sym_specialinline_token4,
    ACTIONS(475), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(478), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(481), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(484), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(487), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(496), 1,
      sym_text,
    STATE(75), 1,
      aux_sym_trshort_repeat1,
    STATE(561), 1,
      sym_tdcontent,
    ACTIONS(454), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(493), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(88), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(490), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1067] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(503), 1,
      sym_text,
    STATE(147), 1,
      sym_inlinemeta,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(122), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1146] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      anon_sym_COLON_COLON,
    ACTIONS(510), 1,
      aux_sym_specialinline_token1,
    ACTIONS(513), 1,
      aux_sym_specialinline_token2,
    ACTIONS(516), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(519), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(522), 1,
      aux_sym_specialinline_token3,
    ACTIONS(525), 1,
      aux_sym_specialinline_token4,
    ACTIONS(528), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(531), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(534), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(537), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(540), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(543), 1,
      anon_sym_COLON,
    ACTIONS(551), 1,
      sym_text,
    ACTIONS(507), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(548), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(545), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1225] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(554), 1,
      anon_sym_COLON_COLON,
    ACTIONS(556), 1,
      anon_sym_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1304] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(560), 1,
      sym_text,
    STATE(149), 1,
      sym_inlinemeta,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(115), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1383] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(562), 1,
      sym_text,
    STATE(146), 1,
      sym_inlinemeta,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(118), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1462] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(410), 1,
      sym_text,
    STATE(75), 1,
      aux_sym_trshort_repeat1,
    STATE(367), 1,
      sym_tdcontent,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(78), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1541] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(566), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1617] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(568), 1,
      anon_sym_COLON_COLON,
    ACTIONS(570), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(139), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1693] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(572), 1,
      anon_sym_COLON_COLON,
    ACTIONS(574), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(134), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1769] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(576), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1845] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(578), 1,
      anon_sym_COLON_COLON,
    ACTIONS(580), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(116), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1921] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(582), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [1997] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 1,
      anon_sym_COLON,
    ACTIONS(586), 1,
      aux_sym_specialinline_token1,
    ACTIONS(588), 1,
      aux_sym_specialinline_token2,
    ACTIONS(590), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(592), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(594), 1,
      aux_sym_specialinline_token3,
    ACTIONS(596), 1,
      aux_sym_specialinline_token4,
    ACTIONS(598), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(600), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(602), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(604), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(606), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(612), 1,
      sym_text,
    ACTIONS(584), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(610), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(144), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(608), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2073] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      anon_sym_SLASH,
    ACTIONS(617), 1,
      aux_sym_specialinline_token1,
    ACTIONS(620), 1,
      aux_sym_specialinline_token2,
    ACTIONS(623), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(626), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(629), 1,
      aux_sym_specialinline_token3,
    ACTIONS(632), 1,
      aux_sym_specialinline_token4,
    ACTIONS(635), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(638), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(641), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(644), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(647), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(656), 1,
      sym_text,
    ACTIONS(614), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(653), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(650), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2149] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(673), 1,
      anon_sym_SLASH,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(689), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2225] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(691), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2301] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(705), 1,
      anon_sym_STAR,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(723), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(96), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2377] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(725), 1,
      anon_sym_COLON_COLON,
    ACTIONS(727), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(102), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2453] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(729), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2529] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(689), 1,
      sym_text,
    ACTIONS(731), 1,
      anon_sym_SLASH,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2605] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(731), 1,
      anon_sym_STAR,
    ACTIONS(733), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2681] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(705), 1,
      anon_sym_SLASH,
    ACTIONS(735), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(95), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2757] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(737), 1,
      anon_sym_SLASH,
    ACTIONS(739), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(90), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2833] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(741), 1,
      anon_sym_COLON_COLON,
    ACTIONS(743), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(111), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2909] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(745), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [2985] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      aux_sym_specialinline_token1,
    ACTIONS(753), 1,
      aux_sym_specialinline_token2,
    ACTIONS(756), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(759), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(762), 1,
      aux_sym_specialinline_token3,
    ACTIONS(765), 1,
      aux_sym_specialinline_token4,
    ACTIONS(768), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(771), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(774), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(777), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(780), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(789), 1,
      sym_text,
    ACTIONS(792), 1,
      sym_paragraph_end,
    ACTIONS(747), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(786), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(783), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3061] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(794), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3137] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(737), 1,
      anon_sym_STAR,
    ACTIONS(796), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(127), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3213] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(798), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3289] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(800), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3365] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(802), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3441] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(804), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3517] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(806), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3593] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(808), 1,
      anon_sym_COLON_COLON,
    ACTIONS(810), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(104), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3669] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(812), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3745] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(814), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3821] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(816), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3897] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(818), 1,
      anon_sym_STAR,
    ACTIONS(820), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(124), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [3973] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(818), 1,
      anon_sym_SLASH,
    ACTIONS(822), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(126), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4049] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(824), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4125] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(826), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4201] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(828), 1,
      anon_sym_COLON_COLON,
    ACTIONS(830), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(106), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4277] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(832), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4353] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(689), 1,
      sym_text,
    ACTIONS(834), 1,
      anon_sym_SLASH,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4429] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(836), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4505] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(733), 1,
      sym_text,
    ACTIONS(834), 1,
      anon_sym_STAR,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4581] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(838), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4657] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(840), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4733] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(733), 1,
      sym_text,
    ACTIONS(842), 1,
      anon_sym_STAR,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4809] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(564), 1,
      sym_text,
    ACTIONS(844), 1,
      sym_paragraph_end,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(101), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4885] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(689), 1,
      sym_text,
    ACTIONS(842), 1,
      anon_sym_SLASH,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [4961] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_STAR,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(733), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5037] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(846), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5113] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(848), 1,
      anon_sym_COLON_COLON,
    ACTIONS(850), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(140), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5189] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(852), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5265] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(854), 1,
      anon_sym_COLON_COLON,
    ACTIONS(856), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(91), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5341] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(858), 1,
      anon_sym_SLASH,
    ACTIONS(860), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(119), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5417] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(858), 1,
      anon_sym_STAR,
    ACTIONS(862), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(121), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5493] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(864), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5569] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 1,
      anon_sym_STAR,
    ACTIONS(869), 1,
      aux_sym_specialinline_token1,
    ACTIONS(872), 1,
      aux_sym_specialinline_token2,
    ACTIONS(875), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(878), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(881), 1,
      aux_sym_specialinline_token3,
    ACTIONS(884), 1,
      aux_sym_specialinline_token4,
    ACTIONS(887), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(890), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(893), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(896), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(899), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(908), 1,
      sym_text,
    ACTIONS(866), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(905), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(902), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5645] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(911), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5721] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(913), 1,
      anon_sym_COLON_COLON,
    ACTIONS(915), 1,
      sym_text,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(105), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5797] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(410), 1,
      sym_text,
    STATE(560), 1,
      sym_tdcontent,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(78), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5873] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(917), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [5949] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 1,
      aux_sym_specialinline_token1,
    ACTIONS(384), 1,
      aux_sym_specialinline_token2,
    ACTIONS(386), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(388), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(390), 1,
      aux_sym_specialinline_token3,
    ACTIONS(392), 1,
      aux_sym_specialinline_token4,
    ACTIONS(394), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(396), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(398), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(400), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(402), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(558), 1,
      sym_text,
    ACTIONS(919), 1,
      anon_sym_COLON_COLON,
    ACTIONS(380), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(408), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(77), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(406), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6025] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(689), 1,
      sym_text,
    ACTIONS(921), 1,
      anon_sym_SLASH,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(89), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6101] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(733), 1,
      sym_text,
    ACTIONS(921), 1,
      anon_sym_STAR,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(135), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6177] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(661), 1,
      aux_sym_specialinline_token1,
    ACTIONS(663), 1,
      aux_sym_specialinline_token2,
    ACTIONS(665), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(667), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(669), 1,
      aux_sym_specialinline_token3,
    ACTIONS(671), 1,
      aux_sym_specialinline_token4,
    ACTIONS(675), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(677), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(679), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(681), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(683), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(923), 1,
      anon_sym_SLASH,
    ACTIONS(925), 1,
      sym_text,
    ACTIONS(659), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(687), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(141), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(685), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6253] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_COLON,
    ACTIONS(930), 1,
      aux_sym_specialinline_token1,
    ACTIONS(933), 1,
      aux_sym_specialinline_token2,
    ACTIONS(936), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(939), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(942), 1,
      aux_sym_specialinline_token3,
    ACTIONS(945), 1,
      aux_sym_specialinline_token4,
    ACTIONS(948), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(951), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(954), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(957), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(960), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(969), 1,
      sym_text,
    ACTIONS(927), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(966), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(144), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(963), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6329] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(695), 1,
      aux_sym_specialinline_token1,
    ACTIONS(697), 1,
      aux_sym_specialinline_token2,
    ACTIONS(699), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(701), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(703), 1,
      aux_sym_specialinline_token3,
    ACTIONS(707), 1,
      aux_sym_specialinline_token4,
    ACTIONS(709), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(711), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(713), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(715), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(717), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(923), 1,
      anon_sym_STAR,
    ACTIONS(972), 1,
      sym_text,
    ACTIONS(693), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(721), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(142), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_inline_repeat1,
    ACTIONS(719), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6405] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(974), 1,
      sym_text,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(123), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6478] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(976), 1,
      sym_text,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(107), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6551] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(978), 1,
      sym_text,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(112), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6624] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_COLONmath_COLON,
    ACTIONS(37), 1,
      anon_sym_COLONcode_COLON,
    ACTIONS(39), 1,
      aux_sym_specialinline_token3,
    ACTIONS(41), 1,
      aux_sym_specialinline_token4,
    ACTIONS(43), 1,
      anon_sym_COLONref_COLON,
    ACTIONS(45), 1,
      anon_sym_COLONprevious_COLON,
    ACTIONS(47), 1,
      anon_sym_COLONurl_COLON,
    ACTIONS(49), 1,
      anon_sym_COLONcite_COLON,
    ACTIONS(51), 1,
      anon_sym_COLONqed_COLON,
    ACTIONS(499), 1,
      aux_sym_specialinline_token1,
    ACTIONS(501), 1,
      aux_sym_specialinline_token2,
    ACTIONS(980), 1,
      sym_text,
    ACTIONS(29), 3,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
    ACTIONS(57), 3,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
    STATE(125), 5,
      sym_inline,
      sym_construct,
      sym_specialinline,
      sym_specialconstruct,
      aux_sym_paragraph_repeat1,
    ACTIONS(55), 14,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
  [6697] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      anon_sym_COLON,
    ACTIONS(982), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6739] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_COLON,
    ACTIONS(986), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_COLON,
    ACTIONS(990), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_COLON,
    ACTIONS(994), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_COLON,
    ACTIONS(998), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_COLON,
    ACTIONS(1002), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_COLON,
    ACTIONS(1006), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [6991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_COLON,
    ACTIONS(1010), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_COLON,
    ACTIONS(1014), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_COLON,
    ACTIONS(1018), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_COLON,
    ACTIONS(1022), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_COLON,
    ACTIONS(1026), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_COLON,
    ACTIONS(990), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_COLON,
    ACTIONS(1030), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      anon_sym_COLON,
    ACTIONS(1034), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7327] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      anon_sym_COLON,
    ACTIONS(1038), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      anon_sym_COLON,
    ACTIONS(1042), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7411] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      anon_sym_COLON,
    ACTIONS(1046), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_COLON,
    ACTIONS(1050), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      anon_sym_COLON,
    ACTIONS(1054), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      anon_sym_COLON,
    ACTIONS(1058), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_COLON,
    ACTIONS(1062), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7621] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1046), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7660] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1018), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      anon_sym_COLON,
    ACTIONS(982), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7742] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      anon_sym_COLON,
    ACTIONS(1062), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      anon_sym_COLON,
    ACTIONS(986), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      anon_sym_COLON,
    ACTIONS(1022), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      anon_sym_COLON,
    ACTIONS(1018), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1062), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      aux_sym_specialinline_token4,
    ACTIONS(986), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [7988] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      anon_sym_COLON,
    ACTIONS(1006), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_COLON,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8109] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      anon_sym_COLON,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      anon_sym_COLON,
    ACTIONS(1034), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      anon_sym_COLON,
    ACTIONS(1038), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1022), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1020), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1018), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8314] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1002), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8353] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(998), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8392] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(994), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1006), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      aux_sym_specialinline_token4,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8513] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      aux_sym_specialinline_token4,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8554] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1034), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      anon_sym_COLON,
    ACTIONS(998), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1038), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1042), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      anon_sym_COLON,
    ACTIONS(1042), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8798] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(982), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8837] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1062), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8876] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      anon_sym_COLON,
    ACTIONS(1046), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      anon_sym_COLON,
    ACTIONS(1050), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8958] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(986), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [8997] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1046), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9038] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1022), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      anon_sym_COLON,
    ACTIONS(994), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9118] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1050), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9159] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      anon_sym_COLON,
    ACTIONS(1026), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1026), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9239] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1010), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9278] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      anon_sym_COLON,
    ACTIONS(1010), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9319] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1054), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9360] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      anon_sym_COLON,
    ACTIONS(1054), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9401] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      anon_sym_COLON,
    ACTIONS(1058), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1058), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9483] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1014), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      anon_sym_COLON,
    ACTIONS(1030), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9565] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 33,
      sym_text,
      anon_sym_COLON_COLON,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1030), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1002), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9686] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1030), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9725] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1014), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      anon_sym_COLON,
    ACTIONS(1014), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1018), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1010), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1026), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9926] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1006), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [9965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      aux_sym_specialinline_token3,
    ACTIONS(994), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10006] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(990), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      aux_sym_specialinline_token3,
    ACTIONS(998), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1034), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10125] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1038), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1002), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10205] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1000), 1,
      aux_sym_specialinline_token4,
    ACTIONS(998), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10246] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1042), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      aux_sym_specialinline_token4,
    ACTIONS(982), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10326] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(996), 1,
      aux_sym_specialinline_token4,
    ACTIONS(994), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(984), 1,
      aux_sym_specialinline_token3,
    ACTIONS(982), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1064), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1062), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10449] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(988), 1,
      aux_sym_specialinline_token3,
    ACTIONS(986), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10490] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1050), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10529] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1024), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1022), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10570] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1004), 1,
      anon_sym_COLON,
    ACTIONS(1002), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1008), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1006), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10652] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1054), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      aux_sym_specialinline_token3,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10732] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1058), 33,
      sym_text,
      sym_paragraph_end,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(992), 1,
      aux_sym_specialinline_token3,
    ACTIONS(990), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1036), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1034), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1040), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1038), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1028), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1026), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1044), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1042), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [10976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1048), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1046), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1052), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1050), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11058] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1012), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1010), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1032), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1030), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11140] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1016), 1,
      aux_sym_specialinline_token4,
    ACTIONS(1014), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      anon_sym_SLASH,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1056), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1054), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11222] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1060), 1,
      aux_sym_specialinline_token3,
    ACTIONS(1058), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      anon_sym_STAR,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1070), 32,
      sym_text,
      anon_sym_COLONprev_COLON,
      anon_sym_COLONprev2_COLON,
      anon_sym_COLONprev3_COLON,
      aux_sym_specialinline_token1,
      aux_sym_specialinline_token2,
      anon_sym_COLONmath_COLON,
      anon_sym_COLONcode_COLON,
      aux_sym_specialinline_token3,
      aux_sym_specialinline_token4,
      anon_sym_COLONref_COLON,
      anon_sym_COLONprevious_COLON,
      anon_sym_COLONurl_COLON,
      anon_sym_COLONcite_COLON,
      anon_sym_COLONqed_COLON,
      anon_sym_COLONassume_COLON,
      anon_sym_COLONsuppose_COLON,
      anon_sym_COLONprove_COLON,
      anon_sym_COLONthen_COLON,
      anon_sym_COLONnew_COLON,
      anon_sym_COLONlet_COLON,
      anon_sym_COLONcase_COLON,
      anon_sym_COLONdefine_COLON,
      anon_sym_COLONwrite_COLON,
      anon_sym_COLONwlog_COLON,
      anon_sym_COLONsuffices_COLON,
      anon_sym_COLONclaim_COLON,
      anon_sym_COLON_PIPE_DASH_COLON,
      anon_sym_COLON_COLON2,
      anon_sym_COLONdraft_COLON,
      anon_sym_COLONnote_COLON,
      anon_sym_COLONspan_COLON,
  [11301] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1072), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1076), 1,
      anon_sym_COLONthead_COLON,
    ACTIONS(1078), 1,
      anon_sym_COLONtbody_COLON,
    STATE(286), 1,
      sym_metakey_bool,
    STATE(314), 1,
      sym_blockmeta,
    STATE(318), 1,
      sym_thead,
    STATE(330), 1,
      sym_tbody,
    STATE(339), 1,
      sym_metakey_list,
    STATE(398), 1,
      sym_metakey_any,
    STATE(401), 1,
      sym_metakey_text,
    STATE(453), 1,
      sym_caption,
    STATE(265), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11370] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(286), 1,
      sym_metakey_bool,
    STATE(339), 1,
      sym_metakey_list,
    STATE(398), 1,
      sym_metakey_any,
    STATE(401), 1,
      sym_metakey_text,
    STATE(264), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(85), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(88), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(75), 4,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
    ACTIONS(1082), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(79), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11421] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(286), 1,
      sym_metakey_bool,
    STATE(339), 1,
      sym_metakey_list,
    STATE(398), 1,
      sym_metakey_any,
    STATE(401), 1,
      sym_metakey_text,
    STATE(264), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(91), 4,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11472] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1087), 1,
      sym_asis_two_dollars_text,
    STATE(303), 1,
      sym_metakey_bool,
    STATE(334), 1,
      sym_metakey_list,
    STATE(407), 1,
      sym_metakey_text,
    STATE(409), 1,
      sym_metakey_any,
    STATE(490), 1,
      sym_blockmeta,
    STATE(274), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1085), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11523] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 1,
      sym_asis_three_backticks_text,
    STATE(307), 1,
      sym_metakey_bool,
    STATE(331), 1,
      sym_metakey_list,
    STATE(420), 1,
      sym_metakey_text,
    STATE(426), 1,
      sym_metakey_any,
    STATE(483), 1,
      sym_blockmeta,
    STATE(275), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1089), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11574] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1095), 1,
      sym_asis_halmos_text,
    STATE(300), 1,
      sym_metakey_bool,
    STATE(333), 1,
      sym_metakey_list,
    STATE(413), 1,
      sym_metakey_any,
    STATE(415), 1,
      sym_metakey_text,
    STATE(481), 1,
      sym_blockmeta,
    STATE(273), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1093), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11625] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1097), 1,
      sym_asis_halmos_text,
    STATE(300), 1,
      sym_metakey_bool,
    STATE(333), 1,
      sym_metakey_list,
    STATE(413), 1,
      sym_metakey_any,
    STATE(415), 1,
      sym_metakey_text,
    STATE(477), 1,
      sym_blockmeta,
    STATE(273), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1093), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11676] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_asis_halmos_text,
    STATE(300), 1,
      sym_metakey_bool,
    STATE(333), 1,
      sym_metakey_list,
    STATE(413), 1,
      sym_metakey_any,
    STATE(415), 1,
      sym_metakey_text,
    STATE(270), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(85), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(88), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1099), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(79), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11724] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_asis_two_dollars_text,
    STATE(303), 1,
      sym_metakey_bool,
    STATE(334), 1,
      sym_metakey_list,
    STATE(407), 1,
      sym_metakey_text,
    STATE(409), 1,
      sym_metakey_any,
    STATE(271), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(85), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(88), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1102), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(79), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11772] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_asis_three_backticks_text,
    STATE(307), 1,
      sym_metakey_bool,
    STATE(331), 1,
      sym_metakey_list,
    STATE(420), 1,
      sym_metakey_text,
    STATE(426), 1,
      sym_metakey_any,
    STATE(272), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(85), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(88), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1105), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(79), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11820] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_asis_halmos_text,
    STATE(300), 1,
      sym_metakey_bool,
    STATE(333), 1,
      sym_metakey_list,
    STATE(413), 1,
      sym_metakey_any,
    STATE(415), 1,
      sym_metakey_text,
    STATE(270), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1093), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11868] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_asis_two_dollars_text,
    STATE(303), 1,
      sym_metakey_bool,
    STATE(334), 1,
      sym_metakey_list,
    STATE(407), 1,
      sym_metakey_text,
    STATE(409), 1,
      sym_metakey_any,
    STATE(271), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1085), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11916] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      sym_asis_three_backticks_text,
    STATE(307), 1,
      sym_metakey_bool,
    STATE(331), 1,
      sym_metakey_list,
    STATE(420), 1,
      sym_metakey_text,
    STATE(426), 1,
      sym_metakey_any,
    STATE(272), 2,
      sym_pair,
      aux_sym_blockmeta_repeat1,
    ACTIONS(65), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(67), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1089), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(61), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [11964] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    STATE(431), 1,
      sym_inlinemetapair,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 23,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12040] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(419), 1,
      sym_inlinemetapair,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12087] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    STATE(542), 1,
      sym_inlinemetapair,
    ACTIONS(1120), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1123), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1117), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1114), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12134] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(406), 1,
      sym_inlinemetapair,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12181] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(279), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(385), 1,
      sym_inlinemetapair,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12228] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(281), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    STATE(430), 1,
      sym_inlinemetapair,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12275] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(280), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(410), 1,
      sym_inlinemetapair,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12322] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(276), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(421), 1,
      sym_metakey_any,
    STATE(423), 1,
      sym_inlinemetapair,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12369] = 11,
    ACTIONS(3), 1,
      sym_comment,
    STATE(278), 1,
      aux_sym_inlinemeta_repeat1,
    STATE(332), 1,
      sym_metakey_list,
    STATE(421), 1,
      sym_metakey_any,
    STATE(424), 1,
      sym_metakey_bool,
    STATE(429), 1,
      sym_metakey_text,
    STATE(432), 1,
      sym_inlinemetapair,
    ACTIONS(1110), 3,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
    ACTIONS(1112), 3,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
    ACTIONS(1080), 4,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
    ACTIONS(1108), 7,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
  [12416] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12470] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12524] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 21,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONthead_COLON,
      anon_sym_COLONtbody_COLON,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12602] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12626] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12650] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12674] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12698] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12722] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12746] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12770] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12794] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12818] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12866] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(95), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12890] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12914] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(119), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(115), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [12986] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 18,
      sym_asis_two_dollars_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [13010] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 18,
      sym_asis_halmos_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [13034] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [13058] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 18,
      sym_asis_three_backticks_text,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [13082] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1126), 17,
      anon_sym_COLONaffiliation_COLON,
      anon_sym_COLONemail_COLON,
      anon_sym_COLONlabel_COLON,
      anon_sym_COLONname_COLON,
      anon_sym_COLONreftext_COLON,
      anon_sym_COLONtitle_COLON,
      anon_sym_COLONgoal_COLON,
      anon_sym_COLONnonum_COLON,
      anon_sym_COLONstrong_COLON,
      anon_sym_COLONemphas_COLON,
      anon_sym_COLONisclaim_COLON,
      anon_sym_COLONkeywords_COLON,
      anon_sym_COLONMSC_COLON,
      anon_sym_COLONtypes_COLON,
      anon_sym_COLONdate_COLON,
      anon_sym_COLONpath_COLON,
      anon_sym_COLONscale_COLON,
  [13105] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1076), 1,
      anon_sym_COLONthead_COLON,
    ACTIONS(1078), 1,
      anon_sym_COLONtbody_COLON,
    ACTIONS(1128), 1,
      anon_sym_COLON_COLON,
    STATE(317), 1,
      sym_thead,
    STATE(327), 1,
      sym_tbody,
    STATE(500), 1,
      sym_caption,
  [13130] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1130), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1132), 1,
      anon_sym_COLONtr_COLON,
    STATE(316), 3,
      sym_tr,
      sym_trshort,
      aux_sym_thead_repeat1,
  [13145] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1134), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1136), 1,
      anon_sym_COLONtr_COLON,
    STATE(316), 3,
      sym_tr,
      sym_trshort,
      aux_sym_thead_repeat1,
  [13160] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1078), 1,
      anon_sym_COLONtbody_COLON,
    ACTIONS(1139), 1,
      anon_sym_COLON_COLON,
    STATE(351), 1,
      sym_tbody,
    STATE(526), 1,
      sym_caption,
  [13179] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1078), 1,
      anon_sym_COLONtbody_COLON,
    ACTIONS(1141), 1,
      anon_sym_COLON_COLON,
    STATE(342), 1,
      sym_tbody,
    STATE(501), 1,
      sym_caption,
  [13198] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_COLONtr_COLON,
    ACTIONS(1143), 1,
      anon_sym_COLON_COLON,
    STATE(316), 3,
      sym_tr,
      sym_trshort,
      aux_sym_thead_repeat1,
  [13213] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1145), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1147), 1,
      anon_sym_AT,
    STATE(322), 2,
      sym_bibitem,
      aux_sym_bibtex_repeat1,
  [13227] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 1,
      anon_sym_COLONtd_COLON,
    ACTIONS(1149), 1,
      anon_sym_COLON_COLON,
    STATE(325), 2,
      sym_td,
      aux_sym_tr_repeat1,
  [13241] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1147), 1,
      anon_sym_AT,
    ACTIONS(1151), 1,
      anon_sym_COLON_COLON,
    STATE(326), 2,
      sym_bibitem,
      aux_sym_bibtex_repeat1,
  [13255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_COLONtr_COLON,
    STATE(315), 3,
      sym_tr,
      sym_trshort,
      aux_sym_thead_repeat1,
  [13267] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1132), 1,
      anon_sym_COLONtr_COLON,
    STATE(319), 3,
      sym_tr,
      sym_trshort,
      aux_sym_thead_repeat1,
  [13279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1153), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1155), 1,
      anon_sym_COLONtd_COLON,
    STATE(325), 2,
      sym_td,
      aux_sym_tr_repeat1,
  [13293] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1158), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1160), 1,
      anon_sym_AT,
    STATE(326), 2,
      sym_bibitem,
      aux_sym_bibtex_repeat1,
  [13307] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1163), 1,
      anon_sym_COLON_COLON,
    STATE(527), 1,
      sym_caption,
  [13320] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1167), 1,
      sym_asis_dollar_text,
    STATE(534), 1,
      sym_inlinemeta,
  [13333] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1169), 1,
      ts_builtin_sym_end,
    ACTIONS(1171), 1,
      anon_sym_COLONbibtex_COLON,
    STATE(438), 1,
      sym_bibtex,
  [13346] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1173), 1,
      anon_sym_COLON_COLON,
    STATE(506), 1,
      sym_caption,
  [13359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1175), 1,
      anon_sym_LBRACE,
    ACTIONS(1177), 1,
      sym_text,
    STATE(312), 1,
      sym_metaval_list,
  [13372] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1179), 1,
      anon_sym_LBRACE,
    ACTIONS(1181), 1,
      sym_upto_brace_or_comma_text,
    STATE(389), 1,
      sym_metaval_list_inline,
  [13385] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1183), 1,
      anon_sym_LBRACE,
    ACTIONS(1185), 1,
      sym_text,
    STATE(292), 1,
      sym_metaval_list,
  [13398] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1187), 1,
      anon_sym_LBRACE,
    ACTIONS(1189), 1,
      sym_text,
    STATE(308), 1,
      sym_metaval_list,
  [13411] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1193), 1,
      sym_asis_halmos_text,
    STATE(587), 1,
      sym_inlinemeta,
  [13424] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_COLONbibtex_COLON,
    ACTIONS(1195), 1,
      ts_builtin_sym_end,
    STATE(508), 1,
      sym_bibtex,
  [13437] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1197), 1,
      sym_asis_halmos_text,
    STATE(586), 1,
      sym_inlinemeta,
  [13450] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 1,
      anon_sym_LBRACE,
    ACTIONS(1201), 1,
      sym_text,
    STATE(9), 1,
      sym_metaval_list,
  [13463] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1203), 1,
      anon_sym_LBRACE,
    ACTIONS(1205), 1,
      sym_text,
    STATE(290), 1,
      sym_metaval_list,
  [13476] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1209), 1,
      sym_asis_backtick_text,
    STATE(585), 1,
      sym_inlinemeta,
  [13489] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      sym_asis_dollar_text,
    STATE(584), 1,
      sym_inlinemeta,
  [13502] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1213), 1,
      anon_sym_COLON_COLON,
    STATE(532), 1,
      sym_caption,
  [13515] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_COLONbibtex_COLON,
    ACTIONS(1215), 1,
      ts_builtin_sym_end,
    STATE(533), 1,
      sym_bibtex,
  [13528] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1171), 1,
      anon_sym_COLONbibtex_COLON,
    ACTIONS(1217), 1,
      ts_builtin_sym_end,
    STATE(496), 1,
      sym_bibtex,
  [13541] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1219), 1,
      aux_sym_bibitempair_token1,
    STATE(345), 1,
      aux_sym_bibitem_repeat1,
    STATE(577), 1,
      sym_bibitempair,
  [13554] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1222), 1,
      sym_asis_halmos_text,
    STATE(454), 1,
      sym_inlinemeta,
  [13567] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1224), 3,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
      anon_sym_COLONtbody_COLON,
  [13576] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1226), 1,
      sym_asis_backtick_text,
    STATE(535), 1,
      sym_inlinemeta,
  [13589] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1228), 1,
      sym_asis_halmos_text,
    STATE(571), 1,
      sym_inlinemeta,
  [13602] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 1,
      aux_sym_bibitempair_token1,
    STATE(345), 1,
      aux_sym_bibitem_repeat1,
    STATE(384), 1,
      sym_bibitempair,
  [13615] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1074), 1,
      anon_sym_COLONcaption_COLON,
    ACTIONS(1232), 1,
      anon_sym_COLON_COLON,
    STATE(545), 1,
      sym_caption,
  [13628] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1234), 1,
      sym_asis_halmos_text,
    STATE(570), 1,
      sym_inlinemeta,
  [13641] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1236), 1,
      sym_asis_halmos_text,
    STATE(536), 1,
      sym_inlinemeta,
  [13654] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1238), 1,
      sym_asis_halmos_text,
    STATE(537), 1,
      sym_inlinemeta,
  [13667] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1230), 1,
      aux_sym_bibitempair_token1,
    STATE(350), 1,
      aux_sym_bibitem_repeat1,
    STATE(378), 1,
      sym_bibitempair,
  [13680] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1240), 1,
      sym_asis_backtick_text,
    STATE(569), 1,
      sym_inlinemeta,
  [13693] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1242), 1,
      sym_asis_halmos_text,
    STATE(460), 1,
      sym_inlinemeta,
  [13706] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1244), 1,
      sym_asis_backtick_text,
    STATE(466), 1,
      sym_inlinemeta,
  [13719] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1246), 1,
      sym_asis_dollar_text,
    STATE(568), 1,
      sym_inlinemeta,
  [13732] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1248), 1,
      sym_asis_dollar_text,
    STATE(468), 1,
      sym_inlinemeta,
  [13745] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1165), 1,
      anon_sym_LBRACE,
    ACTIONS(1250), 1,
      sym_asis_dollar_text,
    STATE(551), 1,
      sym_inlinemeta,
  [13758] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1252), 1,
      sym_asis_halmos_text,
    STATE(554), 1,
      sym_inlinemeta,
  [13771] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1254), 1,
      sym_asis_halmos_text,
    STATE(553), 1,
      sym_inlinemeta,
  [13784] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1256), 1,
      sym_asis_backtick_text,
    STATE(552), 1,
      sym_inlinemeta,
  [13797] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1258), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONtr_COLON,
  [13805] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONtr_COLON,
  [13813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1262), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1264), 1,
      anon_sym_COLON,
  [13823] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1266), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [13833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1268), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [13843] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1270), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [13853] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1274), 1,
      anon_sym_RBRACE,
  [13863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [13873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1279), 1,
      anon_sym_RBRACE,
  [13883] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1281), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONtd_COLON,
  [13891] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1283), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONtr_COLON,
  [13899] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1285), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [13907] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1287), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONtd_COLON,
  [13915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 1,
      anon_sym_COMMA,
    ACTIONS(1291), 1,
      anon_sym_RBRACE,
  [13925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 1,
      anon_sym_LBRACE,
    STATE(148), 1,
      sym_inlinemeta,
  [13935] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1293), 2,
      anon_sym_COLON_COLON,
      anon_sym_COLONcaption_COLON,
  [13943] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1295), 2,
      anon_sym_COLON_COLON,
      anon_sym_AT,
  [13951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1264), 1,
      anon_sym_COLON,
    ACTIONS(1297), 1,
      anon_sym_COLON_COLON,
  [13961] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(394), 1,
      aux_sym_metaval_list_repeat1,
  [13971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1301), 1,
      anon_sym_COMMA,
    ACTIONS(1303), 1,
      anon_sym_RBRACE,
  [13981] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1307), 1,
      anon_sym_RBRACE,
  [13991] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1309), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [13999] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(370), 1,
      aux_sym_metaval_list_repeat1,
  [14009] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1311), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [14017] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [14025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [14033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1317), 1,
      anon_sym_RBRACE,
  [14043] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1319), 2,
      sym_text,
      anon_sym_LBRACE,
  [14051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1321), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1323), 1,
      anon_sym_COMMA,
  [14061] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1325), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [14071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1329), 1,
      anon_sym_COMMA,
  [14081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1331), 1,
      anon_sym_RBRACE,
    ACTIONS(1333), 1,
      aux_sym_bibitempair_token1,
  [14091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1335), 1,
      sym_text,
    STATE(9), 1,
      sym_metaval_text,
  [14101] = 3,
    ACTIONS(1337), 1,
      aux_sym_metaval_any_token1,
    ACTIONS(1339), 1,
      sym_comment,
    STATE(290), 1,
      sym_metaval_any,
  [14111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1341), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [14121] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1343), 2,
      anon_sym_COLON_COLON,
      anon_sym_AT,
  [14129] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1345), 1,
      sym_text,
    STATE(290), 1,
      sym_metaval_text,
  [14139] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1347), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [14147] = 3,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1349), 1,
      aux_sym_metaval_any_token1,
    STATE(9), 1,
      sym_metaval_any,
  [14157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1351), 1,
      anon_sym_RBRACE,
  [14167] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1319), 2,
      sym_upto_brace_or_comma_text,
      anon_sym_LBRACE,
  [14175] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1353), 1,
      anon_sym_RBRACE,
  [14185] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      sym_text,
    STATE(308), 1,
      sym_metaval_text,
  [14195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1357), 1,
      sym_upto_brace_or_comma_text,
    STATE(372), 1,
      aux_sym_metaval_list_repeat1,
  [14205] = 3,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1359), 1,
      aux_sym_metaval_any_token1,
    STATE(308), 1,
      sym_metaval_any,
  [14215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1361), 1,
      anon_sym_RBRACE,
  [14225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1363), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1365), 1,
      anon_sym_COMMA,
  [14235] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1367), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1369), 1,
      anon_sym_COMMA,
  [14245] = 3,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1371), 1,
      aux_sym_metaval_any_token1,
    STATE(292), 1,
      sym_metaval_any,
  [14255] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(369), 1,
      aux_sym_metaval_list_repeat1,
  [14265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      sym_text,
    STATE(292), 1,
      sym_metaval_text,
  [14275] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1375), 1,
      anon_sym_RBRACE,
  [14285] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1377), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1379), 1,
      anon_sym_COMMA,
  [14295] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1381), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1383), 1,
      anon_sym_COMMA,
  [14305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1385), 1,
      anon_sym_RBRACE,
  [14315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 1,
      sym_text,
    STATE(312), 1,
      sym_metaval_text,
  [14325] = 3,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1389), 1,
      aux_sym_metaval_any_inline_token1,
    STATE(389), 1,
      sym_metaval_any_inline,
  [14335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(368), 1,
      aux_sym_metaval_list_repeat1,
  [14345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1391), 1,
      anon_sym_RBRACE,
  [14355] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [14363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(399), 1,
      aux_sym_metaval_list_repeat1,
  [14373] = 3,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1395), 1,
      aux_sym_metaval_any_token1,
    STATE(312), 1,
      sym_metaval_any,
  [14383] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1399), 1,
      anon_sym_COMMA,
  [14393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1401), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1403), 1,
      anon_sym_COMMA,
  [14403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1405), 1,
      sym_upto_brace_or_comma_text,
    STATE(389), 1,
      sym_metaval_text_inline,
  [14413] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_RBRACE,
  [14423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1409), 1,
      anon_sym_RBRACE,
  [14433] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
    ACTIONS(1411), 1,
      anon_sym_RBRACE,
  [14443] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
  [14453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
    ACTIONS(1417), 1,
      anon_sym_RBRACE,
  [14463] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1419), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1421), 1,
      anon_sym_COMMA,
  [14473] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1299), 1,
      sym_upto_brace_or_comma_text,
    STATE(408), 1,
      aux_sym_metaval_list_repeat1,
  [14483] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1423), 2,
      anon_sym_COLON_COLON,
      anon_sym_AT,
  [14491] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1425), 1,
      ts_builtin_sym_end,
  [14498] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 1,
      anon_sym_COLON_COLON,
  [14505] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      aux_sym_specialinline_token1,
  [14512] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      aux_sym_specialinline_token2,
  [14519] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1433), 1,
      anon_sym_COLON_COLON,
  [14526] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1431), 1,
      anon_sym_COLON_COLON,
  [14533] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1435), 1,
      anon_sym_COLON_COLON,
  [14540] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 1,
      anon_sym_COLON_COLON,
  [14547] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1439), 1,
      aux_sym_bibitem_token1,
  [14554] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1441), 1,
      ts_builtin_sym_end,
  [14561] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1443), 1,
      aux_sym_specialinline_token1,
  [14568] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 1,
      aux_sym_specialinline_token2,
  [14575] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1447), 1,
      anon_sym_COLON_COLON,
  [14582] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1445), 1,
      anon_sym_COLON_COLON,
  [14589] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1449), 1,
      ts_builtin_sym_end,
  [14596] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1451), 1,
      anon_sym_COLON_COLON,
  [14603] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1453), 1,
      sym_asis_halmos_text,
  [14610] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1455), 1,
      aux_sym_specialinline_token1,
  [14617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      aux_sym_specialinline_token2,
  [14624] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1459), 1,
      anon_sym_COLON_COLON,
  [14631] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1457), 1,
      anon_sym_COLON_COLON,
  [14638] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 1,
      anon_sym_COLON_COLON,
  [14645] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1463), 1,
      sym_asis_halmos_text,
  [14652] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1465), 1,
      anon_sym_COLON_COLON,
  [14659] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1467), 1,
      anon_sym_COLON_COLON,
  [14666] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1469), 1,
      anon_sym_COLON_COLON,
  [14673] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1471), 1,
      aux_sym_specialblock_token5,
  [14680] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1473), 1,
      anon_sym_COLON_COLON,
  [14687] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1475), 1,
      sym_asis_backtick_text,
  [14694] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1461), 1,
      aux_sym_specialinline_token2,
  [14701] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 1,
      sym_asis_dollar_text,
  [14708] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym_asis_dollar_text,
  [14715] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1471), 1,
      anon_sym_COLON_COLON,
  [14722] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      anon_sym_COLON_COLON,
  [14729] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1481), 1,
      aux_sym_specialinline_token1,
  [14736] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1483), 1,
      aux_sym_specialinline_token2,
  [14743] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      anon_sym_COLON_COLON,
  [14750] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1483), 1,
      anon_sym_COLON_COLON,
  [14757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      aux_sym_specialinline_token1,
  [14764] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      sym_asis_halmos_text,
  [14771] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 1,
      anon_sym_COLON_COLON,
  [14778] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1479), 1,
      aux_sym_specialinline_token2,
  [14785] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 1,
      anon_sym_COLON_COLON,
  [14792] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 1,
      sym_asis_halmos_text,
  [14799] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1497), 1,
      anon_sym_COLON_COLON,
  [14806] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      sym_asis_three_backticks_text,
  [14813] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1501), 1,
      aux_sym_specialinline_token1,
  [14820] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 1,
      aux_sym_specialinline_token1,
  [14827] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      aux_sym_specialinline_token2,
  [14834] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1507), 1,
      anon_sym_COLON_COLON,
  [14841] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      anon_sym_COLON_COLON,
  [14848] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 1,
      aux_sym_specialblock_token5,
  [14855] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1509), 1,
      sym_asis_two_dollars_text,
  [14862] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1511), 1,
      aux_sym_specialinline_token1,
  [14869] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_COLON_COLON,
  [14876] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1515), 1,
      anon_sym_COLON_COLON,
  [14883] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      aux_sym_specialinline_token2,
  [14890] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1519), 1,
      aux_sym_specialblock_token4,
  [14897] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1169), 1,
      ts_builtin_sym_end,
  [14904] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      anon_sym_COLON_COLON,
  [14911] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 1,
      sym_text,
  [14918] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 1,
      sym_text,
  [14925] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 1,
      anon_sym_COLON_COLON,
  [14932] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      anon_sym_COLON_COLON,
  [14939] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1529), 1,
      aux_sym_specialinline_token1,
  [14946] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 1,
      aux_sym_specialinline_token2,
  [14953] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      anon_sym_COLON_COLON,
  [14960] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 1,
      anon_sym_COLON_COLON,
  [14967] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1535), 1,
      anon_sym_COLON_COLON,
  [14974] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1537), 1,
      aux_sym_metaval_any_token1,
  [14981] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      ts_builtin_sym_end,
  [14988] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_COMMA,
  [14995] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      sym_asis_backtick_text,
  [15002] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1539), 1,
      sym_text,
  [15009] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1541), 1,
      aux_sym_specialinline_token8,
  [15016] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1543), 1,
      aux_sym_specialinline_token7,
  [15023] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1545), 1,
      aux_sym_specialinline_token1,
  [15030] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1427), 1,
      aux_sym_specialinline_token2,
  [15037] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1547), 1,
      anon_sym_COLON_COLON,
  [15044] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1549), 1,
      aux_sym_specialblock_token4,
  [15051] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      aux_sym_specialinline_token6,
  [15058] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1543), 1,
      aux_sym_specialinline_token5,
  [15065] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 1,
      anon_sym_COLON_COLON,
  [15072] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      anon_sym_COLON_COLON,
  [15079] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_LBRACE,
  [15086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 1,
      ts_builtin_sym_end,
  [15093] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_COLON_COLON,
  [15100] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1563), 1,
      anon_sym_COLON_COLON,
  [15107] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 1,
      anon_sym_COLON_COLON,
  [15114] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1567), 1,
      anon_sym_COLON_COLON,
  [15121] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1569), 1,
      aux_sym_specialinline_token5,
  [15128] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1571), 1,
      aux_sym_specialinline_token6,
  [15135] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1569), 1,
      aux_sym_specialinline_token7,
  [15142] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1573), 1,
      aux_sym_specialinline_token8,
  [15149] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1575), 1,
      anon_sym_COLON_COLON,
  [15156] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1577), 1,
      ts_builtin_sym_end,
  [15163] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1579), 1,
      sym_asis_dollar_text,
  [15170] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1581), 1,
      sym_asis_backtick_text,
  [15177] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      sym_asis_halmos_text,
  [15184] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      sym_asis_halmos_text,
  [15191] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      sym_upto_brace_or_comma_text,
  [15198] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1589), 1,
      sym_text,
  [15205] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1591), 1,
      sym_text,
  [15212] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1593), 1,
      aux_sym_bibitem_token2,
  [15219] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1305), 1,
      anon_sym_COMMA,
  [15226] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym_asis_halmos_text,
  [15233] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_COLON_COLON,
  [15240] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1597), 1,
      anon_sym_COLON_COLON,
  [15247] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1599), 1,
      aux_sym_specialinline_token5,
  [15254] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1601), 1,
      aux_sym_specialinline_token6,
  [15261] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1599), 1,
      aux_sym_specialinline_token7,
  [15268] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1603), 1,
      aux_sym_specialinline_token8,
  [15275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1605), 1,
      sym_text,
  [15282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1607), 1,
      sym_asis_dollar_text,
  [15289] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1609), 1,
      sym_asis_backtick_text,
  [15296] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      sym_asis_halmos_text,
  [15303] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1613), 1,
      sym_asis_halmos_text,
  [15310] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1615), 1,
      anon_sym_COLON_COLON,
  [15317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1617), 1,
      sym_text,
  [15324] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1619), 1,
      sym_text,
  [15331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      sym_asis_halmos_text,
  [15338] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_COMMA,
  [15345] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1623), 1,
      anon_sym_COLON_COLON,
  [15352] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1625), 1,
      anon_sym_COLON,
  [15359] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_EQ,
  [15366] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1629), 1,
      aux_sym_specialinline_token5,
  [15373] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1631), 1,
      aux_sym_specialinline_token6,
  [15380] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1629), 1,
      aux_sym_specialinline_token7,
  [15387] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1633), 1,
      aux_sym_specialinline_token8,
  [15394] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      anon_sym_LBRACE,
  [15401] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1637), 1,
      sym_asis_dollar_text,
  [15408] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1639), 1,
      sym_asis_backtick_text,
  [15415] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      sym_asis_halmos_text,
  [15422] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      sym_asis_halmos_text,
  [15429] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1333), 1,
      aux_sym_bibitempair_token1,
  [15436] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 1,
      sym_text,
  [15443] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1647), 1,
      sym_text,
  [15450] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1649), 1,
      aux_sym_bibitempair_token2,
  [15457] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 1,
      anon_sym_COLON_COLON,
  [15464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1289), 1,
      anon_sym_COMMA,
  [15471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1653), 1,
      anon_sym_RBRACE,
  [15478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1539), 1,
      sym_upto_brace_or_comma_text,
  [15485] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1655), 1,
      aux_sym_specialinline_token5,
  [15492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      aux_sym_specialinline_token6,
  [15499] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1655), 1,
      aux_sym_specialinline_token7,
  [15506] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1659), 1,
      aux_sym_specialinline_token8,
  [15513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1661), 1,
      sym_asis_dollar_text,
  [15520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 1,
      sym_asis_backtick_text,
  [15527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      sym_asis_halmos_text,
  [15534] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1667), 1,
      sym_asis_halmos_text,
  [15541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1669), 1,
      sym_text,
  [15548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1671), 1,
      sym_text,
  [15555] = 2,
    ACTIONS(1339), 1,
      sym_comment,
    ACTIONS(1537), 1,
      aux_sym_metaval_any_inline_token1,
  [15562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1068), 1,
      sym_asis_backtick_text,
  [15569] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(352), 1,
      anon_sym_COLON_COLON,
  [15576] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1066), 1,
      sym_asis_dollar_text,
  [15583] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 1,
      anon_sym_COLON_COLON,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(63)] = 0,
  [SMALL_STATE(64)] = 86,
  [SMALL_STATE(65)] = 168,
  [SMALL_STATE(66)] = 250,
  [SMALL_STATE(67)] = 332,
  [SMALL_STATE(68)] = 414,
  [SMALL_STATE(69)] = 496,
  [SMALL_STATE(70)] = 578,
  [SMALL_STATE(71)] = 660,
  [SMALL_STATE(72)] = 742,
  [SMALL_STATE(73)] = 824,
  [SMALL_STATE(74)] = 906,
  [SMALL_STATE(75)] = 988,
  [SMALL_STATE(76)] = 1067,
  [SMALL_STATE(77)] = 1146,
  [SMALL_STATE(78)] = 1225,
  [SMALL_STATE(79)] = 1304,
  [SMALL_STATE(80)] = 1383,
  [SMALL_STATE(81)] = 1462,
  [SMALL_STATE(82)] = 1541,
  [SMALL_STATE(83)] = 1617,
  [SMALL_STATE(84)] = 1693,
  [SMALL_STATE(85)] = 1769,
  [SMALL_STATE(86)] = 1845,
  [SMALL_STATE(87)] = 1921,
  [SMALL_STATE(88)] = 1997,
  [SMALL_STATE(89)] = 2073,
  [SMALL_STATE(90)] = 2149,
  [SMALL_STATE(91)] = 2225,
  [SMALL_STATE(92)] = 2301,
  [SMALL_STATE(93)] = 2377,
  [SMALL_STATE(94)] = 2453,
  [SMALL_STATE(95)] = 2529,
  [SMALL_STATE(96)] = 2605,
  [SMALL_STATE(97)] = 2681,
  [SMALL_STATE(98)] = 2757,
  [SMALL_STATE(99)] = 2833,
  [SMALL_STATE(100)] = 2909,
  [SMALL_STATE(101)] = 2985,
  [SMALL_STATE(102)] = 3061,
  [SMALL_STATE(103)] = 3137,
  [SMALL_STATE(104)] = 3213,
  [SMALL_STATE(105)] = 3289,
  [SMALL_STATE(106)] = 3365,
  [SMALL_STATE(107)] = 3441,
  [SMALL_STATE(108)] = 3517,
  [SMALL_STATE(109)] = 3593,
  [SMALL_STATE(110)] = 3669,
  [SMALL_STATE(111)] = 3745,
  [SMALL_STATE(112)] = 3821,
  [SMALL_STATE(113)] = 3897,
  [SMALL_STATE(114)] = 3973,
  [SMALL_STATE(115)] = 4049,
  [SMALL_STATE(116)] = 4125,
  [SMALL_STATE(117)] = 4201,
  [SMALL_STATE(118)] = 4277,
  [SMALL_STATE(119)] = 4353,
  [SMALL_STATE(120)] = 4429,
  [SMALL_STATE(121)] = 4505,
  [SMALL_STATE(122)] = 4581,
  [SMALL_STATE(123)] = 4657,
  [SMALL_STATE(124)] = 4733,
  [SMALL_STATE(125)] = 4809,
  [SMALL_STATE(126)] = 4885,
  [SMALL_STATE(127)] = 4961,
  [SMALL_STATE(128)] = 5037,
  [SMALL_STATE(129)] = 5113,
  [SMALL_STATE(130)] = 5189,
  [SMALL_STATE(131)] = 5265,
  [SMALL_STATE(132)] = 5341,
  [SMALL_STATE(133)] = 5417,
  [SMALL_STATE(134)] = 5493,
  [SMALL_STATE(135)] = 5569,
  [SMALL_STATE(136)] = 5645,
  [SMALL_STATE(137)] = 5721,
  [SMALL_STATE(138)] = 5797,
  [SMALL_STATE(139)] = 5873,
  [SMALL_STATE(140)] = 5949,
  [SMALL_STATE(141)] = 6025,
  [SMALL_STATE(142)] = 6101,
  [SMALL_STATE(143)] = 6177,
  [SMALL_STATE(144)] = 6253,
  [SMALL_STATE(145)] = 6329,
  [SMALL_STATE(146)] = 6405,
  [SMALL_STATE(147)] = 6478,
  [SMALL_STATE(148)] = 6551,
  [SMALL_STATE(149)] = 6624,
  [SMALL_STATE(150)] = 6697,
  [SMALL_STATE(151)] = 6739,
  [SMALL_STATE(152)] = 6781,
  [SMALL_STATE(153)] = 6823,
  [SMALL_STATE(154)] = 6865,
  [SMALL_STATE(155)] = 6907,
  [SMALL_STATE(156)] = 6949,
  [SMALL_STATE(157)] = 6991,
  [SMALL_STATE(158)] = 7033,
  [SMALL_STATE(159)] = 7075,
  [SMALL_STATE(160)] = 7117,
  [SMALL_STATE(161)] = 7159,
  [SMALL_STATE(162)] = 7201,
  [SMALL_STATE(163)] = 7243,
  [SMALL_STATE(164)] = 7285,
  [SMALL_STATE(165)] = 7327,
  [SMALL_STATE(166)] = 7369,
  [SMALL_STATE(167)] = 7411,
  [SMALL_STATE(168)] = 7453,
  [SMALL_STATE(169)] = 7495,
  [SMALL_STATE(170)] = 7537,
  [SMALL_STATE(171)] = 7579,
  [SMALL_STATE(172)] = 7621,
  [SMALL_STATE(173)] = 7660,
  [SMALL_STATE(174)] = 7701,
  [SMALL_STATE(175)] = 7742,
  [SMALL_STATE(176)] = 7783,
  [SMALL_STATE(177)] = 7824,
  [SMALL_STATE(178)] = 7865,
  [SMALL_STATE(179)] = 7906,
  [SMALL_STATE(180)] = 7947,
  [SMALL_STATE(181)] = 7988,
  [SMALL_STATE(182)] = 8027,
  [SMALL_STATE(183)] = 8068,
  [SMALL_STATE(184)] = 8109,
  [SMALL_STATE(185)] = 8150,
  [SMALL_STATE(186)] = 8191,
  [SMALL_STATE(187)] = 8232,
  [SMALL_STATE(188)] = 8273,
  [SMALL_STATE(189)] = 8314,
  [SMALL_STATE(190)] = 8353,
  [SMALL_STATE(191)] = 8392,
  [SMALL_STATE(192)] = 8431,
  [SMALL_STATE(193)] = 8472,
  [SMALL_STATE(194)] = 8513,
  [SMALL_STATE(195)] = 8554,
  [SMALL_STATE(196)] = 8593,
  [SMALL_STATE(197)] = 8634,
  [SMALL_STATE(198)] = 8675,
  [SMALL_STATE(199)] = 8716,
  [SMALL_STATE(200)] = 8757,
  [SMALL_STATE(201)] = 8798,
  [SMALL_STATE(202)] = 8837,
  [SMALL_STATE(203)] = 8876,
  [SMALL_STATE(204)] = 8917,
  [SMALL_STATE(205)] = 8958,
  [SMALL_STATE(206)] = 8997,
  [SMALL_STATE(207)] = 9038,
  [SMALL_STATE(208)] = 9077,
  [SMALL_STATE(209)] = 9118,
  [SMALL_STATE(210)] = 9159,
  [SMALL_STATE(211)] = 9200,
  [SMALL_STATE(212)] = 9239,
  [SMALL_STATE(213)] = 9278,
  [SMALL_STATE(214)] = 9319,
  [SMALL_STATE(215)] = 9360,
  [SMALL_STATE(216)] = 9401,
  [SMALL_STATE(217)] = 9442,
  [SMALL_STATE(218)] = 9483,
  [SMALL_STATE(219)] = 9524,
  [SMALL_STATE(220)] = 9565,
  [SMALL_STATE(221)] = 9604,
  [SMALL_STATE(222)] = 9645,
  [SMALL_STATE(223)] = 9686,
  [SMALL_STATE(224)] = 9725,
  [SMALL_STATE(225)] = 9764,
  [SMALL_STATE(226)] = 9805,
  [SMALL_STATE(227)] = 9844,
  [SMALL_STATE(228)] = 9885,
  [SMALL_STATE(229)] = 9926,
  [SMALL_STATE(230)] = 9965,
  [SMALL_STATE(231)] = 10006,
  [SMALL_STATE(232)] = 10045,
  [SMALL_STATE(233)] = 10086,
  [SMALL_STATE(234)] = 10125,
  [SMALL_STATE(235)] = 10164,
  [SMALL_STATE(236)] = 10205,
  [SMALL_STATE(237)] = 10246,
  [SMALL_STATE(238)] = 10285,
  [SMALL_STATE(239)] = 10326,
  [SMALL_STATE(240)] = 10367,
  [SMALL_STATE(241)] = 10408,
  [SMALL_STATE(242)] = 10449,
  [SMALL_STATE(243)] = 10490,
  [SMALL_STATE(244)] = 10529,
  [SMALL_STATE(245)] = 10570,
  [SMALL_STATE(246)] = 10611,
  [SMALL_STATE(247)] = 10652,
  [SMALL_STATE(248)] = 10691,
  [SMALL_STATE(249)] = 10732,
  [SMALL_STATE(250)] = 10771,
  [SMALL_STATE(251)] = 10812,
  [SMALL_STATE(252)] = 10853,
  [SMALL_STATE(253)] = 10894,
  [SMALL_STATE(254)] = 10935,
  [SMALL_STATE(255)] = 10976,
  [SMALL_STATE(256)] = 11017,
  [SMALL_STATE(257)] = 11058,
  [SMALL_STATE(258)] = 11099,
  [SMALL_STATE(259)] = 11140,
  [SMALL_STATE(260)] = 11181,
  [SMALL_STATE(261)] = 11222,
  [SMALL_STATE(262)] = 11263,
  [SMALL_STATE(263)] = 11301,
  [SMALL_STATE(264)] = 11370,
  [SMALL_STATE(265)] = 11421,
  [SMALL_STATE(266)] = 11472,
  [SMALL_STATE(267)] = 11523,
  [SMALL_STATE(268)] = 11574,
  [SMALL_STATE(269)] = 11625,
  [SMALL_STATE(270)] = 11676,
  [SMALL_STATE(271)] = 11724,
  [SMALL_STATE(272)] = 11772,
  [SMALL_STATE(273)] = 11820,
  [SMALL_STATE(274)] = 11868,
  [SMALL_STATE(275)] = 11916,
  [SMALL_STATE(276)] = 11964,
  [SMALL_STATE(277)] = 12011,
  [SMALL_STATE(278)] = 12040,
  [SMALL_STATE(279)] = 12087,
  [SMALL_STATE(280)] = 12134,
  [SMALL_STATE(281)] = 12181,
  [SMALL_STATE(282)] = 12228,
  [SMALL_STATE(283)] = 12275,
  [SMALL_STATE(284)] = 12322,
  [SMALL_STATE(285)] = 12369,
  [SMALL_STATE(286)] = 12416,
  [SMALL_STATE(287)] = 12443,
  [SMALL_STATE(288)] = 12470,
  [SMALL_STATE(289)] = 12497,
  [SMALL_STATE(290)] = 12524,
  [SMALL_STATE(291)] = 12551,
  [SMALL_STATE(292)] = 12578,
  [SMALL_STATE(293)] = 12602,
  [SMALL_STATE(294)] = 12626,
  [SMALL_STATE(295)] = 12650,
  [SMALL_STATE(296)] = 12674,
  [SMALL_STATE(297)] = 12698,
  [SMALL_STATE(298)] = 12722,
  [SMALL_STATE(299)] = 12746,
  [SMALL_STATE(300)] = 12770,
  [SMALL_STATE(301)] = 12794,
  [SMALL_STATE(302)] = 12818,
  [SMALL_STATE(303)] = 12842,
  [SMALL_STATE(304)] = 12866,
  [SMALL_STATE(305)] = 12890,
  [SMALL_STATE(306)] = 12914,
  [SMALL_STATE(307)] = 12938,
  [SMALL_STATE(308)] = 12962,
  [SMALL_STATE(309)] = 12986,
  [SMALL_STATE(310)] = 13010,
  [SMALL_STATE(311)] = 13034,
  [SMALL_STATE(312)] = 13058,
  [SMALL_STATE(313)] = 13082,
  [SMALL_STATE(314)] = 13105,
  [SMALL_STATE(315)] = 13130,
  [SMALL_STATE(316)] = 13145,
  [SMALL_STATE(317)] = 13160,
  [SMALL_STATE(318)] = 13179,
  [SMALL_STATE(319)] = 13198,
  [SMALL_STATE(320)] = 13213,
  [SMALL_STATE(321)] = 13227,
  [SMALL_STATE(322)] = 13241,
  [SMALL_STATE(323)] = 13255,
  [SMALL_STATE(324)] = 13267,
  [SMALL_STATE(325)] = 13279,
  [SMALL_STATE(326)] = 13293,
  [SMALL_STATE(327)] = 13307,
  [SMALL_STATE(328)] = 13320,
  [SMALL_STATE(329)] = 13333,
  [SMALL_STATE(330)] = 13346,
  [SMALL_STATE(331)] = 13359,
  [SMALL_STATE(332)] = 13372,
  [SMALL_STATE(333)] = 13385,
  [SMALL_STATE(334)] = 13398,
  [SMALL_STATE(335)] = 13411,
  [SMALL_STATE(336)] = 13424,
  [SMALL_STATE(337)] = 13437,
  [SMALL_STATE(338)] = 13450,
  [SMALL_STATE(339)] = 13463,
  [SMALL_STATE(340)] = 13476,
  [SMALL_STATE(341)] = 13489,
  [SMALL_STATE(342)] = 13502,
  [SMALL_STATE(343)] = 13515,
  [SMALL_STATE(344)] = 13528,
  [SMALL_STATE(345)] = 13541,
  [SMALL_STATE(346)] = 13554,
  [SMALL_STATE(347)] = 13567,
  [SMALL_STATE(348)] = 13576,
  [SMALL_STATE(349)] = 13589,
  [SMALL_STATE(350)] = 13602,
  [SMALL_STATE(351)] = 13615,
  [SMALL_STATE(352)] = 13628,
  [SMALL_STATE(353)] = 13641,
  [SMALL_STATE(354)] = 13654,
  [SMALL_STATE(355)] = 13667,
  [SMALL_STATE(356)] = 13680,
  [SMALL_STATE(357)] = 13693,
  [SMALL_STATE(358)] = 13706,
  [SMALL_STATE(359)] = 13719,
  [SMALL_STATE(360)] = 13732,
  [SMALL_STATE(361)] = 13745,
  [SMALL_STATE(362)] = 13758,
  [SMALL_STATE(363)] = 13771,
  [SMALL_STATE(364)] = 13784,
  [SMALL_STATE(365)] = 13797,
  [SMALL_STATE(366)] = 13805,
  [SMALL_STATE(367)] = 13813,
  [SMALL_STATE(368)] = 13823,
  [SMALL_STATE(369)] = 13833,
  [SMALL_STATE(370)] = 13843,
  [SMALL_STATE(371)] = 13853,
  [SMALL_STATE(372)] = 13863,
  [SMALL_STATE(373)] = 13873,
  [SMALL_STATE(374)] = 13883,
  [SMALL_STATE(375)] = 13891,
  [SMALL_STATE(376)] = 13899,
  [SMALL_STATE(377)] = 13907,
  [SMALL_STATE(378)] = 13915,
  [SMALL_STATE(379)] = 13925,
  [SMALL_STATE(380)] = 13935,
  [SMALL_STATE(381)] = 13943,
  [SMALL_STATE(382)] = 13951,
  [SMALL_STATE(383)] = 13961,
  [SMALL_STATE(384)] = 13971,
  [SMALL_STATE(385)] = 13981,
  [SMALL_STATE(386)] = 13991,
  [SMALL_STATE(387)] = 13999,
  [SMALL_STATE(388)] = 14009,
  [SMALL_STATE(389)] = 14017,
  [SMALL_STATE(390)] = 14025,
  [SMALL_STATE(391)] = 14033,
  [SMALL_STATE(392)] = 14043,
  [SMALL_STATE(393)] = 14051,
  [SMALL_STATE(394)] = 14061,
  [SMALL_STATE(395)] = 14071,
  [SMALL_STATE(396)] = 14081,
  [SMALL_STATE(397)] = 14091,
  [SMALL_STATE(398)] = 14101,
  [SMALL_STATE(399)] = 14111,
  [SMALL_STATE(400)] = 14121,
  [SMALL_STATE(401)] = 14129,
  [SMALL_STATE(402)] = 14139,
  [SMALL_STATE(403)] = 14147,
  [SMALL_STATE(404)] = 14157,
  [SMALL_STATE(405)] = 14167,
  [SMALL_STATE(406)] = 14175,
  [SMALL_STATE(407)] = 14185,
  [SMALL_STATE(408)] = 14195,
  [SMALL_STATE(409)] = 14205,
  [SMALL_STATE(410)] = 14215,
  [SMALL_STATE(411)] = 14225,
  [SMALL_STATE(412)] = 14235,
  [SMALL_STATE(413)] = 14245,
  [SMALL_STATE(414)] = 14255,
  [SMALL_STATE(415)] = 14265,
  [SMALL_STATE(416)] = 14275,
  [SMALL_STATE(417)] = 14285,
  [SMALL_STATE(418)] = 14295,
  [SMALL_STATE(419)] = 14305,
  [SMALL_STATE(420)] = 14315,
  [SMALL_STATE(421)] = 14325,
  [SMALL_STATE(422)] = 14335,
  [SMALL_STATE(423)] = 14345,
  [SMALL_STATE(424)] = 14355,
  [SMALL_STATE(425)] = 14363,
  [SMALL_STATE(426)] = 14373,
  [SMALL_STATE(427)] = 14383,
  [SMALL_STATE(428)] = 14393,
  [SMALL_STATE(429)] = 14403,
  [SMALL_STATE(430)] = 14413,
  [SMALL_STATE(431)] = 14423,
  [SMALL_STATE(432)] = 14433,
  [SMALL_STATE(433)] = 14443,
  [SMALL_STATE(434)] = 14453,
  [SMALL_STATE(435)] = 14463,
  [SMALL_STATE(436)] = 14473,
  [SMALL_STATE(437)] = 14483,
  [SMALL_STATE(438)] = 14491,
  [SMALL_STATE(439)] = 14498,
  [SMALL_STATE(440)] = 14505,
  [SMALL_STATE(441)] = 14512,
  [SMALL_STATE(442)] = 14519,
  [SMALL_STATE(443)] = 14526,
  [SMALL_STATE(444)] = 14533,
  [SMALL_STATE(445)] = 14540,
  [SMALL_STATE(446)] = 14547,
  [SMALL_STATE(447)] = 14554,
  [SMALL_STATE(448)] = 14561,
  [SMALL_STATE(449)] = 14568,
  [SMALL_STATE(450)] = 14575,
  [SMALL_STATE(451)] = 14582,
  [SMALL_STATE(452)] = 14589,
  [SMALL_STATE(453)] = 14596,
  [SMALL_STATE(454)] = 14603,
  [SMALL_STATE(455)] = 14610,
  [SMALL_STATE(456)] = 14617,
  [SMALL_STATE(457)] = 14624,
  [SMALL_STATE(458)] = 14631,
  [SMALL_STATE(459)] = 14638,
  [SMALL_STATE(460)] = 14645,
  [SMALL_STATE(461)] = 14652,
  [SMALL_STATE(462)] = 14659,
  [SMALL_STATE(463)] = 14666,
  [SMALL_STATE(464)] = 14673,
  [SMALL_STATE(465)] = 14680,
  [SMALL_STATE(466)] = 14687,
  [SMALL_STATE(467)] = 14694,
  [SMALL_STATE(468)] = 14701,
  [SMALL_STATE(469)] = 14708,
  [SMALL_STATE(470)] = 14715,
  [SMALL_STATE(471)] = 14722,
  [SMALL_STATE(472)] = 14729,
  [SMALL_STATE(473)] = 14736,
  [SMALL_STATE(474)] = 14743,
  [SMALL_STATE(475)] = 14750,
  [SMALL_STATE(476)] = 14757,
  [SMALL_STATE(477)] = 14764,
  [SMALL_STATE(478)] = 14771,
  [SMALL_STATE(479)] = 14778,
  [SMALL_STATE(480)] = 14785,
  [SMALL_STATE(481)] = 14792,
  [SMALL_STATE(482)] = 14799,
  [SMALL_STATE(483)] = 14806,
  [SMALL_STATE(484)] = 14813,
  [SMALL_STATE(485)] = 14820,
  [SMALL_STATE(486)] = 14827,
  [SMALL_STATE(487)] = 14834,
  [SMALL_STATE(488)] = 14841,
  [SMALL_STATE(489)] = 14848,
  [SMALL_STATE(490)] = 14855,
  [SMALL_STATE(491)] = 14862,
  [SMALL_STATE(492)] = 14869,
  [SMALL_STATE(493)] = 14876,
  [SMALL_STATE(494)] = 14883,
  [SMALL_STATE(495)] = 14890,
  [SMALL_STATE(496)] = 14897,
  [SMALL_STATE(497)] = 14904,
  [SMALL_STATE(498)] = 14911,
  [SMALL_STATE(499)] = 14918,
  [SMALL_STATE(500)] = 14925,
  [SMALL_STATE(501)] = 14932,
  [SMALL_STATE(502)] = 14939,
  [SMALL_STATE(503)] = 14946,
  [SMALL_STATE(504)] = 14953,
  [SMALL_STATE(505)] = 14960,
  [SMALL_STATE(506)] = 14967,
  [SMALL_STATE(507)] = 14974,
  [SMALL_STATE(508)] = 14981,
  [SMALL_STATE(509)] = 14988,
  [SMALL_STATE(510)] = 14995,
  [SMALL_STATE(511)] = 15002,
  [SMALL_STATE(512)] = 15009,
  [SMALL_STATE(513)] = 15016,
  [SMALL_STATE(514)] = 15023,
  [SMALL_STATE(515)] = 15030,
  [SMALL_STATE(516)] = 15037,
  [SMALL_STATE(517)] = 15044,
  [SMALL_STATE(518)] = 15051,
  [SMALL_STATE(519)] = 15058,
  [SMALL_STATE(520)] = 15065,
  [SMALL_STATE(521)] = 15072,
  [SMALL_STATE(522)] = 15079,
  [SMALL_STATE(523)] = 15086,
  [SMALL_STATE(524)] = 15093,
  [SMALL_STATE(525)] = 15100,
  [SMALL_STATE(526)] = 15107,
  [SMALL_STATE(527)] = 15114,
  [SMALL_STATE(528)] = 15121,
  [SMALL_STATE(529)] = 15128,
  [SMALL_STATE(530)] = 15135,
  [SMALL_STATE(531)] = 15142,
  [SMALL_STATE(532)] = 15149,
  [SMALL_STATE(533)] = 15156,
  [SMALL_STATE(534)] = 15163,
  [SMALL_STATE(535)] = 15170,
  [SMALL_STATE(536)] = 15177,
  [SMALL_STATE(537)] = 15184,
  [SMALL_STATE(538)] = 15191,
  [SMALL_STATE(539)] = 15198,
  [SMALL_STATE(540)] = 15205,
  [SMALL_STATE(541)] = 15212,
  [SMALL_STATE(542)] = 15219,
  [SMALL_STATE(543)] = 15226,
  [SMALL_STATE(544)] = 15233,
  [SMALL_STATE(545)] = 15240,
  [SMALL_STATE(546)] = 15247,
  [SMALL_STATE(547)] = 15254,
  [SMALL_STATE(548)] = 15261,
  [SMALL_STATE(549)] = 15268,
  [SMALL_STATE(550)] = 15275,
  [SMALL_STATE(551)] = 15282,
  [SMALL_STATE(552)] = 15289,
  [SMALL_STATE(553)] = 15296,
  [SMALL_STATE(554)] = 15303,
  [SMALL_STATE(555)] = 15310,
  [SMALL_STATE(556)] = 15317,
  [SMALL_STATE(557)] = 15324,
  [SMALL_STATE(558)] = 15331,
  [SMALL_STATE(559)] = 15338,
  [SMALL_STATE(560)] = 15345,
  [SMALL_STATE(561)] = 15352,
  [SMALL_STATE(562)] = 15359,
  [SMALL_STATE(563)] = 15366,
  [SMALL_STATE(564)] = 15373,
  [SMALL_STATE(565)] = 15380,
  [SMALL_STATE(566)] = 15387,
  [SMALL_STATE(567)] = 15394,
  [SMALL_STATE(568)] = 15401,
  [SMALL_STATE(569)] = 15408,
  [SMALL_STATE(570)] = 15415,
  [SMALL_STATE(571)] = 15422,
  [SMALL_STATE(572)] = 15429,
  [SMALL_STATE(573)] = 15436,
  [SMALL_STATE(574)] = 15443,
  [SMALL_STATE(575)] = 15450,
  [SMALL_STATE(576)] = 15457,
  [SMALL_STATE(577)] = 15464,
  [SMALL_STATE(578)] = 15471,
  [SMALL_STATE(579)] = 15478,
  [SMALL_STATE(580)] = 15485,
  [SMALL_STATE(581)] = 15492,
  [SMALL_STATE(582)] = 15499,
  [SMALL_STATE(583)] = 15506,
  [SMALL_STATE(584)] = 15513,
  [SMALL_STATE(585)] = 15520,
  [SMALL_STATE(586)] = 15527,
  [SMALL_STATE(587)] = 15534,
  [SMALL_STATE(588)] = 15541,
  [SMALL_STATE(589)] = 15548,
  [SMALL_STATE(590)] = 15555,
  [SMALL_STATE(591)] = 15562,
  [SMALL_STATE(592)] = 15569,
  [SMALL_STATE(593)] = 15576,
  [SMALL_STATE(594)] = 15583,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2),
  [77] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_blockmeta_repeat1, 2),
  [79] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(511),
  [82] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(13),
  [85] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(392),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(507),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_blockmeta, 1),
  [93] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_blockmeta, 1),
  [95] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_list, 4),
  [97] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metaval_list, 4),
  [99] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_text, 1, .production_id = 3),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metaval_text, 1, .production_id = 3),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 2),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pair, 2),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_list, 1, .production_id = 4),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metaval_list, 1, .production_id = 4),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_any, 1),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metaval_any, 1),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pair, 1),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pair, 1),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metakey_bool, 1),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_metakey_bool, 1),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(379),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(43),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(555),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(550),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(266),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(267),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(268),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(269),
  [161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(80),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(79),
  [167] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(249),
  [170] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(360),
  [173] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(358),
  [176] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(357),
  [179] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(346),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(92),
  [185] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(97),
  [188] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(519),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(518),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(513),
  [197] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(512),
  [200] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(247),
  [203] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(263),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(74),
  [209] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(73),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(2),
  [215] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(82),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 2, .production_id = 1),
  [226] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 2, .production_id = 1),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paragraph, 2),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paragraph, 2),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3, .production_id = 2),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3, .production_id = 2),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 5, .production_id = 31),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 5, .production_id = 31),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 21),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 21),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 22),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 22),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 23),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 23),
  [252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 24),
  [254] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 24),
  [256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 3, .production_id = 14),
  [258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 3, .production_id = 14),
  [260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 6, .production_id = 33),
  [262] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 6, .production_id = 33),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2, .production_id = 1),
  [266] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2, .production_id = 1),
  [268] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 4, .production_id = 16),
  [270] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 4, .production_id = 16),
  [272] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 25),
  [274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 25),
  [276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 4, .production_id = 26),
  [278] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 4, .production_id = 26),
  [280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 3, .production_id = 13),
  [282] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 3, .production_id = 13),
  [284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paragraph, 1),
  [286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paragraph, 1),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 2, .production_id = 1),
  [290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 2, .production_id = 1),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 4, .production_id = 15),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 4, .production_id = 15),
  [296] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 4, .production_id = 5),
  [298] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 4, .production_id = 5),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 1),
  [302] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 1),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 4, .production_id = 2),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 4, .production_id = 2),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 3, .production_id = 2),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 3, .production_id = 2),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 3, .production_id = 12),
  [314] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 3, .production_id = 12),
  [316] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paragraph, 4, .production_id = 2),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paragraph, 4, .production_id = 2),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 4, .production_id = 2),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 4, .production_id = 2),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_caption, 4, .production_id = 18),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_caption, 4, .production_id = 18),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 5, .production_id = 15),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 5, .production_id = 15),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3, .production_id = 1),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3, .production_id = 1),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item, 4, .production_id = 18),
  [338] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item, 4, .production_id = 18),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 5, .production_id = 30),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 5, .production_id = 30),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 5, .production_id = 29),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 5, .production_id = 29),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_item, 3),
  [350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_item, 3),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_caption, 3),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_caption, 3),
  [356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 3, .production_id = 1),
  [358] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 3, .production_id = 1),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 3, .production_id = 7),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 3, .production_id = 7),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 3, .production_id = 6),
  [366] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 3, .production_id = 6),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 4, .production_id = 17),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 4, .production_id = 17),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_table, 5, .production_id = 32),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_table, 5, .production_id = 32),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialblock, 3, .production_id = 5),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialblock, 3, .production_id = 5),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(216),
  [457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(341),
  [460] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(340),
  [463] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(337),
  [466] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(335),
  [469] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(145),
  [472] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(143),
  [475] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(580),
  [478] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(581),
  [481] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(582),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(583),
  [487] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(215),
  [490] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(70),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(71),
  [496] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2), SHIFT_REPEAT(88),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2),
  [507] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(170),
  [510] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(359),
  [513] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(356),
  [516] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(352),
  [519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(349),
  [522] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(113),
  [525] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(114),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(563),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(564),
  [534] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(565),
  [537] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(566),
  [540] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(169),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_inline_repeat1, 2),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(64),
  [548] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(65),
  [551] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(77),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tdcontent, 1),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tdcontent, 1),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [614] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(217),
  [617] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(361),
  [620] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(364),
  [623] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(363),
  [626] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(362),
  [629] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(103),
  [632] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(98),
  [635] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(546),
  [638] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(547),
  [641] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(548),
  [644] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(549),
  [647] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(214),
  [650] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(69),
  [653] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(72),
  [656] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(89),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [671] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [703] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [747] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(249),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(360),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(358),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(357),
  [759] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(346),
  [762] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(92),
  [765] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(97),
  [768] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(519),
  [771] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(518),
  [774] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(513),
  [777] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(512),
  [780] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(247),
  [783] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(74),
  [786] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(73),
  [789] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2), SHIFT_REPEAT(101),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_paragraph_repeat1, 2),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [836] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [838] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [842] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [866] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(261),
  [869] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(328),
  [872] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(348),
  [875] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(353),
  [878] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(354),
  [881] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(133),
  [884] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(132),
  [887] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(528),
  [890] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(529),
  [893] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(530),
  [896] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(531),
  [899] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(260),
  [902] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(67),
  [905] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(66),
  [908] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(135),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [927] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(216),
  [930] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(341),
  [933] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(340),
  [936] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(337),
  [939] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(335),
  [942] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(145),
  [945] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(143),
  [948] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(580),
  [951] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(581),
  [954] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(582),
  [957] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(583),
  [960] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(215),
  [963] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(70),
  [966] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(71),
  [969] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_repeat1, 2), SHIFT_REPEAT(144),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline, 3, .production_id = 1),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline, 3, .production_id = 1),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_construct, 3, .production_id = 1),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_construct, 3, .production_id = 1),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 3, .production_id = 1),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 3, .production_id = 1),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 4, .production_id = 2),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 4, .production_id = 2),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 4, .production_id = 20),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 4, .production_id = 20),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 4, .production_id = 19),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 4, .production_id = 19),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 3, .production_id = 10),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 3, .production_id = 10),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline, 4, .production_id = 2),
  [1012] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline, 4, .production_id = 2),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 5, .production_id = 28),
  [1016] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 5, .production_id = 28),
  [1018] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 3, .production_id = 11),
  [1020] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 3, .production_id = 11),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_construct, 3, .production_id = 2),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_construct, 3, .production_id = 2),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_construct, 4, .production_id = 2),
  [1028] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_construct, 4, .production_id = 2),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 5, .production_id = 27),
  [1032] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 5, .production_id = 27),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 3, .production_id = 9),
  [1036] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 3, .production_id = 9),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 3, .production_id = 8),
  [1040] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 3, .production_id = 8),
  [1042] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline, 2, .production_id = 1),
  [1044] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline, 2, .production_id = 1),
  [1046] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_construct, 2, .production_id = 1),
  [1048] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_construct, 2, .production_id = 1),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 2, .production_id = 1),
  [1052] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 2, .production_id = 1),
  [1054] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialconstruct, 1, .production_id = 1),
  [1056] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialconstruct, 1, .production_id = 1),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_specialinline, 1),
  [1060] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_specialinline, 1),
  [1062] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline, 3, .production_id = 2),
  [1064] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline, 3, .production_id = 2),
  [1066] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inlinemeta, 3),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inlinemeta, 4),
  [1070] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_trshort_repeat1, 2),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1082] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(277),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1099] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(297),
  [1102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(301),
  [1105] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_blockmeta_repeat1, 2), SHIFT_REPEAT(306),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inlinemeta_repeat1, 2), SHIFT_REPEAT(579),
  [1117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inlinemeta_repeat1, 2), SHIFT_REPEAT(277),
  [1120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inlinemeta_repeat1, 2), SHIFT_REPEAT(405),
  [1123] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inlinemeta_repeat1, 2), SHIFT_REPEAT(590),
  [1126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inlinemeta_repeat1, 2),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_thead_repeat1, 2),
  [1136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_thead_repeat1, 2), SHIFT_REPEAT(63),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_tr_repeat1, 2),
  [1155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_tr_repeat1, 2), SHIFT_REPEAT(68),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bibtex_repeat1, 2),
  [1160] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bibtex_repeat1, 2), SHIFT_REPEAT(446),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 3, .production_id = 1),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 3, .production_id = 2),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 4, .production_id = 2),
  [1217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2, .production_id = 1),
  [1219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_bibitem_repeat1, 2), SHIFT_REPEAT(562),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_thead, 3, .production_id = 1),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tr, 3, .production_id = 1),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trshort, 3, .production_id = 1),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1264] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1276] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_metaval_list_repeat1, 2), SHIFT_REPEAT(509),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_td, 3, .production_id = 1),
  [1283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_trshort, 4, .production_id = 1),
  [1285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_list_inline, 4),
  [1287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_td, 4, .production_id = 2),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tbody, 3, .production_id = 1),
  [1295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibitem, 7, .production_id = 34),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_any_inline, 1),
  [1311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_list_inline, 1),
  [1313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inlinemetapair, 2),
  [1315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metaval_text_inline, 1, .production_id = 3),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metakey_list, 1),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_bibitem_repeat1, 2),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1339] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibitem, 9, .production_id = 34),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibitempair, 5),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inlinemetapair, 1),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibitem, 8, .production_id = 34),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 4, .production_id = 1),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibtex, 2),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1449] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metakey_any, 1),
  [1539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_metakey_text, 1),
  [1541] = {.entry = {.count = 1, .reusable = false}}, SHIFT(433),
  [1543] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bibtex, 3),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1569] = {.entry = {.count = 1, .reusable = false}}, SHIFT(417),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1573] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 5, .production_id = 2),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_metaval_list_repeat1, 2),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1593] = {.entry = {.count = 1, .reusable = false}}, SHIFT(559),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1599] = {.entry = {.count = 1, .reusable = false}}, SHIFT(427),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(428),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1629] = {.entry = {.count = 1, .reusable = false}}, SHIFT(412),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1633] = {.entry = {.count = 1, .reusable = false}}, SHIFT(411),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1649] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(395),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1659] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_rsm_external_scanner_create(void);
void tree_sitter_rsm_external_scanner_destroy(void *);
bool tree_sitter_rsm_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_rsm_external_scanner_serialize(void *, char *);
void tree_sitter_rsm_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_rsm(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_rsm_external_scanner_create,
      tree_sitter_rsm_external_scanner_destroy,
      tree_sitter_rsm_external_scanner_scan,
      tree_sitter_rsm_external_scanner_serialize,
      tree_sitter_rsm_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
