# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['suretime']

package_data = \
{'': ['*']}

install_requires = \
['defusedxml>=0.7,<1.0']

setup_kwargs = {
    'name': 'suretime',
    'version': '0.1.0',
    'description': 'Handle IANA timezones and fully resolved timestamps and intervals on all platforms',
    'long_description': '# Suretime\n\n[![Version status](https://img.shields.io/pypi/status/suretime)](https://pypi.org/project/suretime)\n[![License](https://img.shields.io/badge/License-Apache%202.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)\n[![Python version compatibility](https://img.shields.io/pypi/pyversions/suretime)](https://pypi.org/project/suretime)\n[![Version on GitHub](https://img.shields.io/github/v/release/dmyersturnbull/suretime?include_prereleases&label=GitHub)](https://github.com/dmyersturnbull/suretime/releases)\n[![Version on PyPi](https://img.shields.io/pypi/v/suretime)](https://pypi.org/project/suretime)\n[![Build (GitHub Actions)](https://img.shields.io/github/workflow/status/dmyersturnbull/suretime/Build%20&%20test?label=Build%20&%20test)](https://github.com/dmyersturnbull/suretime/actions)\n[![Test coverage (coveralls)](https://coveralls.io/repos/github/dmyersturnbull/suretime/badge.svg?branch=main&service=github)](https://coveralls.io/github/dmyersturnbull/suretime?branch=main)\n[![Maintainability (Code Climate)](https://api.codeclimate.com/v1/badges/14b23b28b0d9c37a0ebf/maintainability)](https://codeclimate.com/github/dmyersturnbull/suretime/maintainability)\n[![Code Quality (Scrutinizer)](https://scrutinizer-ci.com/g/dmyersturnbull/suretime/badges/quality-score.png?b=main)](https://scrutinizer-ci.com/g/dmyersturnbull/suretime/?branch=main)\n[![Created with Tyrannosaurus](https://img.shields.io/badge/Created_with-Tyrannosaurus-0000ff.svg)](https://github.com/dmyersturnbull/tyrannosaurus)\n\n(Try to) get IANA timezones on Windows.\nGet fully resolved timestamps and intervals and easily calculate properties.\n\nAlso see [tzlocal](https://github.com/regebro/tzlocal).\nIt sometimes does a better job of getting an IANA zone from your local system zone.\nHowever, it only works for your local system zone and relies on OS system files\n(both Unix and Windows), so it yields different results on different platforms.\nIn contrast, suretime is platform-invariant and a little more precise\n(e.g. by considering territories), but will fail to map the local system zone\nmore often than tzlocal. Suretime also has useful model classes and is *much* faster.\nIf you don’t need the platform-invariance, combine both for the best results\n(refer to the last section of the example).\n\nTimestamps are resolved as accurately as the system permits.\nDownloads and caches an up-to-date timezone name map if necessary.\nYou can map between zone names and find your local IANA zone.\nTimezone-resolved datetimes and intervals know both real and calendar times, correctly representing\nthe ground truth even if a timezone shift occurs between events – such as from a daylight savings change\nor user boarding a flight.\nNote that there is no 1-1 mapping between Windows and IANA timezones.\nThere are several other limitations and [known issues](https://github.com/dmyersturnbull/suretime/issues).\n\nTo install: `pip install suretime tzdata`.\nExamples:\n\n```python\nfrom suretime import TzMap, datetime\n\n# Get your local system, non-IANA timezone\nsystem_time = datetime.now().astimezone()\nsystem_timezone = system_time.tzname()  # e.g. Pacific Standard Time\n\n# Get an IANA timezone instead:\nTzMap.zones.only_local()  # ZoneInfo[America/Los_Angeles]\n# Or for an arbitrary system timezone name:\nTzMap.zones.first(system_timezone)  # ZoneInfo[America/Los_Angeles]\n# Of course, it maps IANA zones to themselves:\nTzMap.zones.only("America/Los_Angeles")  # ZoneInfo[America/Los_Angeles]\n\n# Get all IANA timezones that could match a zone\n# The first uses the primary/null territory\n# The second uses the territory "AQ"\nTzMap.zones.all("Central Pacific Standard Time")  # {ZoneInfo[Pacific/Guadalcanal]}\nTzMap.zones.all("Central Pacific Standard Time", "AQ")  # {ZoneInfo[Antarctica/Casey]}\n\n# Get 1 matching IANA zone; "get" means optional\nTzMap.zones.first("Central Pacific Standard Time", "AQ")  # ZoneInfo[Pacific/Casey]\nTzMap.zones.first("nonexistent zone")  # None\n\n# Get a fully resolved "tagged datetime"\n# It contains:\n# - The zoned datetime\n# - The primary IANA ZoneInfo\n# - The original system timezone\n# - A system wall time (`time.monotonic_ns`)\ntagged = TzMap.tagged.now()  # TaggedDatetime[ ... ]\n\n# 2021-01-20T22:24:13.219253-07:00 [America/Los_Angeles]\nprint(tagged.iso_with_zone)  # <datetime> [zone]\nprint(tagged.source.territory)  # "primary"\n\n# Compare tagged datetimes\nprint(tagged < tagged)  # False\nprint(tagged == tagged)  # True: They\'re the same point in time\nprint(tagged == system_time)  # True: They\'re the same point in time\nprint(tagged.is_identical_to(tagged))  # True: They\'re exactly the same\n\n# Get a "tagged duration" with the start and end, and monotonic real time in nanoseconds\nthen = TzMap.tagged.now()  # TaggedDatetime [ ... ]\nfor i in list(range(10000)): i += 1  # Just waiting a little\nnow = TzMap.tagged.now()  # TaggedInterval [ ... ]\ninterval = TzMap.tagged.interval(then, now)  # TaggedInterval [ ... ]\nprint(interval.delta_real_time)  # Actual time passed\nprint(interval.delta_calendar_time)  # Simple end - start\nprint(interval.exact_duration_str)  # days:HH:mm:ss.millis.micros.nanos\n\n# use suretime, fall back to tzlocal\nimport tzlocal\n\ndef get_local() -> TzMap.Types.TaggedDatetime:\n  try:\n    return TzMap.tagged.now()\n  except TzMap.Errors.CannotMapTzError:\n    zone = tzlocal.get_localzone()\n    return TzMap.tagged.exact(datetime.now(zone))\n\n```\n\nLicensed under the terms of the [Apache License 2.0](https://spdx.org/licenses/Apache-2.0.html).\n[New issues](https://github.com/dmyersturnbull/suretime/issues) and pull requests are welcome.\nPlease refer to the [contributing guide](https://github.com/dmyersturnbull/suretime/blob/main/CONTRIBUTING.md)\nand [security policy](https://github.com/dmyersturnbull/suretime/blob/main/SECURITY.md).\n\nGenerated with [Tyrannosaurus](https://github.com/dmyersturnbull/tyrannosaurus).\n',
    'author': 'Douglas Myers-Turnbull',
    'author_email': None,
    'maintainer': 'Douglas Myers-Turnbull',
    'maintainer_email': None,
    'url': 'https://github.com/dmyersturnbull/suretime',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
