# Contributing to 'socketlabs-python'

If you discover issues, have ideas for improvements or new features,
please report them to the [issue tracker](https://github.com/socketlabs/socketlabs-python/issues) of the repository or
submit a pull request. Please, try to follow these guidelines when you
do so.

- [Issue Reporting](#reporting)
- [Feature Requests](#feature)
- [Pull Requests](#pull)


## <a name="reporting"></a>Issue reporting

* Check that the issue has not already been reported.
* Check that the issue has not already been fixed in the latest code
  (a.k.a. `main`).
* Be clear, concise and precise in your description of the problem.
* Open an issue with a descriptive title and a summary in grammatically correct,
  complete sentences.
* Mention the version info.

## <a name="feature"></a> Want a Feature?

You can request a new feature by submitting an issue to our
[GitHub Repository](https://github.com/socketlabs/socketlabs-python). If you would like to implement a new feature then
consider what kind of change it is:

* **Major Changes** that you wish to contribute to the project should be
  discussed first with `socketlabs-python` contributors in an issue or pull request so
  that we can develop a proper solution and better coordinate our efforts,
  prevent duplication of work, and help you to craft the change so that it is
  successfully accepted into the project.
* **Small Changes** can be crafted and submitted to the
  [GitHub Repository](https://github.com/socketlabs/socketlabs-python) as a Pull Request.
  
  ## <a name="pull"></a> Creating a Pull Request?
  
- Create a personal fork of the project on Github.
- If you created your fork a while ago be sure to pull upstream changes into your local repository.
- Create a new branch to work on! Branch from `main`.
- Implement/fix your feature, comment your code.
- Write or adapt tests as needed.
- Add or change the documentation as needed.
- Squash your commits into a single commit with git's [interactive rebase](https://help.github.com/articles/interactive-rebase). Create a new branch if necessary.
- Push your branch to your fork on Github, the remote `origin`.
- From your fork open a pull request with a clear title and description in grammatically correct, complete sentences.
