# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import date, datetime  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel
from pydantic import AnyUrl, Field  # noqa: F401

from telus_bulk.models.tmf_645.characteristic import Characteristic
from telus_bulk.models.tmf_645.feature import Feature
from telus_bulk.models.tmf_645.note import Note
from telus_bulk.models.tmf_645.related_entity_ref_or_value import (
    RelatedEntityRefOrValue,
)
from telus_bulk.models.tmf_645.related_party import RelatedParty
from telus_bulk.models.tmf_645.related_place_ref_or_value import RelatedPlaceRefOrValue
from telus_bulk.models.tmf_645.related_service_order_item import RelatedServiceOrderItem
from telus_bulk.models.tmf_645.resource_ref import ResourceRef

# from telus_bulk.models.tmf_645.service_relationship import ServiceRelationship
from telus_bulk.models.tmf_645.service_specification_ref import ServiceSpecificationRef
from telus_bulk.models.tmf_645.service_state_type import ServiceStateType
from telus_bulk.models.worker_job.place import PlaceAMS
from telus_bulk.models.worker_job.service_specification import ServiceSpecification


class ServiceRefOrValue(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    ServiceRefOrValue - a model defined in OpenAPI

        id: The id of this ServiceRefOrValue [Optional].
        href: The href of this ServiceRefOrValue [Optional].
        category: The category of this ServiceRefOrValue [Optional].
        description: The description of this ServiceRefOrValue [Optional].
        end_date: The end_date of this ServiceRefOrValue [Optional].
        has_started: The has_started of this ServiceRefOrValue [Optional].
        is_bundle: The is_bundle of this ServiceRefOrValue [Optional].
        is_service_enabled: The is_service_enabled of this ServiceRefOrValue [Optional].
        is_stateful: The is_stateful of this ServiceRefOrValue [Optional].
        name: The name of this ServiceRefOrValue [Optional].
        service_date: The service_date of this ServiceRefOrValue [Optional].
        service_type: The service_type of this ServiceRefOrValue [Optional].
        start_date: The start_date of this ServiceRefOrValue [Optional].
        start_mode: The start_mode of this ServiceRefOrValue [Optional].
        feature: The feature of this ServiceRefOrValue [Optional].
        note: The note of this ServiceRefOrValue [Optional].
        place: The place of this ServiceRefOrValue [Optional].
        related_entity: The related_entity of this ServiceRefOrValue [Optional].
        related_party: The related_party of this ServiceRefOrValue [Optional].
        service_characteristic: The service_characteristic of this ServiceRefOrValue [Optional].
        service_order_item: The service_order_item of this ServiceRefOrValue [Optional].
        service_relationship: The service_relationship of this ServiceRefOrValue [Optional].
        service_specification: The service_specification of this ServiceRefOrValue [Optional].
        state: The state of this ServiceRefOrValue [Optional].
        supporting_resource: The supporting_resource of this ServiceRefOrValue [Optional].
        supporting_service: The supporting_service of this ServiceRefOrValue [Optional].
        base_type: The base_type of this ServiceRefOrValue [Optional].
        schema_location: The schema_location of this ServiceRefOrValue [Optional].
        type: The type of this ServiceRefOrValue [Optional].
        referred_type: The referred_type of this ServiceRefOrValue [Optional].
    """

    id: Optional[str] = None
    href: Optional[str] = None
    category: Optional[str] = None
    description: Optional[str] = None
    end_date: Optional[datetime] = None
    has_started: Optional[bool] = None
    is_bundle: Optional[bool] = None
    is_service_enabled: Optional[bool] = None
    is_stateful: Optional[bool] = None
    name: Optional[str] = None
    service_date: Optional[str] = None
    service_type: Optional[str] = None
    start_date: Optional[datetime] = None
    start_mode: Optional[str] = None
    feature: Optional[List[Feature]] = None
    note: Optional[List[Note]] = None
    place: Optional[List[PlaceAMS] | List[RelatedPlaceRefOrValue]] = None
    related_entity: Optional[List[RelatedEntityRefOrValue]] = None
    related_party: Optional[List[RelatedParty] | RelatedParty] = None
    service_characteristic: Optional[
        List[Characteristic] | List[Any] | Characteristic
    ] = None
    service_order_item: Optional[List[RelatedServiceOrderItem]] = None
    service_relationship: Optional[List[ServiceRelationship]] = None
    service_specification: Optional[
        List[ServiceSpecificationRef]
        | List[ServiceSpecification]
        | ServiceSpecification
    ] = None
    state: Optional[ServiceStateType] = None
    supporting_resource: Optional[List[ResourceRef]] = None
    supporting_service: Optional[List[ServiceRefOrValue]] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")
    referred_type: Optional[str] = Field(default=None, alias="@referredType")


class ServiceRelationship(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    ServiceRelationship - a model defined in OpenAPI

        relationship_type: The relationship_type of this ServiceRelationship.
        service: The service of this ServiceRelationship [Optional].
        service_relationship_characteristic: The service_relationship_characteristic of this ServiceRelationship [Optional].
        base_type: The base_type of this ServiceRelationship [Optional].
        schema_location: The schema_location of this ServiceRelationship [Optional].
        type: The type of this ServiceRelationship [Optional].
    """

    relationship_type: str
    service: Optional[ServiceRefOrValue] = None
    service_relationship_characteristic: Optional[List[Characteristic]] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


ServiceRefOrValue.update_forward_refs()
