"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualNodeListener = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 *  Defines listener for a VirtualNode
 */
class VirtualNodeListener {
    /**
     * Returns an HTTP Listener for a VirtualNode
     */
    static http(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualNode
     */
    static http2(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_Http2VirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.HTTP2, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an GRPC Listener for a VirtualNode
     */
    static grpc(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.GRPC, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
    /**
     * Returns an TCP Listener for a VirtualNode
     */
    static tcp(props = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpVirtualNodeListenerOptions(props);
        return new VirtualNodeListenerImpl(shared_interfaces_1.Protocol.TCP, props.healthCheck, props.timeout, props.port, props.tls, props.outlierDetection, props.connectionPool);
    }
}
exports.VirtualNodeListener = VirtualNodeListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualNodeListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualNodeListener", version: "1.150.0" };
class VirtualNodeListenerImpl extends VirtualNodeListener {
    constructor(protocol, healthCheck, timeout, port = 8080, tls, outlierDetection, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.timeout = timeout;
        this.port = port;
        this.tls = tls;
        this.outlierDetection = outlierDetection;
        this.connectionPool = connectionPool;
    }
    bind(scope) {
        var _b;
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_b = this.healthCheck) === null || _b === void 0 ? void 0 : _b.bind(scope, { defaultPort: this.port }).virtualNodeHealthCheck,
                timeout: this.timeout ? this.renderTimeout(this.timeout) : undefined,
                tls: utils_1.renderListenerTlsOptions(scope, this.tls),
                outlierDetection: this.outlierDetection ? this.renderOutlierDetection(this.outlierDetection) : undefined,
                connectionPool: this.connectionPool ? this.renderConnectionPool(this.connectionPool) : undefined,
            },
        };
    }
    renderTimeout(timeout) {
        return ({
            [this.protocol]: {
                idle: (timeout === null || timeout === void 0 ? void 0 : timeout.idle) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.idle.toMilliseconds(),
                } : undefined,
                perRequest: (timeout === null || timeout === void 0 ? void 0 : timeout.perRequest) !== undefined ? {
                    unit: 'ms',
                    value: timeout === null || timeout === void 0 ? void 0 : timeout.perRequest.toMilliseconds(),
                } : undefined,
            },
        });
    }
    renderOutlierDetection(outlierDetection) {
        return {
            baseEjectionDuration: {
                unit: 'ms',
                value: outlierDetection.baseEjectionDuration.toMilliseconds(),
            },
            interval: {
                unit: 'ms',
                value: outlierDetection.interval.toMilliseconds(),
            },
            maxEjectionPercent: outlierDetection.maxEjectionPercent,
            maxServerErrors: outlierDetection.maxServerErrors,
        };
    }
    renderConnectionPool(connectionPool) {
        return ({
            [this.protocol]: {
                maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
                maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
                maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlydHVhbC1ub2RlLWxpc3RlbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidmlydHVhbC1ub2RlLWxpc3RlbmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBLDJDQUFpRjtBQUNqRiwyREFHNkI7QUF5SDdCOztHQUVHO0FBQ0gsTUFBc0IsbUJBQW1CO0lBQ3ZDOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxRQUF3QyxFQUFFOztRQUMzRCxPQUFPLElBQUksdUJBQXVCLENBQUMsNEJBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLEVBQy9ILEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztLQUN6QjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEtBQUssQ0FBQyxRQUF5QyxFQUFFOztRQUM3RCxPQUFPLElBQUksdUJBQXVCLENBQUMsNEJBQVEsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLEVBQ2hJLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztLQUN6QjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxRQUF3QyxFQUFFOztRQUMzRCxPQUFPLElBQUksdUJBQXVCLENBQUMsNEJBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLEVBQy9ILEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztLQUN6QjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLEdBQUcsQ0FBQyxRQUF1QyxFQUFFOztRQUN6RCxPQUFPLElBQUksdUJBQXVCLENBQUMsNEJBQVEsQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLEdBQUcsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLEVBQzlILEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQztLQUN6Qjs7QUEvQkgsa0RBcUNDOzs7QUFFRCxNQUFNLHVCQUF3QixTQUFRLG1CQUFtQjtJQUN2RCxZQUE2QixRQUFrQixFQUM1QixXQUFvQyxFQUNwQyxPQUFnQyxFQUNoQyxPQUFlLElBQUksRUFDbkIsR0FBbUMsRUFDbkMsZ0JBQThDLEVBQzlDLGNBQWdEO1FBQUksS0FBSyxFQUFFLENBQUM7UUFObEQsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUM1QixnQkFBVyxHQUFYLFdBQVcsQ0FBeUI7UUFDcEMsWUFBTyxHQUFQLE9BQU8sQ0FBeUI7UUFDaEMsU0FBSSxHQUFKLElBQUksQ0FBZTtRQUNuQixRQUFHLEdBQUgsR0FBRyxDQUFnQztRQUNuQyxxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQThCO1FBQzlDLG1CQUFjLEdBQWQsY0FBYyxDQUFrQztLQUFjO0lBRTFFLElBQUksQ0FBQyxLQUFnQjs7UUFDMUIsT0FBTztZQUNMLFFBQVEsRUFBRTtnQkFDUixXQUFXLEVBQUU7b0JBQ1gsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO29CQUNmLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtpQkFDeEI7Z0JBQ0QsV0FBVyxRQUFFLElBQUksQ0FBQyxXQUFXLDBDQUFFLElBQUksQ0FBQyxLQUFLLEVBQUUsRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLElBQUksRUFBRSxFQUFFLHNCQUFzQjtnQkFDN0YsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUNwRSxHQUFHLEVBQUUsZ0NBQXdCLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUM7Z0JBQzlDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUN4RyxjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUNqRztTQUNGLENBQUM7S0FDSDtJQUVPLGFBQWEsQ0FBQyxPQUFvQjtRQUN4QyxPQUFPLENBQUM7WUFDTixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsRUFBRTtnQkFDZixJQUFJLEVBQUUsQ0FBQSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsSUFBSSxNQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUM7b0JBQ2xDLElBQUksRUFBRSxJQUFJO29CQUNWLEtBQUssRUFBRSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsSUFBSSxDQUFDLGNBQWMsRUFBRTtpQkFDdEMsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDYixVQUFVLEVBQUUsQ0FBQSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsVUFBVSxNQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUM7b0JBQzlDLElBQUksRUFBRSxJQUFJO29CQUNWLEtBQUssRUFBRSxPQUFPLGFBQVAsT0FBTyx1QkFBUCxPQUFPLENBQUUsVUFBVSxDQUFDLGNBQWMsRUFBRTtpQkFDNUMsQ0FBQyxDQUFDLENBQUMsU0FBUzthQUNkO1NBQ0YsQ0FBQyxDQUFDO0tBQ0o7SUFFTyxzQkFBc0IsQ0FBQyxnQkFBa0M7UUFDL0QsT0FBTztZQUNMLG9CQUFvQixFQUFFO2dCQUNwQixJQUFJLEVBQUUsSUFBSTtnQkFDVixLQUFLLEVBQUUsZ0JBQWdCLENBQUMsb0JBQW9CLENBQUMsY0FBYyxFQUFFO2FBQzlEO1lBQ0QsUUFBUSxFQUFFO2dCQUNSLElBQUksRUFBRSxJQUFJO2dCQUNWLEtBQUssRUFBRSxnQkFBZ0IsQ0FBQyxRQUFRLENBQUMsY0FBYyxFQUFFO2FBQ2xEO1lBQ0Qsa0JBQWtCLEVBQUUsZ0JBQWdCLENBQUMsa0JBQWtCO1lBQ3ZELGVBQWUsRUFBRSxnQkFBZ0IsQ0FBQyxlQUFlO1NBQ2xELENBQUM7S0FDSDtJQUVPLG9CQUFvQixDQUFDLGNBQW9DO1FBQy9ELE9BQU8sQ0FBQztZQUNOLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxFQUFFO2dCQUNmLFdBQVcsRUFBRSxDQUFBLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxXQUFXLE1BQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxTQUFTO2dCQUMvRixjQUFjLEVBQUUsQ0FBQSxjQUFjLGFBQWQsY0FBYyx1QkFBZCxjQUFjLENBQUUsY0FBYyxNQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsY0FBYyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsU0FBUztnQkFDeEcsa0JBQWtCLEVBQUUsQ0FBQSxjQUFjLGFBQWQsY0FBYyx1QkFBZCxjQUFjLENBQUUsa0JBQWtCLE1BQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxDQUFDLFNBQVM7YUFDckg7U0FDRixDQUFDLENBQUM7S0FDSjtDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ2ZuVmlydHVhbE5vZGUgfSBmcm9tICcuL2FwcG1lc2guZ2VuZXJhdGVkJztcbmltcG9ydCB7IEhlYWx0aENoZWNrIH0gZnJvbSAnLi9oZWFsdGgtY2hlY2tzJztcbmltcG9ydCB7IExpc3RlbmVyVGxzT3B0aW9ucyB9IGZyb20gJy4vbGlzdGVuZXItdGxzLW9wdGlvbnMnO1xuaW1wb3J0IHsgQ29ubmVjdGlvblBvb2xDb25maWcsIHJlbmRlckxpc3RlbmVyVGxzT3B0aW9ucyB9IGZyb20gJy4vcHJpdmF0ZS91dGlscyc7XG5pbXBvcnQge1xuICBHcnBjQ29ubmVjdGlvblBvb2wsIEdycGNUaW1lb3V0LCBIdHRwMkNvbm5lY3Rpb25Qb29sLCBIdHRwQ29ubmVjdGlvblBvb2wsXG4gIEh0dHBUaW1lb3V0LCBPdXRsaWVyRGV0ZWN0aW9uLCBQcm90b2NvbCwgVGNwQ29ubmVjdGlvblBvb2wsIFRjcFRpbWVvdXQsXG59IGZyb20gJy4vc2hhcmVkLWludGVyZmFjZXMnO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgYSBWaXJ0dWFsTm9kZSBsaXN0ZW5lclxuICovXG5leHBvcnQgaW50ZXJmYWNlIFZpcnR1YWxOb2RlTGlzdGVuZXJDb25maWcge1xuICAvKipcbiAgICogU2luZ2xlIGxpc3RlbmVyIGNvbmZpZyBmb3IgYSBWaXJ0dWFsTm9kZVxuICAgKi9cbiAgcmVhZG9ubHkgbGlzdGVuZXI6IENmblZpcnR1YWxOb2RlLkxpc3RlbmVyUHJvcGVydHksXG59XG5cbi8qKlxuICogUmVwcmVzZW50cyB0aGUgcHJvcGVydGllcyBuZWVkZWQgdG8gZGVmaW5lIGEgTGlzdGVuZXJzIGZvciBhIFZpcnR1YWxOb2RlXG4gKi9cbmludGVyZmFjZSBWaXJ0dWFsTm9kZUxpc3RlbmVyQ29tbW9uT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBQb3J0IHRvIGxpc3RlbiBmb3IgY29ubmVjdGlvbnMgb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSA4MDgwXG4gICAqL1xuICByZWFkb25seSBwb3J0PzogbnVtYmVyXG5cbiAgLyoqXG4gICAqIFRoZSBoZWFsdGggY2hlY2sgaW5mb3JtYXRpb24gZm9yIHRoZSBsaXN0ZW5lclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGhlYWx0aGNoZWNrXG4gICAqL1xuICByZWFkb25seSBoZWFsdGhDaGVjaz86IEhlYWx0aENoZWNrO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIHRoZSBjb25maWd1cmF0aW9uIGZvciBlbmFibGluZyBUTFMgb24gYSBsaXN0ZW5lclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHRscz86IExpc3RlbmVyVGxzT3B0aW9ucztcblxuICAvKipcbiAgICogUmVwcmVzZW50cyB0aGUgY29uZmlndXJhdGlvbiBmb3IgZW5hYmxpbmcgb3V0bGllciBkZXRlY3Rpb25cbiAgICpcbiAgICogQGRlZmF1bHQgLSBub25lXG4gICAqL1xuICByZWFkb25seSBvdXRsaWVyRGV0ZWN0aW9uPzogT3V0bGllckRldGVjdGlvbjtcbn1cblxuaW50ZXJmYWNlIENvbW1vbkh0dHBWaXJ0dWFsTm9kZUxpc3RlbmVyT3B0aW9ucyBleHRlbmRzIFZpcnR1YWxOb2RlTGlzdGVuZXJDb21tb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIFRpbWVvdXQgZm9yIEhUVFAgcHJvdG9jb2xcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSB0aW1lb3V0PzogSHR0cFRpbWVvdXQ7XG59XG5cbi8qKlxuICogUmVwcmVzZW50IHRoZSBIVFRQIE5vZGUgTGlzdGVuZXIgcHJvcnBlcnR5XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSHR0cFZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zIGV4dGVuZHMgQ29tbW9uSHR0cFZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zIHtcblxuICAvKipcbiAgICogQ29ubmVjdGlvbiBwb29sIGZvciBodHRwIGxpc3RlbmVyc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGNvbm5lY3Rpb25Qb29sPzogSHR0cENvbm5lY3Rpb25Qb29sO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudCB0aGUgSFRUUDIgTm9kZSBMaXN0ZW5lciBwcm9ycGVydHlcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBIdHRwMlZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zIGV4dGVuZHMgQ29tbW9uSHR0cFZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zIHtcbiAgLyoqXG4gICAqIENvbm5lY3Rpb24gcG9vbCBmb3IgaHR0cDIgbGlzdGVuZXJzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgY29ubmVjdGlvblBvb2w/OiBIdHRwMkNvbm5lY3Rpb25Qb29sO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudCB0aGUgR1JQQyBOb2RlIExpc3RlbmVyIHByb3JwZXJ0eVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEdycGNWaXJ0dWFsTm9kZUxpc3RlbmVyT3B0aW9ucyBleHRlbmRzIFZpcnR1YWxOb2RlTGlzdGVuZXJDb21tb25PcHRpb25zIHtcbiAgLyoqXG4gICAqIFRpbWVvdXQgZm9yIEdSUEMgcHJvdG9jb2xcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSB0aW1lb3V0PzogR3JwY1RpbWVvdXQ7XG5cbiAgLyoqXG4gICAqIENvbm5lY3Rpb24gcG9vbCBmb3IgaHR0cCBsaXN0ZW5lcnNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBjb25uZWN0aW9uUG9vbD86IEdycGNDb25uZWN0aW9uUG9vbDtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnQgdGhlIFRDUCBOb2RlIExpc3RlbmVyIHByb3JwZXJ0eVxuICovXG5leHBvcnQgaW50ZXJmYWNlIFRjcFZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zIGV4dGVuZHMgVmlydHVhbE5vZGVMaXN0ZW5lckNvbW1vbk9wdGlvbnMge1xuICAvKipcbiAgICogVGltZW91dCBmb3IgVENQIHByb3RvY29sXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgdGltZW91dD86IFRjcFRpbWVvdXQ7XG5cbiAgLyoqXG4gICAqIENvbm5lY3Rpb24gcG9vbCBmb3IgaHR0cCBsaXN0ZW5lcnNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb25lXG4gICAqL1xuICByZWFkb25seSBjb25uZWN0aW9uUG9vbD86IFRjcENvbm5lY3Rpb25Qb29sO1xufVxuXG4vKipcbiAqICBEZWZpbmVzIGxpc3RlbmVyIGZvciBhIFZpcnR1YWxOb2RlXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBWaXJ0dWFsTm9kZUxpc3RlbmVyIHtcbiAgLyoqXG4gICAqIFJldHVybnMgYW4gSFRUUCBMaXN0ZW5lciBmb3IgYSBWaXJ0dWFsTm9kZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBodHRwKHByb3BzOiBIdHRwVmlydHVhbE5vZGVMaXN0ZW5lck9wdGlvbnMgPSB7fSk6IFZpcnR1YWxOb2RlTGlzdGVuZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbE5vZGVMaXN0ZW5lckltcGwoUHJvdG9jb2wuSFRUUCwgcHJvcHMuaGVhbHRoQ2hlY2ssIHByb3BzLnRpbWVvdXQsIHByb3BzLnBvcnQsIHByb3BzLnRscywgcHJvcHMub3V0bGllckRldGVjdGlvbixcbiAgICAgIHByb3BzLmNvbm5lY3Rpb25Qb29sKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIEhUVFAyIExpc3RlbmVyIGZvciBhIFZpcnR1YWxOb2RlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGh0dHAyKHByb3BzOiBIdHRwMlZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zID0ge30pOiBWaXJ0dWFsTm9kZUxpc3RlbmVyIHtcbiAgICByZXR1cm4gbmV3IFZpcnR1YWxOb2RlTGlzdGVuZXJJbXBsKFByb3RvY29sLkhUVFAyLCBwcm9wcy5oZWFsdGhDaGVjaywgcHJvcHMudGltZW91dCwgcHJvcHMucG9ydCwgcHJvcHMudGxzLCBwcm9wcy5vdXRsaWVyRGV0ZWN0aW9uLFxuICAgICAgcHJvcHMuY29ubmVjdGlvblBvb2wpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYW4gR1JQQyBMaXN0ZW5lciBmb3IgYSBWaXJ0dWFsTm9kZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBncnBjKHByb3BzOiBHcnBjVmlydHVhbE5vZGVMaXN0ZW5lck9wdGlvbnMgPSB7fSk6IFZpcnR1YWxOb2RlTGlzdGVuZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbE5vZGVMaXN0ZW5lckltcGwoUHJvdG9jb2wuR1JQQywgcHJvcHMuaGVhbHRoQ2hlY2ssIHByb3BzLnRpbWVvdXQsIHByb3BzLnBvcnQsIHByb3BzLnRscywgcHJvcHMub3V0bGllckRldGVjdGlvbixcbiAgICAgIHByb3BzLmNvbm5lY3Rpb25Qb29sKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGFuIFRDUCBMaXN0ZW5lciBmb3IgYSBWaXJ0dWFsTm9kZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyB0Y3AocHJvcHM6IFRjcFZpcnR1YWxOb2RlTGlzdGVuZXJPcHRpb25zID0ge30pOiBWaXJ0dWFsTm9kZUxpc3RlbmVyIHtcbiAgICByZXR1cm4gbmV3IFZpcnR1YWxOb2RlTGlzdGVuZXJJbXBsKFByb3RvY29sLlRDUCwgcHJvcHMuaGVhbHRoQ2hlY2ssIHByb3BzLnRpbWVvdXQsIHByb3BzLnBvcnQsIHByb3BzLnRscywgcHJvcHMub3V0bGllckRldGVjdGlvbixcbiAgICAgIHByb3BzLmNvbm5lY3Rpb25Qb29sKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBCaW5kcyB0aGUgY3VycmVudCBvYmplY3Qgd2hlbiBhZGRpbmcgTGlzdGVuZXIgdG8gYSBWaXJ0dWFsTm9kZVxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IFZpcnR1YWxOb2RlTGlzdGVuZXJDb25maWc7XG59XG5cbmNsYXNzIFZpcnR1YWxOb2RlTGlzdGVuZXJJbXBsIGV4dGVuZHMgVmlydHVhbE5vZGVMaXN0ZW5lciB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvdG9jb2w6IFByb3RvY29sLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgaGVhbHRoQ2hlY2s6IEhlYWx0aENoZWNrIHwgdW5kZWZpbmVkLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdGltZW91dDogSHR0cFRpbWVvdXQgfCB1bmRlZmluZWQsXG4gICAgcHJpdmF0ZSByZWFkb25seSBwb3J0OiBudW1iZXIgPSA4MDgwLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdGxzOiBMaXN0ZW5lclRsc09wdGlvbnMgfCB1bmRlZmluZWQsXG4gICAgcHJpdmF0ZSByZWFkb25seSBvdXRsaWVyRGV0ZWN0aW9uOiBPdXRsaWVyRGV0ZWN0aW9uIHwgdW5kZWZpbmVkLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgY29ubmVjdGlvblBvb2w6IENvbm5lY3Rpb25Qb29sQ29uZmlnIHwgdW5kZWZpbmVkKSB7IHN1cGVyKCk7IH1cblxuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0KTogVmlydHVhbE5vZGVMaXN0ZW5lckNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGxpc3RlbmVyOiB7XG4gICAgICAgIHBvcnRNYXBwaW5nOiB7XG4gICAgICAgICAgcG9ydDogdGhpcy5wb3J0LFxuICAgICAgICAgIHByb3RvY29sOiB0aGlzLnByb3RvY29sLFxuICAgICAgICB9LFxuICAgICAgICBoZWFsdGhDaGVjazogdGhpcy5oZWFsdGhDaGVjaz8uYmluZChzY29wZSwgeyBkZWZhdWx0UG9ydDogdGhpcy5wb3J0IH0pLnZpcnR1YWxOb2RlSGVhbHRoQ2hlY2ssXG4gICAgICAgIHRpbWVvdXQ6IHRoaXMudGltZW91dCA/IHRoaXMucmVuZGVyVGltZW91dCh0aGlzLnRpbWVvdXQpIDogdW5kZWZpbmVkLFxuICAgICAgICB0bHM6IHJlbmRlckxpc3RlbmVyVGxzT3B0aW9ucyhzY29wZSwgdGhpcy50bHMpLFxuICAgICAgICBvdXRsaWVyRGV0ZWN0aW9uOiB0aGlzLm91dGxpZXJEZXRlY3Rpb24gPyB0aGlzLnJlbmRlck91dGxpZXJEZXRlY3Rpb24odGhpcy5vdXRsaWVyRGV0ZWN0aW9uKSA6IHVuZGVmaW5lZCxcbiAgICAgICAgY29ubmVjdGlvblBvb2w6IHRoaXMuY29ubmVjdGlvblBvb2wgPyB0aGlzLnJlbmRlckNvbm5lY3Rpb25Qb29sKHRoaXMuY29ubmVjdGlvblBvb2wpIDogdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHJpdmF0ZSByZW5kZXJUaW1lb3V0KHRpbWVvdXQ6IEh0dHBUaW1lb3V0KTogQ2ZuVmlydHVhbE5vZGUuTGlzdGVuZXJUaW1lb3V0UHJvcGVydHkge1xuICAgIHJldHVybiAoe1xuICAgICAgW3RoaXMucHJvdG9jb2xdOiB7XG4gICAgICAgIGlkbGU6IHRpbWVvdXQ/LmlkbGUgIT09IHVuZGVmaW5lZCA/IHtcbiAgICAgICAgICB1bml0OiAnbXMnLFxuICAgICAgICAgIHZhbHVlOiB0aW1lb3V0Py5pZGxlLnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICAgIH0gOiB1bmRlZmluZWQsXG4gICAgICAgIHBlclJlcXVlc3Q6IHRpbWVvdXQ/LnBlclJlcXVlc3QgIT09IHVuZGVmaW5lZCA/IHtcbiAgICAgICAgICB1bml0OiAnbXMnLFxuICAgICAgICAgIHZhbHVlOiB0aW1lb3V0Py5wZXJSZXF1ZXN0LnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICAgIH0gOiB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSByZW5kZXJPdXRsaWVyRGV0ZWN0aW9uKG91dGxpZXJEZXRlY3Rpb246IE91dGxpZXJEZXRlY3Rpb24pOiBDZm5WaXJ0dWFsTm9kZS5PdXRsaWVyRGV0ZWN0aW9uUHJvcGVydHkge1xuICAgIHJldHVybiB7XG4gICAgICBiYXNlRWplY3Rpb25EdXJhdGlvbjoge1xuICAgICAgICB1bml0OiAnbXMnLFxuICAgICAgICB2YWx1ZTogb3V0bGllckRldGVjdGlvbi5iYXNlRWplY3Rpb25EdXJhdGlvbi50b01pbGxpc2Vjb25kcygpLFxuICAgICAgfSxcbiAgICAgIGludGVydmFsOiB7XG4gICAgICAgIHVuaXQ6ICdtcycsXG4gICAgICAgIHZhbHVlOiBvdXRsaWVyRGV0ZWN0aW9uLmludGVydmFsLnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICB9LFxuICAgICAgbWF4RWplY3Rpb25QZXJjZW50OiBvdXRsaWVyRGV0ZWN0aW9uLm1heEVqZWN0aW9uUGVyY2VudCxcbiAgICAgIG1heFNlcnZlckVycm9yczogb3V0bGllckRldGVjdGlvbi5tYXhTZXJ2ZXJFcnJvcnMsXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgcmVuZGVyQ29ubmVjdGlvblBvb2woY29ubmVjdGlvblBvb2w6IENvbm5lY3Rpb25Qb29sQ29uZmlnKTogQ2ZuVmlydHVhbE5vZGUuVmlydHVhbE5vZGVDb25uZWN0aW9uUG9vbFByb3BlcnR5IHtcbiAgICByZXR1cm4gKHtcbiAgICAgIFt0aGlzLnByb3RvY29sXToge1xuICAgICAgICBtYXhSZXF1ZXN0czogY29ubmVjdGlvblBvb2w/Lm1heFJlcXVlc3RzICE9PSB1bmRlZmluZWQgPyBjb25uZWN0aW9uUG9vbC5tYXhSZXF1ZXN0cyA6IHVuZGVmaW5lZCxcbiAgICAgICAgbWF4Q29ubmVjdGlvbnM6IGNvbm5lY3Rpb25Qb29sPy5tYXhDb25uZWN0aW9ucyAhPT0gdW5kZWZpbmVkID8gY29ubmVjdGlvblBvb2wubWF4Q29ubmVjdGlvbnMgOiB1bmRlZmluZWQsXG4gICAgICAgIG1heFBlbmRpbmdSZXF1ZXN0czogY29ubmVjdGlvblBvb2w/Lm1heFBlbmRpbmdSZXF1ZXN0cyAhPT0gdW5kZWZpbmVkID8gY29ubmVjdGlvblBvb2wubWF4UGVuZGluZ1JlcXVlc3RzIDogdW5kZWZpbmVkLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19