"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 */
class GatewayRoute extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.string({ produce: () => cdk.Names.uniqueId(this) }),
        });
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteProps(props);
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualGateway.mesh.env.account),
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
                priority: routeSpecConfig.priority,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing GatewayRoute given an ARN
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).splitArn(gatewayRouteArn, cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * Import an existing GatewayRoute given attributes
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GatewayRouteAttributes(attrs);
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRoute", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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