# coding: utf-8

"""
    IONOS DBaaS MongoDB REST API

    With IONOS Cloud Database as a Service, you have the ability to quickly set up and manage a MongoDB database. You can also delete clusters, manage backups and users via the API.  MongoDB is an open source, cross-platform, document-oriented database program. Classified as a NoSQL database program, it uses JSON-like documents with optional schemas.  The MongoDB API allows you to create additional database clusters or modify existing ones. Both tools, the Data Center Designer (DCD) and the API use the same concepts consistently and are well suited for smooth and intuitive use.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_dbaas_mongo.configuration import Configuration


class TemplateProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'edition': 'str',

        'cores': 'int',

        'ram': 'int',

        'storage_size': 'int',
    }

    attribute_map = {

        'name': 'name',

        'edition': 'edition',

        'cores': 'cores',

        'ram': 'ram',

        'storage_size': 'storageSize',
    }

    def __init__(self, name=None, edition=None, cores=None, ram=None, storage_size=None, local_vars_configuration=None):  # noqa: E501
        """TemplateProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._edition = None
        self._cores = None
        self._ram = None
        self._storage_size = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if edition is not None:
            self.edition = edition
        if cores is not None:
            self.cores = cores
        if ram is not None:
            self.ram = ram
        if storage_size is not None:
            self.storage_size = storage_size


    @property
    def name(self):
        """Gets the name of this TemplateProperties.  # noqa: E501

        The name of the template.  # noqa: E501

        :return: The name of this TemplateProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TemplateProperties.

        The name of the template.  # noqa: E501

        :param name: The name of this TemplateProperties.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def edition(self):
        """Gets the edition of this TemplateProperties.  # noqa: E501

        The edition of the template (e.g. enterprise)  # noqa: E501

        :return: The edition of this TemplateProperties.  # noqa: E501
        :rtype: str
        """
        return self._edition

    @edition.setter
    def edition(self, edition):
        """Sets the edition of this TemplateProperties.

        The edition of the template (e.g. enterprise)  # noqa: E501

        :param edition: The edition of this TemplateProperties.  # noqa: E501
        :type edition: str
        """

        self._edition = edition

    @property
    def cores(self):
        """Gets the cores of this TemplateProperties.  # noqa: E501

        The number of CPU cores.  # noqa: E501

        :return: The cores of this TemplateProperties.  # noqa: E501
        :rtype: int
        """
        return self._cores

    @cores.setter
    def cores(self, cores):
        """Sets the cores of this TemplateProperties.

        The number of CPU cores.  # noqa: E501

        :param cores: The cores of this TemplateProperties.  # noqa: E501
        :type cores: int
        """

        self._cores = cores

    @property
    def ram(self):
        """Gets the ram of this TemplateProperties.  # noqa: E501

        The amount of memory in GB.  # noqa: E501

        :return: The ram of this TemplateProperties.  # noqa: E501
        :rtype: int
        """
        return self._ram

    @ram.setter
    def ram(self, ram):
        """Sets the ram of this TemplateProperties.

        The amount of memory in GB.  # noqa: E501

        :param ram: The ram of this TemplateProperties.  # noqa: E501
        :type ram: int
        """

        self._ram = ram

    @property
    def storage_size(self):
        """Gets the storage_size of this TemplateProperties.  # noqa: E501

        The amount of storage size in GB.  # noqa: E501

        :return: The storage_size of this TemplateProperties.  # noqa: E501
        :rtype: int
        """
        return self._storage_size

    @storage_size.setter
    def storage_size(self, storage_size):
        """Sets the storage_size of this TemplateProperties.

        The amount of storage size in GB.  # noqa: E501

        :param storage_size: The storage_size of this TemplateProperties.  # noqa: E501
        :type storage_size: int
        """

        self._storage_size = storage_size
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TemplateProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TemplateProperties):
            return True

        return self.to_dict() != other.to_dict()
