# coding: utf-8

"""
    IONOS DBaaS MongoDB REST API

    With IONOS Cloud Database as a Service, you have the ability to quickly set up and manage a MongoDB database. You can also delete clusters, manage backups and users via the API.  MongoDB is an open source, cross-platform, document-oriented database program. Classified as a NoSQL database program, it uses JSON-like documents with optional schemas.  The MongoDB API allows you to create additional database clusters or modify existing ones. Both tools, the Data Center Designer (DCD) and the API use the same concepts consistently and are well suited for smooth and intuitive use.   # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud_dbaas_mongo.configuration import Configuration


class PatchUserProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'password': 'str',

        'roles': 'list[UserRoles]',
    }

    attribute_map = {

        'password': 'password',

        'roles': 'roles',
    }

    def __init__(self, password=None, roles=None, local_vars_configuration=None):  # noqa: E501
        """PatchUserProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._password = None
        self._roles = None
        self.discriminator = None

        if password is not None:
            self.password = password
        if roles is not None:
            self.roles = roles


    @property
    def password(self):
        """Gets the password of this PatchUserProperties.  # noqa: E501


        :return: The password of this PatchUserProperties.  # noqa: E501
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """Sets the password of this PatchUserProperties.


        :param password: The password of this PatchUserProperties.  # noqa: E501
        :type password: str
        """
        if (self.local_vars_configuration.client_side_validation and
                password is not None and len(password) < 10):
            raise ValueError("Invalid value for `password`, length must be greater than or equal to `10`")  # noqa: E501

        self._password = password

    @property
    def roles(self):
        """Gets the roles of this PatchUserProperties.  # noqa: E501


        :return: The roles of this PatchUserProperties.  # noqa: E501
        :rtype: list[UserRoles]
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this PatchUserProperties.


        :param roles: The roles of this PatchUserProperties.  # noqa: E501
        :type roles: list[UserRoles]
        """

        self._roles = roles
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PatchUserProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PatchUserProperties):
            return True

        return self.to_dict() != other.to_dict()
