from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

valves = SchLib(tool=SKIDL).add_parts(*[
        Part(name='CK6418',dest=TEMPLATE,tool=SKIDL,keywords='subminiature pentode valve',description='Subminiature Pentode',ref_prefix='U',num_units=2,fplist=['VALVE*MINI*PENTODE*LINEAR*'],do_erc=True,aliases=['CK548DX', 'JAN6418', 'NOS-6418'],pins=[
            Pin(num='3',name='F+,G3',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='P',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='G2',do_erc=True),
            Pin(num='4',name='G1',do_erc=True),
            Pin(num='5',name='F+,G3',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EABC80',dest=TEMPLATE,tool=SKIDL,keywords='diode triode valve',description='triple diode triode',ref_prefix='U',num_units=4,fplist=['VALVE*NOVAL*P*'],do_erc=True,aliases=['6AK8', '9AK8', 'PABC80', 'UABC80'],pins=[
            Pin(num='2',name='A2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='K',do_erc=True),
            Pin(num='1',name='A1',do_erc=True),
            Pin(num='6',name='A3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='K',do_erc=True),
            Pin(num='7',name='K',do_erc=True),
            Pin(num='8',name='G',do_erc=True),
            Pin(num='9',name='A2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='F1',do_erc=True),
            Pin(num='5',name='F2',do_erc=True)]),
        Part(name='EC92',dest=TEMPLATE,tool=SKIDL,keywords='triode valve',description='single triode',ref_prefix='U',num_units=2,fplist=['VALVE*MINI*P*'],do_erc=True,pins=[
            Pin(num='1',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='G',do_erc=True),
            Pin(num='7',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ECC81',dest=TEMPLATE,tool=SKIDL,keywords='triode valve',description='double triode',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,aliases=['ECC83'],pins=[
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='G',do_erc=True),
            Pin(num='8',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='1',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='G',do_erc=True),
            Pin(num='3',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ECC88',dest=TEMPLATE,tool=SKIDL,keywords='triode valve',description='double triode, low-noise',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='1',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='G',do_erc=True),
            Pin(num='3',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='G',do_erc=True),
            Pin(num='8',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ECH81',dest=TEMPLATE,tool=SKIDL,keywords='triode heptode valve',description='triode heptode',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='3',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='G',do_erc=True),
            Pin(num='1',name='G2_G4',do_erc=True),
            Pin(num='2',name='G1',do_erc=True),
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='G3',do_erc=True),
            Pin(num='~',name='K_G5',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ECL82',dest=TEMPLATE,tool=SKIDL,keywords='triode pentode valve',description='triode pentode',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='1',name='G',do_erc=True),
            Pin(num='8',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='K_G3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='G1',do_erc=True),
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='G2',do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ECL86',dest=TEMPLATE,tool=SKIDL,keywords='triode pentode valve',description='triode pentode',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='1',name='G',do_erc=True),
            Pin(num='2',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='G2',do_erc=True),
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='K_G3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='G1',do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EF80',dest=TEMPLATE,tool=SKIDL,keywords='pentode valve',description='pentode',ref_prefix='U',num_units=2,fplist=['VALVE*NOVAL*P*'],do_erc=True,aliases=['EF85'],pins=[
            Pin(num='2',name='G1',do_erc=True),
            Pin(num='3',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='S',do_erc=True),
            Pin(num='7',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='G2',do_erc=True),
            Pin(num='9',name='G3',do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EF83',dest=TEMPLATE,tool=SKIDL,keywords='pentode valve',description='pentode',ref_prefix='U',num_units=2,fplist=['VALVE*NOVAL*P*'],do_erc=True,aliases=['EF86'],pins=[
            Pin(num='1',name='G2',do_erc=True),
            Pin(num='3',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='S',do_erc=True),
            Pin(num='8',name='G3',do_erc=True),
            Pin(num='9',name='G1',do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EL34',dest=TEMPLATE,tool=SKIDL,keywords='pentode valve',description='pentode, 25W',ref_prefix='U',num_units=2,fplist=['VALVE*OCTAL*'],do_erc=True,pins=[
            Pin(num='1',name='G3',do_erc=True),
            Pin(num='3',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='G2',do_erc=True),
            Pin(num='5',name='G1',do_erc=True),
            Pin(num='8',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EL84',dest=TEMPLATE,tool=SKIDL,keywords='pentode valve',description='pentode, 12W',ref_prefix='U',num_units=2,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='2',name='G1',do_erc=True),
            Pin(num='3',name='K_G3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='G2',do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='EM84',dest=TEMPLATE,tool=SKIDL,keywords='indicator tube valve magic eye',description='indicator tube "magic eye"',ref_prefix='U',num_units=3,fplist=['VALVE*NOVAL*P*'],do_erc=True,pins=[
            Pin(num='2',name='K',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='L',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='ST',do_erc=True),
            Pin(num='1',name='G',do_erc=True),
            Pin(num='9',name='A',func=Pin.OUTPUT,do_erc=True),
            Pin(num='~',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='F1',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='F2',func=Pin.PWRIN,do_erc=True)]),
        Part(name='STABI',dest=TEMPLATE,tool=SKIDL,do_erc=True)])
