from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

microchip_pic16mcu = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PIC16(L)F1454-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1454-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1454-I/SS', 'PIC16(L)F1454-I/ST', 'PIC16(L)F1454-I/SL']),
        Part(name='PIC16(L)F1455-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1455-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1455-I/SS', 'PIC16(L)F1455-I/ST', 'PIC16(L)F1455-I/SL']),
        Part(name='PIC16(L)F1459-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1459-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1459-I/SS', 'PIC16(L)F1459-I/ST', 'PIC16(L)F1459-I/SO']),
        Part(name='PIC16(L)F1503-I/MG',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1503-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1503-I/SL', 'PIC16(L)F1503-I/ST']),
        Part(name='PIC16(L)F1507-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1507-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1507-I/SO', 'PIC16(L)F1507-I/SS']),
        Part(name='PIC16(L)F1508-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1508-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1508-I/SO', 'PIC16(L)F1508-I/SS']),
        Part(name='PIC16(L)F1509-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1509-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1509-I/SO', 'PIC16(L)F1509-I/SS']),
        Part(name='PIC16(L)F1512-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1512-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1512-I/SO', 'PIC16(L)F1512-I/SS']),
        Part(name='PIC16(L)F1513-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1513-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1513-I/SO', 'PIC16(L)F1513-I/SS']),
        Part(name='PIC16(L)F1516-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1516-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1516-I/SO', 'PIC16(L)F1516-I/SS']),
        Part(name='PIC16(L)F1517-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1517-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1517-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1518-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1518-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1518-I/SO', 'PIC16(L)F1518-I/SS']),
        Part(name='PIC16(L)F1519-I/MV',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1519-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1519-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1526-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1526-I/MR']),
        Part(name='PIC16(L)F1527-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1527-I/MR']),
        Part(name='PIC16(L)F1829-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F1829-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1829-I/SL', 'PIC16(L)F1829-I/SO', 'PIC16(L)F1829-I/SS', 'PIC16(L)F1829-I/ST']),
        Part(name='PIC16(L)F1934-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1937-I/ML', 'PIC16(L)F1939-I/ML']),
        Part(name='PIC16(L)F1934-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F1937-I/PT', 'PIC16(L)F1939-I/PT']),
        Part(name='PIC16(L)F610-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F610-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F616-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F616-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F627-xxI/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628-xxI/P']),
        Part(name='PIC16(L)F627-xxI/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628-xxI/SO']),
        Part(name='PIC16(L)F627-xxI/SS',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628-xxI/SS']),
        Part(name='PIC16(L)F627A-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628A-I/P', 'PIC16(L)F648A-I/P']),
        Part(name='PIC16(L)F627A-I/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628A-I/SO', 'PIC16(L)F648A-I/SO']),
        Part(name='PIC16(L)F627A-I/SS',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F628A-I/SS', 'PIC16(L)F648A-I/SS']),
        Part(name='PIC16(L)F684-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F684-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F73-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F76-I/ML']),
        Part(name='PIC16(L)F73-I/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F76-I/SO']),
        Part(name='PIC16(L)F73-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F76-I/SP']),
        Part(name='PIC16(L)F73-I/SS',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F76-I/SS']),
        Part(name='PIC16(L)F74-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F77-I/P']),
        Part(name='PIC16(L)F818-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F819-I/ML']),
        Part(name='PIC16(L)F818-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F819-I/P']),
        Part(name='PIC16(L)F818-I/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F819-I/SO']),
        Part(name='PIC16(L)F818-I/SS',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F819-I/SS']),
        Part(name='PIC16(L)F870-I/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F870-I/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F870-I/SS',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F871-I/L',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F871-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F871-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F873-XXI/SO',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F876-XXI/SO']),
        Part(name='PIC16(L)F873-XXI/SP',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F876-XXI/SP']),
        Part(name='PIC16(L)F874-XXI/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F877-XXI/P']),
        Part(name='PIC16(L)F874A-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F877A-I/P']),
        Part(name='PIC16(L)F874A-I/PT',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F877A-I/PT']),
        Part(name='PIC16(L)F88-I/ML',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F88-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='PIC16(L)F884-I/P',dest=TEMPLATE,tool=SKIDL,do_erc=True,aliases=['PIC16(L)F887-I/P']),
        Part(name='PIC16F1829LIN-E/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS microcontroller regulator LIN',description='Flash-Based, 8-Bit CMOS Microcontrollers with integrated voltage regulator and LIN transceiver',ref_prefix='U',num_units=1,fplist=['SSOP*5.3x7.2mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='RA3/MCLR',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='LINVSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='LBUS',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VREG',func=Pin.PWROUT,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='/FAULT',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1/ICSPCLK',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='RA0/ICSPDAT',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F505-I/MG',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8bit Microcontroller',description='PIC16F505, 1024W FLASH, 72B SRAM, QFN16',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='CLKIN/OSC1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='CLKOUT/OSC2/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='Vpp/~MCLR~/RB3',do_erc=True),
            Pin(num='4',name='RC5/T0CKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='ICSPCLK/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPDAT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC16F505-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8bit Microcontroller',description='1024W FLASH, 72B SRAM, DIP14',ref_prefix='U',num_units=1,fplist=['PDIP*', 'DIP*'],do_erc=True,aliases=['PIC16C505-I/P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RB3',do_erc=True),
            Pin(num='5',name='RC5/T0CKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPCLK/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPDAT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC16F505-I/SL',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8bit Microcontroller',description='PIC16F505, 1024W FLASH, 72B SRAM, SO14',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,aliases=['PIC16C505-I/SL'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RB3',do_erc=True),
            Pin(num='5',name='RC5/T0CKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPCLK/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPDAT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC16F505-I/ST',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8bit Microcontroller',description='PIC16F505, 1024W FLASH, 72B SRAM, TSSOP14',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,aliases=['PIC16C505-I/ST'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='CLKIN/OSC1/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='CLKOUT/OSC2/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RB3',do_erc=True),
            Pin(num='5',name='RC5/T0CKI',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPCLK/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPDAT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PIC16F54-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='512W FLASH, 25B SRAM, DIP18',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI',do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPCLK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPDAT/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKI',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F54-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC16F54, 512W FLASH, 25B SRAM, SO18',ref_prefix='U',num_units=1,fplist=['SO*', 'SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI',do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='ICSPCLK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPDAT/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKI',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F54-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC16F54, 512W FLASH, 25B SRAM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI',do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='ICSPCLK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='ICSPDAT/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='OSC1/CLKIN',do_erc=True),
            Pin(num='19',name='RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F631-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='1024W Flash, 64B SRAM, 128B EEPROM, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F631-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F631, 1024W Flash, 64B SRAM, 128B EEPROM, SO20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F631-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F631, 1024W Flash, 64B SRAM, 128B EEPROM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F677-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='2048W Flash, 128B SRAM, 128B EEPROM, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCL/SCK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDA/SDI/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F677-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F677, 2048W Flash, 128B SRAM, 128B EEPROM, SO20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCL/SCK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDA/SDI/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F677-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F677, 2048W Flash, 128B SRAM, 128B EEPROM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCL/SCK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDA/SDI/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F685-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='4096W Flash, 256B SRAM, 256B EEPROM, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F685-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F685, 4096W Flash, 256B SRAM, 256B EEPROM, SO20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F685-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F685, 4096W Flash, 256B SRAM, 256B EEPROM, SSOP20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F687-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='4096W Flash, 256B SRAM, 256B EEPROM, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['PIC16F689-I/P'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F687-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F689, 4096W Flash, 256B SRAM, 256B EEPROM, SO20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['PIC16F689-I/SO'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F687-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F689, 4096W Flash, 256B SRAM, 256B EEPROM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,aliases=['PIC16F689-I/SS'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='T0CKI/INT/C1OUT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F690-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='4096W Flash, 256B SRAM, 256B EEPROM, DIP20',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='C1OUT/T0CKI/INT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F690-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F690, 4096W Flash, 256B SRAM, 256B EEPROM, SO20',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='C1OUT/T0CKI/INT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F690-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller nanoWatt',description='PIC16F690, 4096W Flash, 256B SRAM, 256B EEPROM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='T1CKI/OSC1/CLKIN/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='~T1G~/OSC2/CLKOUT/AN3/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='Vpp/~MCLR~/RA3',do_erc=True),
            Pin(num='5',name='RC5/CCP1/P1A',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='RC4/C2OUT/P1B',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RC3/AN7/C12IN3-/P1C',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RC6/AN8/~SS~',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RC7/AN9/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='TX/CK/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SCK/SCL/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RX/DT/AN11/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SDI/SDA/AN10/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC2/AN6/C12IN2-/P1D',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC1/AN5/C12IN1-',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC0/AN4/C2IN+',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='C1OUT/T0CKI/INT/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='C12IN0-/ICSPCLK/Vref/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='C1IN+/ICSPDAT/ULPWU/AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F716-I/P',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='2048W Flash, 128B SRAM, DIP18',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='Vref/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI/RA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/~ECCPAS2~/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='T1OSO/T1CKI/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSI/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CCP1/P1A/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~ECCPAS0~/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P1B/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P1C/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P1D/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKI',do_erc=True),
            Pin(num='17',name='AN0/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AN1/RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F716-I/SO',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC16F716, 2048W Flash, 128B SRAM, SO18',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='Vref/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI/RA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/~ECCPAS2~/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='T1OSO/T1CKI/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSI/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='CCP1/P1A/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='~ECCPAS0~/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='P1B/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P1C/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P1D/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKI',do_erc=True),
            Pin(num='17',name='AN0/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='AN1/RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F716-I/SS',dest=TEMPLATE,tool=SKIDL,keywords='FLASH-Based 8-Bit CMOS Microcontroller',description='PIC16F716, 2048W Flash, 128B SRAM, SSOP20',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='Vref/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI/RA4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~MCLR~/Vpp',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='INT/~ECCPAS2~/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='T1OSO/T1CKI/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='T1OSI/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='CCP1/P1A/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='~ECCPAS0~/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='P1B/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='P1C/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='P1D/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='OSC2/CLKO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='OSC1/CLKI',do_erc=True),
            Pin(num='19',name='AN0/RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F83-XX/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='PIC16F84, 1K Flash, 68B SRAM, 64B EEPROM, DIP18',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['PIC16F84-XX/P'],pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TOCKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~MCLR~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKIN',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F83-XX/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='PIC16F84, 1KB Flash, 68B SRAM, 64B EEPROM, SOIC18',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,aliases=['PIC16F84-XX/SO'],pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TOCKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~MCLR~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKIN',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F84A-XX/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='PIC16F84A, 1K Flash, 68B SRAM, 64B EEPROM, DIP18',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TOCKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~MCLR~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKIN',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F84A-XX/SO',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='PIC16F84A, 1KB Flash, 68B SRAM, 64B EEPROM, SOIC18',ref_prefix='U',num_units=1,fplist=['SO*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='TOCKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~MCLR~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='INT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='OSC1/CLKIN',do_erc=True),
            Pin(num='17',name='RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RA1',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F84A-XX/SS',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit Microcontroller',description='PIC16F84A, 1KB Flash, 68B SRAM, 64B EEPROM, SSOP18',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='T0CKI/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='~MCLR~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='INT/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='11',name='RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='OSC2/CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='OSC1/CLKIN',do_erc=True),
            Pin(num='19',name='RA0',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PIC16F882-I/P',dest=TEMPLATE,tool=SKIDL,keywords='Flash-Based 8-Bit CMOS Microcontroller',description='8K Flash, 256B SRAM, 256B EEPROM, XLP, DIP28',ref_prefix='U',num_units=1,fplist=['DIP*', 'PDIP*'],do_erc=True,aliases=['PIC16F883-I/P', 'PIC16F886-I/P'],pins=[
            Pin(num='1',name='RE3/~MCLR~/Vpp',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='ULPWU/C12IN0-/AN0/RA0',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='C12IN1-/AN1/RA1',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='CVref/C2IN1+/Vref-/AN2/RA2',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='C1IN+/Vref+/AN3/RA3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='T0CKI/C1OUT/RA4',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~SS~/C2OUT/AN4/RA5',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CLKIN/OSC1/RA7',do_erc=True),
            Pin(num='10',name='CLKOUT/OSC2/RA6',func=Pin.BIDIR,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RC0/T1OSO/T1CK1',func=Pin.BIDIR,do_erc=True),
            Pin(num='21',name='INT/AN12/RB0',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='RC1/T1OSI/CCP2',func=Pin.BIDIR,do_erc=True),
            Pin(num='22',name='P1C/AN10/RB1',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='RC2/P1A/CCP1',func=Pin.BIDIR,do_erc=True),
            Pin(num='23',name='P1B/AN8/RB2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='RC3/SCK/SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='24',name='PGM/C12IN2-/AN8/RB3',func=Pin.BIDIR,do_erc=True),
            Pin(num='15',name='RC4/SDI/SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='P1D/AN11/RB4',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='RC5/SDO',func=Pin.BIDIR,do_erc=True),
            Pin(num='26',name='~T1G~/AN13/RB5',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='RC6/TX/CK',func=Pin.BIDIR,do_erc=True),
            Pin(num='27',name='ICSPCLK/RB6',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='RC7/RX/DT',func=Pin.BIDIR,do_erc=True),
            Pin(num='28',name='ICSPDAT/RB7',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='VSS',func=Pin.PWRIN,do_erc=True)])])
