from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

intersil = SchLib(tool=SKIDL).add_parts(*[
        Part(name='HIP2100_DFN',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Half Bridge Driver, TTL/CMOS inputs, Output Current 2.0A, 100V, DFN-8 4x4mm',ref_prefix='U',num_units=1,fplist=['DFN*1EP*4x4mm*Pitch0.5mm*'],do_erc=True,aliases=['HIP2101_DFN'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='4',name='HB',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='HO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='HS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='HI',do_erc=True),
            Pin(num='8',name='LI',do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='LO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='EP',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='HIP2100_EPSOIC',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Half Bridge Driver, TTL/CMOS inputs, Output Current 2.0A, 100V, EPSOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*1EP*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['HIP2101_EPSOIC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='HB',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='HO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='HS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='HI',do_erc=True),
            Pin(num='6',name='LI',do_erc=True),
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='EP',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='HIP2100_QFN',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Half Bridge Driver, TTL/CMOS inputs, Output Current 2.0A, 100V, QFN-16 5x5mm',ref_prefix='U',num_units=1,fplist=['QFN*1EP*5x5mm*Pitch0.8mm*'],do_erc=True,aliases=['HIP2101_QFN'],pins=[
            Pin(num='1',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='2',name='HB',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='HO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='HS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='HI',do_erc=True),
            Pin(num='8',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='LI',do_erc=True),
            Pin(num='11',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='LO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='EP',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='HIP2100_SOIC',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Half Bridge Driver, TTL/CMOS inputs, Output Current 2.0A, 100V, SOIC-8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['HIP2101_SOIC'],pins=[
            Pin(num='1',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='HB',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='HO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='HS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='HI',do_erc=True),
            Pin(num='6',name='LI',do_erc=True),
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='HIP4080A',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Full Bridge FET Driver, Input Comparator, 2.5A, 80V',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x12.8mm*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='BHB',do_erc=True),
            Pin(num='2',name='HEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='DIS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='IN+',do_erc=True),
            Pin(num='7',name='IN-',do_erc=True),
            Pin(num='8',name='HDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='LDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='AHB',do_erc=True),
            Pin(num='20',name='BHO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='AHO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='AHS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='ALO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='ALS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='BLS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='BLO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='BHS',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='HIP4081A',dest=TEMPLATE,tool=SKIDL,keywords='Half Bridge Gate Driver',description='High Frequency Full Bridge FET Driver, 2.5A, 80V',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x12.8mm*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='BHB',do_erc=True),
            Pin(num='2',name='BHI',do_erc=True),
            Pin(num='3',name='DIS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='BLI',do_erc=True),
            Pin(num='6',name='ALI',do_erc=True),
            Pin(num='7',name='AHI',do_erc=True),
            Pin(num='8',name='HDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='LDEL',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='AHB',do_erc=True),
            Pin(num='20',name='BHO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='AHO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='AHS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='ALO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='ALS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='BLS',func=Pin.PASSIVE,do_erc=True),
            Pin(num='18',name='BLO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='BHS',func=Pin.PASSIVE,do_erc=True)])])
