from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

dc_dc = SchLib(tool=SKIDL).add_parts(*[
        Part(name='ADP1108',dest=TEMPLATE,tool=SKIDL,keywords='switching buck boost converter step-down step-up',description='Micropower DC-DC conveter, step-up or step-down operation, 2V-30Vin, adjustable output voltage',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*', 'DIP*W7.62mm*'],do_erc=True,aliases=['LT1108', 'ADP1108-3.3', 'ADP1108-5', 'ADP1108-12'],pins=[
            Pin(num='1',name='ILIM',do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SW1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='SW2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='AO',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='SET',do_erc=True),
            Pin(num='8',name='FB/SENSE',do_erc=True)]),
        Part(name='ADP2108',dest=TEMPLATE,tool=SKIDL,keywords='Voltage regulator switching buck fixed output analog',description='3MHz switching buck regulator, 600mA fixed output voltage in SOT23-5 package',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='Vin',do_erc=True),
            Pin(num='2',name='GND',do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='SW',do_erc=True)]),
        Part(name='ADP5054',dest=TEMPLATE,tool=SKIDL,keywords='quad regulator dcdc buck synchronizable parallel',description='250kHz to 2MHz, 6A/6A/2A/2A Quad Buck Regulator, -40 to +125C',ref_prefix='U',num_units=1,fplist=['TQFP*48*1EP'],do_erc=True,pins=[
            Pin(num='1',name='BST3',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='PGND3',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PGND3',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SW3',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='SW3',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='PVIN3',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PVIN4',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SW4',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='SW4',func=Pin.PWROUT,do_erc=True),
            Pin(num='10',name='PGND4',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='COMP2',func=Pin.UNSPEC,do_erc=True),
            Pin(num='30',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='40',name='COMP1',func=Pin.UNSPEC,do_erc=True),
            Pin(num='11',name='PGND4',func=Pin.PWRIN,do_erc=True),
            Pin(num='21',name='EN2',do_erc=True),
            Pin(num='31',name='DL1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='41',name='FB1',do_erc=True),
            Pin(num='12',name='BST4',func=Pin.PWRIN,do_erc=True),
            Pin(num='22',name='PVIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='BST1',func=Pin.PWRIN,do_erc=True),
            Pin(num='42',name='RT',func=Pin.UNSPEC,do_erc=True),
            Pin(num='13',name='CFG34',do_erc=True),
            Pin(num='23',name='PVIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='33',name='SW1',func=Pin.PWROUT,do_erc=True),
            Pin(num='43',name='VDD',func=Pin.PWROUT,do_erc=True),
            Pin(num='14',name='EN4',do_erc=True),
            Pin(num='24',name='PVIN2',func=Pin.PWRIN,do_erc=True),
            Pin(num='34',name='SW1',func=Pin.PWROUT,do_erc=True),
            Pin(num='44',name='SYNC/MODE',func=Pin.UNSPEC,do_erc=True),
            Pin(num='15',name='COMP4',func=Pin.UNSPEC,do_erc=True),
            Pin(num='25',name='SW2',func=Pin.PWROUT,do_erc=True),
            Pin(num='35',name='SW1',func=Pin.PWROUT,do_erc=True),
            Pin(num='45',name='VREG',func=Pin.PWROUT,do_erc=True),
            Pin(num='16',name='FB4',do_erc=True),
            Pin(num='26',name='SW2',func=Pin.PWROUT,do_erc=True),
            Pin(num='36',name='PVIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='46',name='FB3',do_erc=True),
            Pin(num='17',name='PWRGD',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='27',name='SW2',func=Pin.PWROUT,do_erc=True),
            Pin(num='37',name='PVIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='47',name='COMP3',func=Pin.UNSPEC,do_erc=True),
            Pin(num='18',name='CFG12',do_erc=True),
            Pin(num='28',name='BST2',func=Pin.PWRIN,do_erc=True),
            Pin(num='38',name='PVIN1',func=Pin.PWRIN,do_erc=True),
            Pin(num='48',name='EN3',do_erc=True),
            Pin(num='19',name='FB2',do_erc=True),
            Pin(num='29',name='DL2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='39',name='EN1',do_erc=True),
            Pin(num='49',name='EPAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='APE1707H-33-HF',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 2A 150KHz PWM Buck DC/DC',description='Adjustable 2A, 150KHz PWM Buck DC/DC Converter, TO252-5 (D-PAK)',ref_prefix='U',num_units=1,fplist=['TO?252*', 'D?PAK*', 'DPAK*'],do_erc=True,aliases=['APE1707H-50-HF', 'APE1707H-12-HF', 'APE1707H-HF'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~EN~',do_erc=True)]),
        Part(name='APE1707M-33-HF',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 2A 150KHz PWM Buck DC/DC',description='Adjustable 2A, 150KHz PWM Buck DC/DC Converter, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['APE1707M-50-HF', 'APE1707M-12-HF', 'APE1707M-HF'],pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='~EN~',do_erc=True),
            Pin(num='5',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BD9001F',dest=TEMPLATE,tool=SKIDL,keywords='DC-DC Step-Down Switching Regulator',description='48V 2A, Flexible Step-Down Switching Regulator, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='INV',do_erc=True),
            Pin(num='6',name='RT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BD9778F',dest=TEMPLATE,tool=SKIDL,keywords='DC-DC Step-Down Switching Regulator',description='35V 2A, Flexible Step-Down Switching Regulator, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='INV',do_erc=True),
            Pin(num='5',name='EN',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='RT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='PVIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BD9778HFP',dest=TEMPLATE,tool=SKIDL,keywords='DC-DC Step-Down Switching Regulator',description='35V 2A, Flexible Step-Down Switching Regulator, HRP7',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='INV',do_erc=True),
            Pin(num='6',name='RT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='EN',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BD9781HFP',dest=TEMPLATE,tool=SKIDL,keywords='DC-DC Step-Down Switching Regulator',description='35V 4A, Flexible Step-Down Switching Regulator, HRP7',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='RT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='INV',do_erc=True),
            Pin(num='7',name='EN/SYNC',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='BD9G341EFJ',dest=TEMPLATE,tool=SKIDL,keywords='BD9G341EFJ, Buck Converter',description='12V-76V input voltage range 3A output current',ref_prefix='U',num_units=1,fplist=['HTSOP*'],do_erc=True,pins=[
            Pin(num='1',name='LX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='RT',do_erc=True),
            Pin(num='6',name='EN',do_erc=True),
            Pin(num='7',name='BST',do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='GL2576-3.3SF8DR',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 3A 52KHz Buck DC/DC',description='Adjustable 3A, 52KHz Step Down Converter, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['GL2576-5.0SF8DR', 'GL2576-12SF8DR', 'GL2576-15SF8DR', 'GL2576-ASF8DR'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='~ON~/OFF',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='GL2576-3.3TA5PR',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 3A 52KHz Buck DC/DC',description='Adjustable 3A, 52KHz Step Down Converter, TD2P-5',ref_prefix='U',num_units=1,do_erc=True,aliases=['GL2576-5.0TA5PR', 'GL2576-12TA5PR', 'GL2576-15TA5PR', 'GL2576-ATA5PR'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='GL2576-3.3TA5R',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 3A 52KHz Buck DC/DC',description='Adjustable 3A, 52KHz Step Down Converter, TO263-5 (D2-PAK)',ref_prefix='U',num_units=1,fplist=['TO?263*', 'D2-PAK-5*'],do_erc=True,aliases=['GL2576-5.0TA5R', 'GL2576-12TA5R', 'GL2576-15TA5R', 'GL2576-ATA5R'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='GL2576-3.3TB5T',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 3A 52KHz Buck DC/DC',description='Adjustable 3A, 52KHz Step Down Converter, TO220-5',ref_prefix='U',num_units=1,fplist=['TO?220*'],do_erc=True,aliases=['GL2576-5.0TB5T', 'GL2576-12TB5T', 'GL2576-15TB5T', 'GL2576-ATB5T'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='IS31LT3360',dest=TEMPLATE,tool=SKIDL,keywords='Switching LED driver',description='Constant current LED driver, internal switch, up to 40V/1.2A, SOT-89-5',ref_prefix='U',num_units=1,fplist=['SOT-23*', 'SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='LX',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='ADJ',do_erc=True),
            Pin(num='4',name='ISENSE',do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='ISL8117',dest=TEMPLATE,tool=SKIDL,keywords='PWM step down buck converter controller synchronous POL',description='Synchronous step-down PWM controller, 4.5v to 60v input, 0.6v to 54v output',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='EXTBIAS',do_erc=True),
            Pin(num='2',name='EN',do_erc=True),
            Pin(num='3',name='CLKOUT',do_erc=True),
            Pin(num='4',name='MOD/SYNC',do_erc=True),
            Pin(num='5',name='PGOOD',do_erc=True),
            Pin(num='6',name='RT',do_erc=True),
            Pin(num='7',name='SS/TRK',do_erc=True),
            Pin(num='8',name='FB',do_erc=True),
            Pin(num='9',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='LGATE/OCS',do_erc=True),
            Pin(num='11',name='VCC5V',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='ISEN',do_erc=True),
            Pin(num='13',name='PHASE',do_erc=True),
            Pin(num='14',name='UGATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='BOOT',do_erc=True),
            Pin(num='16',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='L5973D',dest=TEMPLATE,tool=SKIDL,keywords='step down buck regulator',description='2.5A step down switching regulator',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*1EP*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='INH',do_erc=True),
            Pin(num='4',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='EP',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='LM2574HVH-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable 500mA HV',description='LM2574N, Adjustable Output, 0.5A Step-Down VR, High Votage Input',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM2574HVH-3.3', 'LM2574HVH-5', 'LM2574HVH-15', 'LM2574HVH-ADJ'],pins=[
            Pin(num='1',name='FB',do_erc=True),
            Pin(num='2',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='ON/~OFF',do_erc=True),
            Pin(num='4',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2574N-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable 500mA',description='Adjustable Output, 0.5A Step-Down VR',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM2574N-3.3', 'LM2574N-5', 'LM2574N-15', 'LM2574N-ADJ'],pins=[
            Pin(num='1',name='FB',do_erc=True),
            Pin(num='2',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='ON/~OFF',do_erc=True),
            Pin(num='4',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='OUT',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2576HVS-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 3A Adjustable High Voltage',description='TO-263, Adjustable Output 3A Step-Down VR High Voltage Input',ref_prefix='U',num_units=1,fplist=['TO?263*'],do_erc=True,aliases=['LM2576HVS-3.3', 'LM2576HVS-5', 'LM2576HVS-15', 'LM2576HVS-ADJ'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2576HVT-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 3A Adjustable High Voltage',description='LM2576HVS, TO-220-5, Adjustable Output 3A Step-Down VR High Voltage Input',ref_prefix='U',num_units=1,fplist=['TO?220*'],do_erc=True,aliases=['LM2576HVT-3.3', 'LM2576HVT-5', 'LM2576HVT-15', 'LM2576HVT-ADJ'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2576S-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 3A Adjustable',description='TO-263, Adjustable Output 3A Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?263*'],do_erc=True,aliases=['LM2576S-3.3', 'LM2576S-5', 'LM2576S-15', 'LM2576S-ADJ', 'LM2575BU-ADJ', 'LM2575-3.3BU', 'LM2575-5.0BU', 'LM2575-12BU'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2576T-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 3A Adjustable',description='LM2576S, TO-220-5, Adjustable Output 3A Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?220*'],do_erc=True,aliases=['LM2576T-3.3', 'LM2576T-5', 'LM2576T-15', 'LM2576T-ADJ', 'LM2575BT-ADJ', 'LM2575-3.3BT', 'LM2575-5.0BT', 'LM2575-12BT'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2595S-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 1A Adjustable',description='Adjustable Output 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?263*'],do_erc=True,aliases=['LM2595S-3.3', 'LM2595S-5', 'LM2595S-ADJ'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True)]),
        Part(name='LM2595T-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator 1A Adjustable',description='Adjustable Output 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?220*'],do_erc=True,aliases=['LM2595T-3.3', 'LM2595T-5', 'LM2595T-ADJ'],pins=[
            Pin(num='1',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2596S-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable 3A',description='TO-263, Adjustable 3A Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?263*'],do_erc=True,aliases=['LM2596S-5', 'LM2596S-3.3', 'LM2596S-ADJ'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2596T-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable 3A',description='TO220-5, Adjustable 3A 150kHz Step-Down VR',ref_prefix='U',num_units=1,fplist=['TO?220*'],do_erc=True,aliases=['LM2596T-5', 'LM2596T-3.3', 'LM2596T-ADJ'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='OUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~ON~/OFF',do_erc=True)]),
        Part(name='LM2672M-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator',description='Adjustable Output, 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LM2672M-3.3', 'LM2672M-5.0', 'LM2672M-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='2',name='SS',do_erc=True),
            Pin(num='3',name='SYNC',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2672N-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator',description='Adjustable Output, 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM2672N-3.3', 'LM2672N-5.0', 'LM2672N-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='2',name='SS',do_erc=True),
            Pin(num='3',name='SYNC',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2674M-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator',description='Adjustable Output, 500 mA Step-Down VR',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LM2674M-3.3', 'LM2674M-5.0', 'LM2674M-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2674N-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator',description='LM2674M, Adjustable Output, 500 mA Step-Down VR',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM2674N-3.3', 'LM2674N-5.0', 'LM2674N-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2675M-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable',description='Adjustable Output, 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['LM2675M-3.3', 'LM2675M-5', 'LM2675M-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2675N-12',dest=TEMPLATE,tool=SKIDL,keywords='SIMPLE SWITCHER® Step-Down Voltage Regulator Adjustable',description='LM2675M, Adjustable Output, 1A Step-Down VR',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['LM2675N-3.3', 'LM2675N-5', 'LM2675N-ADJ'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM2734',dest=TEMPLATE,tool=SKIDL,keywords='Miniature Step-Down Buck Voltage Regulator',description='Thin SOT 1-A Load Step-Down DC-DC Regulator',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='BOOST',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='EN',do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM3407MY',dest=TEMPLATE,tool=SKIDL,keywords='LED Step-Down Switching Regulator',description='LED Lighting CC Floating Buck Switching Regulator, eMSOP-8',ref_prefix='U',num_units=1,fplist=['eMSOP-8*'],do_erc=True,pins=[
            Pin(num='1',name='ISNS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='DIM',do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='FS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='VIN',do_erc=True),
            Pin(num='6',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LX',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM3578',dest=TEMPLATE,tool=SKIDL,keywords='POWER REGUL',description='Switching Regulator (adjustable)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='E-',do_erc=True),
            Pin(num='2',name='E+',do_erc=True),
            Pin(num='3',name='CAP_OSC',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='E',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='6',name='C',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='CUR_LIM',do_erc=True),
            Pin(num='8',name='VP+',do_erc=True)]),
        Part(name='LM3670MF',dest=TEMPLATE,tool=SKIDL,keywords='DC-DC buck conveter step down voltage regulator',description='Miniature Step-Down DC-DC Converter, 2.5V < Vin < 5.5V',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM5006MM',dest=TEMPLATE,tool=SKIDL,keywords='Constant On-Time Buck Switching Regulator',description='600 mA, 80V Constant On-Time Buck Switching Regulator',ref_prefix='U',num_units=1,fplist=['MSOP-10*'],do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='LG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='UV',do_erc=True),
            Pin(num='6',name='UVO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='FB',do_erc=True),
            Pin(num='8',name='RT/SD',do_erc=True),
            Pin(num='9',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LM5007MM',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='700 mA, 80V Step-Down Switching Regulator',ref_prefix='U',num_units=1,fplist=['MSOP-8*'],do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5007SD',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='700 mA, 80V Step-Down Switching Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5008MM',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='500 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,fplist=['MSOP-8*'],do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5008SD',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='500 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5008SDC',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='500 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5009MM',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator',description='150 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,fplist=['MSOP-8*'],do_erc=True,pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='BST',do_erc=True),
            Pin(num='3',name='RCL',do_erc=True),
            Pin(num='4',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='RON/SD',do_erc=True),
            Pin(num='7',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LM5017MR',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator High Voltage',description='600 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='3',name='ULVO',do_erc=True),
            Pin(num='4',name='RON',do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='BST',do_erc=True),
            Pin(num='8',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM5017SD',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down Switching Regulator High Voltage High Frequency',description='600 mA, 100V Step-Down Switching Regulator',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='RTN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='3',name='ULVO',do_erc=True),
            Pin(num='4',name='RON',do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='VCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='BST',do_erc=True),
            Pin(num='8',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LM5165X',dest=TEMPLATE,tool=SKIDL,keywords='step-down dc-dc buck regulator fixed 3V3',description='150mA Step-Down Conveter, 3V-65V input, 3.3V fixed output voltage, DFN10 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x3mm*Pitch0.5mm*'],do_erc=True,aliases=['LM5165Y', 'LM5165'],pins=[
            Pin(num='1',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='ILIM',do_erc=True),
            Pin(num='4',name='SS',do_erc=True),
            Pin(num='5',name='RT',do_erc=True),
            Pin(num='6',name='PGOOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='EN',do_erc=True),
            Pin(num='8',name='FB/VOUT',do_erc=True),
            Pin(num='9',name='HYS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LMR10510XMF',dest=TEMPLATE,tool=SKIDL,keywords='Miniature Step-Up Boost Voltage Regulator',description='LM64010, 1A, 40Vout Step-Up Voltage Regulator, 1.6MHz Frequency, SOT-23-5',ref_prefix='U',num_units=1,fplist=['SOT-23-5*'],do_erc=True,aliases=['LM2731XMF', 'LM2731YMF', 'LM27313XMF', 'LM2733XMF', 'LM2733YMF', 'LM2735XMF', 'LMR10510YMF', 'LMR62014XMF', 'LMR62421XMF', 'LMR64010XMF'],pins=[
            Pin(num='1',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='EN',do_erc=True),
            Pin(num='5',name='VIN',do_erc=True)]),
        Part(name='LMR10510YSD',dest=TEMPLATE,tool=SKIDL,keywords='Miniature Step-Up Boost SEPIC Voltage Regulator',description='2.1A, 24Vout Step-Up Voltage Regulator, 1.6MHz Frequency',ref_prefix='U',num_units=1,do_erc=True,aliases=['LMR62421XSD'],pins=[
            Pin(num='1',name='FB',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='VIND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VINA',do_erc=True),
            Pin(num='6',name='EN',do_erc=True)]),
        Part(name='LMR16006YQ',dest=TEMPLATE,tool=SKIDL,keywords='simple-switcher buck step-down voltage-regulator',description='Simple Switcher Buck Regulator, Vin=4-40V, Iout=600mA, Fixed 5.0V output voltage, SOT-23-6 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,aliases=['LMR16006YQ3', 'LMR16006YQ5'],pins=[
            Pin(num='1',name='CB',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='~SHDN',do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LT1054',dest=TEMPLATE,tool=SKIDL,keywords='monolithic bipolar switched capacitor voltage converter regulator inverter doubler shutdown',description='Switched-Capacitor Voltage Converter with Regulator, output current 100mA, operating range 3.5V to 15V, low loss 1.1V at 100mA',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='FB/SHDN',do_erc=True),
            Pin(num='2',name='CAP+',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CAP-',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VREF',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='OSC',do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT1073',dest=TEMPLATE,tool=SKIDL,keywords='Micropower DC/DC Converter',description='Micropower DC/DC Converter Adjustable and Fixed 5V, 12V',ref_prefix='U',num_units=1,fplist=['SOIC-8*', 'DIP*W7.62mm*'],do_erc=True,pins=[
            Pin(num='1',name='Ilim',do_erc=True),
            Pin(num='2',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='SW1',do_erc=True),
            Pin(num='4',name='SW2',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='A0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='SET',do_erc=True),
            Pin(num='8',name='SENSE',do_erc=True)]),
        Part(name='LT1372',dest=TEMPLATE,tool=SKIDL,description='Set up/step down switching regulator',ref_prefix='U',num_units=1,do_erc=True,aliases=['LT1373'],pins=[
            Pin(num='1',name='Vc',do_erc=True),
            Pin(num='2',name='FB+',do_erc=True),
            Pin(num='3',name='FB-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='S/S',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='GND_S',do_erc=True),
            Pin(num='7',name='GND',do_erc=True),
            Pin(num='8',name='Vsw',do_erc=True)]),
        Part(name='LT1945',dest=TEMPLATE,tool=SKIDL,keywords='switched voltage converter regulator inverter double shutdown positive negative',description='Dual Micropower DC/DC Converter with Positive and Negative Outputs',ref_prefix='U',num_units=1,fplist=['MSOP-10*'],do_erc=True,pins=[
            Pin(num='1',name='NFB1',do_erc=True),
            Pin(num='2',name='~SHDN1',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~SHDN2',do_erc=True),
            Pin(num='5',name='FB2',do_erc=True),
            Pin(num='6',name='SW2',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='V_IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='SW1',func=Pin.PWROUT,do_erc=True)]),
        Part(name='LT3430',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='Hight Voltage Step-down switching regulator (synchronous) 3 A',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='VIN',do_erc=True),
            Pin(num='4',name='VIN',do_erc=True),
            Pin(num='5',name='SW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='BOOST',do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='Bias',do_erc=True),
            Pin(num='11',name='COMP',do_erc=True),
            Pin(num='12',name='FB(1.22V)',do_erc=True),
            Pin(num='14',name='SYNC',do_erc=True),
            Pin(num='15',name='SHDN',do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT3439',dest=TEMPLATE,tool=SKIDL,description='Low EMI DC/DC converter.',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='COLA',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Rsl',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='SYNC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Ct',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='Rt',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~SHDN~',do_erc=True),
            Pin(num='13',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='COLB',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='PGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LT3757EMSE',dest=TEMPLATE,tool=SKIDL,description='Boost, flyback, SEPIC and inverting regulator (MSOP package)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VC',do_erc=True),
            Pin(num='2',name='FBX',do_erc=True),
            Pin(num='3',name='SS',do_erc=True),
            Pin(num='4',name='RT',do_erc=True),
            Pin(num='5',name='SYNC',do_erc=True),
            Pin(num='6',name='SENSE',do_erc=True),
            Pin(num='7',name='GATE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='INTVCC',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~SHDN~/UVLO',do_erc=True),
            Pin(num='10',name='VIN',do_erc=True),
            Pin(num='11',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1044',dest=TEMPLATE,tool=SKIDL,keywords='monolithic CMOS switched capacitor voltage converter invert double divide multiply boost',description='Switched-Capacitor Voltage Converter, 1.5V to 10.0V operating supply voltage, 10mA with a 0.5V output drop',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['MAX1044', 'ICL7660'],pins=[
            Pin(num='1',name='BOOST',do_erc=True),
            Pin(num='2',name='CAP+',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='CAP-',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='LV',do_erc=True),
            Pin(num='7',name='OSC',do_erc=True),
            Pin(num='8',name='V+',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC1307',dest=TEMPLATE,tool=SKIDL,keywords='POWER',description='Switching Regulator (Single cell micropower)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='Vc',do_erc=True),
            Pin(num='2',name='FeedBack',do_erc=True),
            Pin(num='3',name='SHDW',do_erc=True),
            Pin(num='4',name='GND',do_erc=True),
            Pin(num='5',name='SW',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='6',name='VIN',do_erc=True),
            Pin(num='7',name='LBI',do_erc=True),
            Pin(num='8',name='LBO',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC1624',dest=TEMPLATE,tool=SKIDL,keywords='POWER',description='Switching Regulator Controller',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='ISENSE',do_erc=True),
            Pin(num='2',name='Ith/RUN',do_erc=True),
            Pin(num='3',name='SET',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SW',do_erc=True),
            Pin(num='6',name='TG',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='BOOST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VIN',do_erc=True)]),
        Part(name='LTC1878',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='Synchronous Step-Down Regulator',ref_prefix='U',num_units=1,do_erc=True,aliases=['LTC1878EMS8'],pins=[
            Pin(num='1',name='RUN',do_erc=True),
            Pin(num='2',name='ITH',do_erc=True),
            Pin(num='3',name='VFB',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VIN',do_erc=True),
            Pin(num='7',name='SYNC',do_erc=True),
            Pin(num='8',name='PLL_LPF',func=Pin.BIDIR,do_erc=True)]),
        Part(name='LTC3429',dest=TEMPLATE,tool=SKIDL,keywords='boost step-up DC/DC synchronous',description='600mA, 500kHz Micropower Synchronous Boost Converter with Output Disconnect, Continuous Switching at Light Loads, TSOT-23 6-Lead Package',ref_prefix='U',num_units=1,fplist=['TSOT-23*', 'SOT-23*'],do_erc=True,aliases=['LTC3429B'],pins=[
            Pin(num='1',name='SW',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='~SHDN',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC3442',dest=TEMPLATE,tool=SKIDL,description='Micropower Synchronous Buck-Boost DC/DC Converter with Automatic Burst Mode Operation',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='SHDN/SS',do_erc=True),
            Pin(num='2',name='RT',do_erc=True),
            Pin(num='3',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SW1',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='BURST',do_erc=True),
            Pin(num='8',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='RLIM',do_erc=True),
            Pin(num='11',name='VC',do_erc=True),
            Pin(num='12',name='FB',do_erc=True),
            Pin(num='13',name='PGND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC3525',dest=TEMPLATE,tool=SKIDL,keywords='fixed boost step-up DC/DC synchronous',description='Fixed 3V, 400mA Micropower Synchronous Step-Up DC/DC Converter with Output Disconnect',ref_prefix='U',num_units=1,fplist=['SC70*'],do_erc=True,aliases=['LTC3525-3', 'LTC3525-3.3', 'LTC3525-5', 'LTC3525D-3.3', 'LTC3525L-3'],pins=[
            Pin(num='1',name='~SHDN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',do_erc=True)]),
        Part(name='LTC3630',dest=TEMPLATE,tool=SKIDL,keywords='buck dc-dc switcher switching',description='High efficiency 76V 500mA synchronous step-down converter',ref_prefix='U',num_units=1,fplist=['DFN*', 'MSOP*'],do_erc=True,aliases=['LTC3630A'],pins=[
            Pin(num='1',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='3',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='5',name='RUN',do_erc=True),
            Pin(num='6',name='Vprg2',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='Vprg1',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Vfb',do_erc=True),
            Pin(num='10',name='SS',do_erc=True),
            Pin(num='11',name='Iset',do_erc=True),
            Pin(num='12',name='FBO',do_erc=True),
            Pin(num='13',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='16',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC3886',dest=TEMPLATE,tool=SKIDL,keywords='step down switch manager I2C telemetry fault current sense',description='60V dual output buck output with digital power system management',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='SW0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='TG0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Isense0+',do_erc=True),
            Pin(num='5',name='Isense0-',do_erc=True),
            Pin(num='6',name='TSNS0',do_erc=True),
            Pin(num='7',name='Vsense0+',do_erc=True),
            Pin(num='8',name='Vsense0-',do_erc=True),
            Pin(num='9',name='Isense1+',do_erc=True),
            Pin(num='10',name='Isense1-',do_erc=True),
            Pin(num='20',name='RUN1',do_erc=True),
            Pin(num='30',name='Vdd33',func=Pin.PWROUT,do_erc=True),
            Pin(num='40',name='BOOST1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='50',name='BG0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Ithr0',do_erc=True),
            Pin(num='21',name='ASEL0',do_erc=True),
            Pin(num='31',name='Ith1',do_erc=True),
            Pin(num='12',name='Ith0',do_erc=True),
            Pin(num='22',name='ASEL1',do_erc=True),
            Pin(num='32',name='Ithr1',do_erc=True),
            Pin(num='42',name='BG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='52',name='BOOST0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='SYNC',do_erc=True),
            Pin(num='23',name='Vout_cfg0',do_erc=True),
            Pin(num='33',name='PGOOD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='43',name='EXTVcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='53',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='SCL',do_erc=True),
            Pin(num='24',name='Vout_cfg1',do_erc=True),
            Pin(num='34',name='PGOOD0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='44',name='INTVcc',func=Pin.PWROUT,do_erc=True),
            Pin(num='15',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='25',name='FREQ_CFG',do_erc=True),
            Pin(num='35',name='Vsense1+',do_erc=True),
            Pin(num='16',name='~ALERT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='PHAS_CFG',do_erc=True),
            Pin(num='36',name='TSNS1',do_erc=True),
            Pin(num='46',name='Iin-',do_erc=True),
            Pin(num='17',name='~FAULT0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='Vdd25',func=Pin.PWROUT,do_erc=True),
            Pin(num='47',name='Iin+',do_erc=True),
            Pin(num='18',name='~FAULT1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='WP',do_erc=True),
            Pin(num='38',name='TG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='48',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='RUN0',do_erc=True),
            Pin(num='29',name='SHARE_CLK',do_erc=True),
            Pin(num='39',name='SW1',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC3890',dest=TEMPLATE,tool=SKIDL,keywords='switching buck converter regulator dual-output',description='60V dual 2-phase synchronous step-down DC/DC controller in QFN-32 package',ref_prefix='U',num_units=1,fplist=['QFN*'],do_erc=True,pins=[
            Pin(num='1',name='SENSE1-',do_erc=True),
            Pin(num='2',name='FREQ',do_erc=True),
            Pin(num='3',name='PHASMD',do_erc=True),
            Pin(num='4',name='CLKOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='PLL/MODE',do_erc=True),
            Pin(num='6',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='RUN1',do_erc=True),
            Pin(num='8',name='RUN2',do_erc=True),
            Pin(num='9',name='SENSE2-',do_erc=True),
            Pin(num='10',name='SENSE2+',do_erc=True),
            Pin(num='20',name='EXTVcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='30',name='ITH1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='VFB2',do_erc=True),
            Pin(num='21',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='31',name='VFB1',do_erc=True),
            Pin(num='12',name='ITH2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='32',name='SENSE1+',do_erc=True),
            Pin(num='13',name='SS2',do_erc=True),
            Pin(num='23',name='BG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='33',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='PGOOD2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='24',name='BOOST1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='TG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='SW1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='SW2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='TG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='BOOST2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='PGOOD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='BG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='I_Lim',do_erc=True),
            Pin(num='19',name='INTVcc',func=Pin.PWROUT,do_erc=True),
            Pin(num='29',name='SS1',do_erc=True)]),
        Part(name='LTC3890-1',dest=TEMPLATE,tool=SKIDL,keywords='switching buck converter regulator dual-output',description='60V dual 2-phase synchronous step-down DC/DC controller in SSOP-28 package',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='ITH1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='VFB1',do_erc=True),
            Pin(num='3',name='SENSE1+',do_erc=True),
            Pin(num='4',name='SENSE1-',do_erc=True),
            Pin(num='5',name='FREQ',do_erc=True),
            Pin(num='6',name='PLL/MODE',do_erc=True),
            Pin(num='7',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='RUN1',do_erc=True),
            Pin(num='9',name='RUN2',do_erc=True),
            Pin(num='10',name='SENSE2-',do_erc=True),
            Pin(num='20',name='EXTVcc',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='SENSE2+',do_erc=True),
            Pin(num='21',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VFB2',do_erc=True),
            Pin(num='22',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='ITH2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='23',name='BG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='SS2',do_erc=True),
            Pin(num='24',name='BOOST1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='TG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='SW1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='SW2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='TG1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='17',name='BOOST2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='PGOOD1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='BG2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='SS1',do_erc=True),
            Pin(num='19',name='INTVcc',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MAX15062A',dest=TEMPLATE,tool=SKIDL,keywords='step-down dc-dc switching regulator',description='60V, 300mA, synchronous step-down dc-dc converter, adjustable output voltage',ref_prefix='U',num_units=1,fplist=['DFN*2x2mm*Pitch0.5mm*'],do_erc=True,aliases=['MAX15062B', 'MAX15062C'],pins=[
            Pin(num='1',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='EN/UVLO',do_erc=True),
            Pin(num='3',name='VCC',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='FB/Vout',do_erc=True),
            Pin(num='5',name='MODE',do_erc=True),
            Pin(num='6',name='~RESET',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LX',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MAX5035AUPA',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 1A Step-Down Converter 76V',description='Adjustable 1A, High-Efficiency Step-Down DC-DC Converter, Vin 76V, PDIP-8',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*'],do_erc=True,aliases=['MAX5035BUPA', 'MAX5035CUPA', 'MAX5035DUPA'],pins=[
            Pin(num='1',name='BST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='VD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF~',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LX',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX5035AUSA',dest=TEMPLATE,tool=SKIDL,keywords='Adjustable 1A Step-Down Converter 76V',description='Adjustable 1A, High-Efficiency Step-Down DC-DC Converter, Vin 76V, SO8',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,aliases=['MAX5035AASA', 'MAX5035BUSA', 'MAX5035BASA', 'MAX5035CUSA', 'MAX5035CASA', 'MAX5035DUSA', 'MAX5035DASA', 'MAX5035EUSA', 'MAX5035EASA'],pins=[
            Pin(num='1',name='BST',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='VD',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='ON/~OFF~',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='LX',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MAX777',dest=TEMPLATE,tool=SKIDL,keywords='switching regulator boost step-up dc-dc',description='Low voltage input, step-up, DC-DC converter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='ILIM',do_erc=True),
            Pin(num='2',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='LX',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='~SHDN',do_erc=True)]),
        Part(name='MC34063',dest=TEMPLATE,tool=SKIDL,keywords='smps buck boost inverting',description='1.5A step up/down/inverting switching regulator',ref_prefix='U',num_units=1,fplist=['DIP*W7.62mm*', 'SOIC*3.9x4.9mm*Pitch1.27mm*', 'DFN*'],do_erc=True,pins=[
            Pin(num='1',name='SwC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='SwE',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='TC',do_erc=True),
            Pin(num='4',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Vfb',do_erc=True),
            Pin(num='6',name='Vin(VCC)',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Ipk',do_erc=True),
            Pin(num='8',name='DC',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MCP16301',dest=TEMPLATE,tool=SKIDL,keywords='switching buck converter power-supply voltage regulator',description='4.7 to 36V Input, 1A output, integrated switch step-down regulator, SOT-23-6 package',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['MCP16301H'],pins=[
            Pin(num='1',name='BOOST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vfb',do_erc=True),
            Pin(num='4',name='EN',do_erc=True),
            Pin(num='5',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',func=Pin.PWROUT,do_erc=True)]),
        Part(name='MCP16311-MNY',dest=TEMPLATE,tool=SKIDL,keywords='switching buck converter power-supply voltage regulator',description='30V Input, 1A output, integrated switch step-down regulator, PWM modulation, DFN-8 package',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x2mm*Pitch0.5mm*'],do_erc=True,aliases=['MCP16312-MNY'],pins=[
            Pin(num='1',name='Vfb',do_erc=True),
            Pin(num='2',name='Vcc',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Pgnd',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='BOOST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Agnd',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP16311-MS',dest=TEMPLATE,tool=SKIDL,keywords='switching buck converter power-supply voltage regulator',description='30V Input, 1A output, integrated switch step-down regulator with, modulation, MSOP-8 package',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,aliases=['MCP16312-MS'],pins=[
            Pin(num='1',name='Vfb',do_erc=True),
            Pin(num='2',name='Vcc',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='Pgnd',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='BOOST',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='Agnd',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1640-CH',dest=TEMPLATE,tool=SKIDL,keywords='Step-Up Boost DC-DC Regulator Adjustable',description='Synchronous Boost Regulator, Adjustable Output 2.0V-5.5V, PWM Only Input to Output Bypass, SOT23',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['MCP1640B-CH', 'MCP1640C-CH', 'MCP1640D-CH'],pins=[
            Pin(num='1',name='SW',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='VFB',do_erc=True),
            Pin(num='5',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='VIN',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1640-MC',dest=TEMPLATE,tool=SKIDL,keywords='Step-Up Boost DC-DC Regulator Adjustable',description='Synchronous Boost Regulator, Adjustable Output 2.0V-5.5V, PWM Only Input to Output Bypass, DFN',ref_prefix='U',num_units=1,fplist=['DFN*1EP*3x2mm*Pitch0.5mm*'],do_erc=True,aliases=['MCP1640B-MC', 'MCP1640C-MC', 'MCP1640D-MC'],pins=[
            Pin(num='1',name='VFB',do_erc=True),
            Pin(num='2',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='EN',do_erc=True),
            Pin(num='5',name='SW',do_erc=True),
            Pin(num='6',name='VOUTP',func=Pin.PWROUT,do_erc=True),
            Pin(num='7',name='VOUTS',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='MCP1650',dest=TEMPLATE,tool=SKIDL,keywords='boost controller',description='750 kHz Boost Controller from 3.3V up to 100V, 5W.',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='EXT',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CS',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='8',name='Vin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1651',dest=TEMPLATE,tool=SKIDL,keywords='boost controller',description='750 kHz Boost Controller from 3.3V up to 100V, 5W.',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='EXT',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CS',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='LBI',do_erc=True),
            Pin(num='7',name='~LBO',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='8',name='Vin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1652',dest=TEMPLATE,tool=SKIDL,keywords='boost controller',description='750 kHz Boost Controller from 3.3V up to 100V, 5W.',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='EXT',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CS',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='~SHDN',do_erc=True),
            Pin(num='6',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='7',name='PG',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='8',name='Vin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MCP1653',dest=TEMPLATE,tool=SKIDL,keywords='boost controller',description='750 kHz Boost Controller from 3.3V up to 100V, 5W.',ref_prefix='U',num_units=1,fplist=['MSOP*3x3mm*Pitch0.5mm*'],do_erc=True,pins=[
            Pin(num='1',name='EXT',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='CS',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='6',name='~SHDN',do_erc=True),
            Pin(num='7',name='LBI',do_erc=True),
            Pin(num='8',name='~LBO',func=Pin.OPENEMIT,do_erc=True),
            Pin(num='9',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Vin',func=Pin.PWRIN,do_erc=True)]),
        Part(name='MIC2177',dest=TEMPLATE,tool=SKIDL,keywords='REGUL POWER',description='Step-down switching regulator (synchronous) 2.5 A',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN',do_erc=True),
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='3',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SW',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='VIN',do_erc=True),
            Pin(num='10',name='Sense',do_erc=True),
            Pin(num='20',name='SHDN',do_erc=True),
            Pin(num='11',name='AUTO',do_erc=True),
            Pin(num='12',name='FB',do_erc=True),
            Pin(num='13',name='COMP',do_erc=True),
            Pin(num='14',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='15',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='SGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='SYNC',do_erc=True),
            Pin(num='19',name='Bias',do_erc=True)]),
        Part(name='NID60',dest=TEMPLATE,tool=SKIDL,keywords='60W, 250KHz Buck DC/DC',description='60W, 250kHz Step Down Converter',ref_prefix='U',num_units=1,do_erc=True,aliases=['NID60S24-5', 'NID60S24-15', 'NID60S48-24', 'NID60S24-12'],pins=[
            Pin(num='1',name='Vout',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='Vout',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='Vout',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='COM',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='COM',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='RC',do_erc=True)]),
        Part(name='ST1CC40PHR',dest=TEMPLATE,tool=SKIDL,keywords='DC/DC Buck Conwerter 3A Low Voltage Input LED Lighting',description="DC/DC Buck CC Converter for LED's, Vin 18V, 3A, Power SO-8 (Preliminary)",ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN_A',do_erc=True),
            Pin(num='2',name='SGND',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='3',name='~ON~/OFF',do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='VIN_SW',do_erc=True),
            Pin(num='7',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ST1S10PHR',dest=TEMPLATE,tool=SKIDL,keywords='DC/DC Buck Conwerter 3A Low Voltage Input',description='DC/DC Buck Converter, Vin 18V, 3A, Power SO-8',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN_A',do_erc=True),
            Pin(num='2',name='INH',do_erc=True),
            Pin(num='2',name='PGND',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VIN_SW',do_erc=True),
            Pin(num='7',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ST1S10PUR',dest=TEMPLATE,tool=SKIDL,keywords='DC/DC Buck Conwerter 3A Low Voltage Input',description='ST1S10PHR, DC/DC Buck Converter, Vin 18V, 3A, DFN-8 (4x4mm)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='VIN_A',do_erc=True),
            Pin(num='2',name='INH',do_erc=True),
            Pin(num='2',name='PGND',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='FB',do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SYNC',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='VIN_SW',do_erc=True),
            Pin(num='7',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='ST1S14PHR',dest=TEMPLATE,tool=SKIDL,keywords='DC/DC Buck Conwerter 3A',description='DC/DC Buck Converter, Vin 48V, 3A, Power SO-8',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='BST',do_erc=True),
            Pin(num='2',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~EN1~',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='EN2',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',do_erc=True),
            Pin(num='8',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TEN20-2411WIN',dest=TEMPLATE,tool=SKIDL,keywords='TRACO DC/DC',description='Isolated DC/DC Converter, Vin=18-75V, Vout=15V@1.33A',ref_prefix='U',num_units=1,fplist=['DCDC?Conv?TRACO?TEN20?xxxx*'],do_erc=True,aliases=['TEN20-2410WIN', 'TEN20-2412WIN', 'TEN20-2413WIN', 'TEN20-4810WIN', 'TEN20-4811WIN', 'TEN20-4812WIN', 'TEN20-4813WIN'],pins=[
            Pin(num='1',name='VIN+',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='TRIM',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VOUT-',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='ON/~OFF',do_erc=True)]),
        Part(name='TEN20-2421WIN',dest=TEMPLATE,tool=SKIDL,keywords='TRACO DC/DC',description='Isolated DC/DC Dual Supply Converter, Vin=18-75V, Vout=+-15V@665mA',ref_prefix='U',num_units=1,fplist=['DCDC?Conv?TRACO?TEN20?xxxx*'],do_erc=True,aliases=['TEN20-2422WIN', 'TEN20-2423WIN', 'TEN20-4821WIN', 'TEN20-4822WIN', 'TEN20-4823WIN'],pins=[
            Pin(num='1',name='VIN+',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN-',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VOUT+',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='CM',func=Pin.PWROUT,do_erc=True),
            Pin(num='5',name='VOUT-',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='ON/~OFF',do_erc=True)]),
        Part(name='TL497',dest=TEMPLATE,tool=SKIDL,keywords='buck regulator',description='500 mA step up/step down switching regulator',ref_prefix='U',num_units=1,do_erc=True,aliases=['TL497A'],pins=[
            Pin(num='1',name='Comp',do_erc=True),
            Pin(num='2',name='Inhbt',do_erc=True),
            Pin(num='3',name='Freq',do_erc=True),
            Pin(num='4',name='Substrate',do_erc=True),
            Pin(num='5',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='Cath.',do_erc=True),
            Pin(num='7',name='Anode',do_erc=True),
            Pin(num='8',name='Emit',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='10',name='Coll',do_erc=True),
            Pin(num='11',name='Base_Tr',func=Pin.UNSPEC,do_erc=True),
            Pin(num='12',name='BaseDrv',func=Pin.UNSPEC,do_erc=True),
            Pin(num='13',name='Curr_Lim',do_erc=True),
            Pin(num='14',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS5430DDA',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down DC-DC Switching Regulator',description='23V 3A, Step Down Swift Converter, HSOIC8',ref_prefix='U',num_units=1,fplist=['*SO*'],do_erc=True,aliases=['TPS5431DDA'],pins=[
            Pin(num='1',name='BOOT',do_erc=True),
            Pin(num='4',name='VSENSE',do_erc=True),
            Pin(num='5',name='EN',do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='VIN',do_erc=True),
            Pin(num='8',name='PH',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TPS54360DDA',dest=TEMPLATE,tool=SKIDL,keywords='Step-Down DC-DC Switching Regulator High Voltage High Frequency',description='60V 3.5 A, Step Down DC-DC Converter with Eco-mode, HSOIC8',ref_prefix='U',num_units=1,fplist=['*SO*'],do_erc=True,aliases=['TPS54340DDA'],pins=[
            Pin(num='1',name='BOOT',do_erc=True),
            Pin(num='2',name='VIN',do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='RT/CLK',do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='COMP',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='TPS560200',dest=TEMPLATE,tool=SKIDL,keywords='Voltage regulator switching buck fixed output analog',description='17V step-down regulator, 500mA output in SOT23-5 package',ref_prefix='U',num_units=1,fplist=['SOT-23*'],do_erc=True,pins=[
            Pin(num='1',name='EN',do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='PH',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True)]),
        Part(name='TPS60500DGS',dest=TEMPLATE,tool=SKIDL,keywords='Regulator Step-Down Charge Pump TPS Texas Instruments Ti',description='250mA Step-Down Charge Pump Regulator, 1.5V',ref_prefix='U',num_units=1,fplist=['MSOP-10*'],do_erc=True,aliases=['TPS60501DGS', 'TPS60502DGS', 'TPS60503DGS'],pins=[
            Pin(num='1',name='~EN',do_erc=True),
            Pin(num='2',name='PG',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='C2-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='C2+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='VIN',do_erc=True),
            Pin(num='6',name='C1+',func=Pin.PASSIVE,do_erc=True),
            Pin(num='7',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='C1-',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='FB',do_erc=True)]),
        Part(name='TPS61200',dest=TEMPLATE,tool=SKIDL,keywords='boost step-up DC/DC synchronous',description='Fixed 5V Output, Low Input Voltage Synchronous Boost Converter With 1.3-A Switches, VSON (10) Package',ref_prefix='U',num_units=1,fplist=['S-PVSON-N10', 'S-PWSON-N10'],do_erc=True,aliases=['TPS61201', 'TPS61202'],pins=[
            Pin(num='1',name='VAUX',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='VOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='3',name='L',do_erc=True),
            Pin(num='4',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='6',name='EN',do_erc=True),
            Pin(num='7',name='UVLO',do_erc=True),
            Pin(num='8',name='PS',do_erc=True),
            Pin(num='9',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='FB',do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS62170',dest=TEMPLATE,tool=SKIDL,keywords='step-down dc-dc buck regulator',description='Step-Down Conveter, 0.5A, 3V-17V input, 5.0V fixed output',ref_prefix='U',num_units=1,fplist=['DFN*1EP*2x2mm*Pitch0.5mm*'],do_erc=True,aliases=['TPS62171', 'TPS62172', 'TPS62173'],pins=[
            Pin(num='1',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='VOS',do_erc=True),
            Pin(num='7',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='8',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS62177',dest=TEMPLATE,tool=SKIDL,keywords='step-down dc-dc buck regulator',description='Step-Down Conveter, 0.5A, 4.75V-28V input, 3.3V fixed output, with Sleep Mode',ref_prefix='U',num_units=1,fplist=['DFN*1EP*2x3mm*Pitch0.5mm*'],do_erc=True,aliases=['TPS62175'],pins=[
            Pin(num='1',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='VIN',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='NC',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='FB',do_erc=True),
            Pin(num='6',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='PG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~SLEEP',do_erc=True),
            Pin(num='9',name='SW',func=Pin.PWROUT,do_erc=True),
            Pin(num='10',name='VOS',do_erc=True),
            Pin(num='11',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='TPS62200DBV',dest=TEMPLATE,tool=SKIDL,keywords='TPS62208DBV Step-Down DC-DC Converter SOT-23-5',description='SOT-23-5, High-Efficiency Step-Down DC-DC Converter, 1.875V',ref_prefix='U',num_units=1,fplist=['SOT?23*'],do_erc=True,aliases=['TPS62201DBV', 'TPS62202DBV', 'TPS62203DBV', 'TPS62204DBV', 'TPS62205DBV', 'TPS62207DBV', 'TPS62208DBV'],pins=[
            Pin(num='1',name='VI',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='EN',do_erc=True),
            Pin(num='4',name='FB',do_erc=True),
            Pin(num='5',name='SW',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='TSR_1-2450',dest=TEMPLATE,tool=SKIDL,keywords='dc-dc traco buck',description='9V 1A, step-down regulator, 12-36Vin, TO-220 compatible, replacement for LMxx linear regulators, -40°C to +85°C',ref_prefix='U',num_units=1,fplist=['DCDC?Conv?TRACO?TSR-1*'],do_erc=True,aliases=['TSR_1-2412', 'TSR_1-2415', 'TSR_1-2418', 'TSR_1-2425', 'TSR_1-2433', 'TSR_1-2465', 'TSR_1-2490', 'TSR_1-24120', 'TSR_1-24150'],pins=[
            Pin(num='1',name='Vin',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vout',func=Pin.PWROUT,do_erc=True)])])
