from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

cmos4000 = SchLib(tool=SKIDL).add_parts(*[
        Part(name='14529',dest=TEMPLATE,tool=SKIDL,keywords='CMOS MUX MUX4',description='Dual 4 to 1 Multiplexer',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='STX',do_erc=True),
            Pin(num='2',name='X0',do_erc=True),
            Pin(num='3',name='X1',do_erc=True),
            Pin(num='4',name='X2',do_erc=True),
            Pin(num='5',name='X3',do_erc=True),
            Pin(num='6',name='A',do_erc=True),
            Pin(num='7',name='B',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Z',func=Pin.TRISTATE,do_erc=True),
            Pin(num='10',name='W',func=Pin.TRISTATE,do_erc=True),
            Pin(num='11',name='Y3',do_erc=True),
            Pin(num='12',name='Y2',do_erc=True),
            Pin(num='13',name='Y1',do_erc=True),
            Pin(num='14',name='Y0',do_erc=True),
            Pin(num='15',name='STY',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='4001',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nor2',description='Quad Nor 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4002',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nor4',description='Dual 4 input NOR gate',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='40106',dest=TEMPLATE,tool=SKIDL,do_erc=True),
        Part(name='4011',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nand2',description='Quad Nand 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4012',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nand4',description='Dual 4 inputs Nand',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4013',dest=TEMPLATE,tool=SKIDL,keywords='CMOS DFF',description='Dual D FlipFlop, Set & reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Cp',do_erc=True),
            Pin(num='4',name='Cd',do_erc=True),
            Pin(num='5',name='D',do_erc=True),
            Pin(num='6',name='Sd',do_erc=True),
            Pin(num='8',name='Sd',do_erc=True),
            Pin(num='9',name='D',do_erc=True),
            Pin(num='10',name='Cd',do_erc=True),
            Pin(num='11',name='Cp',do_erc=True),
            Pin(num='12',name='~Q',do_erc=True),
            Pin(num='13',name='Q',do_erc=True)]),
        Part(name='4016',dest=TEMPLATE,tool=SKIDL,keywords='CMOS SWITCH',description='Quad Ananlog Switches',ref_prefix='U',num_units=4,do_erc=True,aliases=['4066'],pins=[
            Pin(num='7',name='V-',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='V+',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='I/O',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='O/I',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='ON',do_erc=True),
            Pin(num='3',name='O/I',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='I/O',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='ON',do_erc=True),
            Pin(num='6',name='ON',do_erc=True),
            Pin(num='8',name='I/O',func=Pin.PASSIVE,do_erc=True),
            Pin(num='9',name='O/I',func=Pin.PASSIVE,do_erc=True),
            Pin(num='10',name='O/I',func=Pin.PASSIVE,do_erc=True),
            Pin(num='11',name='I/O',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='ON',do_erc=True)]),
        Part(name='4017',dest=TEMPLATE,tool=SKIDL,keywords='CNT CNT10',description='Jonhson Counter ( 10 outputs )',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Cout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CKEN',do_erc=True),
            Pin(num='14',name='CLK',do_erc=True),
            Pin(num='15',name='Reset',do_erc=True)]),
        Part(name='4020',dest=TEMPLATE,tool=SKIDL,keywords='CMOS CNT CNT14',description='Binary counter 14 stages (asynchronous)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Q12',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q13',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='CLK',do_erc=True),
            Pin(num='11',name='Reset',do_erc=True),
            Pin(num='12',name='Q8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q10',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4022',dest=TEMPLATE,tool=SKIDL,keywords='CMOS CNT CNT8',description='Jonhson Counter (8 states)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Cout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CKEN',do_erc=True),
            Pin(num='14',name='CLK',do_erc=True),
            Pin(num='15',name='Reset',do_erc=True)]),
        Part(name='4023',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nand3',description='Triple Nand 3 inputs',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4025',dest=TEMPLATE,tool=SKIDL,keywords='CMOS Nor3',description='Triple Nor 3 inputs',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='~',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4027',dest=TEMPLATE,tool=SKIDL,keywords='CMOS JK JKFF',description='Dual JK FlipFlop, set & reset',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Cp',do_erc=True),
            Pin(num='4',name='Cd',do_erc=True),
            Pin(num='5',name='K',do_erc=True),
            Pin(num='6',name='J',do_erc=True),
            Pin(num='7',name='Sd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Sd',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='J',do_erc=True),
            Pin(num='11',name='K',do_erc=True),
            Pin(num='12',name='Cd',do_erc=True),
            Pin(num='13',name='Cp',do_erc=True),
            Pin(num='14',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4028',dest=TEMPLATE,tool=SKIDL,keywords='CMOS DECOD DECOD10',description='Decoder 4 to 10 lines',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='S4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='S2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='S0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='S7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='S9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='S5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='S6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='S8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='A',do_erc=True),
            Pin(num='11',name='D',do_erc=True),
            Pin(num='12',name='C',do_erc=True),
            Pin(num='13',name='B',do_erc=True),
            Pin(num='14',name='S1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='S3',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4029',dest=TEMPLATE,tool=SKIDL,keywords='CMOS COUNTER',description='Up/Down Counter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='PE',do_erc=True),
            Pin(num='2',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='J4',do_erc=True),
            Pin(num='4',name='J1',do_erc=True),
            Pin(num='5',name='Cin',do_erc=True),
            Pin(num='6',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Cout',do_erc=True),
            Pin(num='9',name='B/D',do_erc=True),
            Pin(num='10',name='U/D',do_erc=True),
            Pin(num='11',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='J2',do_erc=True),
            Pin(num='13',name='J3',do_erc=True),
            Pin(num='14',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='CK',do_erc=True)]),
        Part(name='4040',dest=TEMPLATE,tool=SKIDL,keywords='CMOS CNT CNT12',description='Binary Counter 12 stages (Asynchronous)',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Q11',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Q5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q6',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='Q0',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='CLK',do_erc=True),
            Pin(num='11',name='Reset',do_erc=True),
            Pin(num='12',name='Q8',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q7',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q9',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Q10',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4046',dest=TEMPLATE,tool=SKIDL,keywords='CMOS PLL',description='Phase Comp & VCO',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PCP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='PC1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='SigIn',do_erc=True),
            Pin(num='4',name='FOUT',do_erc=True),
            Pin(num='5',name='Inh',do_erc=True),
            Pin(num='6',name='C1',do_erc=True),
            Pin(num='7',name='C2',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='VCOin',do_erc=True),
            Pin(num='10',name='SFout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='R1',do_erc=True),
            Pin(num='12',name='R2',do_erc=True),
            Pin(num='13',name='PC2',func=Pin.TRISTATE,do_erc=True),
            Pin(num='14',name='RefIn',do_erc=True),
            Pin(num='15',name='ZOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='4049',dest=TEMPLATE,tool=SKIDL,keywords='CMOS BUFFER',description='Hex Buffer Inverter',ref_prefix='U',num_units=6,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4050',dest=TEMPLATE,tool=SKIDL,keywords='CMOS BUFFER',description='Hex Buffer',ref_prefix='U',num_units=6,do_erc=True,pins=[
            Pin(num='1',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='~',do_erc=True),
            Pin(num='15',name='~',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='4051',dest=TEMPLATE,tool=SKIDL,keywords='CMOS MUX MUX8',description='Analog Multiplexer 8 to 1 lins',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='X4',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='X6',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='X',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='X7',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='X5',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Inh',do_erc=True),
            Pin(num='7',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='C',do_erc=True),
            Pin(num='10',name='B',do_erc=True),
            Pin(num='11',name='A',do_erc=True),
            Pin(num='12',name='X3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='X0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='X1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='X2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='4052',dest=TEMPLATE,tool=SKIDL,keywords='CMOS MUX MUX4',description='Dual Analog Multiplexer 4 to 1 line',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Y0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='Y2',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Y',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='Y3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='Y1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Inh',do_erc=True),
            Pin(num='7',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='B',do_erc=True),
            Pin(num='10',name='A',do_erc=True),
            Pin(num='11',name='X3',func=Pin.PASSIVE,do_erc=True),
            Pin(num='12',name='X0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='X',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='X1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='X2',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='4053',dest=TEMPLATE,tool=SKIDL,keywords='CMOS MUX MUX2',description='Triple analog Multiplexer 2 to 1 line',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='Y1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='2',name='Y0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='3',name='Z1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='4',name='Z',func=Pin.PASSIVE,do_erc=True),
            Pin(num='5',name='Z0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='6',name='Inh',do_erc=True),
            Pin(num='7',name='VEE',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='C',do_erc=True),
            Pin(num='10',name='B',do_erc=True),
            Pin(num='11',name='A',do_erc=True),
            Pin(num='12',name='X0',func=Pin.PASSIVE,do_erc=True),
            Pin(num='13',name='X1',func=Pin.PASSIVE,do_erc=True),
            Pin(num='14',name='X',func=Pin.PASSIVE,do_erc=True),
            Pin(num='15',name='Y',func=Pin.PASSIVE,do_erc=True)]),
        Part(name='4069',dest=TEMPLATE,tool=SKIDL,keywords='CMOD NOT',description='Hex inverter',ref_prefix='U',num_units=6,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4070',dest=TEMPLATE,tool=SKIDL,keywords='CMOS XOR2',description='Quad Xor 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4071',dest=TEMPLATE,tool=SKIDL,keywords='CMOS OR2',description='Quad Or 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4072',dest=TEMPLATE,tool=SKIDL,keywords='CMOS OR4',description='Dual 4 input OR gate',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='1',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4073',dest=TEMPLATE,tool=SKIDL,keywords='CMOS And3',description='Triple And 3 inputs',ref_prefix='U',num_units=3,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='~',do_erc=True),
            Pin(num='4',name='~',do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4077',dest=TEMPLATE,tool=SKIDL,keywords='CMOS XOR XNOR XNOR2',description='Quad Xnor 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4081',dest=TEMPLATE,tool=SKIDL,keywords='CMOS And2',description='Quad And 2 inputs',ref_prefix='U',num_units=4,do_erc=True,pins=[
            Pin(num='7',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True),
            Pin(num='1',name='~',do_erc=True),
            Pin(num='2',name='~',do_erc=True),
            Pin(num='3',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='~',do_erc=True),
            Pin(num='6',name='~',do_erc=True),
            Pin(num='8',name='~',do_erc=True),
            Pin(num='9',name='~',do_erc=True),
            Pin(num='10',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='~',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='~',do_erc=True),
            Pin(num='13',name='~',do_erc=True)]),
        Part(name='4510',dest=TEMPLATE,tool=SKIDL,keywords='CMOS CNT CNT4',description='4 bits programmable counter',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='PE',do_erc=True),
            Pin(num='2',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='A4',do_erc=True),
            Pin(num='4',name='A1',do_erc=True),
            Pin(num='5',name='CI',do_erc=True),
            Pin(num='6',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='CO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='RST',do_erc=True),
            Pin(num='10',name='U/D',do_erc=True),
            Pin(num='11',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='A2',do_erc=True),
            Pin(num='13',name='A3',do_erc=True),
            Pin(num='14',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='CLK',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='4518',dest=TEMPLATE,tool=SKIDL,keywords='CMOS',description='Dual BCD Up-Counter',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='1',name='CK',do_erc=True),
            Pin(num='2',name='Enable',do_erc=True),
            Pin(num='3',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Reset',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CK',do_erc=True),
            Pin(num='10',name='Enable',do_erc=True),
            Pin(num='11',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Reset',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='4520',dest=TEMPLATE,tool=SKIDL,keywords='CMOS',description='Dual Binary Up-Counter',ref_prefix='U',num_units=2,do_erc=True,pins=[
            Pin(num='1',name='CK',do_erc=True),
            Pin(num='2',name='Enable',do_erc=True),
            Pin(num='3',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='5',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='Reset',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='CK',do_erc=True),
            Pin(num='10',name='Enable',do_erc=True),
            Pin(num='11',name='Q1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='12',name='Q2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='Q3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='Q4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='Reset',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='4538',dest=TEMPLATE,tool=SKIDL,keywords='CMOS',description='Monostable',ref_prefix='U',num_units=2,do_erc=True,aliases=['4528', '14528', '14538'],pins=[
            Pin(num='1',name='gnd',do_erc=True),
            Pin(num='2',name='RxCx',do_erc=True),
            Pin(num='3',name='R',do_erc=True),
            Pin(num='4',name='Clk+',do_erc=True),
            Pin(num='5',name='Clk-',do_erc=True),
            Pin(num='6',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='7',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='Q',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='Clk-',do_erc=True),
            Pin(num='12',name='Clk+',do_erc=True),
            Pin(num='13',name='R',do_erc=True),
            Pin(num='14',name='RxCx',do_erc=True),
            Pin(num='15',name='gnd',do_erc=True),
            Pin(num='16',name='VDD',func=Pin.PWRIN,do_erc=True)])])
