from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

NXP = SchLib(tool=SKIDL).add_parts(*[
        Part(name='PCA9536D',dest=TEMPLATE,tool=SKIDL,keywords='i2c io port',description='4-bit I2C-bus and SMBus IO port, SOIC8 package',ref_prefix='U',num_units=1,fplist=['SOIC*3.9x4.9mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='IO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCA9536DP',dest=TEMPLATE,tool=SKIDL,keywords='i2c io port',description='4-bit I2C-bus and SMBus IO port, TSSOP8 package',ref_prefix='U',num_units=1,fplist=['TSSOP*3x3mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='IO0',func=Pin.BIDIR,do_erc=True),
            Pin(num='2',name='IO1',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='IO2',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='IO3',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='VDD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCA9544AD',dest=TEMPLATE,tool=SKIDL,keywords='i2c multiplexer',description='4-channel I2C-bus multiplexer with interrupt logic, SOIC20 package',ref_prefix='U',num_units=1,fplist=['SOIC*7.5x12.8mm*Pitch1.27mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='~INT0',do_erc=True),
            Pin(num='5',name='SD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~INT1',do_erc=True),
            Pin(num='8',name='SD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~INT2',do_erc=True),
            Pin(num='12',name='SD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~INT3',do_erc=True),
            Pin(num='15',name='SD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='~INT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SDA',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PCA9544APW',dest=TEMPLATE,tool=SKIDL,keywords='i2c multiplexer',description='4-channel I2C-bus multiplexer with interrupt logic, TSSOP20 package',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x6.5mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='~INT0',do_erc=True),
            Pin(num='5',name='SD0',func=Pin.BIDIR,do_erc=True),
            Pin(num='6',name='SC0',func=Pin.BIDIR,do_erc=True),
            Pin(num='7',name='~INT1',do_erc=True),
            Pin(num='8',name='SD1',func=Pin.BIDIR,do_erc=True),
            Pin(num='9',name='SC1',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='11',name='~INT2',do_erc=True),
            Pin(num='12',name='SD2',func=Pin.BIDIR,do_erc=True),
            Pin(num='13',name='SC2',func=Pin.BIDIR,do_erc=True),
            Pin(num='14',name='~INT3',do_erc=True),
            Pin(num='15',name='SD3',func=Pin.BIDIR,do_erc=True),
            Pin(num='16',name='SC3',func=Pin.BIDIR,do_erc=True),
            Pin(num='17',name='~INT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='18',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='SDA',func=Pin.BIDIR,do_erc=True)]),
        Part(name='PCA9685BS',dest=TEMPLATE,tool=SKIDL,keywords='PWM LED driver I2C QFN',description='16-channel 12-bit PWM Fm+ I2C-bus LED controller RGBA QFN',ref_prefix='U',num_units=1,fplist=['QFN*6x6mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='A3',do_erc=True),
            Pin(num='5',name='A4',do_erc=True),
            Pin(num='6',name='OUT0',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='OUT1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='OUT2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='OUT3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='20',name='OUT13',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='OUT5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='21',name='OUT14',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='OUT6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='22',name='OUT15',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='OUT7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='23',name='~OE~',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A5',do_erc=True),
            Pin(num='15',name='OUT8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='25',name='EXTCLK',do_erc=True),
            Pin(num='16',name='OUT9',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='26',name='SCL',do_erc=True),
            Pin(num='17',name='OUT10',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='27',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='OUT11',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='OUT12',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='29',name='GND',func=Pin.PWRIN,do_erc=True)]),
        Part(name='PCA9685PW',dest=TEMPLATE,tool=SKIDL,keywords='PWM LED driver I2C TSSOP',description='16-channel 12-bit PWM Fm+ I2C-bus LED controller RGBA TSSOP',ref_prefix='U',num_units=1,fplist=['TSSOP*4.4x9.7mm*Pitch0.65mm*'],do_erc=True,pins=[
            Pin(num='1',name='A0',do_erc=True),
            Pin(num='2',name='A1',do_erc=True),
            Pin(num='3',name='A2',do_erc=True),
            Pin(num='4',name='A3',do_erc=True),
            Pin(num='5',name='A4',do_erc=True),
            Pin(num='6',name='OUT0',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='7',name='OUT1',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='OUT2',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='9',name='OUT3',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='10',name='OUT4',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='20',name='OUT13',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='OUT5',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='21',name='OUT14',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='OUT6',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='22',name='OUT15',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='13',name='OUT7',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='23',name='~OE~',do_erc=True),
            Pin(num='14',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='24',name='A5',do_erc=True),
            Pin(num='15',name='OUT8',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='25',name='EXTCLK',do_erc=True),
            Pin(num='16',name='OUT9',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='26',name='SCL',do_erc=True),
            Pin(num='17',name='OUT10',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='27',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='18',name='OUT11',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='28',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='OUT12',func=Pin.OPENCOLL,do_erc=True)])])
