<p align="center">
  <a href="https://datapane.com">
    <img src="https://datapane-cdn.com/static/v1/datapane-logo-dark.svg.br" width="250px" alt="Datapane" />
  </a>
</p>
<p align="center">
  <a href="https://datapane.com/cloud">Cloud</a> |
  <a href="https://docs.datapane.com">Docs</a> |
      <a href="#demos-and-examples">Examples</a> |
  <a href="https://datapane.nolt.io">Roadmap</a> | <a href="https://forum.datapane.com">Forum</a> |
  <a href="https://chat.datapane.com">Discord</a>
</p>
<p align='center'>
  <a href="https://pypi.org/project/datapane/">
      <img src="https://img.shields.io/pypi/dm/datapane?label=pip%20downloads" alt="Pip Downloads" />
  </a>
  <a href="https://pypi.org/project/datapane/">
      <img src="https://img.shields.io/pypi/v/datapane?color=blue" alt="Latest release" />
  </a>
  <a href="https://anaconda.org/conda-forge/datapane">
      <img alt="Conda (channel only)" src="https://img.shields.io/conda/vn/conda-forge/datapane">
  </a>
</p>

---

## Welcome to the Datapane Component Repository

Hi there! 👋

This repository contains our collection of reusable components for use in your Datapane Reports and Apps.

### For Users

1. Run `pip install datapane-components`
1. In your code, import the library
```python
import datapane as dp
import datapane_components as dc

...
```

### For Contributors

1. Clone this repo
1. Install the dependencies via `poetry install`
1. Make changes
1. Submit your PR

This package is released on a regular time-based schedule.

## Resources

We're here to help you get up and running with Datapane. Check out the [Datapane quickstart repo](https://github.com/datapane/dp-quickstart/) to get started, or visit any of the resources below.

- [Join Discord](https://chat.datapane.com)
- [Sign up for a free account](https://datapane.com/accounts/signup)
- [Read the documentation](https://docs.datapane.com)
- [Ask a question](https://forum.datapane.com/)


## What makes Datapane special?

<p align="center">
  <a href="https://datapane.com">
    <img src="https://user-images.githubusercontent.com/3541695/176545400-919a327d-ddee-4755-b29f-bf85fbfdb4ef.png"  width='75%'>
  </a>
</p>

- **Static generation:** Sharing an app shouldn't require deploying an app. Render a standalone HTML bundle which you can share or host on the web.
- **API-first and programmatic:** Programmatically generate apps from inside of Spark, Airflow, or Jupyter. Schedule updates to build real-time dashboards.
- **Dynamic front-end components**: Say goodbye to writing HTML. Build apps from a set of interactive components, like DataTables, tabs, and selects.
