import math
from datetime import datetime, timedelta


def convert_size(size_bytes):
    if size_bytes == 0:
        return "0B"
    size_name = ("B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB")
    i = int(math.floor(math.log(size_bytes, 1024)))
    p = math.pow(1024, i)
    s = round(size_bytes / p, 2)
    return "%s %s" % (s, size_name[i])


def get_or_default(array, walk_through_count, default_value=0):
    try:
        return array[walk_through_count]
    except IndexError:
        return default_value
