/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.PathAnalystSetting;
import com.supermap.analyst.networkanalyst.SSCPathAnalystSettingNative;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;

public class SSCPathAnalystSetting
extends PathAnalystSetting {
    private DatasetVector m_networkDataset;
    private String m_sscFilePath;
    private double m_tolerance;
    private boolean m_bReset;
    private boolean m_bLoad;

    public SSCPathAnalystSetting() {
        this.setHandle(0L);
        long l = SSCPathAnalystSettingNative.jni_New();
        this.setHandle(l, true);
        this.m_bReset = true;
        this.m_bLoad = false;
        this.m_tolerance = 0.0;
    }

    public SSCPathAnalystSetting(DatasetVector datasetNetwork, String sscFilePath) {
        this();
        this.setSSCFilePath(sscFilePath);
        this.setNetworkDataset(datasetNetwork);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            SSCPathAnalystSettingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    @Override
    public DatasetVector getNetworkDataset() {
        return this.m_networkDataset;
    }

    public SSCPathAnalystSetting setNetworkDataset(DatasetVector value) {
        if (value != null && value.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("value", "DatasetTypeMustBeNetwork", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (value != this.m_networkDataset) {
            this.m_bReset = true;
        }
        this.m_networkDataset = value;
        return this;
    }

    public SSCPathAnalystSetting setSSCFilePath(String sscFilePath) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SSCPathAnalystSetting", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (sscFilePath == null || sscFilePath.isEmpty()) {
            String string = InternalResource.loadString("sscFilePath", "Global_ArgumentNull", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (!sscFilePath.trim().equals(this.m_sscFilePath)) {
            this.m_bReset = true;
        }
        this.m_sscFilePath = sscFilePath;
        return this;
    }

    public String getSSCFilePath() {
        return this.m_sscFilePath;
    }

    public SSCPathAnalystSetting setTolerance(double tolerance) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SSCPathAnalystSetting", "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (tolerance < 0.0) {
            String string = InternalResource.loadString("tolerance", "MustBeEqualOrGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_tolerance != tolerance) {
            this.m_bReset = true;
        }
        this.m_tolerance = tolerance;
        return this;
    }

    public double getTolerance() {
        if (this.m_bLoad && this.getHandle() != 0L) {
            return SSCPathAnalystSettingNative.jni_getTolerance(this.getHandle());
        }
        return this.m_tolerance;
    }

    @Override
    boolean load() {
        if (this.m_bReset) {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_networkDataset);
            SSCPathAnalystSettingNative.jni_setTolerance(this.getHandle(), this.m_tolerance);
            this.m_bLoad = SSCPathAnalystSettingNative.jni_connectData(this.getHandle(), this.m_sscFilePath, l);
            if (this.m_bLoad) {
                this.m_bReset = false;
            }
        }
        return this.m_bLoad;
    }
}

