/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandleDisposable;
import com.supermap.analyst.networkanalyst.MultiTransportationAnalystPoint;
import com.supermap.analyst.networkanalyst.TransportationAnalystParameterNative;

public class MultiTransportationAnalystParameter
extends InternalHandleDisposable {
    private MultiTransportationAnalystPoint[] m_points = null;
    private String m_weightName = "";
    private String m_turnWeightField = "";
    private boolean m_isRoutesReturn = false;
    private boolean m_isNodesReturn = false;
    private boolean m_isEdgesReturn = false;
    private boolean m_isPathGuidesReturn = false;
    private boolean m_isStopsReturn = false;
    private boolean m_isAlt = false;

    public MultiTransportationAnalystParameter() {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
    }

    void reset() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_Reset(l);
        }
    }

    public MultiTransportationAnalystParameter(MultiTransportationAnalystParameter transportationAnalystParameter) {
        long l = TransportationAnalystParameterNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.copyFrom(transportationAnalystParameter);
    }

    void copyFrom(MultiTransportationAnalystParameter value) {
        if (value != null) {
            this.setPoints(value.getPoints());
            this.setWeightName(value.getWeightName());
            this.setTurnWeightField(value.getTurnWeightField());
            this.setNodesReturn(value.isNodesReturn());
            this.setEdgesReturn(value.isEdgesReturn());
            this.setPathGuidesReturn(value.isPathGuidesReturn());
            this.setRoutesReturn(value.isRoutesReturn());
            this.setStopIndexesReturn(value.isStopIndexesReturn());
            this.setAlternative(value.isAlternative());
        }
    }

    protected long getHandle() {
        long l = super.getHandle();
        if (l != 0L) {
            TransportationAnalystParameterNative.jni_SetIsRoutesReturn(l, this.m_isRoutesReturn);
            TransportationAnalystParameterNative.jni_SetIsNodesReturn(l, this.m_isNodesReturn);
            TransportationAnalystParameterNative.jni_SetIsEdgesReturn(l, this.m_isEdgesReturn);
            TransportationAnalystParameterNative.jni_SetIsPathGuidesReturn(l, this.m_isPathGuidesReturn);
            TransportationAnalystParameterNative.jni_SetIsStopsReturn(l, this.m_isStopsReturn);
            if (this.m_points != null && this.m_points.length > 0) {
                int n = this.m_points.length;
                double[] dArray = new double[n];
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = this.m_points[i].getPoint().x;
                    dArray2[i] = this.m_points[i].getPoint().y;
                }
                TransportationAnalystParameterNative.jni_SetPoints(l, dArray, dArray2);
            }
            TransportationAnalystParameterNative.jni_SetWeightName(l, this.m_weightName);
            TransportationAnalystParameterNative.jni_SetTurnWeightField(l, this.m_turnWeightField);
            TransportationAnalystParameterNative.jni_SetIsAlternative(l, this.m_isAlt);
        }
        return l;
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            TransportationAnalystParameterNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public boolean isRoutesReturn() {
        return this.m_isRoutesReturn;
    }

    public void setRoutesReturn(boolean value) {
        this.m_isRoutesReturn = value;
    }

    public boolean isNodesReturn() {
        return this.m_isNodesReturn;
    }

    public void setNodesReturn(boolean value) {
        this.m_isNodesReturn = value;
    }

    public boolean isEdgesReturn() {
        return this.m_isEdgesReturn;
    }

    public void setEdgesReturn(boolean value) {
        this.m_isEdgesReturn = value;
    }

    public boolean isPathGuidesReturn() {
        return this.m_isPathGuidesReturn;
    }

    public void setPathGuidesReturn(boolean value) {
        this.m_isPathGuidesReturn = value;
    }

    public boolean isStopIndexesReturn() {
        return this.m_isStopsReturn;
    }

    public void setStopIndexesReturn(boolean value) {
        this.m_isStopsReturn = value;
    }

    public MultiTransportationAnalystPoint[] getPoints() {
        if (this.m_points != null) {
            return (MultiTransportationAnalystPoint[])this.m_points.clone();
        }
        return null;
    }

    public void setPoints(MultiTransportationAnalystPoint[] value) {
        if (value == null) {
            this.m_points = null;
        } else {
            int n = value.length;
            this.m_points = new MultiTransportationAnalystPoint[n];
            for (int i = 0; i < n; ++i) {
                this.m_points[i] = value[i];
            }
        }
    }

    public String getWeightName() {
        return this.m_weightName;
    }

    public void setWeightName(String value) {
        this.m_weightName = value;
    }

    public String getTurnWeightField() {
        return this.m_turnWeightField;
    }

    public void setTurnWeightField(String value) {
        this.m_turnWeightField = value;
    }

    private boolean isAlternative() {
        return this.m_isAlt;
    }

    private void setAlternative(boolean value) {
        this.m_isAlt = value;
    }
}

