/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.networkanalyst;

import com.supermap.analyst.networkanalyst.InternalHandle;
import com.supermap.analyst.networkanalyst.InternalResource;
import com.supermap.analyst.networkanalyst.MapMatchingResultNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;

public class MapMatchingResult {
    private Point2D[] m_rectifyPoints;
    private Point2D[] m_trackPoints;
    private int[] m_edges;
    private PrjCoordSys m_prj;

    private MapMatchingResult(Point2D[] rectifyPoints, Point2D[] trackPoints, int[] edges, PrjCoordSys prj) {
        this.m_rectifyPoints = rectifyPoints;
        this.m_trackPoints = trackPoints;
        this.m_edges = edges;
        this.m_prj = prj;
    }

    public Point2D[] getRectifiedPoints() {
        return this.m_rectifyPoints;
    }

    public Point2D[] getTrackPoints() {
        return this.m_trackPoints;
    }

    public GeoLine getTrackLine() {
        if (this.m_trackPoints != null && this.m_trackPoints.length > 1) {
            return new GeoLine(new Point2Ds(this.m_trackPoints));
        }
        return null;
    }

    public int[] getEdges() {
        return this.m_edges;
    }

    public double evaluateTruth(GeoLine[] truthEdges) {
        if (truthEdges == null) {
            String string = InternalResource.loadString("truthEdges", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_trackPoints == null) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (truthEdges.length == 0) {
            String string = InternalResource.loadString("truthEdges", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_trackPoints.length == 0) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[truthEdges.length];
        for (int i = 0; i < truthEdges.length; ++i) {
            if (truthEdges[i] == null) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]) == 0L) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]);
        }
        long l = this.m_prj != null ? InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_prj) : 0L;
        double[] dArray = new double[this.m_trackPoints.length];
        double[] dArray2 = new double[this.m_trackPoints.length];
        for (int i = 0; i < this.m_trackPoints.length; ++i) {
            dArray[i] = this.m_trackPoints[i].x;
            dArray2[i] = this.m_trackPoints[i].y;
        }
        return MapMatchingResultNative.jni_EvaluationTruth(lArray, dArray, dArray2, l);
    }

    public double evaluateError(GeoLine[] truthEdges) {
        if (truthEdges == null) {
            String string = InternalResource.loadString("truthEdges", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (this.m_trackPoints == null) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArgumentNull", "networkanalyst_resources");
            throw new NullPointerException(string);
        }
        if (truthEdges.length == 0) {
            String string = InternalResource.loadString("truthEdges", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.m_trackPoints.length == 0) {
            String string = InternalResource.loadString("TrackPoints", "Global_ArrayLengthShouldGreaterThanZero", "networkanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = new long[truthEdges.length];
        for (int i = 0; i < truthEdges.length; ++i) {
            if (truthEdges[i] == null) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentNull", "networkanalyst_resources");
                throw new NullPointerException(string);
            }
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]) == 0L) {
                String string = InternalResource.loadString(String.format("truthEdges[%d]", i), "Global_ArgumentObjectHasBeenDisposed", "networkanalyst_resources");
                throw new IllegalStateException(string);
            }
            lArray[i] = InternalHandle.getHandle((com.supermap.data.InternalHandle)truthEdges[i]);
        }
        long l = this.m_prj != null ? InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_prj) : 0L;
        double[] dArray = new double[this.m_trackPoints.length];
        double[] dArray2 = new double[this.m_trackPoints.length];
        for (int i = 0; i < this.m_trackPoints.length; ++i) {
            dArray[i] = this.m_trackPoints[i].x;
            dArray2[i] = this.m_trackPoints[i].y;
        }
        return MapMatchingResultNative.jni_EvaluationError(lArray, dArray, dArray2, l);
    }

    static MapMatchingResult parse(long handle, boolean isDisposeHandle, PrjCoordSys prjCoordSys) {
        if (handle == 0L) {
            return null;
        }
        boolean[] blArray = MapMatchingResultNative.jni_GetMatchingResultValid(handle);
        double[] dArray = MapMatchingResultNative.jni_GetMatchingResultRectifyPoints(handle);
        Point2D[] point2DArray = null;
        if (dArray.length == blArray.length * 2) {
            point2DArray = new Point2D[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                point2DArray[i] = blArray[i] ? new Point2D(dArray[2 * i], dArray[2 * i + 1]) : null;
            }
        } else {
            point2DArray = new Point2D[]{};
        }
        double[] dArray2 = MapMatchingResultNative.jni_GetMatchingResultRoutePoints(handle);
        int n = dArray2.length / 2;
        Point2D[] point2DArray2 = new Point2D[n];
        for (int i = 0; i < n; ++i) {
            point2DArray2[i] = new Point2D(dArray2[2 * i], dArray2[2 * i + 1]);
        }
        int[] nArray = MapMatchingResultNative.jni_GetEdges(handle);
        if (isDisposeHandle) {
            MapMatchingResultNative.jni_Delete(handle);
        }
        return new MapMatchingResult(point2DArray, point2DArray2, nArray, prjCoordSys);
    }
}

