/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel;
import com.supermap.data.GeoModel3D;
import com.supermap.data.GeoRegion3D;
import com.supermap.data.Geometry;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.AnalysisQuality;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalGeoModel;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.SkylineDisplayMode;
import com.supermap.realspace.spatialanalyst.SkylineNative;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class Skyline
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Point3D m_viewerPosition = new Point3D(0.0, 0.0, 0.0);
    private Color m_color;
    private AnalysisQuality m_quality;
    private SkylineDisplayMode m_displayStyle = SkylineDisplayMode.LINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public Skyline(Scene scene) {
        Skyline.verifyLicense();
        this.m_scene = scene;
        long l = SkylineNative.jni_New("");
        this.setHandle(l, true);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            SkylineNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    public Point3D getViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_viewerPosition;
    }

    public void setViewerPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetViewerPosition(this.getHandle(), position.getX(), position.getY(), position.getZ());
        this.m_viewerPosition = position;
    }

    public double getDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDirection()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetDirection(this.getHandle());
    }

    public void setDirection(double direction) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDirection()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetDirection(this.getHandle(), direction);
    }

    public double getPitch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHiddenColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetPitch(this.getHandle());
    }

    public void setPitch(double pitch) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPitch()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetPitch(this.getHandle(), pitch);
    }

    public Color getColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_color;
    }

    public void setColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleAreaColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetColor(this.getHandle(), color.getRGB());
        this.m_color = color;
    }

    public AnalysisQuality getQuality() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAnalysisQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_quality;
    }

    public void setQuality(AnalysisQuality quality) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAnalysisQuality()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(quality);
        SkylineNative.jni_SetAnalysisQuality(this.getHandle(), n);
        this.m_quality = quality;
    }

    public SkylineDisplayMode getDisplayStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_displayStyle;
    }

    public void setDisplayStyle(SkylineDisplayMode displayMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(displayMode);
        SkylineNative.jni_SetDisplayStyle(this.getHandle(), n);
        this.m_displayStyle = displayMode;
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public GeoLine3D getSkyline() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSkyline()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry = null;
        long l = SkylineNative.jni_GetSkyline(this.getHandle());
        if (l != 0L) {
            geometry = InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        GeoLine3D geoLine3D = (GeoLine3D)geometry;
        return geoLine3D;
    }

    public void locateToViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("locateToViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_LocateToViewerPosition(this.getHandle());
    }

    public int AddLimitBody(GeoRegion3D region3d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("AddLimitBody()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)region3d);
        if (l == 0L) {
            String string = InternalResource.loadString("region3d", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion3D geoRegion3D = region3d.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion3D, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion3D);
        int n = SkylineNative.jni_AddLimitBody(this.getHandle(), l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region3d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion3D);
        return n;
    }

    public int getLimitBodyCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLimitBodyCount()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetLimitBodyCount(this.getHandle());
    }

    public void setLimitBody(int index, GeoRegion3D region3d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLimitBody()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLimitBodyCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("setLimitBody()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)region3d);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRegion3D geoRegion3D = region3d.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion3D, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion3D);
        SkylineNative.jni_SetLimitBody(this.getHandle(), index, l2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)region3d);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoRegion3D);
    }

    public GeoRegion3D getLimitRegion(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLimitRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLimitBodyCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("getLimitRegion()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion3D geoRegion3D = null;
        long l = SkylineNative.jni_GetLimitRegion(this.getHandle(), index);
        if (l != 0L) {
            geoRegion3D = (GeoRegion3D)InternalGeometry.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoRegion3D, true);
        }
        return geoRegion3D;
    }

    public boolean removeLimitBody(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeLimitBody()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLimitBodyCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("removeLimitBody()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_RemoveLimitBody(this.getHandle(), index);
    }

    public void removeAllLimitBodies() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAllLimitBodies()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_RemoveAllLimitBodies(this.getHandle());
    }

    public GeoModel getLimitModel(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLimitModel()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getLimitBodyCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("getLimitModel()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = SkylineNative.jni_GetLimitModel(this.getHandle(), index);
        GeoModel geoModel = null;
        if (l != 0L) {
            geoModel = InternalGeoModel.createInstance(l);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geoModel, true);
        }
        return geoModel;
    }

    public void setViewerVisible(boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetViewerVisible(this.getHandle(), visible);
    }

    public int getInViewport() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetInViewport(this.getHandle());
    }

    public void setInViewport(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetInViewport(this.getHandle(), value);
    }

    public boolean getLookAround() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetLookAround(this.getHandle());
    }

    public void setLookAround(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetLookAround(this.getHandle(), value);
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SkylineNative.jni_GetRaduis(this.getHandle());
    }

    public void setRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SkylineNative.jni_SetRaduis(this.getHandle(), value);
    }

    public GeoLine getSkyline2D() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoLine geoLine = null;
        long l = SkylineNative.jni_GetSkyline2D(this.getHandle());
        if (l != 0L) {
            geoLine = (GeoLine)InternalGeometry.createInstance(l);
        }
        return geoLine;
    }

    public GeoModel3D getSkylineSector() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = SkylineNative.jni_GetSkylineSector(this.getHandle());
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public GeoModel3D getSkylineSector(double dSectorRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = SkylineNative.jni_GetSkylineSector(this.getHandle(), dSectorRadius);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public GeoModel3D getSkylineSectorBody(double dHeight) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = SkylineNative.jni_GetSkylineSectorBody(this.getHandle(), dHeight);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public GeoModel3D getSkylineSectorBody(double dHeight, double dBodyRadius) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        GeoModel3D geoModel3D = null;
        long l = SkylineNative.jni_GetSkylineSectorBody(this.getHandle(), dHeight, dBodyRadius);
        if (l != 0L) {
            geoModel3D = (GeoModel3D)InternalGeometry.createInstance(l);
        }
        return geoModel3D;
    }

    public void getObjsVisible(HashMap<String, int[]> value) {
        if (this.m_scene == null) {
            String string = InternalResource.loadString("Skyline", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene);
        if (l == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Skyline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_scene.getTrackingLayer() != null) {
            bl = this.m_scene.getTrackingLayer().isVisible();
            this.m_scene.getTrackingLayer().setVisible(false);
        }
        int[] nArray = new int[1];
        long l2 = SkylineNative.jni_GetObjsVisibleLength(this.getHandle(), l, nArray);
        String[] stringArray = new String[nArray[0]];
        Object[] objectArray = new Object[nArray[0]];
        SkylineNative.jni_GetObjsVisible(l, l2, stringArray, objectArray);
        if (this.m_scene.getTrackingLayer() != null) {
            this.m_scene.getTrackingLayer().setVisible(bl);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            value.put(stringArray[i], (int[])objectArray[i]);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

