/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.AltitudeMode;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Point2D;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ProfileAnalystNative;
import java.util.ArrayList;

public class ProfileAnalyst {
    private static License m_license;

    private ProfileAnalyst() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static DatasetVector calculatePlumbProfile(Point2D startPoint, Point2D endPoint, DatasetVector[] modelDatasets, DatasetGrid surfaceGrid, Datasource targetDatasource, String targetDatasetName, AltitudeMode altitudeMode) {
        double d;
        double d2;
        double d3;
        int n;
        ProfileAnalyst.verifyLicense();
        if (startPoint.getX() > 180.0 || startPoint.getX() < -180.0 || startPoint.getY() > 90.0 || startPoint.getY() < -90.0) {
            String string = InternalResource.loadString("startPoint", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (endPoint.getX() > 180.0 || endPoint.getX() < -180.0 || endPoint.getY() > 90.0 || endPoint.getY() < -90.0) {
            String string = InternalResource.loadString("endPoint", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint == endPoint) {
            String string = InternalResource.loadString("startPoint & endPoint", "StartPoint_CannotEqualTo_EndPoint", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        if (0L == l) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        long[] lArray = null;
        if (modelDatasets != null && (n = modelDatasets.length) != 0) {
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                long l2;
                if (modelDatasets[i] == null || modelDatasets[i].getType() != DatasetType.CAD || (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelDatasets[i])) == 0L) continue;
                lArray[i] = l2;
                bl = true;
            }
        }
        long l3 = 0L;
        if (surfaceGrid != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
            bl = true;
        }
        if (!bl) {
            String string = InternalResource.loadString("modelDatasets & surfaceGrid", "NoValidDataset", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        double d4 = startPoint.getX();
        long l4 = ProfileAnalystNative.jni_CalculatePlumbProfile(d4, d3 = startPoint.getY(), d2 = endPoint.getX(), d = endPoint.getY(), lArray, l3, l, targetDatasetName, altitudeMode.value());
        if (l4 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            return datasetVector;
        }
        return null;
    }

    public static DatasetVector calculatePlumbProfile(Point2D startPoint, Point2D endPoint, DatasetVector[] modelDatasets, DatasetGrid surfaceGrid, Datasource targetDatasource, String targetDatasetName) {
        double d;
        double d2;
        double d3;
        int n;
        ProfileAnalyst.verifyLicense();
        if (startPoint.getX() > 180.0 || startPoint.getX() < -180.0 || startPoint.getY() > 90.0 || startPoint.getY() < -90.0) {
            String string = InternalResource.loadString("startPoint", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (endPoint.getX() > 180.0 || endPoint.getX() < -180.0 || endPoint.getY() > 90.0 || endPoint.getY() < -90.0) {
            String string = InternalResource.loadString("endPoint", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (startPoint == endPoint) {
            String string = InternalResource.loadString("startPoint & endPoint", "StartPoint_CannotEqualTo_EndPoint", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        if (0L == l) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        long[] lArray = null;
        if (modelDatasets != null && (n = modelDatasets.length) != 0) {
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                long l2;
                if (modelDatasets[i] == null || modelDatasets[i].getType() != DatasetType.CAD || (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelDatasets[i])) == 0L) continue;
                lArray[i] = l2;
                bl = true;
            }
        }
        long l3 = 0L;
        if (surfaceGrid != null && InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid) != 0L) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)surfaceGrid);
            bl = true;
        }
        if (!bl) {
            String string = InternalResource.loadString("modelDatasets & surfaceGrid", "NoValidDataset", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (null == targetDatasetName) {
            String string = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        double d4 = startPoint.getX();
        long l4 = ProfileAnalystNative.jni_CalculatePlumbProfile(d4, d3 = startPoint.getY(), d2 = endPoint.getX(), d = endPoint.getY(), lArray, l3, l, targetDatasetName, AltitudeMode.ABSOLUTE.value());
        if (l4 != 0L) {
            DatasetVector datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
            return datasetVector;
        }
        return null;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

