/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3DNative;
import com.supermap.realspace.spatialanalyst.SearchMode;

public abstract class InterpolationParameter3D
extends InternalHandleDisposable {
    protected SearchMode m_searchMode;

    protected InterpolationParameter3D(InterpolationAlgorithmType algorithmType) {
        this(algorithmType, 0.0, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    protected InterpolationParameter3D(InterpolationAlgorithmType algorithmType, double resolution, SearchMode mode, double searchRadius, int expectedCount) {
        super.setHandle(InterpolationParameter3DNative.jni_New(InternalEnum.getUGCValue(algorithmType), resolution, InternalEnum.getUGCValue(mode), searchRadius, expectedCount), true);
        this.m_searchMode = mode;
        this.setBounds(Rectangle2D.getEMPTY());
    }

    protected InterpolationParameter3D(InterpolationAlgorithmType algorithmType, double resolution) {
        this(algorithmType, resolution, SearchMode.KDTREE_FIXED_COUNT, 0.0, 12);
    }

    public double getResolution() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getResolution()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetResolution(this.getHandle());
    }

    public void setResolution(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setResolution(double value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetResolution(this.getHandle(), value);
    }

    public SearchMode getSearchMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSearchMode()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_searchMode;
    }

    public void setSearchMode(SearchMode searchMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSearchMode(SearchMode searchMode)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(searchMode);
        InterpolationParameter3DNative.jni_SetSearchMode(this.getHandle(), n);
        this.m_searchMode = searchMode;
    }

    public double getSearchRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSearchRadius()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetSearchRadius(this.getHandle());
    }

    public void setSearchRadius(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSearchRadius(double value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetSearchRadius(this.getHandle(), value);
    }

    public int getExpectedCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getExpectedCount()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetExpectedCount(this.getHandle());
    }

    public void setExpectedCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setExpectedCount(int value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value <= 0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetExpectedCount(this.getHandle(), value);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        InterpolationParameter3DNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds(Rectangle2D rectangle2D)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            rectangle2D = Rectangle2D.getEMPTY();
        }
        double[] dArray = new double[]{rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop()};
        InterpolationParameter3DNative.jni_SetBounds(this.getHandle(), dArray);
    }

    public abstract InterpolationAlgorithmType getType();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Bounds={");
        stringBuffer.append(this.getBounds().toString());
        stringBuffer.append("},ExpectedCount=");
        stringBuffer.append(this.getExpectedCount());
        stringBuffer.append(",Resolution=");
        stringBuffer.append(this.getResolution());
        stringBuffer.append(",SearchMode=");
        stringBuffer.append(this.getSearchMode().name());
        stringBuffer.append(",SearchRadius=");
        stringBuffer.append(this.getSearchRadius());
        stringBuffer.append(",Type=");
        stringBuffer.append(this.getType().name());
        return stringBuffer.toString();
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            InterpolationParameter3DNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }

    public void setSliceAltitudes(double[] value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSliceAltitudes(double[] value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value.length < 1) {
            String string = InternalResource.loadString("value", "Global_ArrayLengthShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetSliceAltitudes(this.getHandle(), value);
    }

    public double[] getSliceAltitudes() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSliceAltitudes(double[] value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = InterpolationParameter3DNative.jni_GetSliceAltitudes(this.getHandle());
        return dArray;
    }
}

