/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.ResampleInformation;
import com.supermap.data.ResampleType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.spatialanalyst.DissolveParameter3D;
import com.supermap.realspace.spatialanalyst.Generalization3DNative;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.util.ArrayList;
import java.util.Vector;

public class Generalization3D {
    private static License m_license;
    private static transient Vector m_steppedListeners;

    private Generalization3D() {
    }

    public static DatasetVector dissolve(DatasetVector sourceDatasetVector, Datasource targetDatasource, String targetDatasetName, DissolveParameter3D dissolveParameter) {
        Generalization3D.verifyLicense();
        if (sourceDatasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector) == 0L) {
            String string = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (sourceDatasetVector.getType() != DatasetType.LINE3D) {
            String string = InternalResource.loadString("sourceDatasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        if (dissolveParameter == null) {
            String string = InternalResource.loadString("dissolveParameter", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDatasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter);
        long l4 = Generalization3DNative.jni_Dissolve(l, l2, targetDatasetName, l3);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static boolean resample(DatasetVector datasetVector, double tolerance) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.LINE3D && datasetType != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("datasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (tolerance <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        ResampleInformation resampleInformation = new ResampleInformation();
        resampleInformation.setResampleType(ResampleType.RTBEND);
        resampleInformation.setTolerance(tolerance);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resampleInformation);
        boolean bl = Generalization3DNative.jni_Resample(l, l2);
        resampleInformation.dispose();
        return bl;
    }

    public static boolean smooth(DatasetVector datasetVector, int smoothness) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.LINE3D && datasetType != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("datasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (smoothness < 2) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentShouldNotSmallerThanTwo", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        return Generalization3DNative.jni_Smooth(l, smoothness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener l) {
        if (m_steppedListeners == null) {
            m_steppedListeners = new Vector();
        }
        if (!m_steppedListeners.contains(l)) {
            m_steppedListeners.add(l);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener l) {
        if (m_steppedListeners != null && m_steppedListeners.contains(l)) {
            m_steppedListeners.remove(l);
        }
    }

    protected static void fireStepped(SteppedEvent event) {
        if (m_steppedListeners != null) {
            Vector vector = m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(int percent, long remainTime, String title, String message, long cancelHandle) {
        String string = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, percent, remainTime, title, message, string);
        Generalization3D.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
    }

    public static DatasetVector interpolateShape(DatasetGrid datasetGrid, DatasetVector datasetVector, Datasource targetDatasource, String targetDatasetName, double sampleDistance, double zFactor, boolean isVerticesOnly) {
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("datasetGrid", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("outputDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("outputDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (zFactor == 0.0) {
            String string = InternalResource.loadString("zFactor", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (datasetVector.getType() != DatasetType.LINE && datasetVector.getType() != DatasetType.POINT && datasetVector.getType() != DatasetType.REGION) {
            String string = InternalResource.loadString("datasetVector", "ArgumentInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        long l4 = Generalization3DNative.jni_InterpolateShape(l, l2, l3, targetDatasetName, true, sampleDistance, zFactor, isVerticesOnly);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

