/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Geometry;
import com.supermap.data.Rectangle2D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.ContourDisplayMode;
import com.supermap.realspace.spatialanalyst.ContourMapNative;
import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ContourMap
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private double m_interval = 100.0;
    private Color m_lineColor = new Color(0, 255, 255, 255);
    private Geometry m_coverageRegion = null;
    private double m_opacity = 1.0;
    private ContourDisplayMode m_displayMode = ContourDisplayMode.FACE_AND_LINE;
    private double m_minVisibleAltitude = 0.0;
    private double m_maxVisibleAltitude = 8844.43;
    private boolean m_borderVisible = false;
    private Color m_borderColor = Color.YELLOW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public ContourMap(Scene scene) {
        ContourMap.verifyLicense();
        this.m_scene = scene;
        long l = ContourMapNative.jni_New("");
        this.setHandle(l, true);
    }

    public double getInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getInterval()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_interval;
    }

    public void setInterval(double interval) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setInterval()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetInterval(this.getHandle(), interval);
        this.m_interval = interval;
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_lineColor;
    }

    public void setLineColor(Color lineColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLineColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetLineColor(this.getHandle(), lineColor.getRGB());
        this.m_lineColor = lineColor;
    }

    public Geometry getCoverageRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverageRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_coverageRegion;
    }

    public void setCoverageRegion(Geometry coverageRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCoverageRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (coverageRegion == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)coverageRegion);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry = coverageRegion.clone();
        InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, false);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        ContourMapNative.jni_SetCoverageRegion(this.getHandle(), l2);
        this.m_coverageRegion = geometry.clone();
    }

    public double getOpacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOpacity()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_opacity;
    }

    public void setOpacity(double opacity) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOpacity()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetOpacity(this.getHandle(), opacity);
        this.m_opacity = opacity;
    }

    public ContourDisplayMode getDisplayStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_displayMode;
    }

    public void setDisplayStyle(ContourDisplayMode mode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayStyle()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(mode);
        ContourMapNative.jni_SetDisplayStyle(this.getHandle(), n);
        this.m_displayMode = mode;
    }

    public double getMinVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMinVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_minVisibleAltitude;
    }

    public void setMinVisibleAltitude(double minVisibleAltitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMinVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetMinVisibleAltitude(this.getHandle(), minVisibleAltitude);
        this.m_minVisibleAltitude = minVisibleAltitude;
    }

    public double getMaxVisibleAltitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_maxVisibleAltitude;
    }

    public void setMaxVisibleAltitude(double maxVisibleAltitude) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxVisibleAltitude()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetMaxVisibleAltitude(this.getHandle(), maxVisibleAltitude);
        this.m_maxVisibleAltitude = maxVisibleAltitude;
    }

    public boolean isBorderVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isBorderVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_borderVisible;
    }

    public void setBorderVisible(boolean borderVisible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderVisible()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetBorderVisible(this.getHandle(), borderVisible);
        this.m_borderVisible = borderVisible;
    }

    public Color getBorderColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCoverageRegion()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBorderColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_SetBorderColor(this.getHandle(), borderColor.getRGB());
        this.m_borderColor = borderColor;
    }

    public void setColorDictTable(HashMap<Double, Color> colorTable) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = colorTable.size();
        double[] dArray = new double[n];
        int[] nArray = new int[n];
        Set<Map.Entry<Double, Color>> set = colorTable.entrySet();
        Iterator<Map.Entry<Double, Color>> iterator = set.iterator();
        Map.Entry<Double, Color> entry = null;
        for (int i = 0; i < n; ++i) {
            entry = iterator.next();
            dArray[i] = entry.getKey();
            nArray[i] = entry.getValue().getRGB();
        }
        ContourMapNative.jni_SetColorDictTable(this.getHandle(), dArray, nArray);
    }

    public HashMap<Double, Color> getColorDictTable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getColorDictTable()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        HashMap<Double, Color> hashMap = new HashMap<Double, Color>();
        double[] dArray = ContourMapNative.jni_GetColorTable_Keys(this.getHandle());
        int[] nArray = ContourMapNative.jni_GetColotTable_Colors(this.getHandle());
        for (int i = 0; i < dArray.length; ++i) {
            hashMap.put(dArray[i], new Color(nArray[i], true));
        }
        return hashMap;
    }

    public Rectangle2D getCoverageArea() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        ContourMapNative.jni_GetCoverageArea(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setCoverageArea(Rectangle2D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SlopeMap", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || value.isEmpty()) {
            return;
        }
        ContourMapNative.jni_SetCoverageArea(this.getHandle(), value.getLeft(), value.getBottom(), value.getRight(), value.getTop());
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return ContourMapNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        ContourMapNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            ContourMapNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

