/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoModel;
import com.supermap.data.Point3D;
import com.supermap.realspace.spatialanalyst.CheckErrorType;
import com.supermap.realspace.spatialanalyst.CheckResult;
import com.supermap.realspace.spatialanalyst.InternalGeoModel;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.ModelValidatorNative;
import com.supermap.realspace.spatialanalyst.ModelValidatorParameter;

@Deprecated
public class ModelValidator {
    private static Point3D[] checkIsolatedPoint(GeoModel geoModel, boolean isRepair, boolean bOnlyCheck) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        double[][] dArray = ModelValidatorNative.jni_CheckIsolatedPoints(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), isRepair, bOnlyCheck);
        if (dArray.length != 3 || dArray[0].length == 0 || dArray[1].length == 0 || dArray[2].length == 0) {
            return null;
        }
        Point3D[] point3DArray = new Point3D[dArray[0].length];
        for (int i = 0; i < dArray[0].length; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(dArray[0][i]);
            point3D.setY(dArray[1][i]);
            point3D.setZ(dArray[2][i]);
            point3DArray[i] = point3D;
        }
        return point3DArray;
    }

    private static GeoLine3D[] checkSelfIntersection(GeoModel geoModel, boolean bOnlyCheck) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckSelfIntersection(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bOnlyCheck);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    private static boolean connectivityValidator(GeoModel geoModel, boolean bOnlyCheck) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelValidatorNative.jni_CheckConnectivity(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bOnlyCheck);
        InternalGeoModel.clearMeshes(geoModel);
        geoModel.getMeshes();
        return bl;
    }

    private static GeoLine3D[] checkAmbiguousLine(GeoModel geoModel, boolean bOnlyCheck) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckAmbiguousLines(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bOnlyCheck);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    private static Boolean triangleValidator(GeoModel geoModel, boolean bOnlyCheck) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ModelValidatorNative.jni_TriangleValidator(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bOnlyCheck);
        return bl;
    }

    private static GeoLine3D[] checkBorder(GeoModel geoModel, boolean bOnlyCheck) {
        GeoLine3D[] geoLine3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = ModelValidatorNative.jni_CheckBorder(InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel), bOnlyCheck);
        if (lArray == null) {
            return new GeoLine3D[0];
        }
        int n = lArray.length;
        if (n > 0) {
            geoLine3DArray = new GeoLine3D[n];
            for (int i = 0; i < n; ++i) {
                if (lArray[i] == 0L) continue;
                geoLine3DArray[i] = (GeoLine3D)InternalGeometry.createInstance(lArray[i]);
            }
        } else {
            geoLine3DArray = new GeoLine3D[]{};
        }
        return geoLine3DArray;
    }

    public static CheckResult validator(GeoModel geoModel, ModelValidatorParameter parameter) {
        Point3D[] point3DArray;
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        CheckResult checkResult = new CheckResult();
        if (parameter.isIsolatedPointChecked()) {
            point3DArray = ModelValidator.checkIsolatedPoint(geoModel, parameter.isRepair(), false);
            if (!parameter.isRepair() && point3DArray != null && point3DArray.length > 0) {
                checkResult.setErrorPoints(point3DArray);
                checkResult.setErrorType(CheckErrorType.ISOLATED_POINT);
                return checkResult;
            }
        }
        if (parameter.isConnectivityProcessed()) {
            ModelValidator.connectivityValidator(geoModel, false);
        }
        if (parameter.isNoncoplanarIntersectionChecked() && (point3DArray = ModelValidator.checkSelfIntersection(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.NONCOPLANAR_INTERSECTION);
            return checkResult;
        }
        if (parameter.isTriangleProcessed()) {
            ModelValidator.triangleValidator(geoModel, false);
        }
        if (parameter.isAmbiguousLineChecked() && (point3DArray = ModelValidator.checkAmbiguousLine(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.AMBIGUOUS_LINE);
            return checkResult;
        }
        if (parameter.isBorderChecked() && (point3DArray = ModelValidator.checkBorder(geoModel, false)).length > 0) {
            checkResult.setErrorLines((GeoLine3D[])point3DArray);
            checkResult.setErrorType(CheckErrorType.BORDER);
            return checkResult;
        }
        return checkResult;
    }

    public static boolean isClosed(GeoModel geoModel) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Point3D[] point3DArray = ModelValidator.checkIsolatedPoint(geoModel, false, true);
        if (point3DArray != null && point3DArray.length > 0) {
            return false;
        }
        boolean bl = ModelValidator.connectivityValidator(geoModel, true);
        if (!bl) {
            return false;
        }
        GeoLine3D[] geoLine3DArray = ModelValidator.checkSelfIntersection(geoModel, true);
        if (geoLine3DArray.length > 0) {
            return false;
        }
        GeoLine3D[] geoLine3DArray2 = ModelValidator.checkAmbiguousLine(geoModel, true);
        if (geoLine3DArray2.length > 0) {
            return false;
        }
        boolean bl2 = ModelValidator.triangleValidator(geoModel, true);
        if (!bl2) {
            return false;
        }
        GeoLine3D[] geoLine3DArray3 = ModelValidator.checkBorder(geoModel, true);
        return geoLine3DArray3.length <= 0;
    }

    public static boolean isValid(GeoModel geoModel) {
        if (geoModel == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geoModel) == 0L) {
            String string = InternalResource.loadString("geoModel", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        Point3D[] point3DArray = ModelValidator.checkIsolatedPoint(geoModel, false, true);
        if (point3DArray != null && point3DArray.length > 0) {
            return false;
        }
        boolean bl = ModelValidator.connectivityValidator(geoModel, true);
        if (!bl) {
            return false;
        }
        GeoLine3D[] geoLine3DArray = ModelValidator.checkSelfIntersection(geoModel, true);
        if (geoLine3DArray.length > 0) {
            return false;
        }
        GeoLine3D[] geoLine3DArray2 = ModelValidator.checkAmbiguousLine(geoModel, true);
        if (geoLine3DArray2.length > 0) {
            return false;
        }
        boolean bl2 = ModelValidator.triangleValidator(geoModel, true);
        return bl2;
    }
}

