/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.realspace.spatialanalyst.InternalEnum;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3D;
import com.supermap.realspace.spatialanalyst.InterpolationParameter3DNative;
import com.supermap.realspace.spatialanalyst.SearchMode;
import com.supermap.realspace.spatialanalyst.VariogramMode;

public class InterpolationKrigingParameter3D
extends InterpolationParameter3D {
    private InterpolationAlgorithmType m_Type = InterpolationAlgorithmType.KRIGING;

    public InterpolationKrigingParameter3D() {
        super(InterpolationAlgorithmType.KRIGING);
    }

    public InterpolationKrigingParameter3D(double resolution, SearchMode searchMode, double searchRadius, int expectedCount, VariogramMode variogramMode) {
        super(InterpolationAlgorithmType.KRIGING, resolution, searchMode, searchRadius, expectedCount);
        this.setVariogramMode(variogramMode);
    }

    public VariogramMode getVariogramMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVariogramMode()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = InterpolationParameter3DNative.jni_GetVariogramMode(this.getHandle());
        return (VariogramMode)InternalEnum.parseUGCValue(VariogramMode.class, n);
    }

    public void setVariogramMode(VariogramMode variogramMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVariogramMode(VariogramMode variogramMode)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetVariogramMode(this.getHandle(), InternalEnum.getUGCValue(variogramMode));
    }

    public double getRange() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRange()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetRange(this.getHandle());
    }

    public void setRange(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRange(double value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetRange(this.getHandle(), value);
    }

    public double getSill() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSill()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetSill(this.getHandle());
    }

    public void setSill(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSill(double value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetSill(this.getHandle(), value);
    }

    public double getNugget() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getNugget()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetNugget(this.getHandle());
    }

    public void setNugget(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setNugget(double value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetNugget(this.getHandle(), value);
    }

    public int getMaxPointCountForInterpolation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxPointCountForInterpolation()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_searchMode != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("getMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetMaxPointCountForInterpolation(this.getHandle());
    }

    public void setMaxPointCountForInterpolation(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxPointCountForInterpolation(int value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_searchMode != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("setMaxPointCountForInterpolation()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetMaxPointCountForInterpolation(this.getHandle(), value);
    }

    public int getMaxPointCountInNode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMaxPointCountInNode()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_searchMode != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("getMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameter3DNative.jni_GetMaxPointCountInNode(this.getHandle());
    }

    public void setMaxPointCountInNode(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMaxPointCountInNode(int value)", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_searchMode != SearchMode.QUADTREE) {
            String string = InternalResource.loadString("setMaxPointCountInNode()", "InterpolationAlgorithmType_NotMatch", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        InterpolationParameter3DNative.jni_SetMaxPointCountInNode(this.getHandle(), value);
    }

    @Override
    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_Type;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Range=");
        stringBuffer.append(this.getRange());
        stringBuffer.append(",Sill=");
        stringBuffer.append(this.getSill());
        stringBuffer.append(",Nugget=");
        stringBuffer.append(this.getNugget());
        stringBuffer.append(",VariogramMode=");
        stringBuffer.append(this.getVariogramMode().name());
        if (this.getSearchMode() == SearchMode.QUADTREE) {
            stringBuffer.append(",MaxPointCountForInterpolation=");
            stringBuffer.append(this.getMaxPointCountForInterpolation());
            stringBuffer.append(",MaxPointCountInNode=");
            stringBuffer.append(this.getMaxPointCountInNode());
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

