/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.jsuperpy.threeddesigner;

import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.EngineType;
import com.supermap.data.Recordset;
import com.supermap.data.Workspace;
import com.supermap.jsuperpy.threeddesigner.MaterailParameter;
import com.supermap.jsuperpy.threeddesigner.ModelBuilder3DTools;
import com.supermap.jsuperpy.threeddesigner.SteppedEvent;
import com.supermap.jsuperpy.threeddesigner.SteppedListener;
import java.awt.Color;

public class Test {
    public static void main(String[] args) {
        Workspace workspace = new Workspace();
        String dsPath = "E:\\iobjectsPy\\iobjectspy\\unittestdata\\data\\threeddesigner.udb";
        DatasourceConnectionInfo dsInfo = new DatasourceConnectionInfo();
        dsInfo.setServer(dsPath);
        dsInfo.setEngineType(EngineType.UDB);
        Datasource datasource = workspace.getDatasources().open(dsInfo);
        DatasetVector datasetV = (DatasetVector)datasource.getDatasets().get("Region");
        String name = datasource.getDatasets().getAvailableDatasetName("House");
        DatasetVectorInfo vectorInfo = new DatasetVectorInfo();
        vectorInfo.setType(DatasetType.MODEL);
        vectorInfo.setName(name);
        DatasetVector datasetR = datasource.getDatasets().create(vectorInfo);
        datasetR.setPrjCoordSys(datasetV.getPrjCoordSys());
        Test.linearExtrude(datasetV, datasetR);
    }

    private static void linearExtrude(DatasetVector datasetV, DatasetVector datasetR) {
        SteppedListener steppedListener = new SteppedListener(){

            @Override
            public void stepped(SteppedEvent event) {
                System.out.println(event.getPercent() + "%;" + event.getMessage() + ";" + event.getTitle());
            }
        };
        ModelBuilder3DTools.addSteppedListener(steppedListener);
        int[] ids = new int[]{1, 2, 3, 4, 5};
        Recordset recordset = datasetV.query(ids, CursorType.STATIC);
        boolean b = ModelBuilder3DTools.linearExtrude(recordset, datasetR, "Height", 0.0, "", "scaleX");
        System.out.println("linearExtrude:" + b);
    }

    private static void buildHouse(DatasetVector datasetV, DatasetVector datasetR) {
        MaterailParameter wallParameter = new MaterailParameter();
        wallParameter.setMaterialColor(Color.GRAY);
        wallParameter.setTextureFile("E:\\iobjectsPy\\pic\\wall.jpg");
        MaterailParameter eaveParameter = new MaterailParameter();
        eaveParameter.setMaterialColor(Color.YELLOW);
        eaveParameter.setTextureFile("E:\\iobjectsPy\\pic\\wall2.jpg");
        MaterailParameter roofParameter = new MaterailParameter();
        roofParameter.setMaterialColor(Color.RED);
        roofParameter.setTextureFile("E:\\iobjectsPy\\pic\\roof.jpg");
        SteppedListener steppedListener = new SteppedListener(){

            @Override
            public void stepped(SteppedEvent event) {
                System.out.println(event.getPercent() + "%;" + event.getMessage() + ";" + event.getTitle());
            }
        };
        ModelBuilder3DTools.addSteppedListener(steppedListener);
        int[] ids = new int[]{1, 2, 3, 4, 5};
        Recordset recordset = datasetV.query(ids, CursorType.STATIC);
        boolean b = ModelBuilder3DTools.buildHouse(recordset, datasetR, 50, wallParameter, 0.5, "", eaveParameter, 0.5, "Height", roofParameter);
        System.out.println("buildHouse:" + b);
        System.out.println("Hello World");
    }
}

