/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.ColorGradientType;
import com.supermap.data.Colors;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.JoinItems;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DUniqueItem;
import com.supermap.realspace.ThemeUnique3DNative;
import java.util.ArrayList;

public class Theme3DUnique
extends Theme3D {
    private GeoStyle3D m_defaultStyle;
    private ArrayList<Theme3DUniqueItem> m_uniqueItems;

    public Theme3DUnique() {
        long l = ThemeUnique3DNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_uniqueItems = new ArrayList();
    }

    public Theme3DUnique(Theme3DUnique themeUnique3D) {
        if (themeUnique3D == null) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeUnique3D.getHandle() == 0L) {
            String string = InternalResource.loadString("themeUnique", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeUnique3DNative.jni_Clone(themeUnique3D.getHandle());
        this.setHandle(l, true);
        this.m_uniqueItems = new ArrayList();
        int n = themeUnique3D.getUniqueItemsList().size();
        for (int i = 0; i < n; ++i) {
            Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
            this.m_uniqueItems.add(theme3DUniqueItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeUnique3D));
    }

    Theme3DUnique(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.m_uniqueItems = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
            this.m_uniqueItems.add(theme3DUniqueItem);
        }
    }

    public Theme3DUniqueItem get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_uniqueItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUnique3DNative.jni_GetCount(this.getHandle());
    }

    public String getUniqueExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniqueExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUnique3DNative.jni_GetUniqueExpression(this.getHandle());
    }

    public void setUniqueExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniqueExpression(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeUnique3DNative.jni_SetUniqueExpression(this.getHandle(), value);
    }

    public GeoStyle3D getDefaultStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_defaultStyle == null && (l = ThemeUnique3DNative.jni_GetDefaultStyle(this.getHandle())) != 0L) {
            this.m_defaultStyle = InternalGeoStyle3D.createInstance(l);
        }
        return this.m_defaultStyle;
    }

    public void setDefaultStyle(GeoStyle3D style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyle(GeoStyle3D value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style.clone());
        ThemeUnique3DNative.jni_SetDefaultStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
    }

    public int add(Theme3DUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(ThemeUnique3DItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeUnique3DNative.jni_IsExist(this.getHandle(), item.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeUnique3D_TheUniqueIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)item.getStyle());
        int n = ThemeUnique3DNative.jni_Add(this.getHandle(), item.getUnique(), item.isVisible(), item.getCaption(), l);
        if (n != -1) {
            Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
            this.m_uniqueItems.add(theme3DUniqueItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)item);
        return n;
    }

    public boolean insert(int index, Theme3DUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, ThemeUniqueItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeUnique3DNative.jni_IsExist(this.getHandle(), item.getUnique());
        if (bl) {
            String string = InternalResource.loadString("item.getUnique()", "ThemeUnique3D_TheUniqueIsExist", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)item.getStyle());
        boolean bl2 = false;
        if (index == n) {
            int n2 = ThemeUnique3DNative.jni_Add(this.getHandle(), item.getUnique(), item.isVisible(), item.getCaption(), l);
            if (n2 == n) {
                bl2 = true;
                Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
                this.m_uniqueItems.add(theme3DUniqueItem);
            }
        } else {
            bl2 = ThemeUnique3DNative.jni_Insert(this.getHandle(), index, item.getUnique(), item.isVisible(), item.getCaption(), l);
            Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
            this.m_uniqueItems.add(index, theme3DUniqueItem);
        }
        return bl2;
    }

    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeUnique3DNative.jni_Remove(this.getHandle(), index);
        if (bl) {
            Theme3DUniqueItem theme3DUniqueItem = this.m_uniqueItems.get(index);
            theme3DUniqueItem.clearHandle();
            this.m_uniqueItems.remove(index);
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeUnique3DNative.jni_Clear(this.getHandle());
        if (this.m_uniqueItems != null) {
            int n = this.m_uniqueItems.size();
            for (int i = 0; i < n; ++i) {
                Theme3DUniqueItem theme3DUniqueItem = this.m_uniqueItems.get(i);
                theme3DUniqueItem.clearHandle();
            }
            this.m_uniqueItems.clear();
        }
    }

    public static Theme3DUnique makeDefault(DatasetVector dataset, String uniqueExpression) {
        return Theme3DUnique.makeDefault(dataset, uniqueExpression, null, null);
    }

    public static Theme3DUnique makeDefault(DatasetVector dataset, String uniqueExpression, ColorGradientType colorGradientType) {
        return Theme3DUnique.makeDefault(dataset, uniqueExpression, colorGradientType, null);
    }

    public static Theme3DUnique makeDefault(DatasetVector dataset, String uniqueExpression, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (uniqueExpression == null || uniqueExpression.trim().length() == 0) {
            String string = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeUnique3DNative.jni_MakeDefault(l2, uniqueExpression, l, n);
        Theme3DUnique theme3DUnique = null;
        if (l3 != 0L) {
            theme3DUnique = new Theme3DUnique(l3, true);
        }
        return theme3DUnique;
    }

    public static Theme3DUnique makeDefault(DatasetVector dataset, String colorField, Colors colors) {
        boolean bl;
        Object object;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (!dataset.getType().equals((Object)DatasetType.REGION)) {
            String string = InternalResource.loadString("dataset", "ThemeUnique3D_TheDatasetTypeIsUnsupported", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfo fieldInfo = dataset.getFieldInfos().get(colorField);
        if (fieldInfo != null) {
            if (fieldInfo.isSystemField()) {
                String string = InternalResource.loadString("colorField", "ThemeUnique3D_SystemFieldIsReadOnly", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            object = fieldInfo.getType();
            boolean bl2 = bl = object.equals((Object)FieldType.BYTE) || object.equals((Object)FieldType.INT16) || object.equals((Object)FieldType.INT32);
            if (!bl) {
                String string = InternalResource.loadString("colorField", "ThemeUnique3D_OnlySupportIntegerField", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            if (!dataset.isAvailableFieldName(colorField)) {
                String string = InternalResource.loadString("colorField", "ThemeUnique3D_TheArgumentOfColorFieldIsNotAvailableFieldName", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            object = new FieldInfo();
            object.setType(FieldType.INT32);
            object.setName(colorField);
            object.setCaption(colorField);
            dataset.getFieldInfos().add((FieldInfo)object);
        }
        if (colors != null && com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)colors) == 0L) {
            colors = null;
        }
        object = null;
        bl = ThemeUnique3DNative.jni_MakeFourColor(l, colorField);
        if (bl) {
            object = Theme3DUnique.makeDefault(dataset, colorField);
        }
        if (object != null) {
            int n = ((Theme3DUnique)((Object)object)).getCount();
            if (colors == null) {
                colors = Colors.makeRandom((int)n);
            }
            if (colors.getCount() < n) {
                colors = new Colors(colors);
                Colors colors2 = Colors.makeRandom((int)(n - colors.getCount()));
                colors.addRange(colors2.toArray());
            }
            for (int i = 0; i < n; ++i) {
                ((Theme3DUnique)((Object)object)).get(i).getStyle().setFillForeColor(colors.get(i));
            }
        }
        return object;
    }

    public int indexOf(String unique) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String unique)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (unique != null && unique.trim().length() != 0) {
            n = ThemeUnique3DNative.jni_IndexOf(this.getHandle(), unique);
        }
        return n;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeUnique3DNative.jni_ReverseStyle(this.getHandle());
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = super.fromXML(xml);
        if (bl) {
            if (this.m_defaultStyle != null) {
                InternalGeoStyle3D.clearHandle(this.m_defaultStyle);
                this.m_defaultStyle = null;
            }
            if (this.m_uniqueItems != null) {
                this.clearUniqueItemsList();
            }
            int n = this.getCount();
            for (int i = 0; i < n; ++i) {
                Theme3DUniqueItem theme3DUniqueItem = new Theme3DUniqueItem(this);
                this.m_uniqueItems.add(theme3DUniqueItem);
            }
        }
        return bl;
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",UniqueExpression = ");
        stringBuffer.append(this.getUniqueExpression());
        stringBuffer.append(",DefaultStyle = ");
        stringBuffer.append(this.getDefaultStyle().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeUnique3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.m_uniqueItems != null) {
            this.clearUniqueItemsList();
            this.m_uniqueItems = null;
        }
        if (this.m_defaultStyle != null) {
            InternalGeoStyle3D.clearHandle(this.m_defaultStyle);
            this.m_defaultStyle = null;
        }
        this.setHandle(0L);
    }

    ArrayList getUniqueItemsList() {
        return this.m_uniqueItems;
    }

    private void clearUniqueItemsList() {
        int n = this.m_uniqueItems.size();
        for (int i = 0; i < n; ++i) {
            Theme3DUniqueItem theme3DUniqueItem = this.m_uniqueItems.get(i);
            theme3DUniqueItem.clearHandle();
        }
        this.m_uniqueItems.clear();
    }

    private void reset() {
        ThemeUnique3DNative.jni_Reset(this.getHandle());
    }

    public boolean isDefaultModellingStyleEnable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDefaultModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUnique3DNative.jni_IsDefaultModellingStyleEnabled(this.getHandle());
    }

    public void setDefaultModellingStyleEnable(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultModellingStyleEnable()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeUnique3DNative.jni_SetDefaultModellingStyleEnabled(this.getHandle(), value);
    }
}

