/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.GeoStyle3D;
import com.supermap.data.JoinItems;
import com.supermap.data.Toolkit;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalGeoStyle3D;
import com.supermap.realspace.InternalHandle;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.RangeMode3D;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.Theme3DRangeItem;
import com.supermap.realspace.ThemeRange3DNative;
import java.util.ArrayList;

public class Theme3DRange
extends Theme3D {
    private ArrayList<Theme3DRangeItem> m_range3DItems;
    private String String_ForThemeRangeMiddleItem = "<= X <";

    public Theme3DRange() {
        long l = ThemeRange3DNative.jni_New();
        this.setHandle(l, true);
        this.m_range3DItems = new ArrayList();
    }

    public Theme3DRange(Theme3DRange themeRange3D) {
        if (themeRange3D == null) {
            String string = InternalResource.loadString("themeRange3D", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeRange3D.getHandle() == 0L) {
            String string = InternalResource.loadString("themeRange3D", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeRange3DNative.jni_Clone(themeRange3D.getHandle());
        this.setHandle(l, true);
        this.m_range3DItems = new ArrayList();
        int n = themeRange3D.getRangeItemsList().size();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(theme3DRangeItem);
        }
    }

    Theme3DRange(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        this.m_range3DItems = new ArrayList();
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(theme3DRangeItem);
        }
    }

    public Theme3DRangeItem get(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        return this.m_range3DItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public String getRangeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeExpression()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return ThemeRange3DNative.jni_GetRangeExpression(this.getHandle());
    }

    public void setRangeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRangeExpression(String value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeRange3DNative.jni_SetRangeExpression(this.getHandle(), value);
    }

    public boolean addToHead(Theme3DRangeItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeRange3DItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            String string = InternalResource.loadString("item", "ThemeRange3D_TheEndShouldBeBiggerTheStart", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        if (n > 0) {
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), 0);
            double d2 = item.getEnd();
            boolean bl = Toolkit.isZero((double)(d2 - d));
            if (!bl) {
                String string = InternalResource.loadString("item.getEnd()", "ThemeRange3D_InvalidEndOfItem", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)item.getStyle());
        boolean bl = ThemeRange3DNative.jni_AddToHead(this.getHandle(), item.getCaption(), item.isVisible(), l, item.getStart(), item.getEnd());
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(0, theme3DRangeItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)item);
        return bl;
    }

    public boolean addToTail(Theme3DRangeItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeRangeItem item)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (item.getStart() >= item.getEnd()) {
            String string = InternalResource.loadString("item", "ThemeRange3D_TheEndShouldBeBiggerTheStart", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        int n = this.getCount();
        if (n > 0) {
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), n);
            double d2 = item.getStart();
            boolean bl = Toolkit.isZero((double)(d2 - d));
            if (!bl) {
                String string = InternalResource.loadString("item.getStart()", "ThemeRange3D_InavlidStartOfItem", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)item.getStyle());
        boolean bl = ThemeRange3DNative.jni_AddToTail(this.getHandle(), item.getCaption(), item.isVisible(), l, item.getStart(), item.getEnd());
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(theme3DRangeItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)item);
        return bl;
    }

    public boolean split(int index, double splitValue, GeoStyle3D style1, String caption1, GeoStyle3D style2, String caption2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (style1 == null) {
            String string = InternalResource.loadString("style1", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)style1);
        if (l == 0L) {
            String string = InternalResource.loadString("style1", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (style2 == null) {
            String string = InternalResource.loadString("style2", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style2);
        if (l2 == 0L) {
            String string = InternalResource.loadString("style2", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), index);
        double d2 = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), index + 1);
        if (splitValue <= d || splitValue >= d2) {
            String string = InternalResource.loadString("splitValue", "ThemeRange3D_InvalidSplitValue", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style1.clone());
        long l4 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style2.clone());
        if (caption1 == null || caption1.trim().length() == 0) {
            String string = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (caption2 == null || caption2.trim().length() == 0) {
            String string = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeRange3DNative.jni_Split(this.getHandle(), index, splitValue, l3, caption1, l4, caption2);
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(index + 1, theme3DRangeItem);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style1);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style2);
        return bl;
    }

    public boolean merge(int index, int count, GeoStyle3D style, String caption) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("merge(int index, int count, GeoStyle3D style, String caption)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (count < 0 || index + count > n) {
            String string = InternalResource.loadString("count", "ThemeRange3D_TheCountIsInvalid", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)style);
        if (l == 0L) {
            String string = InternalResource.loadString("style", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (count == 0) {
            return true;
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)style.clone());
        if (caption == null || caption.trim().length() == 0) {
            String string = InternalResource.loadString("caption", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = ThemeRange3DNative.jni_Merge(this.getHandle(), index, count, l2, caption);
        if (bl) {
            Theme3DRangeItem theme3DRangeItem = this.m_range3DItems.get(index);
            double d = ThemeRange3DNative.jni_GetValueAt(this.getHandle(), index + 1);
            theme3DRangeItem.setEnd(d);
            theme3DRangeItem.setCaption(caption);
            theme3DRangeItem.setStyle(style.clone());
            for (int i = 0; i < count - 1; ++i) {
                Theme3DRangeItem theme3DRangeItem2 = this.m_range3DItems.get(index + 1);
                theme3DRangeItem2.clearHandle();
                this.m_range3DItems.remove(index + 1);
            }
            this.refreshRange3DItemStyle();
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)style);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeRange3DNative.jni_Clear(this.getHandle());
        if (this.m_range3DItems != null) {
            int n = this.m_range3DItems.size();
            for (int i = 0; i < n; ++i) {
                Theme3DRangeItem theme3DRangeItem = this.m_range3DItems.get(i);
                theme3DRangeItem.clearHandle();
            }
            this.m_range3DItems.clear();
        }
    }

    public static Theme3DRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode3D rangeMode, double rangeParameter) {
        return Theme3DRange.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, null, null);
    }

    public static Theme3DRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode3D rangeMode, double rangeParameter, ColorGradientType colorGradientType) {
        return Theme3DRange.makeDefault(dataset, rangeExpression, rangeMode, rangeParameter, colorGradientType, null);
    }

    public static Theme3DRange makeDefault(DatasetVector dataset, String rangeExpression, RangeMode3D rangeMode, double rangeParameter, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeExpression == null || rangeExpression.trim().length() == 0) {
            String string = InternalResource.loadString("rangeExpression", "Global_StringIsNullOrEmpty", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode == null) {
            String string = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if ((rangeMode.equals((Object)RangeMode3D.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode3D.SQUAREROOT) || rangeMode.equals((Object)RangeMode3D.STDDEVIATION) || rangeMode.equals((Object)RangeMode3D.LOGARITHM) || rangeMode.equals((Object)RangeMode3D.QUANTILE)) && rangeParameter < 1.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeRange3D_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode3D.CUSTOMINTERVAL) && rangeParameter < 0.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeRange3D_TheArgumentOfRangeParameterShouldBePositive", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue(rangeMode);
        int n2 = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeRange3DNative.jni_MakeDefault(l2, rangeExpression, l, n, rangeParameter, n2);
        Theme3DRange theme3DRange = null;
        if (l3 != 0L) {
            theme3DRange = new Theme3DRange(l3, true);
            theme3DRange.setRangeExpression(rangeExpression);
            theme3DRange.setDefaultCaptions();
            int n3 = ThemeRange3DNative.jni_GetValueCount(theme3DRange.getHandle());
            if (theme3DRange.getCount() != 0) {
                String string = "min< X <" + theme3DRange.get(0).getStart();
                GeoStyle3D geoStyle3D = theme3DRange.getStyle(-1);
                Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(1.4E-45f, theme3DRange.get(0).getStart(), geoStyle3D, string);
                theme3DRange.addToHead(theme3DRangeItem);
                string = theme3DRange.get(theme3DRange.getCount() - 1).getEnd() + "<= X <max";
                geoStyle3D = theme3DRange.get(theme3DRange.getCount() - 1).getStyle();
                theme3DRangeItem = new Theme3DRangeItem(theme3DRange.get(theme3DRange.getCount() - 1).getEnd(), 3.4028234663852886E38, geoStyle3D, string);
                theme3DRange.addToTail(theme3DRangeItem);
            } else if (n3 == 1) {
                double d = theme3DRange.getStart(0);
                String string = "min< X <" + d;
                GeoStyle3D geoStyle3D = theme3DRange.getStyle(-1);
                Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(1.4E-45f, d, geoStyle3D, string);
                theme3DRange.addToHead(theme3DRangeItem);
                double d2 = theme3DRange.getEnd(0);
                string = d2 + "<= X <max";
                geoStyle3D = theme3DRange.getStyle(theme3DRange.getCount() - 1);
                theme3DRangeItem = new Theme3DRangeItem(d2, 3.4028234663852886E38, geoStyle3D, string);
                theme3DRange.addToTail(theme3DRangeItem);
            }
        }
        return theme3DRange;
    }

    public int indexOf(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetValueCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeRange3DNative.jni_GetValues(this.getHandle(), dArray);
        int n2 = -1;
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= value) || !(value < dArray[i + 1])) continue;
            n2 = i;
        }
        return n2;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        ThemeRange3DNative.jni_ReverseStyle(this.getHandle());
    }

    @Override
    public boolean fromXML(String xml) {
        boolean bl = super.fromXML(xml);
        if (bl) {
            this.refreshRange3DItemsList();
        }
        return bl;
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(n);
        stringBuffer.append(",RangeExpression = ");
        stringBuffer.append(this.getRangeExpression());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeRange3DNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public RangeMode3D getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeRange3DNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode3D)Enum.parse(RangeMode3D.class, (int)n);
    }

    ArrayList<Theme3DRangeItem> getRangeItemsList() {
        return this.m_range3DItems;
    }

    @Override
    protected void clearHandle() {
        if (this.m_range3DItems != null) {
            this.clearRange3DItemsList();
            this.m_range3DItems = null;
        }
        this.setHandle(0L);
    }

    private void refreshRange3DItemStyle() {
        int n = this.getCount();
        long[] lArray = new long[n];
        ThemeRange3DNative.jni_GetStylesHandle(this.getHandle(), lArray);
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = this.get(i);
            theme3DRangeItem.refreshStyle(lArray[i]);
        }
    }

    private void clearRange3DItemsList() {
        int n = this.m_range3DItems.size();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = this.m_range3DItems.get(i);
            theme3DRangeItem.clearHandle();
        }
        this.m_range3DItems.clear();
    }

    private void refreshRange3DItemsList() {
        if (this.m_range3DItems != null) {
            this.clearRange3DItemsList();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            Theme3DRangeItem theme3DRangeItem = new Theme3DRangeItem(this);
            this.m_range3DItems.add(theme3DRangeItem);
        }
    }

    protected void setDefaultCaptions() {
        for (Theme3DRangeItem theme3DRangeItem : this.m_range3DItems) {
            theme3DRangeItem.setCaption(String.valueOf(theme3DRangeItem.getStart()) + this.String_ForThemeRangeMiddleItem + String.valueOf(theme3DRangeItem.getEnd()));
        }
    }

    protected double getStart(int index) {
        return ThemeRange3DNative.jni_GetValueAt(this.getHandle(), index);
    }

    protected double getEnd(int index) {
        return ThemeRange3DNative.jni_GetValueAt(this.getHandle(), index + 1);
    }

    protected GeoStyle3D getStyle(int index) {
        long l = ThemeRange3DNative.jni_GetStyleAt(this.getHandle(), index);
        GeoStyle3D geoStyle3D = null;
        if (l != 0L) {
            geoStyle3D = InternalGeoStyle3D.createInstance(l);
        }
        return geoStyle3D;
    }
}

