/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.Datasource;
import com.supermap.data.InternalHandle;
import com.supermap.data.QueryParameter;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.CacheFileType;
import com.supermap.realspace.CullModeType;
import com.supermap.realspace.InternalDataset;
import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalQueryParameter;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalToolkitSpace;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3DNative;
import com.supermap.realspace.Layer3DSetting;
import com.supermap.realspace.Layer3DSettingGrid;
import com.supermap.realspace.Layer3DSettingImage;
import com.supermap.realspace.Layer3DSettingVector;
import com.supermap.realspace.Layer3DSettingVolume;
import com.supermap.realspace.Layer3DType;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.Theme3D;
import com.supermap.realspace.WireFrameType;
import java.util.Vector;

public class Layer3DDataset
extends Layer3D {
    private Dataset m_dataset;
    private Theme3D m_theme3D;
    private QueryParameter m_queryParameter;
    private Layer3DSetting m_layer3DSetting;
    private Vector m_steppedListeners;
    private long m_selfEventHandle;
    private static String m_senderMethodName;

    Layer3DDataset(long handle, Dataset dataset, Layer3Ds layer3Ds) {
        super(handle, layer3Ds);
        this.m_dataset = dataset;
        this.m_selfEventHandle = Layer3DNative.jni_NewSelfEventHandle(this);
    }

    public Dataset getDataset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.m_dataset;
    }

    @Deprecated
    public boolean convertStyledRegionsToDataset(Datasource datasource, String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertStyledRegionsToDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("convertStyledRegionsToDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (datasource == null) {
            bl = Layer3DNative.jni_ConvertStyledRegionsToDataset(this.getHandle(), 0L, InternalHandle.getHandle((InternalHandle)this.getLayer3Ds().getScene()), this.m_selfEventHandle, value);
            this.m_dataset.getDatasource().updateDataset();
        } else {
            bl = Layer3DNative.jni_ConvertStyledRegionsToDataset(this.getHandle(), InternalHandle.getHandle((InternalHandle)datasource), InternalHandle.getHandle((InternalHandle)this.getLayer3Ds().getScene()), this.m_selfEventHandle, value);
            datasource.updateDataset();
        }
        return bl;
    }

    public boolean toDatasetVector(Datasource datasource, String datasetName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("convertSymbol3DsToDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_dataset == null) {
            String string = InternalResource.loadString("convertSymbol3DsToDataset()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (datasource == null) {
            bl = Layer3DNative.jni_ConvertSymbol3DsToDataset(this.getHandle(), 0L, InternalHandle.getHandle((InternalHandle)this.getLayer3Ds().getScene()), this.m_selfEventHandle, datasetName);
            this.m_dataset.getDatasource().updateDataset();
        } else {
            bl = Layer3DNative.jni_ConvertSymbol3DsToDataset(this.getHandle(), InternalHandle.getHandle((InternalHandle)datasource), InternalHandle.getHandle((InternalHandle)this.getLayer3Ds().getScene()), this.m_selfEventHandle, datasetName);
            datasource.updateDataset();
        }
        return bl;
    }

    public Theme3D getTheme() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTheme()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_theme3D == null && (l = Layer3DNative.jni_GetTheme(this.getHandle())) != 0L) {
            this.m_theme3D = Theme3D.createInstance(l, this);
        }
        return this.m_theme3D;
    }

    public QueryParameter getDisplayFilter() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDisplayFilter()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_queryParameter == null && (l = Layer3DNative.jni_GetDisplayFilter(this.getHandle())) != 0L) {
            this.m_queryParameter = InternalQueryParameter.createInstance(l);
        }
        return this.m_queryParameter;
    }

    public void setDisplayFilter(QueryParameter queryParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDisplayFilter(QueryParameter value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter == null) {
            String string = InternalResource.loadString("queryParameter", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((InternalHandle)queryParameter);
        if (l == 0L) {
            String string = InternalResource.loadString("queryParameter", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        QueryParameter queryParameter2 = new QueryParameter(queryParameter);
        long l2 = InternalHandle.getHandle((InternalHandle)queryParameter2);
        Layer3DNative.jni_SetDisplayFilter(this.getHandle(), l2);
        InternalQueryParameter.identicalJavaObject(this.getDisplayFilter(), queryParameter2);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)queryParameter);
    }

    public Layer3DSetting getAdditionalSetting() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getAddtionalSetting()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_layer3DSetting == null) {
            Dataset dataset = this.getDataset();
            if (InternalDataset.getIsVector(dataset)) {
                this.m_layer3DSetting = new Layer3DSettingVector(this, this.getLayer3Ds());
            } else if (dataset.getType().equals((Object)DatasetType.IMAGE)) {
                this.m_layer3DSetting = new Layer3DSettingImage(this, this.getLayer3Ds());
            } else if (dataset.getType().equals((Object)DatasetType.GRID)) {
                this.m_layer3DSetting = new Layer3DSettingGrid(this, this.getLayer3Ds());
            } else if (dataset.getType().equals((Object)DatasetType.VOLUME)) {
                this.m_layer3DSetting = new Layer3DSettingVolume(this);
            }
        }
        return this.m_layer3DSetting;
    }

    public void setAdditionalSetting(Layer3DSetting value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAdditionalSetting(value)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getAdditionalSetting() == null) {
            String string = InternalResource.loadString("setAdditionalSetting(value)", "Layer3DUnSuppsorted_AdditionalSetting", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (!this.m_layer3DSetting.getType().equals((Object)value.getType())) {
            String string = InternalResource.loadString("layerSetting", "Layer3D_TheArgumentOfLayerSettingIsInvalidLayerSettingType", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_layer3DSetting.reset(value);
    }

    @Override
    protected void clearHandle() {
        if (this.m_layer3DSetting != null) {
            this.m_layer3DSetting.clearHandle();
            this.m_layer3DSetting = null;
        }
        if (this.m_theme3D != null) {
            this.m_theme3D.clearHandle();
        }
        super.clearHandle();
        this.m_dataset = null;
        this.clearSelfEventHandle();
    }

    private void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            Layer3DNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    static void steppedCallBack(Layer3DDataset source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            m_senderMethodName = "convert";
            boolean bl = InternalToolkitSpace.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, m_senderMethodName, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitSpace.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    public String getPreCachePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreCachePath()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetPreCachePath(this.getHandle());
    }

    public void setPreCachePath(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreCachePath()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetPreCachePath(this.getHandle(), value);
    }

    public boolean getIsBuildOSGBCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getType() != Layer3DType.DATASET) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetIsBuildOSGBCache(this.getHandle());
    }

    public void setIsBuildOSGBCache(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetIsBuildOSGBCache(this.getHandle(), value);
    }

    public void setObjectsVisible(int[] ids, boolean visible) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (ids == null) {
            String string = InternalResource.loadString("ids", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetObjectsVisible(this.getHandle(), ids, visible);
    }

    public CacheFileType getFileType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetFileType(this.getHandle());
        switch (n) {
            case 505: {
                n = 0;
                break;
            }
            case 511: {
                n = 1;
                break;
            }
            case 515: {
                n = 2;
                break;
            }
            default: {
                String string = InternalResource.loadString("fileType", "Global_ArgumentTypeInvalid", "realspace_resources");
                throw new IllegalStateException(string);
            }
        }
        return (CacheFileType)InternalEnum.parseUGCValue(CacheFileType.class, n);
    }

    public void setFileType(CacheFileType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (value == CacheFileType.OSGB) {
            n = 505;
        } else if (value == CacheFileType.S3M) {
            n = 511;
        } else if (value == CacheFileType.S3MB) {
            n = 515;
        } else {
            String string = InternalResource.loadString("fileType", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetFileType(this.getHandle(), n);
    }

    public boolean isBuildOSGBPipeCache() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsBuildOSGBPipeCache(this.getHandle());
    }

    public void setBuildOSGBPipeCache(boolean isBuildOSGBPipeCache) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetBuildOSGBPipeCache(this.getHandle(), isBuildOSGBPipeCache);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetTileWidth(this.getHandle());
    }

    public void setTileWidth(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0.0) {
            String string = InternalResource.loadString("value", "GlobalArgument_MustGreaterThanZero", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetTileWidth(this.getHandle(), value);
    }

    public WireFrameType getWireFrameMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetWireFrameMode(this.getHandle());
        return (WireFrameType)InternalEnum.parseUGCValue(WireFrameType.class, n);
    }

    public void setWireFrameMode(WireFrameType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetWireFrameMode(this.getHandle(), value.value());
    }

    public boolean getSCPRelated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType2(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSCPRelated(this.getHandle());
    }

    public void setSCPRelated(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType2(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSCPRelated(this.getHandle(), value);
    }

    public String getSCPRelatedField() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType2(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSCPRelatedField(this.getHandle());
    }

    public void setSCPRelatedField(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType2(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSCPRelatedField(this.getHandle(), value);
    }

    public float getBrightness() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetBrightness(this.getHandle());
    }

    public void setBrightness(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetBrightness(this.getHandle(), value);
    }

    public float getConstrast() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetConstrast(this.getHandle());
    }

    public void setConstrast(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetConstrast(this.getHandle(), value);
    }

    public float getHue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetHue(this.getHandle());
    }

    public void setHue(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetHue(this.getHandle(), value);
    }

    public float getSaturation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSaturation(this.getHandle());
    }

    public void setSaturation(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSaturation(this.getHandle(), value);
    }

    public float getGamma() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetGamma(this.getHandle());
    }

    public void setGamma(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetGamma(this.getHandle(), value);
    }

    public float getConstantPolygonOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetConstantPolygonOffset(this.getHandle());
    }

    public void setConstantPolygonOffset(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetConstantPolygonOffset(this.getHandle(), value);
        this.updateData();
    }

    public boolean isColorByCategory() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_FileType(this.getHandle());
        if (n != 16) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_IsColorByCategory(this.getHandle());
    }

    public void setColorByCategory(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_FileType(this.getHandle());
        if (n != 16) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetColorByCategory(this.getHandle(), value);
    }

    public int getLODCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetLODCount(this.getHandle());
    }

    public void setLODCount(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Layer3DNative.jni_IsSupportFileType(this.getHandle());
        if (!bl) {
            String string = InternalResource.loadString("Layer3DDataset", "Global_ArgumentTypeInvalid", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (value < 0) {
            String string = InternalResource.loadString("value", "GlobalArgument_MustGreaterThanZero", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetLODCount(this.getHandle(), value);
    }

    public double getLODRangeScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_FileType(this.getHandle());
        if (n == 16) {
            return Layer3DNative.jni_GetLODRangeScale(this.getHandle());
        }
        return 1.0;
    }

    public void setLODRangeScale(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_FileType(this.getHandle());
        if (n == 16) {
            Layer3DNative.jni_SetLODRangeScale(this.getHandle(), value);
        }
    }

    public float getSlopeScalePolygonOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetSlopeScalePolygonOffset(this.getHandle());
    }

    public void setSlopeScalePolygonOffset(float value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetSlopeScalePolygonOffset(this.getHandle(), value);
        this.updateData();
    }

    public double getRegionOffsettingSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return Layer3DNative.jni_GetRegionOffsettingSize(this.getHandle());
    }

    public void setRegionOffsettingSize(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DDataset", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetRegionOffsettingSize(this.getHandle(), value);
    }

    public CullModeType getCullMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        int n = Layer3DNative.jni_GetCullMode(this.getHandle());
        return (CullModeType)InternalEnum.parseUGCValue(CullModeType.class, n);
    }

    public void setCullMode(CullModeType value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Layer3DOSGBFile", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_SetCullMode(this.getHandle(), value.value());
    }

    public void updateTheme3DStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("updateTheme3DStyle", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Layer3DNative.jni_UpdateTheme3DStyle(this.getHandle());
    }
}

