/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import com.supermap.realspace.InternalEnum;
import com.supermap.realspace.InternalHandleDisposable;
import com.supermap.realspace.InternalResource;
import com.supermap.realspace.InternalVariantNative;
import com.supermap.realspace.InternalVariantType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

class InternalVariant
extends InternalHandleDisposable {
    private InternalVariant() {
        this.setHandle(InternalVariantNative.jni_New(), true);
    }

    public InternalVariant(Object obj) {
        this();
        if (obj.getClass().equals(Byte.class)) {
            Byte by = (Byte)obj;
            this.setValue(by);
        } else if (obj.getClass().equals(Integer.class)) {
            Integer n = (Integer)obj;
            this.setValue(n);
        } else if (obj.getClass().equals(Long.class)) {
            Long l = (Long)obj;
            this.setValue(l);
        } else if (obj.getClass().equals(Short.class)) {
            Short s = (Short)obj;
            this.setValue(s);
        } else if (obj.getClass().equals(Boolean.class)) {
            Boolean bl = (Boolean)obj;
            this.setValue(bl);
        } else if (obj.getClass().equals(Float.class)) {
            Float f = (Float)obj;
            this.setValue(f.floatValue());
        } else if (obj.getClass().equals(Double.class)) {
            Double d = (Double)obj;
            this.setValue(d);
        } else if (obj.getClass().equals(String.class)) {
            String string = (String)obj;
            this.setValue(string);
        } else if (obj.getClass().equals(Date.class)) {
            Date date = (Date)obj;
            this.setValue(date);
        } else if (obj.getClass().getName().compareToIgnoreCase("[B") == 0) {
            byte[] byArray = (byte[])obj;
            this.setValue(byArray);
        } else {
            String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
    }

    public InternalVariant(byte value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(int value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(long value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(short value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(boolean value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(float value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(double value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(String value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(Date value) {
        this();
        this.setValue(value);
    }

    public InternalVariant(byte[] value) {
        this();
        this.setValue(value);
    }

    public InternalVariantType getType() {
        int n = InternalVariantNative.jni_GetType(this.getHandle());
        InternalVariantType internalVariantType = (InternalVariantType)InternalEnum.parseUGCValue(InternalVariantType.class, n);
        return internalVariantType;
    }

    public void setValue(byte value) {
        InternalVariantNative.jni_SetValueByte(this.getHandle(), value);
    }

    public void setValue(int value) {
        InternalVariantNative.jni_SetValueInt(this.getHandle(), value);
    }

    public void setValue(long value) {
        InternalVariantNative.jni_SetValueLong(this.getHandle(), value);
    }

    public void setValue(short value) {
        InternalVariantNative.jni_SetValueShort(this.getHandle(), value);
    }

    public void setValue(boolean value) {
        InternalVariantNative.jni_SetValueBoolean(this.getHandle(), value);
    }

    public void setValue(float value) {
        InternalVariantNative.jni_SetValueFloat(this.getHandle(), value);
    }

    public void setValue(double value) {
        InternalVariantNative.jni_SetValueDouble(this.getHandle(), value);
    }

    public void setValue(String value) {
        InternalVariantNative.jni_SetValueString(this.getHandle(), value);
    }

    public void setValue(byte[] value) {
        InternalVariantNative.jni_SetValueBinary(this.getHandle(), value);
    }

    public void setValue(Date value) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.US);
        gregorianCalendar.setTime(value);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(10);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        InternalVariantNative.jni_SetValueTime(this.getHandle(), n, n2, n3, n4, n5, n6);
    }

    public int toByte() {
        return InternalVariantNative.jni_GetValueByte(this.getHandle());
    }

    public int toInt() {
        return InternalVariantNative.jni_GetValueInt(this.getHandle());
    }

    public long toLong() {
        return InternalVariantNative.jni_GetValueLong(this.getHandle());
    }

    public short toShort() {
        return InternalVariantNative.jni_GetValueShort(this.getHandle());
    }

    public boolean toBoolean() {
        return InternalVariantNative.jni_GetValueBoolean(this.getHandle());
    }

    public double toDouble() {
        return InternalVariantNative.jni_GetValueDouble(this.getHandle());
    }

    public float toFloat() {
        return InternalVariantNative.jni_GetValueFloat(this.getHandle());
    }

    public byte[] toBinary() {
        return InternalVariantNative.jni_GetValueBinary(this.getHandle());
    }

    public String toString() {
        String string = null;
        if (this.getType().equals((Object)InternalVariantType.TIME)) {
            Date date = this.toDate();
            string = DateFormat.getDateInstance().format(date);
        } else {
            string = InternalVariantNative.jni_GetValueString(this.getHandle());
        }
        return string;
    }

    public Date toDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.US);
        Date date = null;
        try {
            date = simpleDateFormat.parse(InternalVariantNative.jni_GetValueString(this.getHandle()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public Object toObject() {
        InternalVariantType internalVariantType = this.getType();
        if (internalVariantType.equals((Object)InternalVariantType.BYTE)) {
            return Byte.valueOf(String.valueOf(this.toByte()));
        }
        if (internalVariantType.equals((Object)InternalVariantType.INTEGER)) {
            return this.toInt();
        }
        if (internalVariantType.equals((Object)InternalVariantType.LONG)) {
            return this.toLong();
        }
        if (internalVariantType.equals((Object)InternalVariantType.SHORT)) {
            return this.toShort();
        }
        if (internalVariantType.equals((Object)InternalVariantType.FLOAT)) {
            return Float.valueOf(this.toFloat());
        }
        if (internalVariantType.equals((Object)InternalVariantType.DOUBLE)) {
            return this.toDouble();
        }
        if (internalVariantType.equals((Object)InternalVariantType.TIME)) {
            return this.toDate();
        }
        if (internalVariantType.equals((Object)InternalVariantType.STRING)) {
            return this.toString();
        }
        if (internalVariantType.equals((Object)InternalVariantType.BINARY)) {
            return this.toBinary();
        }
        if (internalVariantType.equals((Object)InternalVariantType.NULL)) {
            return null;
        }
        String string = InternalResource.loadString("", "InternalVariant_UnsupportType", "realspace_resources");
        throw new IllegalArgumentException(string);
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            InternalVariantNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    private InternalVariant(long handle, boolean empty) {
        this.setHandle(handle, true);
    }

    static final InternalVariant createInstance(long handle) {
        return new InternalVariant(handle, true);
    }

    static boolean isSupportedInstance(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(Byte.class)) {
            return true;
        }
        if (obj.getClass().equals(Integer.class)) {
            return true;
        }
        if (obj.getClass().equals(Long.class)) {
            return true;
        }
        if (obj.getClass().equals(Short.class)) {
            return true;
        }
        if (obj.getClass().equals(Boolean.class)) {
            return true;
        }
        if (obj.getClass().equals(Float.class)) {
            return true;
        }
        if (obj.getClass().equals(Double.class)) {
            return true;
        }
        if (obj.getClass().equals(String.class)) {
            return true;
        }
        return obj.getClass().equals(Date.class);
    }
}

