/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.DatasetType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.FileType;
import com.supermap.data.conversion.ImportDataInfo;
import com.supermap.data.conversion.ImportDataInfoLIDARNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalFieldInfos;
import com.supermap.data.conversion.InternalResource;

public class ImportDataInfoLIDAR
extends ImportDataInfo {
    ImportDataInfoLIDAR(long handle, String filePath, FileType fileType, String prefixName) {
        super(handle, filePath, fileType, prefixName);
    }

    public DatasetType getDatasetType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDatasetType()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        int n = ImportDataInfoLIDARNative.jni_GetDatasetType(this.getHandle());
        DatasetType datasetType = (DatasetType)InternalEnum.parse(DatasetType.class, (int)n);
        return datasetType;
    }

    public int getRecordCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRecordCount()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportDataInfoLIDARNative.jni_GetRecordCount(this.getHandle());
    }

    public FieldInfo[] getSourceFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSourceFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.getSourceFieldInfos_base();
    }

    public FieldInfo[] getTargetFieldInfos() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.getTargetFieldInfos_base();
    }

    public void setTargetFieldInfos(FieldInfo[] fieldinfo) {
        FieldInfos fieldInfos = new FieldInfos(fieldinfo);
        if (ImportDataInfoLIDAR.getHandle((InternalHandle)fieldInfos) == 0L) {
            String string = InternalResource.loadString("fieldInfos", "Global_InvalidConstructorArgument", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetFieldInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalFieldInfos.getHandle(fieldInfos);
        ImportDataInfoLIDARNative.jni_SetTargetFieldInfos(this.getHandle(), l);
        this.Init();
    }

    public boolean changeFieldName(String oldName, String newName) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ChangeFieldName(String oldName, String newName)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.changeFieldName_base(oldName, newName);
    }

    public boolean setImportFieldState(String fieldName, boolean excludeField) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportFieldState(String fieldname,Boolean excludeField)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.setImportFieldState_base(fieldName, excludeField);
    }

    public boolean exchangeFieldOrder(String fieldName1, String fieldName2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("exchangeFieldOrder(String fieldName1, String fieldName2)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return this.exchangeFieldOrder_base(fieldName1, fieldName2);
    }
}

