/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.SightlineNative;
import com.supermap.realspace.spatialanalyst.SightlineResult;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

public class Sightline
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;
    private Color m_hiddenColor = Color.RED;
    private Color m_visibleColor = Color.GREEN;
    private Point3D m_viewerPosition = new Point3D(0.0, 0.0, 0.0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public Sightline(Scene scene) {
        Sightline.verifyLicense();
        this.m_scene = scene;
        long l = SightlineNative.jni_New("");
        this.setHandle(l, true);
    }

    public Color getHiddenColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHiddenColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_hiddenColor;
    }

    public void setHiddenColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHiddenColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SightlineNative.jni_SetHiddenColor(this.getHandle(), color.getRGB());
        this.m_hiddenColor = color;
    }

    public void setVisibleColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SightlineNative.jni_SetVisibleColor(this.getHandle(), color.getRGB());
        this.m_visibleColor = color;
    }

    public Color getVisibleColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setVisibleColor()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_visibleColor;
    }

    public Point3D getViewerPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return this.m_viewerPosition;
    }

    public void setViewerPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setViewerPosition()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SightlineNative.jni_SetViewerPosition(this.getHandle(), position.getX(), position.getY(), position.getZ());
        this.m_viewerPosition = position;
    }

    public Point3D getTargetPoint(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getTargetPointCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("getTargetPoint()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = SightlineNative.jni_GetTargetPoint(this.getHandle(), index);
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SightlineNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SightlineNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    public int addTargetPoint(Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addTargetPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SightlineNative.jni_AddTargetPoint(this.getHandle(), point.getX(), point.getY(), point.getZ());
    }

    public SightlineResult getSightlineResult(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSightlineResult()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getTargetPointCount();
        if (index < 0 || index >= n) {
            String string = InternalResource.loadString("getSightlineResult()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = this.getTargetPoint(index);
        double[] dArray = SightlineNative.jni_GetBarrierPoint(this.getHandle(), index);
        Point3D point3D2 = new Point3D(dArray[0], dArray[1], dArray[2]);
        boolean bl = SightlineNative.jni_GetVisible(this.getHandle(), index);
        return new SightlineResult(this.m_viewerPosition, point3D, point3D2, bl);
    }

    public int getTargetPointCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetPointCount()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SightlineNative.jni_GetTargetPointCount(this.getHandle());
    }

    public void removeAllTargetPoints() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeAllTargetPoints()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (this.getTargetPointCount() > 0) {
            SightlineNative.jni_RemoveAllTargetPoints(this.getHandle());
        }
    }

    public boolean removeTargetPoint(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeTargetPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getTargetPointCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("removeTargetPoint()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SightlineNative.jni_RemoveTargetPoint(this.getHandle(), index);
    }

    public void setTargetPoint(int index, Point3D point) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTargetPoint()", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getTargetPointCount();
        if (index >= n || index < 0) {
            String string = InternalResource.loadString("setTargetPoint()", "ArgumentOutOfRange", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double d = point.getX();
        double d2 = point.getY();
        double d3 = point.getZ();
        SightlineNative.jni_SetTargetPoint(this.getHandle(), index, d, d2, d3);
    }

    public void getObjsVisible(int index, HashMap<String, int[]> value) {
        if (this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L || this.getHandle() == 0L) {
            String string = InternalResource.loadString("Sightline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.m_scene.getTrackingLayer() != null) {
            bl = this.m_scene.getTrackingLayer().isVisible();
            this.m_scene.getTrackingLayer().setVisible(false);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[1];
        long l = SightlineNative.jni_GetObjsVisible(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), index, nArray);
        if (this.m_scene.getTrackingLayer() != null) {
            this.m_scene.getTrackingLayer().setVisible(bl);
        }
        if (nArray[0] == 0) {
            return;
        }
        String[] stringArray = new String[nArray[0]];
        Object[] objectArray = new Object[nArray[0]];
        SightlineNative.jni_ReadObjsVisibleResult(l, InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene), stringArray, objectArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].isEmpty()) continue;
            value.put(stringArray[i], (int[])objectArray[i]);
        }
    }

    public int getInViewport() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Sightline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return SightlineNative.jni_GetInViewport(this.getHandle());
    }

    public void setInViewport(int value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Sightline", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        SightlineNative.jni_SetInViewport(this.getHandle(), value);
    }

    public void dispose() {
        if (this.getHandle() != 0L) {
            SightlineNative.jni_Delete(this.getHandle());
        }
        this.setHandle(0L);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

