/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Recordset;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalRecordset;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import com.supermap.realspace.spatialanalyst.ProximityAnalyst3DNative;
import java.util.ArrayList;
import java.util.Vector;

public class ProximityAnalyst3D {
    private static License m_license;
    transient Vector m_steppedListeners;
    protected long m_selfEventHandle;

    public DatasetVector pipeLineDistanceCheck(DatasetVector sourceDataset, DatasetVector validatingDataset, Datasource targetDatasource, String targetDatasetName, String radiusFieldName, double distance) {
        ProximityAnalyst3D.verifyLicense();
        if (sourceDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() != DatasetType.LINE3D && sourceDataset.getType() != DatasetType.NETWORK) {
            String string = InternalResource.loadString("sourceDataset", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (sourceDataset.getType() == DatasetType.NETWORK && sourceDataset.getChildDataset().getType() != DatasetType.POINT3D) {
            String string = InternalResource.loadString("datasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (validatingDataset != null && validatingDataset.getType() != sourceDataset.getType()) {
            String string = InternalResource.loadString("validatingDataset", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (targetDatasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource) == 0L) {
            String string = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (!targetDatasource.getDatasets().isAvailableDatasetName(targetDatasetName)) {
            String string = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (distance < 0.0) {
            String string = InternalResource.loadString("distance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)sourceDataset);
        long l2 = 0L;
        if (validatingDataset != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)validatingDataset)) == 0L) {
            String string = InternalResource.loadString("validatingDataset", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)targetDatasource);
        this.m_selfEventHandle = ProximityAnalyst3DNative.jni_NewSelfEventHandle(this);
        long l4 = ProximityAnalyst3DNative.jni_PipeLineDistanceCheck(l, l2, l3, targetDatasetName, radiusFieldName, distance, this.m_selfEventHandle);
        DatasetVector datasetVector = null;
        if (l4 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l4, targetDatasource);
            InternalDatasets.add(targetDatasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public Recordset modelDistanceQuery(DatasetVector modelDataset, Geometry geometry, double bufferDistance, String attributeFilter, CursorType cursorType) {
        ProximityAnalyst3D.verifyLicense();
        if (modelDataset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)modelDataset) == 0L) {
            String string = InternalResource.loadString("modelDataset", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry) == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOPOINT3D && geometry.getType() != GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("geometry->Type", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (bufferDistance < 0.0) {
            String string = InternalResource.loadString("distance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (attributeFilter == null) {
            attributeFilter = "";
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.value();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelDataset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        this.m_selfEventHandle = ProximityAnalyst3DNative.jni_NewSelfEventHandle(this);
        long l3 = ProximityAnalyst3DNative.jni_ModelDistanceQuery1(l, l2, bufferDistance, attributeFilter, n, this.m_selfEventHandle);
        return InternalRecordset.createInstance(l3, modelDataset, cursorType);
    }

    public Recordset modelDistanceQuery(Recordset modelRecordset, Geometry geometry, double bufferDistance, CursorType cursorType) {
        ProximityAnalyst3D.verifyLicense();
        if (modelRecordset == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)modelRecordset) == 0L) {
            String string = InternalResource.loadString("modelDataset", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry) == 0L) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOPOINT3D && geometry.getType() != GeometryType.GEOLINE3D) {
            String string = InternalResource.loadString("geometry->Type", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (bufferDistance < 0.0) {
            String string = InternalResource.loadString("distance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (cursorType == null) {
            cursorType = CursorType.STATIC;
        }
        int n = cursorType.value();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)modelRecordset);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        this.m_selfEventHandle = ProximityAnalyst3DNative.jni_NewSelfEventHandle(this);
        long l3 = ProximityAnalyst3DNative.jni_ModelDistanceQuery2(l, l2, bufferDistance, n, this.m_selfEventHandle);
        return InternalRecordset.createInstance(l3, modelRecordset.getDataset(), cursorType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public synchronized void addSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.add(l);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener l) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(l)) {
            this.m_steppedListeners.remove(l);
        }
    }

    protected void fireStepped(SteppedEvent event) {
        if (this.m_steppedListeners != null) {
            Vector vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(event);
            }
        }
    }

    static void steppedCallBack(ProximityAnalyst3D source, int percent, long remainTime, String title, String message, long cancelHandle) {
        if (source != null) {
            boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(cancelHandle);
            SteppedEvent steppedEvent = new SteppedEvent((Object)source, percent, remainTime, title, message, null, bl);
            source.fireStepped(steppedEvent);
            InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(cancelHandle, steppedEvent.getCancel());
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)source);
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

