/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.License;
import com.supermap.ProductType;
import com.supermap.data.GeoModel3D;
import com.supermap.data.Point3D;
import com.supermap.realspace.Scene;
import com.supermap.realspace.spatialanalyst.CollisionAnalysisNative;
import com.supermap.realspace.spatialanalyst.InternalGeometry;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalHandleDisposable;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.awt.Color;
import java.util.ArrayList;

public class CollisionAnalysis
extends InternalHandleDisposable {
    private static License m_license;
    private Scene m_scene;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyLicense() {
        int n = -1;
        Object object = m_license;
        synchronized (object) {
            n = m_license.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public CollisionAnalysis(Scene scene) {
        CollisionAnalysis.verifyLicense();
        this.m_scene = scene;
        long l = CollisionAnalysisNative.jni_New();
        this.setHandle(l, true);
    }

    public void dispose() {
        this.m_scene = null;
        if (this.getHandle() != 0L) {
            CollisionAnalysisNative.jni_Delete(this.getHandle());
        }
        this.clearHandle();
    }

    public Color getCollisionColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = CollisionAnalysisNative.jni_GetCollisionColor(this.getHandle());
        Color color = new Color(nArray[1], nArray[2], nArray[3], nArray[0]);
        nArray = null;
        return color;
    }

    public void setCollisionColor(Color value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_SetCollisionColor(this.getHandle(), value.getAlpha(), value.getRed(), value.getGreen(), value.getBlue());
    }

    public GeoModel3D getCollisionModel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        long l = CollisionAnalysisNative.jni_GetCollisionModel(this.getHandle());
        if (l == 0L) {
            return null;
        }
        return (GeoModel3D)InternalGeometry.createInstance(l);
    }

    public void setCollisionModel(GeoModel3D value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        if (value == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)value) == 0L) {
            return;
        }
        CollisionAnalysisNative.jni_SetCollisionModel(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)value));
    }

    public double getOpacity() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return CollisionAnalysisNative.jni_GetOpacity(this.getHandle());
    }

    public void setOpacity(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_SetOpacity(this.getHandle(), value);
    }

    public Point3D getPosition() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = CollisionAnalysisNative.jni_GetPosition(this.getHandle());
        return new Point3D(dArray[0], dArray[1], dArray[2]);
    }

    public void setPosition(Point3D position) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{position.getX(), position.getY(), position.getZ()};
        CollisionAnalysisNative.jni_SetPosition(this.getHandle(), dArray);
    }

    public double getDirection() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return CollisionAnalysisNative.jni_GetDirection(this.getHandle());
    }

    public void setDirection(double direction) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_SetDirection(this.getHandle(), direction);
    }

    public double getPitch() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        return CollisionAnalysisNative.jni_GetPitch(this.getHandle());
    }

    public void setPitch(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_SetPitch(this.getHandle(), value);
    }

    public boolean build() {
        if (this.getHandle() == 0L || this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_Build(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
        return true;
    }

    public void clear() {
        if (this.getHandle() == 0L || this.m_scene == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene) == 0L) {
            String string = InternalResource.loadString("CollisionAnalysis", "Handle_ObjectHasBeenDisposed", "spatialanalyst3d_resources");
            throw new IllegalStateException(string);
        }
        CollisionAnalysisNative.jni_Clear(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this.m_scene));
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        m_license = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

