/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.Colors;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Enum;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldType;
import com.supermap.data.GeoStyle;
import com.supermap.data.JoinItems;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalGeoStyle;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeUniqueItem;
import com.supermap.mapping.ThemeUniqueNative;
import java.util.ArrayList;

public class ThemeUnique
extends Theme {
    private GeoStyle m_defaultStyle = null;
    private ArrayList m_uniqueItems = null;

    public ThemeUnique() {
        long l = ThemeUniqueNative.jni_New();
        this.setHandle(l, true);
        this.reset();
        this.m_uniqueItems = new ArrayList();
    }

    public ThemeUnique(ThemeUnique themeUnique) {
        if (themeUnique == null) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeUnique.getHandle() == 0L) {
            String string = InternalResource.loadString("themeUnique", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeUniqueNative.jni_Clone(themeUnique.getHandle());
        this.setHandle(l, true);
        this.m_uniqueItems = new ArrayList();
        int n = themeUnique.getUniqueItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeUnique));
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
            this.m_uniqueItems.add(themeUniqueItem);
        }
    }

    ThemeUnique(long handle, boolean disposable) {
        this.setHandle(handle, disposable);
        this.m_uniqueItems = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
            this.m_uniqueItems.add(themeUniqueItem);
        }
    }

    public ThemeUniqueItem getItem(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeUniqueItem)this.m_uniqueItems.get(index);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetCount(this.getHandle());
    }

    public String getUniqueExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getUniqueExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetUniqueExpression(this.getHandle());
    }

    public void setUniqueExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setUniqueExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetUniqueExpression(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public GeoStyle getDefaultStyle() {
        long l;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDefaultStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (this.m_defaultStyle == null && (l = ThemeUniqueNative.jni_GetDefaultStyle(this.getHandle())) != 0L) {
            this.m_defaultStyle = InternalGeoStyle.createInstance(l);
        }
        return this.m_defaultStyle;
    }

    public void setDefaultStyle(GeoStyle style) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyle(GeoStyle value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (style == null) {
            String string = InternalResource.loadString("style", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)style) == 0L) {
            String string = InternalResource.loadString("style", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyle geoStyle = style.clone();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geoStyle);
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetDefaultStyle(this.getHandle(), l);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)geoStyle);
        this.m_lock.unlock();
    }

    public String getCustomMarkerSizeExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("String getCustomMarkerSizeExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetCustomMarkerSizeExpression(this.getHandle());
    }

    public void setCustomMarkerSizeExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomMarkerSizeExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueNative.jni_SetCustomMarkerSizeExpression(this.getHandle(), value);
    }

    public String getCustomMarkerAngleExpression() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("String getCustomMarkerAngleExpression()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetCustomMarkerAngleExpression(this.getHandle());
    }

    public void setCustomMarkerAngleExpression(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setCustomMarkerAngleExpression(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            String string = InternalResource.loadString("value", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueNative.jni_SetCustomMarkerAngleExpression(this.getHandle(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(ThemeUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("add(ThemeUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(item);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeUniqueItem.getStyle());
        int n = -1;
        try {
            this.m_lock.lock();
            n = ThemeUniqueNative.jni_Add(this.getHandle(), themeUniqueItem.getUnique(), themeUniqueItem.isVisible(), themeUniqueItem.getCaption(), l);
            if (n != -1) {
                ThemeUniqueItem themeUniqueItem2 = new ThemeUniqueItem(this);
                this.m_uniqueItems.add(themeUniqueItem2);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        themeUniqueItem.hashCode();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(int index, ThemeUniqueItem item) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("insert(int index, ThemeUniqueItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this.getCount();
        if (index < 0 || index > n) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (item == null) {
            String string = InternalResource.loadString("item", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(item);
        boolean bl = false;
        this.m_lock.lock();
        try {
            long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)themeUniqueItem.getStyle());
            if (index == n) {
                int n2 = ThemeUniqueNative.jni_Add(this.getHandle(), themeUniqueItem.getUnique(), themeUniqueItem.isVisible(), themeUniqueItem.getCaption(), l);
                if (n2 == n) {
                    bl = true;
                    ThemeUniqueItem themeUniqueItem2 = new ThemeUniqueItem(this);
                    this.m_uniqueItems.add(themeUniqueItem2);
                }
            } else {
                bl = ThemeUniqueNative.jni_Insert(this.getHandle(), index, themeUniqueItem.getUnique(), themeUniqueItem.isVisible(), themeUniqueItem.getCaption(), l);
                if (bl) {
                    ThemeUniqueItem themeUniqueItem3 = new ThemeUniqueItem(this);
                    this.m_uniqueItems.add(index, themeUniqueItem3);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(int index) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("remove(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (index < 0 || index >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = ThemeUniqueNative.jni_Remove(this.getHandle(), index);
            if (bl) {
                ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this.m_uniqueItems.get(index);
                themeUniqueItem.clearHandle();
                this.m_uniqueItems.remove(index);
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_Clear(this.getHandle());
        if (this.m_uniqueItems != null) {
            int n = this.m_uniqueItems.size();
            for (int i = 0; i < n; ++i) {
                ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this.m_uniqueItems.get(i);
                themeUniqueItem.clearHandle();
            }
            this.m_uniqueItems.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeUnique makeDefault(DatasetVector dataset, String uniqueExpression) {
        return ThemeUnique.makeDefault(dataset, uniqueExpression, null, null);
    }

    public static ThemeUnique makeDefault(DatasetVector dataset, String uniqueExpression, ColorGradientType colorGradientType) {
        return ThemeUnique.makeDefault(dataset, uniqueExpression, colorGradientType, null);
    }

    public static ThemeUnique makeDefault(DatasetVector dataset, String uniqueExpression, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l2 == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (uniqueExpression == null || uniqueExpression.trim().length() == 0) {
            String string = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l3 = ThemeUniqueNative.jni_MakeDefault(l2, uniqueExpression, l, n);
        ThemeUnique themeUnique = null;
        if (l3 != 0L) {
            themeUnique = new ThemeUnique(l3, true);
        }
        return themeUnique;
    }

    public static ThemeUnique makeDefault(DatasetVector dataset, String colorField, Colors colors) {
        boolean bl;
        Object object;
        if (dataset == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)dataset);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (!dataset.getType().equals((Object)DatasetType.REGION)) {
            String string = InternalResource.loadString("dataset", "ThemeUnique_TheDatasetTypeIsUnsupported", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        FieldInfo fieldInfo = dataset.getFieldInfos().get(colorField);
        if (fieldInfo != null) {
            if (fieldInfo.isSystemField()) {
                String string = InternalResource.loadString("colorField", "ThemeUnique_SystemFieldIsReadOnly", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            object = fieldInfo.getType();
            boolean bl2 = bl = object.equals((Object)FieldType.BYTE) || object.equals((Object)FieldType.INT16) || object.equals((Object)FieldType.INT32);
            if (!bl) {
                String string = InternalResource.loadString("colorField", "ThemeUnique_OnlySupportIntegerField", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        } else {
            if (!dataset.isAvailableFieldName(colorField)) {
                String string = InternalResource.loadString("colorField", "ThemeUnique_TheArgumentOfColorFieldIsNotAvailableFieldName", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
            object = new FieldInfo();
            object.setType(FieldType.INT32);
            object.setName(colorField);
            object.setCaption(colorField);
            dataset.getFieldInfos().add((FieldInfo)object);
        }
        if (colors != null && com.supermap.data.InternalHandle.getHandle((com.supermap.data.InternalHandle)colors) == 0L) {
            colors = null;
        }
        object = null;
        bl = ThemeUniqueNative.jni_MakeFourColor(l, colorField);
        if (bl) {
            object = ThemeUnique.makeDefault(dataset, colorField);
        }
        if (object != null) {
            int n = ((ThemeUnique)((Object)object)).getCount();
            if (colors == null) {
                colors = Colors.makeRandom((int)n);
            }
            if (colors.getCount() < n) {
                colors = new Colors(colors);
                Colors colors2 = Colors.makeRandom((int)(n - colors.getCount()));
                colors.addRange(colors2.toArray());
            }
            for (int i = 0; i < n; ++i) {
                ((ThemeUnique)((Object)object)).getItem(i).getStyle().setFillForeColor(colors.get(i));
            }
        }
        return object;
    }

    public static ThemeUnique makeDefault(String[] values, String uniqueExpression, ColorGradientType colorGradientType, JoinItems joinItems) {
        long l;
        if (values == null) {
            String string = InternalResource.loadString("values", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (values.length == 0) {
            String string = InternalResource.loadString("values", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (uniqueExpression == null || uniqueExpression.trim().length() == 0) {
            String string = InternalResource.loadString("uniqueExpression", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (joinItems == null) {
            joinItems = new JoinItems();
        }
        if ((l = InternalHandle.getHandle((com.supermap.data.InternalHandle)joinItems)) == 0L) {
            String string = InternalResource.loadString("joinItems", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.YELLOWRED;
        }
        int n = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l2 = ThemeUniqueNative.jni_MakeDefault2(values, uniqueExpression, l, n);
        ThemeUnique themeUnique = null;
        if (l2 != 0L) {
            themeUnique = new ThemeUnique(l2, true);
        }
        return themeUnique;
    }

    public int indexOf(String unique) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(String unique)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = -1;
        if (unique != null && unique.trim().length() != 0) {
            n = ThemeUniqueNative.jni_IndexOf(this.getHandle(), unique);
        }
        return n;
    }

    public void reverseStyle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseStyle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_ReverseStyle(this.getHandle());
        this.m_lock.unlock();
    }

    @Override
    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append(",UniqueExpression = ");
        stringBuffer.append(this.getUniqueExpression());
        stringBuffer.append(",DefaultStyle = ");
        stringBuffer.append(this.getDefaultStyle().toString());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeUniqueNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fromXML(String xml) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(xml);
            if (bl) {
                if (this.m_defaultStyle != null) {
                    InternalGeoStyle.clearHandle(this.m_defaultStyle);
                    this.m_defaultStyle = null;
                }
                if (this.m_uniqueItems != null) {
                    this.clearUniqueItemsList();
                }
                int n = this.getCount();
                for (int i = 0; i < n; ++i) {
                    ThemeUniqueItem themeUniqueItem = new ThemeUniqueItem(this);
                    this.m_uniqueItems.add(themeUniqueItem);
                }
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    public void setDefaultStyleVisible(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDefaultStyleVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeUniqueNative.jni_SetIsDefaultStyleVisible(this.getHandle(), value);
        this.m_lock.unlock();
    }

    public boolean isDefaultStyleVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isDefaultStyleVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetIsDefaultStyleVisible(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.m_uniqueItems != null) {
            this.clearUniqueItemsList();
            this.m_uniqueItems = null;
        }
        if (this.m_defaultStyle != null) {
            InternalGeoStyle.clearHandle(this.m_defaultStyle);
            this.m_defaultStyle = null;
        }
        this.setHandle(0L);
    }

    ArrayList getUniqueItemsList() {
        return this.m_uniqueItems;
    }

    private void clearUniqueItemsList() {
        int n = this.m_uniqueItems.size();
        for (int i = 0; i < n; ++i) {
            ThemeUniqueItem themeUniqueItem = (ThemeUniqueItem)this.m_uniqueItems.get(i);
            themeUniqueItem.clearHandle();
        }
        this.m_uniqueItems.clear();
    }

    private void reset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_Reset(this.getHandle());
    }

    public String getOffsetX() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetX()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetX(this.getHandle());
    }

    public void setOffsetX(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetX(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeUniqueNative.jni_SetOffsetX(this.getHandle(), value);
    }

    public String getOffsetY() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOffsetY()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetY(this.getHandle());
    }

    public void setOffsetY(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetY(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (value == null) {
            value = "";
        }
        ThemeUniqueNative.jni_SetOffsetY(this.getHandle(), value);
    }

    public boolean isOffsetFixed() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOffsetFixed()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetOffsetFixed(this.getHandle());
    }

    public void setOffsetFixed(boolean value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOffsetFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_SetOffsetFixed(this.getHandle(), value);
    }

    public double getTrafficConditionOffset() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrafficConditionOffset()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetTrafficConditionOffset(this.getHandle());
    }

    public void setTrafficConditionOffset(double value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTrafficConditionOffset(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_SetTrafficConditionOffset(this.getHandle(), value);
    }

    public String getTrafficConditionExpress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTrafficConditionExpress()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeUniqueNative.jni_GetTrafficConditionExpress(this.getHandle());
    }

    public void setTrafficConditionExpress(String value) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTrafficConditionExpress(String value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeUniqueNative.jni_SetTrafficConditionExpress(this.getHandle(), value);
    }
}

